/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.util;

import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import org.j4me.logging.Log;

public class ConnectorHelper
extends Thread {
    private final String url;
    private final int mode;
    private final int timeout;
    private StreamConnection connection;
    private Exception exception;

    private ConnectorHelper(String string, int n, int n2) {
        super("ConnectorHelper");
        this.url = string;
        this.mode = n;
        this.timeout = n2;
    }

    public synchronized void run() {
        try {
            this.connection = (StreamConnection)Connector.open((String)this.url, (int)this.mode, (boolean)true);
        }
        catch (IOException iOException) {
            Log.warn("Problem opening connection to " + this.url, iOException);
            this.exception = iOException;
        }
        catch (SecurityException securityException) {
            Log.error("Not allowed to open connection", securityException);
            this.exception = securityException;
        }
        catch (Exception exception) {
            Log.error("Unknown connection exception", exception);
            this.exception = exception;
        }
        this.notifyAll();
    }

    public synchronized StreamConnection blockUntilConnected() throws IOException, SecurityException {
        try {
            this.wait(this.timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.exception != null) {
            if (this.exception instanceof ConnectionNotFoundException) {
                throw (ConnectionNotFoundException)this.exception;
            }
            if (this.exception instanceof SecurityException) {
                throw (SecurityException)this.exception;
            }
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            if (this.exception instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)this.exception;
            }
            throw (RuntimeException)this.exception;
        }
        return this.connection;
    }

    public static Connection open(String string, int n, int n2) throws IllegalArgumentException, ConnectionNotFoundException, IOException, SecurityException {
        ConnectorHelper connectorHelper = new ConnectorHelper(string, n, n2);
        connectorHelper.start();
        StreamConnection streamConnection = connectorHelper.blockUntilConnected();
        if (streamConnection == null) {
            connectorHelper.interrupt();
            throw new ConnectionNotFoundException("Connection attempt timed out to " + string);
        }
        return streamConnection;
    }
}

