/*
 * Decompiled with CFR 0.152.
 */
package st.nct;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import st.nct.LoadDataObserver;
import st.nct.MainCanvasList;
import st.nct.PaymentCanvas;
import st.nct.PlayerCanvas;
import st.nct.PlaylistCanvasList;
import st.nct.SongCanvasList;
import st.nct.common.CheckPayment;
import st.nct.common.CheckPaymentObserver;
import st.nct.common.ParseData;
import st.nct.model.Playlist;
import st.nct.utils.Utils;

public final class CuaTuiCanvasList
extends Canvas
implements CommandListener,
CheckPaymentObserver,
LoadDataObserver {
    private Command nowPlayingCommand;
    private Command selectCommand;
    private Command exitCommand;
    private Command searchCommand;
    private Utils.BreadCrumbTrail observer;
    int linePadding = 0;
    int margin = 2;
    int padding = 0;
    Font font = Font.getDefaultFont();
    int bgColor = 0xEEEEEE;
    int foreColor = 0;
    int foreSelectedColor = 0xEEEEEE;
    int backColor = 0xEEEEEE;
    int backSelectedColor = 0x505050;
    int borderWidth = 0;
    int borderColor = 0;
    int borderSelectedColor = 0xFF0000;
    String[][] itemLines = null;
    Image[] images = null;
    public int selectedItem = 0;
    int[] itemsTop = null;
    int[] itemsHeight = null;
    int scrollTop = 0;
    final int SCROLL_STEP;
    private String userName;
    private String defaultlistkey;
    private Playlist defaultPlaylist;
    Thread mLoaDataThread;

    public CuaTuiCanvasList(String title, String[] items, Image[] imageElements, String _defaultlistkey) {
        this.SCROLL_STEP = 20;
        this.setTitle(title);
        this.userName = title;
        this.defaultlistkey = _defaultlistkey;
        this.initMenu();
        this.images = imageElements;
        this.itemLines = new String[items.length][];
        this.itemsTop = new int[this.itemLines.length];
        this.itemsHeight = new int[this.itemLines.length];
        for (int i = 0; i < this.itemLines.length; ++i) {
            Image imagePart = this.getImage(i);
            int w = this.getItemWidth() - (imagePart != null ? imagePart.getWidth() + this.padding : 0);
            this.itemLines[i] = MainCanvasList.getTextRows(items[i], this.font, w);
        }
    }

    protected void paint(Graphics g) {
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.translate(0, -this.scrollTop);
        int top = 0;
        this.font = Font.getFont((int)0, (int)1, (int)16);
        g.setFont(this.font);
        for (int i = 0; i < this.itemLines.length; ++i) {
            int itemRows = this.itemLines[i].length;
            Image imagePart = this.getImage(i);
            int itemHeight = itemRows * this.font.getHeight() + this.linePadding * (itemRows - 1);
            this.itemsTop[i] = top;
            this.itemsHeight[i] = itemHeight;
            if (imagePart != null && imagePart.getHeight() > itemHeight) {
                itemHeight = imagePart.getHeight();
            }
            itemHeight += 2 * this.padding + 2 * this.borderWidth;
            g.translate(0, top);
            if (this.borderWidth > 0) {
                g.setColor(i == this.selectedItem ? this.borderSelectedColor : this.borderColor);
                g.fillRect(this.margin, this.margin, this.getWidth() - 2 * this.margin, itemHeight);
            }
            g.setColor(i == this.selectedItem ? this.backSelectedColor : this.backColor);
            g.fillRoundRect(this.margin + this.borderWidth, this.margin + this.borderWidth, this.getWidth() - 2 * this.margin - 2 * this.borderWidth, itemHeight - 2 * this.borderWidth, 5, 10);
            if (imagePart != null) {
                g.drawImage(imagePart, this.margin + this.borderWidth + this.padding, this.margin + this.borderWidth + this.padding, 20);
            }
            g.setColor(i == this.selectedItem ? this.foreSelectedColor : this.foreColor);
            int textLeft = this.margin + this.borderWidth + this.padding + (imagePart != null ? imagePart.getWidth() + this.padding : 0);
            for (int j = 0; j < itemRows; ++j) {
                g.drawString(this.itemLines[i][j], textLeft + 5, this.margin + this.borderWidth + this.padding + j * (this.linePadding + this.font.getHeight()), 20);
            }
            g.translate(0, -top);
            top += itemHeight + 2 * this.margin;
        }
        g.translate(0, this.scrollTop);
    }

    protected void keyPressed(int key) {
        int keyCode = this.getGameAction(key);
        if (this.itemLines.length > 0) {
            if (keyCode == 1) {
                if (this.itemsTop[this.selectedItem] < this.scrollTop) {
                    this.scrollTop -= 20;
                    this.repaint();
                } else if (this.selectedItem > 0) {
                    --this.selectedItem;
                    this.repaint();
                }
            } else if (keyCode == 6) {
                if (this.itemsTop[this.selectedItem] + this.itemsHeight[this.selectedItem] >= this.scrollTop + this.getHeight()) {
                    this.scrollTop += 20;
                    this.repaint();
                } else if (this.selectedItem < this.itemLines.length - 1) {
                    ++this.selectedItem;
                    this.repaint();
                }
            } else if (keyCode == 8 || keyCode == -5) {
                this.itemAction();
            }
        }
        super.keyPressed(key);
    }

    public int getItemWidth() {
        return this.getWidth() - 2 * this.borderWidth - 2 * this.padding - 2 * this.margin;
    }

    Image getImage(int index) {
        return this.images != null && this.images.length > index ? this.images[index] : null;
    }

    protected void paintTitleBarBackground(Graphics g, int x, int y) {
        try {
            Image image = Image.createImage((String)"/images/title.png");
            g.drawImage(image, x, y, 20);
            int ofset = (y + image.getHeight()) / 4;
            this.font = Font.getFont((int)0, (int)1, (int)16);
            g.setFont(this.font);
            g.drawString("NhacCuaTui", (x + image.getWidth()) / 4, ofset, 20);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.selectCommand) {
            this.itemAction();
        } else if (c == this.exitCommand) {
            this.observer.goBack();
        } else if (c == this.nowPlayingCommand) {
            MainCanvasList.gotoNowPlaying(this.observer);
        } else if (c == this.searchCommand) {
            MainCanvasList.gotoSearch(this.observer);
        }
    }

    public void setObserver(Utils.BreadCrumbTrail mObserver) {
        this.observer = mObserver;
    }

    private void gotoPlaylistByAction(final String action, final String userName) {
        this.displayMessage("NhacCuaTui", "\u0110ang t\u1ea3i d\u1eef li\u1ec7u...", "loading");
        this.mLoaDataThread = new Thread(new Runnable(){

            public void run() {
                Vector listItems = ParseData.parseUserPlaylistsByAction(action, userName, 1, 10);
                if (listItems == null) {
                    CuaTuiCanvasList.this.displayMessage("NhacCuaTui", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i t\u1edbi m\u00e1y ch\u1ee7! Xin vui l\u00f2ng ki\u1ec3m tra k\u1ebft n\u1ed1i.", "error");
                    return;
                }
                if (listItems.isEmpty()) {
                    CuaTuiCanvasList.this.displayMessage("NhacCuaTui", "Ch\u01b0a c\u00f3 d\u1eef li\u1ec7u!", "error");
                    return;
                }
                PlaylistCanvasList cateCanvas = new PlaylistCanvasList("Playlist", listItems, "genre", "");
                cateCanvas.setObserver(CuaTuiCanvasList.this.observer);
                CuaTuiCanvasList.this.observer.replaceCurrent((Displayable)cateCanvas);
            }
        });
        this.mLoaDataThread.start();
    }

    private void gotoPlayDefaultPlaylist() {
        this.displayMessage("NhacCuaTui", "\u0110ang t\u1ea3i d\u1eef li\u1ec7u...", "loading");
        this.mLoaDataThread = new Thread(new Runnable(){

            public void run() {
                Vector songItems = ParseData.parseSongsInPlaylist(CuaTuiCanvasList.this.defaultlistkey, CuaTuiCanvasList.this.userName, 1, 10);
                if (songItems == null) {
                    CuaTuiCanvasList.this.displayMessage("NhacCuaTui", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i t\u1edbi m\u00e1y ch\u1ee7! Xin vui l\u00f2ng ki\u1ec3m tra k\u1ebft n\u1ed1i.", "error");
                    return;
                }
                if (songItems.isEmpty()) {
                    CuaTuiCanvasList.this.displayMessage("NhacCuaTui", "Ch\u01b0a c\u00f3 d\u1eef li\u1ec7u!", "error");
                    return;
                }
                CuaTuiCanvasList.this.gotoPlaySong(songItems);
            }
        });
        this.mLoaDataThread.start();
    }

    private void itemAction() {
        if (this.selectedItem == 0) {
            this.doCheckPayment();
        } else if (this.selectedItem == 1) {
            this.gotoPlaylistByAction("myPlaylist", this.userName);
        } else if (this.selectedItem == 2) {
            this.gotoPlaylistByAction("playlistLiked", this.userName);
        }
    }

    private void gotoPlaySong(Vector songItems) {
        if (SongCanvasList.playerCanvas == null) {
            SongCanvasList.playerCanvas = new PlayerCanvas("NhacCuaTui", songItems, this.selectedItem, this.defaultPlaylist);
        } else {
            SongCanvasList.playerCanvas.change("NhacCuaTui", songItems, this.selectedItem, this.defaultPlaylist);
        }
        SongCanvasList.playerCanvas.setObserver(this.observer);
        this.observer.replaceCurrent((Displayable)SongCanvasList.playerCanvas);
    }

    private void doCheckPayment() {
        this.displayMessage("NhacCuaTui", "\u0110ang t\u1ea3i d\u1eef li\u1ec7u...", "loading");
        this.mLoaDataThread = new Thread(new Runnable(){

            public void run() {
                CuaTuiCanvasList.this.defaultPlaylist = ParseData.getDefaultPlaylist(CuaTuiCanvasList.this.userName, 1, 10);
                if (CuaTuiCanvasList.this.defaultPlaylist == null) {
                    CuaTuiCanvasList.this.displayMessage("NhacCuaTui", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i t\u1edbi m\u00e1y ch\u1ee7! Xin vui l\u00f2ng ki\u1ec3m tra k\u1ebft n\u1ed1i.", "error");
                    return;
                }
                CheckPayment checkPayment = new CheckPayment();
                checkPayment.setObserver(CuaTuiCanvasList.this);
                checkPayment.doChecPayment(CuaTuiCanvasList.this.defaultlistkey);
            }
        });
        this.mLoaDataThread.start();
    }

    private void initMenu() {
        this.selectCommand = new Command("Ch\u1ecdn", 8, 1);
        this.nowPlayingCommand = new Command("\u0110ang ch\u01a1i...", 8, 1);
        this.exitCommand = new Command("Tr\u1edf l\u1ea1i", 7, 0);
        this.searchCommand = new Command("T\u00ecm ki\u1ebfm", 8, 1);
        this.addCommand(this.selectCommand);
        this.addCommand(this.exitCommand);
        this.addCommand(this.searchCommand);
        this.addCommand(this.nowPlayingCommand);
        this.setCommandListener(this);
    }

    private void displayMessage(String title, String message, String messageType) {
        MainCanvasList.displayMessage(title, message, messageType, this.observer, this);
    }

    public void checCompleted(String result) {
        if (result == null) {
            return;
        }
        if (result.equals("true")) {
            this.observer.goBack();
            this.gotoPlayDefaultPlaylist();
        } else if (result.equals("false")) {
            this.gotoPaymentService();
        }
    }

    private void gotoPaymentService() {
        this.displayMessage("NhacCuaTui", "\u0110ang t\u1ea3i d\u1eef li\u1ec7u...", "error");
        this.mLoaDataThread = new Thread(new Runnable(){

            public void run() {
                Vector items = ParseData.parseDurationService();
                Vector songItems = ParseData.parseSongsInPlaylist(CuaTuiCanvasList.this.defaultlistkey, CuaTuiCanvasList.this.userName, 1, 10);
                if (songItems == null || items == null) {
                    CuaTuiCanvasList.this.displayMessage("NhacCuaTui", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i t\u1edbi m\u00e1y ch\u1ee7! Xin vui l\u00f2ng ki\u1ec3m tra k\u1ebft n\u1ed1i.", "error");
                    return;
                }
                if (songItems.isEmpty()) {
                    CuaTuiCanvasList.this.displayMessage("NhacCuaTui", "Ch\u01b0a c\u00f3 d\u1eef li\u1ec7u!", "error");
                    return;
                }
                PaymentCanvas pc = new PaymentCanvas(CuaTuiCanvasList.this.defaultPlaylist.getName(), items, CuaTuiCanvasList.this.defaultPlaylist, songItems, 0);
                pc.setObserver(CuaTuiCanvasList.this.observer);
                CuaTuiCanvasList.this.observer.replaceCurrent((Displayable)pc);
            }
        });
        this.mLoaDataThread.start();
    }

    public void cancel() {
        this.quit();
    }

    public void quit() {
        try {
            if (this.mLoaDataThread.isAlive()) {
                this.mLoaDataThread.join();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

