/*
 * Decompiled with CFR 0.152.
 */
package st.nct;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import org.json.me.JSONObject;
import st.nct.CuaTuiCanvasList;
import st.nct.LoadDataObserver;
import st.nct.MainCanvasList;
import st.nct.MessageForm;
import st.nct.common.ParseData;
import st.nct.common.ReadWriteRecordStore;
import st.nct.utils.Utils;

public class LoginForm
extends Form
implements CommandListener,
LoadDataObserver {
    private TextField userName = new TextField("UserName:", "", 30, 0);
    private TextField password = new TextField("Password:", "", 30, 65536);
    private Command exitCommand;
    private Command loginComand;
    private Command nowPlayingCommand;
    StringItem message = new StringItem("", "");
    private Utils.BreadCrumbTrail observer;
    Thread mLoaDataThread;
    private String defaultlistkey;

    public LoginForm(String title) {
        super(title);
        this.readLoginRecordStore();
        this.append((Item)this.userName);
        this.append((Item)this.password);
        this.append((Item)this.message);
        this.initMenu();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exitCommand) {
            this.observer.goBack();
        } else if (c == this.loginComand) {
            this.doLogin(this.userName.getString(), this.password.getString());
        } else if (c == this.nowPlayingCommand) {
            MainCanvasList.gotoNowPlaying(this.observer);
        }
    }

    private void doLogin(final String userName, final String passWord) {
        this.message.setText("");
        if (!this.checkLoginInvalidate()) {
            this.message.setText("Xin vui l\u00f2ng nh\u1eadp \u0111\u1ea7y \u0111\u1ee7 th\u00f4ng tin t\u00e0i kho\u1ea3n!");
            return;
        }
        this.displayMessage("\u0110ang t\u1ea3i d\u1eef li\u1ec7u...", "loading");
        this.mLoaDataThread = new Thread(new Runnable(){

            public void run() {
                String result = ParseData.parseLoginResult(userName, passWord);
                try {
                    JSONObject json = new JSONObject(result);
                    result = json.getString("result");
                    LoginForm.this.defaultlistkey = json.getString("defaultlistkey");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if ("LoginSuccess".equals(result)) {
                    ReadWriteRecordStore recordStore = new ReadWriteRecordStore();
                    recordStore.deleteRecStore();
                    LoginForm.this.writeUserNameToRecordStore(userName, passWord);
                    LoginForm.this.gotoCuaTui();
                } else {
                    LoginForm form = new LoginForm("\u0110\u0103ng nh\u1eadp");
                    form.setObserver(LoginForm.this.observer);
                    form.message.setText("\u0110\u0103ng nh\u1eadp th\u1ea5t b\u1ea1i! Vui l\u00f2ng ki\u1ec3m tra th\u00f4ng tin t\u00e0i kho\u1ea3n");
                    LoginForm.this.observer.replaceCurrent((Displayable)form);
                }
            }
        });
        this.mLoaDataThread.start();
    }

    public void setObserver(Utils.BreadCrumbTrail _observer) {
        this.observer = _observer;
    }

    private void gotoCuaTui() {
        Image[] images = null;
        try {
            images = new Image[]{Image.createImage((String)"/images/icon_listened.png"), Image.createImage((String)"/images/icon_tui.png"), Image.createImage((String)"/images/icon_like.png")};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] mainItems = new String[]{"Nghe NhacCuaTui", "Playlist c\u1ee7a Tui", "Playlist Tui th\u00edch"};
        CuaTuiCanvasList myCanvas = new CuaTuiCanvasList(this.userName.getString(), mainItems, images, this.defaultlistkey);
        myCanvas.setObserver(this.observer);
        this.observer.replaceCurrent((Displayable)myCanvas);
    }

    private void displayMessage(String message, String messageType) {
        MessageForm messageForm = new MessageForm("\u0110\u0103ng nh\u1eadp", message, messageType);
        messageForm.setObserver(this.observer);
        if (messageType.equals("error")) {
            this.observer.go((Displayable)messageForm);
        } else {
            this.observer.replaceCurrent((Displayable)messageForm);
        }
    }

    private void writeUserNameToRecordStore(String userName, String pass) {
        try {
            ReadWriteRecordStore recordStore = new ReadWriteRecordStore();
            recordStore.openRecStore();
            recordStore.writeRecord(userName);
            recordStore.writeRecord(pass);
            recordStore.closeRecStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readLoginRecordStore() {
        try {
            ReadWriteRecordStore recordStore = new ReadWriteRecordStore();
            recordStore.openRecStore();
            Vector items = recordStore.readRecords();
            recordStore.closeRecStore();
            if (items == null) {
                return;
            }
            if (items.size() >= 2) {
                String name = (String)items.elementAt(0);
                String pass = (String)items.elementAt(1);
                if (!"".equals(name) && !"".equals(pass)) {
                    this.userName = new TextField("UserName:", name, 50, 0);
                    this.password = new TextField("Password:", pass, 50, 65536);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMenu() {
        this.loginComand = new Command("Login", 8, 0);
        this.nowPlayingCommand = new Command("\u0110ang ch\u01a1i...", 8, 1);
        this.exitCommand = new Command("Tr\u1edf l\u1ea1i", 7, 0);
        this.addCommand(this.loginComand);
        this.addCommand(this.exitCommand);
        this.addCommand(this.nowPlayingCommand);
        this.setCommandListener(this);
    }

    private boolean checkLoginInvalidate() {
        return !this.userName.getString().equals("") && !this.password.getString().equals("");
    }

    public void cancel() {
        this.quit();
    }

    public void quit() {
        try {
            if (this.mLoaDataThread.isAlive()) {
                this.mLoaDataThread.join();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

