/*
 * Decompiled with CFR 0.152.
 */
package st.nct;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import st.nct.AboutCanvas;
import st.nct.CategoryCanvasList;
import st.nct.HelpCanvas;
import st.nct.LoadDataObserver;
import st.nct.LoginForm;
import st.nct.MessageForm;
import st.nct.PlaylistCanvasList;
import st.nct.SearchForm;
import st.nct.SongCanvasList;
import st.nct.common.ParseData;
import st.nct.utils.Utils;

public class MainCanvasList
extends Canvas
implements CommandListener,
LoadDataObserver {
    private Command nowPlayingCommand;
    private Command selectCommand;
    private Command exitCommand;
    private Utils.BreadCrumbTrail observer;
    int linePadding = 0;
    int margin = 2;
    int padding = 0;
    Font font = Font.getDefaultFont();
    int bgColor = 0xEEEEEE;
    int foreColor = 0;
    int foreSelectedColor = 0xEEEEEE;
    int backColor = 0xEEEEEE;
    int backSelectedColor = 0x505050;
    int borderWidth = 0;
    int borderColor = 0;
    int borderSelectedColor = 0xFF0000;
    String[][] itemLines = null;
    Image[] images = null;
    public int selectedItem = 0;
    int[] itemsTop = null;
    int[] itemsHeight = null;
    int scrollTop = 0;
    final int SCROLL_STEP;
    Thread mLoaDataThread;

    public MainCanvasList(String title, String[] items, Image[] imageElements) {
        this.SCROLL_STEP = 20;
        this.setTitle(title);
        this.initMenu();
        this.images = imageElements;
        this.itemLines = new String[items.length][];
        this.itemsTop = new int[this.itemLines.length];
        this.itemsHeight = new int[this.itemLines.length];
        for (int i = 0; i < this.itemLines.length; ++i) {
            Image imagePart = this.getImage(i);
            int w = this.getItemWidth() - (imagePart != null ? imagePart.getWidth() + this.padding : 0);
            this.itemLines[i] = MainCanvasList.getTextRows(items[i], this.font, w);
        }
    }

    protected void paint(Graphics g) {
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.translate(0, -this.scrollTop);
        int top = 0;
        this.font = Font.getFont((int)0, (int)1, (int)16);
        g.setFont(this.font);
        for (int i = 0; i < this.itemLines.length; ++i) {
            int itemRows = this.itemLines[i].length;
            Image imagePart = this.getImage(i);
            int itemHeight = itemRows * this.font.getHeight() + this.linePadding * (itemRows - 1);
            this.itemsTop[i] = top;
            this.itemsHeight[i] = itemHeight;
            if (imagePart != null && imagePart.getHeight() > itemHeight) {
                itemHeight = imagePart.getHeight();
            }
            itemHeight += 2 * this.padding + 2 * this.borderWidth;
            g.translate(0, top);
            if (this.borderWidth > 0) {
                g.setColor(i == this.selectedItem ? this.borderSelectedColor : this.borderColor);
                g.fillRect(this.margin, this.margin, this.getWidth() - 2 * this.margin, itemHeight);
            }
            g.setColor(i == this.selectedItem ? this.backSelectedColor : this.backColor);
            g.fillRoundRect(this.margin + this.borderWidth, this.margin + this.borderWidth, this.getWidth() - 2 * this.margin - 2 * this.borderWidth, itemHeight - 2 * this.borderWidth, 5, 10);
            if (imagePart != null) {
                g.drawImage(imagePart, this.margin + this.borderWidth + this.padding, this.margin + this.borderWidth + this.padding, 20);
            }
            g.setColor(i == this.selectedItem ? this.foreSelectedColor : this.foreColor);
            int textLeft = this.margin + this.borderWidth + this.padding + (imagePart != null ? imagePart.getWidth() + this.padding : 0);
            for (int j = 0; j < itemRows; ++j) {
                g.drawString(this.itemLines[i][j], textLeft + 5, this.margin + this.borderWidth + this.padding + j * (this.linePadding + this.font.getHeight()), 20);
            }
            g.translate(0, -top);
            top += itemHeight + 2 * this.margin;
        }
        g.translate(0, this.scrollTop);
    }

    protected void keyPressed(int key) {
        int keyCode = this.getGameAction(key);
        if (this.itemLines.length > 0) {
            if (keyCode == 1) {
                if (this.itemsTop[this.selectedItem] < this.scrollTop) {
                    this.scrollTop -= 20;
                    this.repaint();
                } else if (this.selectedItem > 0) {
                    --this.selectedItem;
                    this.repaint();
                }
            } else if (keyCode == 6) {
                if (this.itemsTop[this.selectedItem] + this.itemsHeight[this.selectedItem] >= this.scrollTop + this.getHeight()) {
                    this.scrollTop += 20;
                    this.repaint();
                } else if (this.selectedItem < this.itemLines.length - 1) {
                    ++this.selectedItem;
                    this.repaint();
                }
            } else if (keyCode == 8 || keyCode == -5) {
                this.itemAction();
            }
        }
        super.keyPressed(key);
    }

    public int getItemWidth() {
        return this.getWidth() - 2 * this.borderWidth - 2 * this.padding - 2 * this.margin;
    }

    Image getImage(int index) {
        return this.images != null && this.images.length > index ? this.images[index] : null;
    }

    public static String[] getTextRows(String text, Font font, int width) {
        char SPACE_CHAR = ' ';
        String VOID_STRING = "";
        int prevIndex = 0;
        int currIndex = text.indexOf(SPACE_CHAR);
        Vector<String> rowsVector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        String currentRowText = VOID_STRING;
        while (prevIndex != -1) {
            int startCharIndex = prevIndex == 0 ? prevIndex : prevIndex + 1;
            String currentToken = currIndex != -1 ? text.substring(startCharIndex, currIndex) : text.substring(startCharIndex);
            prevIndex = currIndex;
            currIndex = text.indexOf(SPACE_CHAR, prevIndex + 1);
            if (currentToken.length() == 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(SPACE_CHAR);
            }
            stringBuffer.append(currentToken);
            if (font.stringWidth(stringBuffer.toString()) > width) {
                if (currentRowText.length() > 0) {
                    rowsVector.addElement(currentRowText);
                }
                stringBuffer.setLength(0);
                currentRowText = VOID_STRING;
                stringBuffer.append(currentToken);
                currentRowText = stringBuffer.toString();
                continue;
            }
            currentRowText = stringBuffer.toString();
        }
        if (currentRowText.length() > 0) {
            rowsVector.addElement(currentRowText);
        }
        Object[] rowsArray = new String[rowsVector.size()];
        rowsVector.copyInto(rowsArray);
        return rowsArray;
    }

    protected void paintTitleBarBackground(Graphics g, int x, int y) {
        try {
            Image image = Image.createImage((String)"/images/title.png");
            g.drawImage(image, x, y, 20);
            int ofset = (y + image.getHeight()) / 4;
            this.font = Font.getFont((int)0, (int)1, (int)16);
            g.setFont(this.font);
            g.drawString("NhacCuaTui", (x + image.getWidth()) / 4, ofset, 20);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.selectCommand) {
            this.itemAction();
        } else if (c == this.exitCommand) {
            this.observer.goBack();
        } else if (c == this.nowPlayingCommand) {
            MainCanvasList.gotoNowPlaying(this.observer);
        }
    }

    public static void gotoNowPlaying(Utils.BreadCrumbTrail observer) {
        if (SongCanvasList.playerCanvas != null) {
            SongCanvasList.playerCanvas.setObserver(observer);
            observer.go((Displayable)SongCanvasList.playerCanvas);
        }
    }

    public void setObserver(Utils.BreadCrumbTrail mObserver) {
        this.observer = mObserver;
    }

    private void gotoCate() {
        this.mLoaDataThread = new Thread(new Runnable(){

            public void run() {
                Vector cateItems = ParseData.parseCate(2);
                if (cateItems == null) {
                    MainCanvasList.displayMessage("NhacCuaTui", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i t\u1edbi m\u00e1y ch\u1ee7! Xin vui l\u00f2ng ki\u1ec3m tra k\u1ebft n\u1ed1i.", "error", MainCanvasList.this.observer, MainCanvasList.this);
                    return;
                }
                if (cateItems.size() == 0) {
                    MainCanvasList.displayMessage("NhacCuaTui", "Ch\u01b0a c\u00f3 d\u1eef li\u1ec7u!", "error", MainCanvasList.this.observer, MainCanvasList.this);
                    return;
                }
                CategoryCanvasList cateCanvas = new CategoryCanvasList("Th\u1ec3 lo\u1ea1i", cateItems);
                cateCanvas.setObserver(MainCanvasList.this.observer);
                MainCanvasList.this.observer.replaceCurrent((Displayable)cateCanvas);
            }
        });
        this.mLoaDataThread.start();
    }

    private void gotoHotPlaylist() {
        this.mLoaDataThread = new Thread(new Runnable(){

            public void run() {
                Vector playlistItems = ParseData.parseHotPlaylist(1, 10);
                if (playlistItems == null) {
                    MainCanvasList.displayMessage("NhacCuaTui", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i t\u1edbi m\u00e1y ch\u1ee7! Xin vui l\u00f2ng ki\u1ec3m tra k\u1ebft n\u1ed1i.", "error", MainCanvasList.this.observer, MainCanvasList.this);
                    return;
                }
                if (playlistItems.size() == 0) {
                    MainCanvasList.displayMessage("NhacCuaTui", "Ch\u01b0a c\u00f3 d\u1eef li\u1ec7u!", "error", MainCanvasList.this.observer, MainCanvasList.this);
                    return;
                }
                PlaylistCanvasList playlistCanvas = new PlaylistCanvasList("Playlist Hot", playlistItems, "hot", "");
                playlistCanvas.setObserver(MainCanvasList.this.observer);
                MainCanvasList.this.observer.replaceCurrent((Displayable)playlistCanvas);
            }
        });
        this.mLoaDataThread.start();
    }

    private void gotoNewPlaylist() {
        this.mLoaDataThread = new Thread(new Runnable(){

            public void run() {
                Vector playlistItems = ParseData.parseNewPlaylist(1, 10);
                if (playlistItems == null) {
                    MainCanvasList.displayMessage("NhacCuaTui", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i t\u1edbi m\u00e1y ch\u1ee7! Xin vui l\u00f2ng ki\u1ec3m tra k\u1ebft n\u1ed1i.", "error", MainCanvasList.this.observer, MainCanvasList.this);
                    return;
                }
                if (playlistItems.size() == 0) {
                    MainCanvasList.displayMessage("NhacCuaTui", "Ch\u01b0a c\u00f3 d\u1eef li\u1ec7u!", "error", MainCanvasList.this.observer, MainCanvasList.this);
                    return;
                }
                PlaylistCanvasList playlistCanvas = new PlaylistCanvasList("Playlist New", playlistItems, "new", "");
                playlistCanvas.setObserver(MainCanvasList.this.observer);
                MainCanvasList.this.observer.replaceCurrent((Displayable)playlistCanvas);
            }
        });
        this.mLoaDataThread.start();
    }

    public static void gotoSearch(Utils.BreadCrumbTrail observer) {
        SearchForm searchForm = new SearchForm("T\u00ecm ki\u1ebfm");
        searchForm.setObserver(observer);
        observer.go((Displayable)searchForm);
    }

    private void gotoLogin() {
        LoginForm loginForm = new LoginForm("\u0110\u0103ng nh\u1eadp");
        loginForm.setObserver(this.observer);
        this.observer.go((Displayable)loginForm);
    }

    public static void gotoAbout(Utils.BreadCrumbTrail observer) {
        AboutCanvas aboutCanvas = new AboutCanvas("Th\u00f4ng tin", observer);
        observer.go((Displayable)aboutCanvas);
    }

    public static void gotoHelp(Utils.BreadCrumbTrail observer) {
        HelpCanvas aboutCanvas = new HelpCanvas("Privacy Policy", observer);
        observer.go((Displayable)aboutCanvas);
    }

    private void itemAction() {
        if (this.selectedItem == 2) {
            MainCanvasList.displayMessage("NhacCuaTui", "\u0110ang t\u1ea3i d\u1eef li\u1ec7u...", "loading", this.observer, this);
            this.gotoCate();
        } else if (this.selectedItem == 0) {
            MainCanvasList.displayMessage("NhacCuaTui", "\u0110ang t\u1ea3i d\u1eef li\u1ec7u...", "loading", this.observer, this);
            this.gotoHotPlaylist();
        } else if (this.selectedItem == 1) {
            MainCanvasList.displayMessage("NhacCuaTui", "\u0110ang t\u1ea3i d\u1eef li\u1ec7u...", "loading", this.observer, this);
            this.gotoNewPlaylist();
        } else if (this.selectedItem == 4) {
            MainCanvasList.gotoSearch(this.observer);
        } else if (this.selectedItem == 3) {
            this.gotoLogin();
        } else if (this.selectedItem == 5) {
            MainCanvasList.gotoAbout(this.observer);
        } else {
            MainCanvasList.gotoHelp(this.observer);
        }
    }

    public static void displayMessage(String title, String message, String messageType, Utils.BreadCrumbTrail observer, LoadDataObserver loadDataOberserver) {
        MessageForm messageForm = new MessageForm(title, message, messageType);
        messageForm.setObserver(observer);
        if (loadDataOberserver != null) {
            messageForm.setLoadDataOberserver(loadDataOberserver);
        }
        if (messageType.equals("error")) {
            observer.replaceCurrent((Displayable)messageForm);
        } else {
            observer.go((Displayable)messageForm);
        }
    }

    private void initMenu() {
        this.selectCommand = new Command("Ch\u1ecdn", 8, 0);
        this.nowPlayingCommand = new Command("\u0110ang ch\u01a1i...", 8, 1);
        this.exitCommand = new Command("Tho\u00e1t", 7, 0);
        this.addCommand(this.selectCommand);
        this.addCommand(this.exitCommand);
        this.addCommand(this.nowPlayingCommand);
        this.setCommandListener(this);
    }

    public void cancel() {
        this.quit();
    }

    public synchronized void quit() {
        try {
            this.mLoaDataThread.interrupt();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

