/*
 * Decompiled with CFR 0.152.
 */
package st.nct;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import st.nct.LoadDataObserver;
import st.nct.MainCanvasList;
import st.nct.PlayerCanvas;
import st.nct.SongCanvasList;
import st.nct.common.ChargeObserver;
import st.nct.common.ChargeService;
import st.nct.model.Payment;
import st.nct.model.Playlist;
import st.nct.utils.Utils;

public class PaymentCanvas
extends Canvas
implements CommandListener,
ChargeObserver,
LoadDataObserver {
    private Command exitCommand;
    private Command selectCommand;
    int linePadding = 0;
    int margin = 2;
    int padding = 0;
    Font font = Font.getDefaultFont();
    int bgColor = 0xEEEEEE;
    int foreColor = 0;
    int foreSelectedColor = 0xEEEEEE;
    int backColor = 0xEEEEEE;
    int backSelectedColor = 0x505050;
    int borderWidth = 0;
    int borderColor = 0;
    int borderSelectedColor = 0xFF0000;
    public int selectedItem = 0;
    public int selectedSongItem = 0;
    int[] itemsTop = null;
    int[] itemsHeight = null;
    int scrollTop = 0;
    final int SCROLL_STEP;
    Vector lstPayment;
    private Utils.BreadCrumbTrail observer;
    int curPage = 1;
    int perPage = 10;
    static PlayerCanvas playerCanvas = null;
    private Playlist playlist;
    Vector songItems;
    final String MESS;

    public PaymentCanvas(String title, Vector items, Playlist _playlist, Vector _songItems, int _selectedSongItem) {
        this.SCROLL_STEP = 40;
        this.MESS = "T\u00e0i kho\u1ea3n ch\u01b0a \u0111\u0103ng k\u00ed g\u00f3i d\u1ecbch v\u1ee5 n\u00e0o, h\u00e3y \u0111\u0103ng k\u00ed g\u00f3i c\u01b0\u1edbc \u0111\u1ec3 \u0111\u01b0\u1ee3c mi\u1ec5n ph\u00ed 3G.";
        this.setTitle(title);
        this.songItems = _songItems;
        this.selectedSongItem = _selectedSongItem;
        this.playlist = _playlist;
        this.curPage = 1;
        this.perPage = 10;
        this.selectCommand = new Command("Ch\u1ecdn", 8, 0);
        this.exitCommand = new Command("Tr\u1edf l\u1ea1i", 2, 1);
        this.addCommand(this.selectCommand);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
        this.lstPayment = items;
        this.initComponents();
    }

    protected void paint(Graphics g) {
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.translate(0, -this.scrollTop);
        int top = 2;
        this.font = Font.getFont((int)0, (int)1, (int)8);
        g.setFont(this.font);
        if (this.lstPayment == null || this.lstPayment.size() == 0) {
            return;
        }
        this.font = Font.getFont((int)0, (int)1, (int)0);
        g.setFont(this.font);
        for (int i = 0; i < this.lstPayment.size(); ++i) {
            int itemRows = 1;
            int itemHeight = itemRows * this.font.getHeight() + this.linePadding * (itemRows - 1);
            this.itemsTop[i] = top;
            this.itemsHeight[i] = itemHeight;
            itemHeight += 2 * this.padding + 2 * this.borderWidth;
            g.translate(0, top);
            if (this.borderWidth > 0) {
                g.setColor(i == this.selectedItem ? this.borderSelectedColor : this.borderColor);
                g.fillRect(this.margin, this.margin, this.getWidth() - 2 * this.margin, itemHeight);
            }
            g.setColor(i == this.selectedItem ? this.backSelectedColor : this.backColor);
            g.fillRoundRect(this.margin + this.borderWidth, this.margin + this.borderWidth, this.getWidth() - 2 * this.margin - 2 * this.borderWidth, itemHeight - 2 * this.borderWidth, 5, 10);
            g.setColor(i == this.selectedItem ? this.foreSelectedColor : this.foreColor);
            int textLeft = this.margin + this.borderWidth + this.padding;
            Payment p = (Payment)this.lstPayment.elementAt(i);
            g.drawString(p.getName(), textLeft + 5, this.margin + this.borderWidth + this.padding, 20);
            g.translate(0, -top);
            top += itemHeight + 2 * this.margin;
        }
        g.translate(0, this.scrollTop);
    }

    protected void keyPressed(int key) {
        int keyCode = this.getGameAction(key);
        if (this.lstPayment.size() > 0) {
            if (keyCode == 1) {
                if (this.itemsTop[this.selectedItem] < this.scrollTop) {
                    this.scrollTop -= 40;
                    this.repaint();
                } else if (this.selectedItem > 0) {
                    --this.selectedItem;
                    this.repaint();
                }
            } else if (keyCode == 6) {
                if (this.itemsTop[this.selectedItem] + this.itemsHeight[this.selectedItem] >= this.scrollTop + this.getHeight()) {
                    this.scrollTop += 40;
                    this.repaint();
                } else if (this.selectedItem < this.lstPayment.size() - 1) {
                    ++this.selectedItem;
                    this.repaint();
                }
            } else if (keyCode == 8 || keyCode == -5) {
                this.doPayment();
            }
        }
        super.keyPressed(key);
    }

    public int getItemWidth() {
        return this.getWidth() - 2 * this.borderWidth - 2 * this.padding - 2 * this.margin;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exitCommand) {
            this.observer.goBack();
        } else if (c == this.selectCommand) {
            this.doPayment();
        }
    }

    private void initComponents() {
        this.itemsTop = new int[this.lstPayment.size()];
        this.itemsHeight = new int[this.lstPayment.size()];
    }

    public void setObserver(Utils.BreadCrumbTrail _observer) {
        this.observer = _observer;
    }

    private void doPayment() {
        Payment payment = (Payment)this.lstPayment.elementAt(this.selectedItem);
        if (payment == null) {
            return;
        }
        ChargeService charge = new ChargeService();
        charge.setObserver(this);
        MainCanvasList.displayMessage("NhacCuaTui", "\u0110ang \u0111\u0103ng k\u00fd g\u00f3i c\u01b0\u1edbc, xin vui l\u00f2ng ch\u1edd trong gi\u00e2y l\u00e1t...", "loading", this.observer, this);
        charge.doCharge(this.playlist.getId(), payment.getCode(), payment.getPrice());
    }

    public void checkCompleted(String result, String errorCode) {
        if ("true".equals(result)) {
            this.observer.goBack();
            this.gotoPlaySong(this.songItems);
        } else {
            String _errorCode = "Thanh to\u00e1n kh\u00f4ng th\u00e0nh c\u00f4ng.";
            MainCanvasList.displayMessage("NhacCuaTui", _errorCode, "error", this.observer, this);
        }
    }

    private void gotoPlaySong(Vector songItems) {
        if (SongCanvasList.playerCanvas == null) {
            SongCanvasList.playerCanvas = new PlayerCanvas("NhacCuaTui", songItems, this.selectedSongItem, this.playlist);
        } else {
            SongCanvasList.playerCanvas.change("NhacCuaTui", songItems, this.selectedSongItem, this.playlist);
        }
        SongCanvasList.playerCanvas.setObserver(this.observer);
        this.observer.replaceCurrent((Displayable)SongCanvasList.playerCanvas);
    }

    public void checkError() {
        MainCanvasList.displayMessage("NhacCuaTui", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i t\u1edbi m\u00e1y ch\u1ee7! Xin vui l\u00f2ng ki\u1ec3m tra k\u1ebft n\u1ed1i.", "error", this.observer, this);
    }

    public void cancel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

