/*
 * Decompiled with CFR 0.152.
 */
package st.nct;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import st.nct.LoadDataObserver;
import st.nct.MainCanvasList;
import st.nct.PlayerGUI;
import st.nct.common.ConvertMessage;
import st.nct.common.LikeOberserver;
import st.nct.common.LikePlaylist;
import st.nct.common.ReadWriteRecordStore;
import st.nct.model.Playlist;
import st.nct.utils.Utils;

public class PlayerCanvas
extends Canvas
implements CommandListener,
LikeOberserver,
LoadDataObserver {
    private Command backCommand = new Command("Tr\u1edf l\u1ea1i", 2, 1);
    private Command playCommand = new Command("Toggle Play", 8, 1);
    private Command pauseCommand = new Command("Pause", 8, 1);
    private Command stopCommand = new Command("Stop", 8, 1);
    private Command nextCommand = new Command("Next Song", 8, 5);
    private Command prevCommand = new Command("Prev Song", 8, 5);
    private Command likeCommand = new Command("Like/Unlike", 8, 5);
    private static int PLAYER_STATUS_TOP = 2;
    private static int SONG_TITLE_GAP = 2;
    private static int TIME_GAP = 5;
    private String title;
    private PlayerGUI gui;
    private Utils.BreadCrumbTrail parent;
    private String status = "";
    private String userName = "";
    int displayWidth = -1;
    int displayHeight = -1;
    int textHeight = 10;
    int logoTop = 0;
    int songTitleTop = 0;
    int timeRateTop = 0;
    int timeWidth = 0;
    int feedbackTop = 0;
    int statusTop = 0;
    private Utils.BreadCrumbTrail observer = null;
    private Playlist playlist;
    private boolean _play = false;
    private Image _imgPlay = null;
    private Image _imgPause = null;
    private Image _imgBack = null;
    private Image _imgNext = null;
    private Image _imgBackActive = null;
    private Image _imgNextActive = null;
    int statusBarTop = 0;
    int statusBarHeight = 0;
    int songNameTop = 0;
    int SignerNameTop = 0;
    int sliderTop = 0;
    int sliderLeft = 0;
    int sliderHeight = 10;
    int sliderWidth = 10;
    float slidervalue = 0.0f;
    int playtop = 0;
    public long timeBack = 0L;
    public long timeNext = 0L;
    public boolean goBack = false;
    public boolean goNext = false;

    public PlayerCanvas(String title, Vector lst, int index, Playlist _playlist) {
        this.playlist = _playlist;
        this.setTitle(title);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.createCommand();
        this.change(title, lst, index, this.playlist);
    }

    public void showNotify() {
        if (!this.status.equals("\u0110ang ch\u01a1i...") && !this.status.equals("T\u1ea1m d\u1eebng...")) {
            return;
        }
        if (this.getGUI().getIsPlaying()) {
            this.setStatus("\u0110ang ch\u01a1i...");
        } else {
            this.setStatus("T\u1ea1m d\u1eebng...");
        }
    }

    public void change(String title, Vector lst, int index, Playlist _playlist) {
        this.title = title;
        this.setTitle(title);
        this.playlist = _playlist;
        this.getGUI().setListSong(lst, index);
        this._play = true;
    }

    public void setupDisplay() {
        this.displayHeight = -1;
        this.updateDisplay();
    }

    public String getTitle() {
        return this.title;
    }

    public void setStatus(String s) {
        this.status = s;
        this.updateDisplay();
    }

    public void updateDisplay() {
        this.repaint();
        this.serviceRepaints();
    }

    public synchronized void close() {
        if (this.gui != null) {
            this.gui.closePlayer();
            this.gui = null;
        }
    }

    private synchronized PlayerGUI getGUI() {
        if (this.gui == null) {
            this.gui = new PlayerGUI(this);
        }
        return this.gui;
    }

    protected void keyPressed(int keycode) {
        try {
            switch (keycode) {
                case 53: {
                    this.gui.pausePlayer();
                    this.gui.setMediaTime(0L);
                    break;
                }
                default: {
                    int code = this.getGameAction(keycode);
                    if (code == 5) {
                        this.goNext = true;
                        this.timeNext = System.currentTimeMillis();
                        this.gui.getNextSong();
                        break;
                    }
                    if (code == 2) {
                        this.goBack = true;
                        this.timeBack = System.currentTimeMillis();
                        this.gui.getPrevSong();
                        break;
                    }
                    if (code == 1) {
                        this.gui.changeVolume(false);
                        break;
                    }
                    if (code == 6) {
                        this.gui.changeVolume(true);
                        break;
                    }
                    if (code == 8) {
                        this.gui.togglePlayer();
                    }
                    break;
                }
            }
        }
        catch (Throwable t) {
            Utils.error(t, this.parent);
        }
    }

    private boolean intersects(int clipY, int clipHeight, int y, int h) {
        return clipY <= y + h && clipY + clipHeight >= y;
    }

    private String timeDisplay(long us) {
        long ts = us / 100000L;
        return this.formatNumber(ts / 600L, 2, true) + ":" + this.formatNumber(ts % 600L / 10L, 2, true);
    }

    private String formatNumber(long num, int len, boolean leadingZeros) {
        StringBuffer ret = new StringBuffer(String.valueOf(num));
        if (leadingZeros) {
            while (ret.length() < len) {
                ret.insert(0, '0');
            }
        } else {
            while (ret.length() < len) {
                ret.append('0');
            }
        }
        return ret.toString();
    }

    public Image imgPlay() {
        if (this._imgPlay == null) {
            try {
                this._imgPlay = Image.createImage((String)"/images/icon-play.png");
            }
            catch (Exception ex) {
                this._imgPlay = null;
            }
        }
        return this._imgPlay;
    }

    public Image imgPause() {
        if (this._imgPause == null) {
            try {
                this._imgPause = Image.createImage((String)"/images/icon-pause.png");
            }
            catch (Exception ex) {
                this._imgPause = null;
            }
        }
        return this._imgPause;
    }

    public Image imgBack() {
        if (this._imgBack == null) {
            try {
                this._imgBack = Image.createImage((String)"/images/button-back.png");
            }
            catch (Exception ex) {
                this._imgBack = null;
            }
        }
        return this._imgBack;
    }

    public Image imgNext() {
        if (this._imgNext == null) {
            try {
                this._imgNext = Image.createImage((String)"/images/button-next.png");
            }
            catch (Exception ex) {
                this._imgNext = null;
            }
        }
        return this._imgNext;
    }

    public Image imgBackActive() {
        if (this._imgBackActive == null) {
            try {
                this._imgBackActive = Image.createImage((String)"/images/button-back-active.png");
            }
            catch (Exception ex) {
                this._imgBackActive = null;
            }
        }
        return this._imgBackActive;
    }

    public Image imgNextActive() {
        if (this._imgNextActive == null) {
            try {
                this._imgNextActive = Image.createImage((String)"/images/button-next-active.png");
            }
            catch (Exception ex) {
                this._imgNextActive = null;
            }
        }
        return this._imgNextActive;
    }

    public void paint(Graphics g) {
        try {
            if (this.displayHeight == -1) {
                int currTop;
                this.displayWidth = this.getWidth();
                this.displayHeight = this.getHeight();
                this.textHeight = g.getFont().getHeight();
                this.statusBarHeight = this.textHeight + 5;
                this.songNameTop = currTop = PLAYER_STATUS_TOP + this.statusBarHeight;
                this.SignerNameTop = currTop += SONG_TITLE_GAP + this.textHeight;
                this.timeRateTop = currTop += TIME_GAP + this.textHeight;
                this.timeWidth = g.getFont().stringWidth("0:00:0  ");
                this.sliderHeight = 10;
                this.sliderWidth = this.displayWidth - 20;
                this.sliderTop = this.timeRateTop + this.textHeight + 10;
                this.sliderLeft = this.displayWidth - this.sliderWidth >> 1;
                this.playtop = this.sliderTop + this.sliderHeight + 30;
                this.feedbackTop = this.sliderTop + this.sliderHeight + this.textHeight;
            }
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            g.setColor(232, 232, 232);
            g.fillRect(0, 0, this.displayWidth, this.displayHeight);
            g.setColor(19, 118, 159);
            g.fillRect(0, 0, this.displayWidth, this.statusBarHeight);
            if (this.intersects(clipY, clipHeight, PLAYER_STATUS_TOP, this.textHeight)) {
                g.setColor(0xFFFFFF);
                g.drawString(this.status, this.displayWidth >> 1, PLAYER_STATUS_TOP, 17);
            }
            if (this.gui != null) {
                if (this.intersects(clipY, clipHeight, this.songNameTop, this.textHeight)) {
                    g.setColor(16, 102, 137);
                    g.drawString(this.gui.getSongName(), this.displayWidth >> 1, this.songNameTop, 17);
                }
                if (this.intersects(clipY, clipHeight, this.SignerNameTop, this.textHeight)) {
                    g.setColor(101, 101, 101);
                    g.drawString(this.gui.getSinger(), this.displayWidth >> 1, this.SignerNameTop, 17);
                }
                g.setColor(101, 101, 101);
                g.drawLine(0, this.timeRateTop - 3, this.displayWidth, this.timeRateTop - 3);
                long duration = this.gui.getDuration();
                long current = this.gui.getCurrentTime();
                String strDuration = this.timeDisplay(duration);
                String strCurrent = this.timeDisplay(current);
                this.slidervalue = (float)this.sliderWidth * ((float)current / (float)duration);
                if (this.intersects(clipY, clipHeight, this.timeRateTop, this.textHeight) && this.intersects(clipX, clipWidth, 0, this.timeWidth)) {
                    g.setColor(101, 101, 101);
                    g.drawString(strCurrent, 0, this.timeRateTop, 20);
                    g.drawString(strDuration, this.displayWidth, this.timeRateTop, 24);
                }
                g.setColor(49, 84, 112);
                g.fillRect(this.sliderLeft, this.sliderTop, this.sliderWidth, this.sliderHeight);
                g.setColor(1, 137, 199);
                g.fillRect(this.sliderLeft, this.sliderTop, (int)this.slidervalue, this.sliderHeight);
                if (!this.gui.getIsPlaying() && this.imgPlay() != null) {
                    g.drawImage(this._imgPlay, this.displayWidth >> 1, this.playtop, 3);
                }
                if (this.gui.getIsPlaying() && this.imgPause() != null) {
                    g.drawImage(this._imgPause, this.displayWidth >> 1, this.playtop, 3);
                }
                if (this.goBack || this.goNext) {
                    long time = System.currentTimeMillis();
                    if (time - this.timeBack >= 1000L) {
                        this.goBack = false;
                    }
                    if (time - this.timeNext >= 1000L) {
                        this.goNext = false;
                    }
                }
                if (this.goBack && this.imgBack() != null) {
                    g.drawImage(this._imgBack, 20, this.playtop, 6);
                }
                if (!this.goBack && this.imgBackActive() != null) {
                    g.drawImage(this._imgBackActive, 20, this.playtop, 6);
                }
                if (this.goNext && this.imgNext() != null) {
                    g.drawImage(this._imgNext, this.displayWidth - 20, this.playtop, 10);
                }
                if (!this.goNext && this.imgNextActive() != null) {
                    g.drawImage(this._imgNextActive, this.displayWidth - 20, this.playtop, 10);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (this._play) {
            this._play = false;
            this.getGUI().closePlayer();
            this.getGUI().startPlayer();
        }
    }

    public void setObserver(Utils.BreadCrumbTrail _observer) {
        this.observer = _observer;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.observer.goBack();
        } else if (c == this.nextCommand) {
            try {
                this.goNext = true;
                this.timeNext = System.currentTimeMillis();
                this.getGUI().getNextSong();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else if (c == this.prevCommand) {
            try {
                this.goBack = true;
                this.timeBack = System.currentTimeMillis();
                this.getGUI().getPrevSong();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else if (c == this.playCommand || c == this.pauseCommand) {
            this.getGUI().togglePlayer();
        } else if (c == this.stopCommand) {
            this.gui.pausePlayer();
            this.gui.setMediaTime(0L);
            this.setStatus("T\u1ea1m d\u1eebng...");
        } else if (c == this.likeCommand) {
            this.doLike();
        }
    }

    private void createCommand() {
        this.addCommand(this.playCommand);
        this.addCommand(this.stopCommand);
        this.addCommand(this.nextCommand);
        this.addCommand(this.prevCommand);
        this.addCommand(this.likeCommand);
    }

    private void doLike() {
        MainCanvasList.displayMessage("NhacCuaTui", "\u0110ang t\u1ea3i d\u1eef li\u1ec7u...", "loading", this.observer, this);
        this.readLoginRecordStore();
        if (!this.userName.equals("")) {
            LikePlaylist like = new LikePlaylist();
            like.setObserver(this);
            like.doLike(this.playlist.getId(), this.userName);
        } else {
            MainCanvasList.displayMessage("NhacCuaTui", "B\u1ea1n ch\u01b0a \u0111\u0103ng nh\u1eadp.  Xin vui l\u00f2ng \u0111\u0103ng nh\u1eadp \u0111\u1ec3 th\u1ef1c hi\u1ec7n ch\u1ee9c n\u0103ng n\u00e0y", "error", this.observer, this);
        }
    }

    private void readLoginRecordStore() {
        try {
            ReadWriteRecordStore recordStore = new ReadWriteRecordStore();
            recordStore.openRecStore();
            Vector items = recordStore.readRecords();
            recordStore.closeRecStore();
            if (items == null) {
                return;
            }
            if (items.size() >= 2) {
                String name = (String)items.elementAt(0);
                String pass = (String)items.elementAt(1);
                if (!"".equals(name) && !"".equals(pass)) {
                    this.userName = name;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void likeComplete(String result) {
        MainCanvasList.displayMessage("NhacCuaTui", ConvertMessage.convertLikeMessage(result), "error", this.observer, this);
    }

    public void cancel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

