/*
 * Decompiled with CFR 0.152.
 */
package st.nct;

import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import st.nct.PlayerCanvas;
import st.nct.model.Song;

public class PlayerGUI
implements PlayerListener {
    private static final int DEFAULT_TIMER_INTERVAL = 500;
    private int timerInterval = 500;
    private Timer guiTimer = null;
    private TimerTask timeDisplayTask = null;
    private PlayerCanvas parent;
    private Player player = null;
    Vector listSong = null;
    int index = 0;
    private static final int SONG_DISPLAY_COUNTER = 4;
    private boolean restartOnResume = false;
    private boolean isplaying;

    public PlayerGUI(PlayerCanvas parent) {
        this.parent = parent;
        this.setStatus("");
        this.guiTimer = new Timer();
    }

    public void setListSong(Vector lst, int index) {
        this.index = index;
        this.listSong = lst;
        this.closePlayer();
        this.setStatus("");
        this.parent.updateDisplay();
    }

    public Vector getListSong() {
        return this.listSong;
    }

    public boolean getIsPlaying() {
        if (this.player == null) {
            return false;
        }
        return this.player.getState() >= 400;
    }

    public String getSongName() {
        Song s = (Song)this.listSong.elementAt(this.index);
        if (s != null) {
            return s.getSongName();
        }
        return "";
    }

    public String getSinger() {
        Song s = (Song)this.listSong.elementAt(this.index);
        if (s != null) {
            return s.getArtistName();
        }
        return "";
    }

    public long getDuration() {
        Song s = (Song)this.listSong.elementAt(this.index);
        return (long)s.getDuration() * 1000000L;
    }

    public long getCurrentTime() {
        try {
            if (this.player != null) {
                return this.player.getMediaTime();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return 0L;
    }

    private void setStatus(String s) {
        this.parent.setStatus(s);
    }

    private VolumeControl getVolumeControl() {
        try {
            if (this.player != null) {
                return (VolumeControl)this.player.getControl("VolumeControl");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private void assertPlayer() throws Throwable {
        try {
            this.setStatus("\u0110ang t\u1ea3i...");
            Song s = (Song)this.listSong.elementAt(this.index);
            this.player = Manager.createPlayer((String)s.getStreamUrl());
            this.player.addPlayerListener((PlayerListener)this);
            this.player.realize();
            this.player.prefetch();
            this.parent.setupDisplay();
        }
        catch (Throwable t) {
            this.player = null;
            t.printStackTrace();
        }
    }

    public void getNextSong() throws Throwable {
        if (++this.index >= this.listSong.size()) {
            this.index = 0;
        }
        this.closePlayer();
        this.startPlayer();
        this.setStatus("\u0110ang ch\u01a1i...");
    }

    public void getPrevSong() throws Throwable {
        if (--this.index < 0) {
            this.index = this.listSong.size() - 1;
        }
        this.closePlayer();
        this.startPlayer();
        this.setStatus("\u0110ang ch\u01a1i...");
    }

    public void startPlayer() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    if (PlayerGUI.this.player == null || PlayerGUI.this.player.getState() < 300) {
                        PlayerGUI.this.assertPlayer();
                    }
                    if (PlayerGUI.this.player == null || PlayerGUI.this.player.getState() >= 400) {
                        return;
                    }
                    try {
                        long duration = PlayerGUI.this.getDuration();
                        if (duration != -1L && PlayerGUI.this.player.getMediaTime() >= duration) {
                            PlayerGUI.this.player.setMediaTime(0L);
                        }
                    }
                    catch (MediaException e) {
                        e.printStackTrace();
                    }
                    PlayerGUI.this.setStatus("B\u1eaft \u0111\u1ea7u...");
                    PlayerGUI.this.player.start();
                    if (PlayerGUI.this.player.getState() >= 400) {
                        PlayerGUI.this.setStatus("\u0110ang ch\u01a1i...");
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }).start();
    }

    public void closePlayer() {
        if (this.player != null) {
            this.setStatus("\u0110ang d\u1eebng...");
            try {
                this.player.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.player.close();
            this.setStatus("T\u1ea1m d\u1eebng...");
            this.player = null;
            this.setStatus("");
            if (this.guiTimer == null) {
                this.guiTimer = new Timer();
            }
        }
    }

    public void pausePlayer() {
        if (this.player != null) {
            this.setStatus("\u0110ang d\u1eebng...");
            try {
                this.player.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setStatus("T\u1ea1m d\u1eebng...");
        }
    }

    public void togglePlayer() {
        if (this.player != null) {
            if (this.player.getState() >= 400) {
                this.pausePlayer();
            } else {
                this.startPlayer();
            }
        }
    }

    public void setMediaTime(long time) {
        if (this.player == null) {
            return;
        }
        try {
            this.player.setMediaTime(time);
            this.parent.updateDisplay();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void changeVolume(boolean decrease) {
        VolumeControl vc;
        int diff = 10;
        if (decrease) {
            diff = -diff;
        }
        if ((vc = this.getVolumeControl()) != null) {
            int cv = vc.getLevel();
            vc.setLevel(cv += diff);
        }
    }

    private synchronized void startDisplayTimer() {
        if (this.timeDisplayTask == null) {
            this.timeDisplayTask = new SPTimerTask();
            this.guiTimer.scheduleAtFixedRate(this.timeDisplayTask, 0L, (long)this.timerInterval);
        }
    }

    private synchronized void stopDisplayTimer() {
        if (this.timeDisplayTask != null) {
            this.timeDisplayTask.cancel();
            this.timeDisplayTask = null;
            this.parent.updateDisplay();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void playerUpdate(Player plyr, String evt, Object evtData) {
        try {
            if (evt == "endOfMedia" && plyr.getState() == 400) {
                return;
            }
            if (evt == "closed" || evt == "error" || evt == "endOfMedia" || evt == "stoppedAtTime" || evt == "stopped") {
                this.stopDisplayTimer();
            }
            if (evt == "endOfMedia" || evt == "stoppedAtTime" || evt == "stopped" || evt == "error") {
                this.parent.updateDisplay();
            }
            if (evt.equals("started")) {
                this.startDisplayTimer();
                return;
            }
            if (evt.equals("deviceUnavailable") || evt == "bufferingStarted" || evt == "bufferingStopped" || evt == "closed") return;
            if (evt == "durationUpdated") {
                this.parent.updateDisplay();
                return;
            }
            if (evt == "endOfMedia") {
                this.setStatus("End of media.");
                this.getNextSong();
                return;
            }
            if (evt == "error") return;
            if (evt == "stoppedAtTime") {
                this.setStatus("Stopped at time.");
                return;
            }
            if (evt != "volumeChanged") return;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public synchronized void pauseApp() {
        if (this.player != null && this.player.getState() >= 400) {
            try {
                this.player.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
            this.stopDisplayTimer();
            this.restartOnResume = true;
        } else {
            this.restartOnResume = false;
        }
    }

    public synchronized void resumeApp() {
        if (this.player != null && this.restartOnResume) {
            try {
                this.player.start();
            }
            catch (MediaException me) {
                me.printStackTrace();
            }
        }
        this.restartOnResume = false;
    }

    private class SPTimerTask
    extends TimerTask {
        private SPTimerTask() {
        }

        public void run() {
            PlayerGUI.this.parent.updateDisplay();
        }
    }
}

