/*
 * Decompiled with CFR 0.152.
 */
package st.nct;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import st.nct.LoadDataObserver;
import st.nct.MainCanvasList;
import st.nct.PlaylistCanvasList;
import st.nct.common.ParseData;
import st.nct.utils.Utils;

public class SearchForm
extends Form
implements CommandListener,
LoadDataObserver {
    private TextField symbolField = new TextField("Nh\u1eadp t\u1eeb kho\u00e1 c\u1ea7n t\u00ecm", "", 300, 0);
    private Command exitCommand;
    private Command searchCommand;
    private Command nowPlayingCommand;
    private String keyWord = "";
    private Utils.BreadCrumbTrail observer;
    Thread mLoaDataThread;

    public SearchForm(String title) {
        super(title);
        this.append((Item)this.symbolField);
        this.initMenu();
    }

    public TextField getSymbolField() {
        return this.symbolField;
    }

    public Command getExitCommand() {
        return this.exitCommand;
    }

    public Command getGetCommand() {
        return this.searchCommand;
    }

    public void setObserver(Utils.BreadCrumbTrail _observer) {
        this.observer = _observer;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exitCommand) {
            this.observer.goBack();
        } else if (c == this.searchCommand) {
            this.keyWord = this.symbolField.getString();
            this.gotoSearchPlaylist(this.keyWord, 1, 10);
        } else if (c == this.nowPlayingCommand) {
            MainCanvasList.gotoNowPlaying(this.observer);
        }
    }

    private void gotoSearchPlaylist(String keyword, final int curPage, final int perPage) {
        this.displayMessage("T\u1eeb kho\u00e1: " + keyword, "\u0110ang t\u1ea3i d\u1eef li\u1ec7u...", "loading");
        this.mLoaDataThread = new Thread(new Runnable(){

            public void run() {
                Vector listItems = ParseData.parseSearch("", SearchForm.this.keyWord, curPage, perPage);
                if (listItems == null) {
                    SearchForm.this.displayMessage("", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i t\u1edbi m\u00e1y ch\u1ee7! Xin vui l\u00f2ng ki\u1ec3m tra k\u1ebft n\u1ed1i.", "error");
                    return;
                }
                if (listItems.size() == 0) {
                    SearchForm.this.displayMessage("", "Kh\u00f4ng t\u00ecm th\u1ea5y k\u1ebft qu\u1ea3 n\u00e0o v\u1edbi t\u1eeb kho\u00e1 t\u00ecm ki\u1ebfm tr\u00ean!", "error");
                    return;
                }
                PlaylistCanvasList cateCanvas = new PlaylistCanvasList("K\u1ebft qu\u1ea3 t\u00ecm ki\u1ebfm: " + SearchForm.this.keyWord, listItems, "search", SearchForm.this.keyWord);
                cateCanvas.setObserver(SearchForm.this.observer);
                SearchForm.this.observer.replaceCurrent((Displayable)cateCanvas);
            }
        });
        this.mLoaDataThread.start();
    }

    private void displayMessage(String title, String message, String messageType) {
        MainCanvasList.displayMessage(title, message, messageType, this.observer, this);
    }

    private void initMenu() {
        this.searchCommand = new Command("T\u00ecm", 8, 0);
        this.nowPlayingCommand = new Command("\u0110ang ch\u01a1i...", 8, 1);
        this.exitCommand = new Command("Tr\u1edf l\u1ea1i", 7, 0);
        this.addCommand(this.searchCommand);
        this.addCommand(this.exitCommand);
        this.addCommand(this.nowPlayingCommand);
        this.setCommandListener(this);
    }

    public void cancel() {
        this.quit();
    }

    public void quit() {
        try {
            if (this.mLoaDataThread.isAlive()) {
                this.mLoaDataThread.join();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

