/*
 * Decompiled with CFR 0.152.
 */
package st.nct.common;

import java.io.IOException;
import java.util.Vector;
import org.json.me.JSONObject;
import st.nct.common.ChargeObserver;
import st.nct.common.RestClient;
import st.nct.network.URLProvider;

public class ChargeService {
    private ChargeObserver observer;

    public static String getChargeResult(String listkey, String servicecode, String payfrom, String actionmode, String type, String serviceprice) {
        RestClient client = new RestClient();
        try {
            return client.get(URLProvider.getChargePayment(servicecode, Integer.parseInt(type), Integer.parseInt(payfrom), Integer.parseInt(actionmode), Integer.parseInt(serviceprice)));
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            return "";
        }
    }

    public static Vector parseCharge(String key, String servicecode, String serviceprice) {
        Vector<String> items = new Vector<String>();
        String payfrom = "2";
        String type = "2";
        String mode = "1";
        String ip = "";
        String result = ChargeService.getChargeResult(key, servicecode, payfrom, mode, type, serviceprice);
        if (result == null || "".equals(result)) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(result);
            items.addElement(json.getString("result"));
            items.addElement(json.getString("message"));
            return items;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void doCharge(final String listKey, final String servicecode, final String serviceprice) {
        new Thread(new Runnable(){

            public void run() {
                Vector result = ChargeService.parseCharge(listKey, servicecode, serviceprice);
                if (result != null) {
                    ChargeService.this.observer.checkCompleted((String)result.elementAt(0), (String)result.elementAt(1));
                } else {
                    ChargeService.this.observer.checkError();
                }
            }
        }).start();
    }

    public void setObserver(ChargeObserver _observer) {
        this.observer = _observer;
    }
}

