/*
 * Decompiled with CFR 0.152.
 */
package st.nct.common;

import java.util.Vector;
import st.nct.common.Common;
import st.nct.common.Observer;

public class Observable {
    private boolean changed = false;
    private Vector obs = new Vector();

    public synchronized void addObserver(Observer o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!this.obs.contains(o)) {
            this.obs.addElement(o);
        }
    }

    public synchronized void deleteObserver(Observer o) {
        this.obs.removeElement(o);
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object arg) {
        Object[] arrLocal;
        Observable observable = this;
        synchronized (observable) {
            if (!this.changed) {
                return;
            }
            arrLocal = Common.vectorToArray(this.obs);
            this.clearChanged();
        }
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            Observer observer = (Observer)arrLocal[i];
            observer.update(this, arg);
        }
    }

    public synchronized void deleteObservers() {
        this.obs.removeAllElements();
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public synchronized int countObservers() {
        return this.obs.size();
    }
}

