/*
 * Decompiled with CFR 0.152.
 */
package st.nct.common;

import java.io.IOException;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;
import st.nct.common.RestClient;
import st.nct.model.Category;
import st.nct.model.Payment;
import st.nct.model.Playlist;
import st.nct.model.Song;
import st.nct.network.URLProvider;

public class ParseData {
    public static String getDeviceInfor() {
        RestClient client = new RestClient();
        if (client != null) {
            try {
                return client.get(URLProvider.newVersion());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return "";
    }

    private static String getCate(int type) {
        RestClient client = new RestClient();
        try {
            return client.get(URLProvider.getCategory(type));
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            return "";
        }
    }

    public static Vector parseCate(int type) {
        Vector<Category> cateItems = new Vector<Category>();
        String result = ParseData.getCate(type);
        if (result == null || "".equals(result)) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(result);
            JSONArray jsonArray = json.getJSONArray("Items");
            int total = jsonArray.length();
            for (int i = 0; i < total; ++i) {
                String threadsJSON = jsonArray.getString(i);
                Category cate = new Category();
                cate.fromJSON(threadsJSON);
                cateItems.addElement(cate);
            }
        }
        catch (JSONException ex) {
            System.out.println(ex.getMessage());
        }
        return cateItems;
    }

    private static String getSearchPlaylists(String key, String keyword, int curpage, int pagesize) {
        RestClient client = new RestClient();
        try {
            return client.get(URLProvider.getSearchData(2, keyword, key, curpage, pagesize));
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            return "";
        }
    }

    private static Vector parsePlaylists(String key, String jsonResult) {
        Vector<Playlist> playlistItems = new Vector<Playlist>();
        try {
            JSONObject json = new JSONObject(jsonResult);
            JSONArray jsonArray = json.getJSONArray("Items");
            int total = jsonArray.length();
            for (int i = 0; i < total; ++i) {
                String threadsJSON = jsonArray.getString(i);
                Playlist playlist = new Playlist();
                playlist.fromJSON(threadsJSON);
                playlistItems.addElement(playlist);
            }
            if ("yes".equals(json.getString("GetMore"))) {
                Playlist more = new Playlist();
                more.setName("xem th\u00eam ...");
                more.setId(key);
                playlistItems.addElement(more);
            }
            return playlistItems;
        }
        catch (JSONException ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    public static Vector parseSearch(String genrekey, String keyword, int curpage, int pagesize) {
        String result = ParseData.getSearchPlaylists(genrekey, keyword, curpage, pagesize);
        if (result == null || "".equals(result)) {
            return null;
        }
        Vector playlistItems = ParseData.parsePlaylists(genrekey, result);
        return playlistItems;
    }

    private static String getTopHotPlaylist(int curPare, int pageSize) {
        RestClient client = new RestClient();
        try {
            return client.get(URLProvider.getTopHotPlaylist(curPare, pageSize));
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            return "";
        }
    }

    public static Vector parseHotPlaylist(int curpage, int pagesize) {
        String result = ParseData.getTopHotPlaylist(curpage, pagesize);
        if (result == null || "".equals(result)) {
            return null;
        }
        Vector playlistItems = ParseData.parsePlaylists("tophot", result);
        return playlistItems;
    }

    private static String getTopNewPlaylist(int curPare, int pageSize) {
        RestClient client = new RestClient();
        try {
            return client.get(URLProvider.getTopNewsPlaylist(curPare, pageSize));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static Vector parseNewPlaylist(int curpage, int pagesize) {
        Vector playlistItems = new Vector();
        String result = ParseData.getTopNewPlaylist(curpage, pagesize);
        if (result == null || "".equals(result)) {
            return null;
        }
        playlistItems = ParseData.parsePlaylists("topnew", result);
        return playlistItems;
    }

    public static String getSongsInPlaylist(String listkey, String username, int curPare, int pageSize) {
        RestClient client = new RestClient();
        try {
            return client.get(URLProvider.getSongByPlaylist(listkey, username));
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            return "";
        }
    }

    public static Vector parseSongsInPlaylist(String listkey, String username, int curPare, int pageSize) {
        String result = ParseData.getSongsInPlaylist(listkey, username, curPare, pageSize);
        if (result == null || "".equals(result)) {
            return null;
        }
        Vector songItems = ParseData.parseSongOfPlaylist(listkey, result);
        return songItems;
    }

    private static Vector parseSongOfPlaylist(String key, String jsonResult) {
        Vector<Song> songItems = new Vector<Song>();
        try {
            JSONObject json = new JSONObject(jsonResult);
            JSONArray jsonArray = json.getJSONArray("Items");
            int total = jsonArray.length();
            for (int i = 0; i < total; ++i) {
                String threadsJSON = jsonArray.getString(i);
                Song song = new Song();
                song.fromJSON(threadsJSON);
                songItems.addElement(song);
            }
            return songItems;
        }
        catch (JSONException ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    private static String getLoginResult(String username, String pass) {
        RestClient client = new RestClient();
        try {
            return client.get(URLProvider.login(username, pass));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String parseLoginResult(String username, String pass) {
        String result = ParseData.getLoginResult(username, pass);
        if (result == null || "".equals(result)) {
            return "";
        }
        try {
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String getUserPlaylistsByAction(String action, String username, int curPare, int pageSize) {
        RestClient client = new RestClient();
        try {
            if (action == "myPlaylist") {
                return client.get(URLProvider.getMyPlaylist(username, curPare, pageSize));
            }
            if (action == "playlistLiked") {
                return client.get(URLProvider.getPlaylistLiked(username, curPare, pageSize));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return "";
    }

    public static Vector parseUserPlaylistsByAction(String action, String username, int curPare, int pageSize) {
        Vector playlistItems = new Vector();
        String result = ParseData.getUserPlaylistsByAction(action, username, curPare, pageSize);
        if (result == null || "".equals(result)) {
            return null;
        }
        playlistItems = ParseData.parsePlaylists(action, result);
        return playlistItems;
    }

    public static String getDefaultPlaylistInfor(String username, int curPare, int pageSize) {
        RestClient client = new RestClient();
        try {
            return client.get(URLProvider.getMyPlaylist(username, curPare, pageSize));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static Vector parseDefaultPlaylistInfor(String username, int curPare, int pageSize) {
        Vector songItems = new Vector();
        String result = ParseData.getDefaultPlaylistInfor(username, curPare, pageSize);
        if (result == null || "".equals(result)) {
            return null;
        }
        songItems = ParseData.parseSongOfPlaylist("", result);
        return songItems;
    }

    public static Playlist getDefaultPlaylist(String username, int curPare, int pageSize) {
        String result = ParseData.getDefaultPlaylistInfor(username, curPare, pageSize);
        if (result == null || "".equals(result)) {
            return null;
        }
        try {
            Playlist playlist = new Playlist();
            playlist.fromJSON(result);
            return playlist;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDurationService() {
        RestClient client = new RestClient();
        try {
            return client.get(URLProvider.getListPayment());
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            return "";
        }
    }

    public static Vector parseDurationService() {
        Vector<Payment> paymentItems = new Vector<Payment>();
        String result = ParseData.getDurationService();
        if (result == null || "".equals(result)) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(result);
            JSONArray jsonArray = json.getJSONArray("Items");
            int total = jsonArray.length();
            for (int i = 0; i < total; ++i) {
                String threadsJSON = jsonArray.getString(i);
                Payment payment = new Payment();
                payment.fromJSON(threadsJSON);
                paymentItems.addElement(payment);
            }
            return paymentItems;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

