/*
 * Decompiled with CFR 0.152.
 */
package st.nct.common;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class RestClient {
    private static void configureConncetion(HttpConnection conn) throws IOException {
        String locale = System.getProperty("microedition.locale");
        if (locale == null) {
            locale = "en-US";
        }
        conn.setRequestProperty("Accept-Language", locale);
        conn.setRequestProperty("Content-Type", "text/plain");
        conn.setRequestProperty("Accept", "text/plain");
    }

    public static HttpConnection getConnection(String url) throws IOException {
        HttpConnection conn = (HttpConnection)Connector.open((String)url);
        RestClient.configureConncetion(conn);
        return conn;
    }

    public static HttpConnection getConnection(String url, int access) throws IOException {
        HttpConnection conn = (HttpConnection)Connector.open((String)url, (int)access);
        RestClient.configureConncetion(conn);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String url) throws IOException {
        HttpConnection hcon = null;
        FilterInputStream dis = null;
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        String data = null;
        try {
            boolean redirect;
            int redirectTimes = 0;
            do {
                int ch;
                redirect = false;
                hcon = RestClient.getConnection(url);
                dis = new DataInputStream(hcon.openInputStream());
                while ((ch = dis.read()) != -1) {
                    response.write((byte)ch);
                }
                try {
                    byte[] bytes = response.toByteArray();
                    data = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println(e.getMessage());
                }
                int status = hcon.getResponseCode();
                switch (status) {
                    case 200: {
                        break;
                    }
                    case 301: 
                    case 302: 
                    case 307: {
                        url = hcon.getHeaderField("location");
                        if (dis != null) {
                            dis.close();
                        }
                        if (hcon != null) {
                            hcon.close();
                        }
                        hcon = null;
                        ++redirectTimes;
                        redirect = true;
                        break;
                    }
                    default: {
                        hcon.close();
                        throw new IOException("Response status not OK:" + status);
                    }
                }
            } while (redirect && redirectTimes < 5);
            if (redirectTimes == 5) {
                throw new IOException("Too much redirects");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            try {
                if (hcon != null) {
                    hcon.close();
                }
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return data;
    }
}

