/*
 * Decompiled with CFR 0.152.
 */
package st.nct.utils;

import java.io.UnsupportedEncodingException;

public class TextUtil {
    static final String HEX_DIGITS = "0123456789ABCDEF";

    private TextUtil() {
    }

    protected static String urlEncode(byte[] rs) {
        StringBuffer result = new StringBuffer(rs.length * 2);
        block4: for (int i = 0; i < rs.length; ++i) {
            char c = (char)rs[i];
            switch (c) {
                case '*': 
                case '-': 
                case '.': 
                case '/': 
                case '_': {
                    result.append(c);
                    continue block4;
                }
                case ' ': {
                    result.append('+');
                    continue block4;
                }
                default: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                        result.append(c);
                        continue block4;
                    }
                    result.append('%');
                    result.append(HEX_DIGITS.charAt((c & 0xF0) >> 4));
                    result.append(HEX_DIGITS.charAt(c & 0xF));
                }
            }
        }
        return result.toString();
    }

    protected static String urlDecode(byte[] bytes, String encoding) throws UnsupportedEncodingException, IllegalArgumentException {
        if (bytes == null) {
            return null;
        }
        byte[] decodeBytes = new byte[bytes.length];
        int decodedByteCount = 0;
        try {
            block8: for (int count = 0; count < bytes.length; ++count) {
                switch (bytes[count]) {
                    case 43: {
                        decodeBytes[decodedByteCount++] = 32;
                        continue block8;
                    }
                    case 37: {
                        decodeBytes[decodedByteCount++] = (byte)((HEX_DIGITS.indexOf(bytes[++count]) << 4) + HEX_DIGITS.indexOf(bytes[++count]));
                        continue block8;
                    }
                    default: {
                        decodeBytes[decodedByteCount++] = bytes[count];
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException ae) {
            throw new IllegalArgumentException("Malformed UTF-8 string?");
        }
        String processedPageName = null;
        try {
            processedPageName = new String(decodeBytes, 0, decodedByteCount, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingException("UTF-8 encoding not supported on this platform");
        }
        return processedPageName;
    }

    public static String urlEncodeUTF8(String text) throws Exception {
        if (text == null) {
            return "";
        }
        try {
            byte[] rs = text.getBytes("UTF-8");
            return TextUtil.urlEncode(rs);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("UTF-8 not supported!?!");
        }
    }

    public static String urlDecodeUTF8(String utf8) throws Exception {
        String rs = null;
        if (utf8 == null) {
            return null;
        }
        try {
            rs = TextUtil.urlDecode(utf8.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("UTF-8 or ISO-8859-1 not supported!?!");
        }
        return rs;
    }

    public static String urlEncode(String data, String encoding) throws Exception {
        if ("UTF-8".equals(encoding)) {
            return TextUtil.urlEncodeUTF8(data);
        }
        try {
            return TextUtil.urlEncode(data.getBytes(encoding));
        }
        catch (UnsupportedEncodingException uee) {
            throw new Exception("Could not encode String into" + encoding);
        }
    }

    public static String urlDecode(String data, String encoding) throws UnsupportedEncodingException, IllegalArgumentException, Exception {
        if ("UTF-8".equals(encoding)) {
            return TextUtil.urlDecodeUTF8(data);
        }
        try {
            return TextUtil.urlDecode(data.getBytes(encoding), encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new Exception("Could not decode String into" + encoding);
        }
    }
}

