/*
 * Decompiled with CFR 0.152.
 */
public class Equation {
    public int level;
    public double[] arrFactors;
    public boolean ComplexRoot;
    public EComplex[] arrComplexRoots;
    public static double ACR;
    public static double LIMIT;
    public static double STEP;
    public int flagError;

    public Equation() {
        ACR = 1.0E-9;
        LIMIT = 100000.0;
        STEP = 30.0;
    }

    public void Init(int l, double[] arrs) {
        this.flagError = -1;
        if (l < 2) {
            this.flagError = 1;
        }
        this.ComplexRoot = l == 2;
        this.level = l++;
        this.arrFactors = new double[l];
        for (int i = 0; i < l; ++i) {
            this.arrFactors[i] = arrs[i];
        }
        if (this.flagError == -1) {
            this.flagError = 0;
        }
    }

    public double[] Derivative() {
        double[] arrS = new double[this.level];
        if (this.flagError != 0) {
            return arrS;
        }
        int i = 0;
        for (i = 0; i < this.level; ++i) {
            arrS[i] = (double)(this.level - i) * this.arrFactors[i];
        }
        return arrS;
    }

    private double absF(double x) {
        if (x < 0.0) {
            return -x;
        }
        return x;
    }

    private double IPow(double x, int e) {
        double s = 1.0;
        while (e > 0) {
            s *= x;
            --e;
        }
        return s;
    }

    public double Eval(double x) {
        if (this.flagError != 0) {
            return 0.0;
        }
        int i = 0;
        int l = this.level + 1;
        double s = 0.0;
        for (i = 0; i < l; ++i) {
            s += this.arrFactors[i] * this.IPow(x, this.level - i);
        }
        return s;
    }

    public double BinRoot(double b1, double b2) {
        if (this.flagError != 0) {
            return 0.0;
        }
        double mid = 0.0;
        double f;
        while (!(this.absF(f = this.Eval(mid = (b1 + b2) / 2.0)) < ACR)) {
            double f1 = this.Eval(b1);
            if (this.absF(f1) < ACR) {
                return b1;
            }
            double f2 = this.Eval(b2);
            if (this.absF(f2) < ACR) {
                return b2;
            }
            if (this.absF(b1 - b2) < ACR) {
                return mid;
            }
            if (f1 * f < 0.0) {
                b2 = mid;
                continue;
            }
            if (!(f2 * f < 0.0)) continue;
            b1 = mid;
        }
        return mid;
    }

    public double[] Solve() {
        double[] arrResults = new double[this.level + 2];
        if (this.flagError != 0) {
            return arrResults;
        }
        switch (this.level) {
            case 1: {
                double a = this.arrFactors[0];
                double b = this.arrFactors[1];
                if (a == 0.0) {
                    if (b == 0.0) {
                        arrResults[0] = -1.0;
                        break;
                    }
                    arrResults[0] = 0.0;
                    break;
                }
                arrResults[0] = 1.0;
                arrResults[1] = -b / a;
                break;
            }
            case 2: {
                double a = this.arrFactors[0];
                double b = this.arrFactors[1];
                double c = this.arrFactors[2];
                if (a == 0.0) {
                    if (b == 0.0) {
                        if (c == 0.0) {
                            arrResults[0] = -1.0;
                            break;
                        }
                        arrResults[0] = 0.0;
                        break;
                    }
                    arrResults[0] = 1.0;
                    arrResults[1] = -b / a;
                    break;
                }
                double delta = b * b - 4.0 * a * c;
                if (delta < 0.0) {
                    arrResults[0] = 0.0;
                    this.ComplexRoot = true;
                    if (!true) break;
                    this.arrComplexRoots = new EComplex[2];
                    this.arrComplexRoots[0] = new EComplex();
                    this.arrComplexRoots[1] = new EComplex();
                    delta = -delta;
                    this.arrComplexRoots[0].Real = -b / (2.0 * a);
                    this.arrComplexRoots[0].Im = Math.sqrt(delta) / (2.0 * a);
                    this.arrComplexRoots[1].Real = -b / (2.0 * a);
                    this.arrComplexRoots[1].Im = -Math.sqrt(delta) / (2.0 * a);
                    break;
                }
                this.ComplexRoot = false;
                if (delta == 0.0) {
                    arrResults[0] = 1.0;
                    arrResults[1] = -b / (2.0 * a);
                    break;
                }
                arrResults[0] = 2.0;
                arrResults[1] = (-b - Math.sqrt(delta)) / (2.0 * a);
                arrResults[2] = (-b + Math.sqrt(delta)) / (2.0 * a);
                break;
            }
            default: {
                double w;
                Equation E = new Equation();
                double[] arrf = new double[this.level];
                arrf = this.Derivative();
                E.Init(this.level - 1, arrf);
                double[] arrS = new double[this.level + 2];
                arrS = E.Solve();
                if (arrS[0] == 0.0) {
                    double f1 = 0.0;
                    double f2 = 0.0;
                    double i = 0.0;
                    arrResults[0] = 0.0;
                    f1 = this.Eval(0.0);
                    if (this.absF(f1) < ACR) {
                        arrResults[0] = 1.0;
                        arrResults[1] = 0.0;
                        return arrResults;
                    }
                    do {
                        if (this.absF(f2 = this.Eval(i += STEP)) < ACR) {
                            arrResults[0] = 1.0;
                            arrResults[1] = i;
                            i = 0.0;
                            break;
                        }
                        if (f1 > 0.0) {
                            if (f2 > f1) {
                                i = 0.0;
                                break;
                            }
                        } else if (f2 < f1) {
                            i = 0.0;
                            break;
                        }
                        if (!(i > LIMIT)) continue;
                        this.flagError = 2;
                        return arrResults;
                    } while (!(f1 * f2 < 0.0));
                    if (i > 0.0) {
                        arrResults[0] = 1.0;
                        arrResults[1] = this.BinRoot(0.0, i);
                    }
                    i = 0.0;
                    do {
                        if (this.absF(f2 = this.Eval(i -= STEP)) < ACR) {
                            arrResults[0] = arrResults[0] + 1.0;
                            arrResults[(int)arrResults[0]] = i;
                            i = 0.0;
                            break;
                        }
                        if (f1 > 0.0) {
                            if (f2 > f1) {
                                i = 0.0;
                                break;
                            }
                        } else if (f2 < f1) {
                            i = 0.0;
                            break;
                        }
                        if (!(i < -LIMIT)) continue;
                        this.flagError = 2;
                        return arrResults;
                    } while (!(f1 * f2 <= 0.0));
                    if (!(i < 0.0)) break;
                    arrResults[0] = arrResults[0] + 1.0;
                    arrResults[(int)arrResults[0]] = this.BinRoot(0.0, i);
                    break;
                }
                arrResults[0] = 0.0;
                int n = (int)arrS[0] + 1;
                double[] f = new double[n + 3];
                double temp = 0.0;
                int i = 0;
                int Next = 1;
                for (i = 1; i < n; ++i) {
                    f[i] = this.Eval(arrS[i]);
                    if (!(this.absF(f[i]) < ACR)) continue;
                    arrResults[Next] = arrS[i];
                    ++Next;
                }
                f[0] = 1.0;
                if (f[1] == 0.0) {
                    f[0] = 0.0;
                } else {
                    temp = this.Eval(arrS[1] - 1.0);
                    if (f[1] > 0.0) {
                        if (temp > f[1]) {
                            f[0] = 0.0;
                        }
                    } else if (temp < f[1]) {
                        f[0] = 0.0;
                    }
                }
                if (f[0] > 0.0) {
                    w = arrS[1];
                    do {
                        if (!((w -= STEP) < -LIMIT)) continue;
                        this.flagError = 2;
                        return arrResults;
                    } while (!((temp = this.Eval(w)) * f[1] <= 0.0));
                    f[0] = temp;
                    arrS[0] = w;
                }
                i = n - 1;
                f[n] = 1.0;
                if (f[i] == 0.0) {
                    f[n] = 0.0;
                } else {
                    temp = this.Eval(arrS[i] + 1.0);
                    if (f[i] > 0.0) {
                        if (temp > f[i]) {
                            f[n] = 0.0;
                        }
                    } else if (temp < f[i]) {
                        f[n] = 0.0;
                    }
                }
                if (f[n] > 0.0) {
                    w = arrS[i];
                    do {
                        if (!((w += STEP) > LIMIT)) continue;
                        this.flagError = 2;
                        return arrResults;
                    } while (!((temp = this.Eval(w)) * f[i] <= 0.0));
                    f[n] = temp;
                    arrS[n] = w;
                }
                for (i = 0; i < n; ++i) {
                    if (!(f[i] * f[i + 1] < 0.0)) continue;
                    arrResults[Next] = this.BinRoot(arrS[i], arrS[i + 1]);
                    ++Next;
                }
                arrResults[0] = Next - 1;
                break;
            }
        }
        int i = 0;
        int j = 0;
        int n = (int)arrResults[0] + 1;
        int mx = 0;
        double temp = 0.0;
        for (i = 1; i < n - 1; ++i) {
            mx = i;
            for (j = i + 1; j < n; ++j) {
                if (!(arrResults[i] > arrResults[j])) continue;
                mx = j;
            }
            if (mx <= i) continue;
            temp = arrResults[mx];
            arrResults[mx] = arrResults[i];
            arrResults[i] = temp;
        }
        return arrResults;
    }
}

