/*
 * Decompiled with CFR 0.152.
 */
public class MathE {
    static double Eps = 1.0E-11;
    static double Pi = Math.PI;
    static double Ln2 = 0.6931471805599453;
    static double Pow2_m = 2.037035976334486E90;
    static double m_ = 300.0;

    static double Sensitive(double x) {
        if (Math.abs(x - Math.ceil(x)) <= Eps) {
            return Math.ceil(x);
        }
        if (Math.abs(x - Math.floor(x)) <= Eps) {
            return Math.floor(x);
        }
        return x;
    }

    static double BasePow(double Base, double exp) {
        double Res = 1.0;
        long i = 1L;
        while ((double)i <= exp) {
            Res *= Base;
            ++i;
        }
        if (exp < 0.0) {
            Res = 1.0 / Res;
        }
        return Res;
    }

    static double Factorial(double N) {
        double Res = 1.0;
        long i = 1L;
        while ((double)i <= N) {
            Res *= (double)i;
            ++i;
        }
        return Res;
    }

    static double Exp(double Alpha) {
        double Add = 1.0;
        double Res = 0.0;
        long i = 0L;
        while (Math.abs(Add) >= Eps) {
            Add = MathE.BasePow(Alpha, i) / MathE.Factorial(i);
            Res += Add;
            ++i;
        }
        return Res;
    }

    static double AgM(double x, double y) {
        for (int i = 0; i < 40; ++i) {
            double a = (x + y) / 2.0;
            double g = Math.sqrt(x * y);
            x = a;
            y = g;
        }
        return y;
    }

    static double Ln(double x) {
        return Pi / (2.0 * MathE.AgM(1.0, 4.0 / (x * Pow2_m))) - m_ * Ln2;
    }

    static double Log(double x) {
        return MathE.Ln(x) / MathE.Ln(10.0);
    }

    static double Pow(double x, double y) {
        if (Math.floor(y) == y) {
            if (y >= 0.0) {
                return MathE.BasePow(x, y);
            }
            return 1.0 / MathE.BasePow(x, Math.abs(y));
        }
        double Res = MathE.Sensitive(MathE.Exp(y * MathE.Ln(Math.abs(x))));
        if (x < 0.0) {
            Res *= -1.0;
        }
        return Res;
    }

    static double RealRoot(double Base, double Root) {
        return MathE.Pow(Base, 1.0 / Root);
    }

    static double E10(double x, double y) {
        return x * MathE.Pow(10.0, y);
    }

    static double ArcCoTan(double x) {
        double Res = x;
        double Add = 1.0;
        double x_ = x;
        double Flag = -1.0;
        double i = 3.0;
        while (Math.abs(Add) > Eps / 10.0) {
            Add = Flag * ((x_ *= x * x) / i);
            Res += Add;
            Flag *= -1.0;
            i += 2.0;
        }
        return Pi / 2.0 - Res;
    }

    static double ArcSin(double x) {
        double Res = x;
        double Add = 1.0;
        double x_ = x;
        double Pref = 1.0;
        double i = 3.0;
        if (Math.abs(x) > 0.94) {
            double CoTan = Math.sqrt(1.0 / (x * x) - 1.0);
            if (x >= 0.0) {
                return MathE.ArcCoTan(CoTan);
            }
            return -MathE.ArcCoTan(CoTan);
        }
        while (Math.abs(Add) > Eps / 10.0) {
            Add = (x_ *= x * x) * (Pref *= (i - 2.0) / (i - 1.0)) / i;
            Res += Add;
            i += 2.0;
        }
        return Res;
    }

    static double ArcCos(double x) {
        return Pi / 2.0 - MathE.ArcSin(x);
    }

    static double ArcTan(double x) {
        double Cos = Math.sqrt(1.0 / (1.0 + x * x));
        if (x >= 0.0) {
            return MathE.ArcCos(Cos);
        }
        return -MathE.ArcCos(Cos);
    }
}

