/*
 * Decompiled with CFR 0.152.
 */
public class SetEquation {
    public boolean Err;
    public int Unks;
    public double[] arrTest;
    public double[][] arrFactors;
    public double[] arrResults;

    public int DetF(int k) {
        if (k % 2 != 0) {
            return -1;
        }
        return 1;
    }

    public double Determinant(int DetLevel, double[][] arr) {
        if (DetLevel < 1) {
            return 0.0;
        }
        double s = 0.0;
        switch (DetLevel) {
            case 1: {
                s = arr[0][0];
                break;
            }
            case 2: {
                s = arr[0][0] * arr[1][1] - arr[0][1] * arr[1][0];
                break;
            }
            default: {
                double[][] f = new double[DetLevel + 5][DetLevel + 5];
                int i = 0;
                int j = 0;
                int k = 0;
                int a = 0;
                for (k = 0; k < DetLevel; ++k) {
                    for (i = 1; i < DetLevel; ++i) {
                        for (j = 0; j < DetLevel; ++j) {
                            if (j == k) continue;
                            f[i - 1][a] = arr[i][j];
                            ++a;
                        }
                        a = 0;
                    }
                    s += (double)this.DetF(k) * arr[0][k] * this.Determinant(DetLevel - 1, f);
                }
            }
        }
        return s;
    }

    public boolean Init(int Us, double[][] arrFs) {
        this.arrTest = new double[10];
        this.Err = true;
        if (Us < 2) {
            return false;
        }
        this.Unks = Us++;
        this.arrResults = new double[Us + 5];
        this.arrFactors = new double[this.Unks + 5][Us + 5];
        for (int i = 0; i < this.Unks; ++i) {
            for (int j = 0; j < Us; ++j) {
                this.arrFactors[i][j] = arrFs[i][j];
            }
        }
        this.Err = false;
        return true;
    }

    public double[] Solve() {
        if (this.Err) {
            this.arrResults[0] = -2.0;
            return this.arrResults;
        }
        switch (this.Unks) {
            case 2: {
                double D = 0.0;
                double Dx = 0.0;
                double Dy = 0.0;
                D = this.arrFactors[0][0] * this.arrFactors[1][1] - this.arrFactors[1][0] * this.arrFactors[0][1];
                Dx = this.arrFactors[0][2] * this.arrFactors[1][1] - this.arrFactors[1][2] * this.arrFactors[0][1];
                Dy = this.arrFactors[0][0] * this.arrFactors[1][2] - this.arrFactors[1][0] * this.arrFactors[0][2];
                if (D == 0.0) {
                    if (Dx != 0.0 || Dy != 0.0) {
                        this.arrResults[0] = 0.0;
                        break;
                    }
                    if (Dx != 0.0 || Dy != 0.0) break;
                    this.arrResults[0] = -1.0;
                    break;
                }
                this.arrResults[0] = 1.0;
                this.arrResults[1] = Dx / D;
                this.arrResults[2] = Dy / D;
                break;
            }
            case 3: {
                double[] z = new double[5];
                double[][] arr = new double[5][5];
                double D = 0.0;
                double Dx = 0.0;
                double Dy = 0.0;
                double Dz = 0.0;
                int i = 0;
                int j = 0;
                for (i = 0; i < this.Unks; ++i) {
                    for (j = 0; j < this.Unks; ++j) {
                        arr[i][j] = this.arrFactors[i][j];
                    }
                }
                D = this.Determinant(3, arr);
                for (i = 0; i < this.Unks; ++i) {
                    z[i] = arr[i][0];
                    arr[i][0] = this.arrFactors[i][this.Unks];
                }
                Dx = this.Determinant(3, arr);
                for (i = 0; i < this.Unks; ++i) {
                    arr[i][0] = z[i];
                    z[i] = arr[i][1];
                    arr[i][1] = this.arrFactors[i][this.Unks];
                }
                Dy = this.Determinant(3, arr);
                for (i = 0; i < this.Unks; ++i) {
                    arr[i][1] = z[i];
                    z[i] = arr[i][2];
                    arr[i][2] = this.arrFactors[i][this.Unks];
                }
                Dz = this.Determinant(3, arr);
                if (D == 0.0) {
                    if (Dx == 0.0 && Dy == 0.0 && Dz == 0.0) {
                        this.arrResults[0] = -1.0;
                        break;
                    }
                    this.arrResults[0] = 0.0;
                    break;
                }
                this.arrResults[0] = 1.0;
                this.arrResults[1] = Dx / D;
                this.arrResults[2] = Dy / D;
                this.arrResults[3] = Dz / D;
                break;
            }
        }
        return this.arrResults;
    }
}

