/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class JpegEncoder {
    DataOutputStream outStream;
    JpegInfo JpegObj;
    Huffman Huf;
    DCT dct;
    int imageHeight;
    int imageWidth;
    int Quality;
    public static int[] jpegNaturalOrder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    public JpegEncoder(Image image, int quality, OutputStream out) {
        this.Quality = quality;
        this.JpegObj = new JpegInfo(image);
        this.imageHeight = this.JpegObj.imageHeight;
        this.imageWidth = this.JpegObj.imageWidth;
        this.outStream = new DataOutputStream(out);
        this.dct = new DCT(this.Quality);
        this.Huf = new Huffman(this.imageWidth, this.imageHeight);
        this.Compress();
    }

    public void setQuality(int quality) {
        this.dct = new DCT(quality);
    }

    public int getQuality() {
        return this.Quality;
    }

    public void Compress() {
        this.WriteHeaders(this.outStream);
        this.WriteCompressedData(this.outStream);
        this.WriteEOI(this.outStream);
        try {
            this.outStream.flush();
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }

    public void WriteCompressedData(DataOutputStream outStream) {
        int comp;
        boolean temp = false;
        float[][] dctArray1 = new float[8][8];
        double[][] dctArray2 = new double[8][8];
        int[] dctArray3 = new int[64];
        int[] lastDCvalue = new int[this.JpegObj.NumberOfComponents];
        int[] zeroArray = new int[64];
        int Width = 0;
        int Height = 0;
        boolean nothing = false;
        int MinBlockWidth = this.imageWidth % 8 != 0 ? (int)(Math.floor((double)this.imageWidth / 8.0) + 1.0) * 8 : this.imageWidth;
        int MinBlockHeight = this.imageHeight % 8 != 0 ? (int)(Math.floor((double)this.imageHeight / 8.0) + 1.0) * 8 : this.imageHeight;
        for (comp = 0; comp < this.JpegObj.NumberOfComponents; ++comp) {
            MinBlockWidth = Math.min(MinBlockWidth, this.JpegObj.BlockWidth[comp]);
            MinBlockHeight = Math.min(MinBlockHeight, this.JpegObj.BlockHeight[comp]);
        }
        int xpos = 0;
        for (int r = 0; r < MinBlockHeight; ++r) {
            for (int c2 = 0; c2 < MinBlockWidth; ++c2) {
                xpos = c2 * 8;
                int ypos = r * 8;
                for (comp = 0; comp < this.JpegObj.NumberOfComponents; ++comp) {
                    Width = this.JpegObj.BlockWidth[comp];
                    Height = this.JpegObj.BlockHeight[comp];
                    float[][] inputArray = (float[][])this.JpegObj.Components[comp];
                    for (int i = 0; i < this.JpegObj.VsampFactor[comp]; ++i) {
                        for (int j = 0; j < this.JpegObj.HsampFactor[comp]; ++j) {
                            int xblockoffset = j * 8;
                            int yblockoffset = i * 8;
                            for (int a2 = 0; a2 < 8; ++a2) {
                                for (int b2 = 0; b2 < 8; ++b2) {
                                    dctArray1[a2][b2] = inputArray[ypos + yblockoffset + a2][xpos + xblockoffset + b2];
                                }
                            }
                            dctArray2 = this.dct.forwardDCT(dctArray1);
                            dctArray3 = this.dct.quantizeBlock(dctArray2, this.JpegObj.QtableNumber[comp]);
                            this.Huf.HuffmanBlockEncoder(outStream, dctArray3, lastDCvalue[comp], this.JpegObj.DCtableNumber[comp], this.JpegObj.ACtableNumber[comp]);
                            lastDCvalue[comp] = dctArray3[0];
                        }
                    }
                }
            }
        }
        this.Huf.flushBuffer(outStream);
    }

    public void WriteEOI(DataOutputStream out) {
        byte[] EOI = new byte[]{-1, -39};
        this.WriteMarker(EOI, out);
    }

    public void WriteHeaders(DataOutputStream out) {
        int j;
        int i;
        byte[] SOI = new byte[]{-1, -40};
        this.WriteMarker(SOI, out);
        byte[] JFIF = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        this.WriteArray(JFIF, out);
        String comment = new String();
        comment = this.JpegObj.getComment();
        int length = comment.length();
        byte[] COM = new byte[length + 4];
        COM[0] = -1;
        COM[1] = -2;
        COM[2] = (byte)(length >> 8 & 0xFF);
        COM[3] = (byte)(length & 0xFF);
        System.arraycopy(this.JpegObj.Comment.getBytes(), 0, COM, 4, this.JpegObj.Comment.length());
        this.WriteArray(COM, out);
        byte[] DQT = new byte[134];
        DQT[0] = -1;
        DQT[1] = -37;
        DQT[2] = 0;
        DQT[3] = -124;
        int offset = 4;
        for (i = 0; i < 2; ++i) {
            DQT[offset++] = (byte)(0 + i);
            int[] tempArray = (int[])this.dct.quantum[i];
            for (j = 0; j < 64; ++j) {
                DQT[offset++] = (byte)tempArray[jpegNaturalOrder[j]];
            }
        }
        this.WriteArray(DQT, out);
        byte[] SOF = new byte[19];
        SOF[0] = -1;
        SOF[1] = -64;
        SOF[2] = 0;
        SOF[3] = 17;
        SOF[4] = (byte)this.JpegObj.Precision;
        SOF[5] = (byte)(this.JpegObj.imageHeight >> 8 & 0xFF);
        SOF[6] = (byte)(this.JpegObj.imageHeight & 0xFF);
        SOF[7] = (byte)(this.JpegObj.imageWidth >> 8 & 0xFF);
        SOF[8] = (byte)(this.JpegObj.imageWidth & 0xFF);
        SOF[9] = (byte)this.JpegObj.NumberOfComponents;
        int index = 10;
        for (i = 0; i < SOF[9]; ++i) {
            SOF[index++] = (byte)this.JpegObj.CompID[i];
            SOF[index++] = (byte)((this.JpegObj.HsampFactor[i] << 4) + this.JpegObj.VsampFactor[i]);
            SOF[index++] = (byte)this.JpegObj.QtableNumber[i];
        }
        this.WriteArray(SOF, out);
        length = 2;
        index = 4;
        int oldindex = 4;
        byte[] DHT1 = new byte[17];
        byte[] DHT4 = new byte[4];
        DHT4[0] = -1;
        DHT4[1] = -60;
        for (i = 0; i < 4; ++i) {
            int bytes = 0;
            DHT1[index++ - oldindex] = (byte)((int[])this.Huf.bits.elementAt(i))[0];
            for (j = 1; j < 17; ++j) {
                int temp = ((int[])this.Huf.bits.elementAt(i))[j];
                DHT1[index++ - oldindex] = (byte)temp;
                bytes += temp;
            }
            int intermediateindex = index;
            byte[] DHT2 = new byte[bytes];
            for (j = 0; j < bytes; ++j) {
                DHT2[index++ - intermediateindex] = (byte)((int[])this.Huf.val.elementAt(i))[j];
            }
            byte[] DHT3 = new byte[index];
            System.arraycopy(DHT4, 0, DHT3, 0, oldindex);
            System.arraycopy(DHT1, 0, DHT3, oldindex, 17);
            System.arraycopy(DHT2, 0, DHT3, oldindex + 17, bytes);
            DHT4 = DHT3;
            oldindex = index;
        }
        DHT4[2] = (byte)(index - 2 >> 8 & 0xFF);
        DHT4[3] = (byte)(index - 2 & 0xFF);
        this.WriteArray(DHT4, out);
        byte[] SOS = new byte[14];
        SOS[0] = -1;
        SOS[1] = -38;
        SOS[2] = 0;
        SOS[3] = 12;
        SOS[4] = (byte)this.JpegObj.NumberOfComponents;
        index = 5;
        for (i = 0; i < SOS[4]; ++i) {
            SOS[index++] = (byte)this.JpegObj.CompID[i];
            SOS[index++] = (byte)((this.JpegObj.DCtableNumber[i] << 4) + this.JpegObj.ACtableNumber[i]);
        }
        SOS[index++] = (byte)this.JpegObj.Ss;
        SOS[index++] = (byte)this.JpegObj.Se;
        SOS[index++] = (byte)((this.JpegObj.Ah << 4) + this.JpegObj.Al);
        this.WriteArray(SOS, out);
    }

    void WriteMarker(byte[] data, DataOutputStream out) {
        try {
            out.write(data, 0, 2);
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }

    void WriteArray(byte[] data, DataOutputStream out) {
        try {
            int length = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF) + 2;
            out.write(data, 0, length);
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }

    class JpegInfo {
        String Comment;
        public Image imageobj;
        public int imageHeight;
        public int imageWidth;
        public int[] BlockWidth;
        public int[] BlockHeight;
        public int Precision = 8;
        public int NumberOfComponents = 3;
        public Object[] Components;
        public int[] CompID = new int[]{1, 2, 3};
        public int[] HsampFactor = new int[]{1, 1, 1};
        public int[] VsampFactor = new int[]{1, 1, 1};
        public int[] QtableNumber = new int[]{0, 1, 1};
        public int[] DCtableNumber = new int[]{0, 1, 1};
        public int[] ACtableNumber = new int[]{0, 1, 1};
        public boolean[] lastColumnIsDummy = new boolean[]{false, false, false};
        public boolean[] lastRowIsDummy = new boolean[]{false, false, false};
        public int Ss = 0;
        public int Se = 63;
        public int Ah = 0;
        public int Al = 0;
        public int[] compWidth;
        public int[] compHeight;
        public int MaxHsampFactor;
        public int MaxVsampFactor;

        public JpegInfo(Image image) {
            this.Components = new Object[this.NumberOfComponents];
            this.compWidth = new int[this.NumberOfComponents];
            this.compHeight = new int[this.NumberOfComponents];
            this.BlockWidth = new int[this.NumberOfComponents];
            this.BlockHeight = new int[this.NumberOfComponents];
            this.imageobj = image;
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getHeight();
            this.Comment = "JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.  ";
            this.getYCCArray();
        }

        public void setComment(String comment) {
            this.Comment.concat(comment);
        }

        public String getComment() {
            return this.Comment;
        }

        private void getYCCArray() {
            int y;
            int[] values = new int[this.imageWidth * this.imageHeight];
            this.imageobj.getRGB(values, 0, this.imageWidth, 0, 0, this.imageWidth, this.imageHeight);
            this.MaxHsampFactor = 1;
            this.MaxVsampFactor = 1;
            for (y = 0; y < this.NumberOfComponents; ++y) {
                this.MaxHsampFactor = Math.max(this.MaxHsampFactor, this.HsampFactor[y]);
                this.MaxVsampFactor = Math.max(this.MaxVsampFactor, this.VsampFactor[y]);
            }
            for (y = 0; y < this.NumberOfComponents; ++y) {
                this.compWidth[y] = (this.imageWidth % 8 != 0 ? (int)Math.ceil((double)this.imageWidth / 8.0) * 8 : this.imageWidth) / this.MaxHsampFactor * this.HsampFactor[y];
                if (this.compWidth[y] != this.imageWidth / this.MaxHsampFactor * this.HsampFactor[y]) {
                    this.lastColumnIsDummy[y] = true;
                }
                this.BlockWidth[y] = (int)Math.ceil((double)this.compWidth[y] / 8.0);
                this.compHeight[y] = (this.imageHeight % 8 != 0 ? (int)Math.ceil((double)this.imageHeight / 8.0) * 8 : this.imageHeight) / this.MaxVsampFactor * this.VsampFactor[y];
                if (this.compHeight[y] != this.imageHeight / this.MaxVsampFactor * this.VsampFactor[y]) {
                    this.lastRowIsDummy[y] = true;
                }
                this.BlockHeight[y] = (int)Math.ceil((double)this.compHeight[y] / 8.0);
            }
            float[][] Y = new float[this.compHeight[0]][this.compWidth[0]];
            float[][] Cr1 = new float[this.compHeight[0]][this.compWidth[0]];
            float[][] Cb1 = new float[this.compHeight[0]][this.compWidth[0]];
            float[][] Cb2 = new float[this.compHeight[1]][this.compWidth[1]];
            float[][] Cr2 = new float[this.compHeight[2]][this.compWidth[2]];
            int index = 0;
            for (y = 0; y < this.imageHeight; ++y) {
                for (int x = 0; x < this.imageWidth; ++x) {
                    int r = values[index] >> 16 & 0xFF;
                    int g = values[index] >> 8 & 0xFF;
                    int b2 = values[index] & 0xFF;
                    Y[y][x] = (float)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b2);
                    Cb1[y][x] = 128.0f + (float)(-0.16874 * (double)r - 0.33126 * (double)g + 0.5 * (double)b2);
                    Cr1[y][x] = 128.0f + (float)(0.5 * (double)r - 0.41869 * (double)g - 0.08131 * (double)b2);
                    ++index;
                }
            }
            this.Components[0] = Y;
            this.Components[1] = Cb1;
            this.Components[2] = Cr1;
        }

        float[][] DownSample(float[][] C, int comp) {
            int inrow = 0;
            int incol = 0;
            float[][] output = new float[this.compHeight[comp]][this.compWidth[comp]];
            for (int outrow = 0; outrow < this.compHeight[comp]; ++outrow) {
                int bias = 1;
                for (int outcol = 0; outcol < this.compWidth[comp]; ++outcol) {
                    output[outrow][outcol] = (C[inrow][incol++] + C[inrow++][incol--] + C[inrow][incol++] + C[inrow--][incol++] + (float)bias) / 4.0f;
                    bias ^= 3;
                }
                inrow += 2;
                incol = 0;
            }
            return output;
        }
    }

    class Huffman {
        int bufferPutBits;
        int bufferPutBuffer;
        public int ImageHeight;
        public int ImageWidth;
        public int[][] DC_matrix0;
        public int[][] AC_matrix0;
        public int[][] DC_matrix1;
        public int[][] AC_matrix1;
        public Object[] DC_matrix;
        public Object[] AC_matrix;
        public int code;
        public int NumOfDCTables;
        public int NumOfACTables;
        public int[] bitsDCluminance = new int[]{0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
        public int[] valDCluminance = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        public int[] bitsDCchrominance = new int[]{1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
        public int[] valDCchrominance = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        public int[] bitsACluminance = new int[]{16, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125};
        public int[] valACluminance = new int[]{1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, 129, 145, 161, 8, 35, 66, 177, 193, 21, 82, 209, 240, 36, 51, 98, 114, 130, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250};
        public int[] bitsACchrominance = new int[]{17, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119};
        public int[] valACchrominance = new int[]{0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, 129, 8, 20, 66, 145, 161, 177, 193, 9, 35, 51, 82, 240, 21, 98, 114, 209, 10, 22, 36, 52, 225, 37, 241, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 130, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 226, 227, 228, 229, 230, 231, 232, 233, 234, 242, 243, 244, 245, 246, 247, 248, 249, 250};
        public Vector bits = new Vector();
        public Vector val;

        public Huffman(int Width, int Height) {
            this.bits.addElement(this.bitsDCluminance);
            this.bits.addElement(this.bitsACluminance);
            this.bits.addElement(this.bitsDCchrominance);
            this.bits.addElement(this.bitsACchrominance);
            this.val = new Vector();
            this.val.addElement(this.valDCluminance);
            this.val.addElement(this.valACluminance);
            this.val.addElement(this.valDCchrominance);
            this.val.addElement(this.valACchrominance);
            this.initHuf();
            this.ImageWidth = Width;
            this.ImageHeight = Height;
        }

        public void HuffmanBlockEncoder(DataOutputStream outStream, int[] zigzag, int prec, int DCcode, int ACcode) {
            this.NumOfDCTables = 2;
            this.NumOfACTables = 2;
            int temp2 = zigzag[0] - prec;
            int temp = temp2;
            if (temp < 0) {
                temp = -temp;
                --temp2;
            }
            int nbits = 0;
            while (temp != 0) {
                ++nbits;
                temp >>= 1;
            }
            this.bufferIt(outStream, ((int[][])this.DC_matrix[DCcode])[nbits][0], ((int[][])this.DC_matrix[DCcode])[nbits][1]);
            if (nbits != 0) {
                this.bufferIt(outStream, temp2, nbits);
            }
            int r = 0;
            for (int k = 1; k < 64; ++k) {
                temp = zigzag[jpegNaturalOrder[k]];
                if (temp == 0) {
                    ++r;
                    continue;
                }
                while (r > 15) {
                    this.bufferIt(outStream, ((int[][])this.AC_matrix[ACcode])[240][0], ((int[][])this.AC_matrix[ACcode])[240][1]);
                    r -= 16;
                }
                temp2 = temp;
                if (temp < 0) {
                    temp = -temp;
                    --temp2;
                }
                nbits = 1;
                while ((temp >>= 1) != 0) {
                    ++nbits;
                }
                int i = (r << 4) + nbits;
                this.bufferIt(outStream, ((int[][])this.AC_matrix[ACcode])[i][0], ((int[][])this.AC_matrix[ACcode])[i][1]);
                this.bufferIt(outStream, temp2, nbits);
                r = 0;
            }
            if (r > 0) {
                this.bufferIt(outStream, ((int[][])this.AC_matrix[ACcode])[0][0], ((int[][])this.AC_matrix[ACcode])[0][1]);
            }
        }

        void bufferIt(DataOutputStream outStream, int code, int size) {
            int PutBuffer = code;
            int PutBits = this.bufferPutBits;
            PutBuffer &= (1 << size) - 1;
            PutBuffer <<= 24 - (PutBits += size);
            PutBuffer |= this.bufferPutBuffer;
            while (PutBits >= 8) {
                int c2 = PutBuffer >> 16 & 0xFF;
                try {
                    outStream.write(c2);
                }
                catch (IOException e) {
                    System.out.println("IO Error: " + e.getMessage());
                }
                if (c2 == 255) {
                    try {
                        outStream.write(0);
                    }
                    catch (IOException e) {
                        System.out.println("IO Error: " + e.getMessage());
                    }
                }
                PutBuffer <<= 8;
                PutBits -= 8;
            }
            this.bufferPutBuffer = PutBuffer;
            this.bufferPutBits = PutBits;
        }

        void flushBuffer(DataOutputStream outStream) {
            int c2;
            int PutBits;
            int PutBuffer = this.bufferPutBuffer;
            for (PutBits = this.bufferPutBits; PutBits >= 8; PutBits -= 8) {
                c2 = PutBuffer >> 16 & 0xFF;
                try {
                    outStream.write(c2);
                }
                catch (IOException e) {
                    System.out.println("IO Error: " + e.getMessage());
                }
                if (c2 == 255) {
                    try {
                        outStream.write(0);
                    }
                    catch (IOException e) {
                        System.out.println("IO Error: " + e.getMessage());
                    }
                }
                PutBuffer <<= 8;
            }
            if (PutBits > 0) {
                c2 = PutBuffer >> 16 & 0xFF;
                try {
                    outStream.write(c2);
                }
                catch (IOException e) {
                    System.out.println("IO Error: " + e.getMessage());
                }
            }
        }

        public void initHuf() {
            int i;
            int l;
            this.DC_matrix0 = new int[12][2];
            this.DC_matrix1 = new int[12][2];
            this.AC_matrix0 = new int[255][2];
            this.AC_matrix1 = new int[255][2];
            this.DC_matrix = new Object[2];
            this.AC_matrix = new Object[2];
            int[] huffsize = new int[257];
            int[] huffcode = new int[257];
            int p = 0;
            for (l = 1; l <= 16; ++l) {
                for (i = 1; i <= this.bitsDCchrominance[l]; ++i) {
                    huffsize[p++] = l;
                }
            }
            huffsize[p] = 0;
            int lastp = p;
            int code = 0;
            int si = huffsize[0];
            p = 0;
            while (huffsize[p] != 0) {
                while (huffsize[p] == si) {
                    huffcode[p++] = code++;
                }
                code <<= 1;
                ++si;
            }
            for (p = 0; p < lastp; ++p) {
                this.DC_matrix1[this.valDCchrominance[p]][0] = huffcode[p];
                this.DC_matrix1[this.valDCchrominance[p]][1] = huffsize[p];
            }
            p = 0;
            for (l = 1; l <= 16; ++l) {
                for (i = 1; i <= this.bitsACchrominance[l]; ++i) {
                    huffsize[p++] = l;
                }
            }
            huffsize[p] = 0;
            lastp = p;
            code = 0;
            si = huffsize[0];
            p = 0;
            while (huffsize[p] != 0) {
                while (huffsize[p] == si) {
                    huffcode[p++] = code++;
                }
                code <<= 1;
                ++si;
            }
            for (p = 0; p < lastp; ++p) {
                this.AC_matrix1[this.valACchrominance[p]][0] = huffcode[p];
                this.AC_matrix1[this.valACchrominance[p]][1] = huffsize[p];
            }
            p = 0;
            for (l = 1; l <= 16; ++l) {
                for (i = 1; i <= this.bitsDCluminance[l]; ++i) {
                    huffsize[p++] = l;
                }
            }
            huffsize[p] = 0;
            lastp = p;
            code = 0;
            si = huffsize[0];
            p = 0;
            while (huffsize[p] != 0) {
                while (huffsize[p] == si) {
                    huffcode[p++] = code++;
                }
                code <<= 1;
                ++si;
            }
            for (p = 0; p < lastp; ++p) {
                this.DC_matrix0[this.valDCluminance[p]][0] = huffcode[p];
                this.DC_matrix0[this.valDCluminance[p]][1] = huffsize[p];
            }
            p = 0;
            for (l = 1; l <= 16; ++l) {
                for (i = 1; i <= this.bitsACluminance[l]; ++i) {
                    huffsize[p++] = l;
                }
            }
            huffsize[p] = 0;
            lastp = p;
            code = 0;
            si = huffsize[0];
            p = 0;
            while (huffsize[p] != 0) {
                while (huffsize[p] == si) {
                    huffcode[p++] = code++;
                }
                code <<= 1;
                ++si;
            }
            for (int q = 0; q < lastp; ++q) {
                this.AC_matrix0[this.valACluminance[q]][0] = huffcode[q];
                this.AC_matrix0[this.valACluminance[q]][1] = huffsize[q];
            }
            this.DC_matrix[0] = this.DC_matrix0;
            this.DC_matrix[1] = this.DC_matrix1;
            this.AC_matrix[0] = this.AC_matrix0;
            this.AC_matrix[1] = this.AC_matrix1;
        }
    }

    class DCT {
        public int N = 8;
        public int QUALITY = 80;
        public Object[] quantum = new Object[2];
        public Object[] Divisors = new Object[2];
        public int[] quantum_luminance = new int[this.N * this.N];
        public double[] DivisorsLuminance = new double[this.N * this.N];
        public int[] quantum_chrominance = new int[this.N * this.N];
        public double[] DivisorsChrominance = new double[this.N * this.N];

        public DCT(int QUALITY) {
            this.initMatrix(QUALITY);
        }

        private void initMatrix(int quality) {
            int i;
            int temp;
            int j;
            double[] AANscaleFactor = new double[]{1.0, 1.387039845, 1.306562965, 1.175875602, 1.0, 0.785694958, 0.5411961, 0.275899379};
            int Quality = quality;
            if (Quality <= 0) {
                Quality = 1;
            }
            if (Quality > 100) {
                Quality = 100;
            }
            Quality = Quality < 50 ? 5000 / Quality : 200 - Quality * 2;
            this.quantum_luminance[0] = 16;
            this.quantum_luminance[1] = 11;
            this.quantum_luminance[2] = 10;
            this.quantum_luminance[3] = 16;
            this.quantum_luminance[4] = 24;
            this.quantum_luminance[5] = 40;
            this.quantum_luminance[6] = 51;
            this.quantum_luminance[7] = 61;
            this.quantum_luminance[8] = 12;
            this.quantum_luminance[9] = 12;
            this.quantum_luminance[10] = 14;
            this.quantum_luminance[11] = 19;
            this.quantum_luminance[12] = 26;
            this.quantum_luminance[13] = 58;
            this.quantum_luminance[14] = 60;
            this.quantum_luminance[15] = 55;
            this.quantum_luminance[16] = 14;
            this.quantum_luminance[17] = 13;
            this.quantum_luminance[18] = 16;
            this.quantum_luminance[19] = 24;
            this.quantum_luminance[20] = 40;
            this.quantum_luminance[21] = 57;
            this.quantum_luminance[22] = 69;
            this.quantum_luminance[23] = 56;
            this.quantum_luminance[24] = 14;
            this.quantum_luminance[25] = 17;
            this.quantum_luminance[26] = 22;
            this.quantum_luminance[27] = 29;
            this.quantum_luminance[28] = 51;
            this.quantum_luminance[29] = 87;
            this.quantum_luminance[30] = 80;
            this.quantum_luminance[31] = 62;
            this.quantum_luminance[32] = 18;
            this.quantum_luminance[33] = 22;
            this.quantum_luminance[34] = 37;
            this.quantum_luminance[35] = 56;
            this.quantum_luminance[36] = 68;
            this.quantum_luminance[37] = 109;
            this.quantum_luminance[38] = 103;
            this.quantum_luminance[39] = 77;
            this.quantum_luminance[40] = 24;
            this.quantum_luminance[41] = 35;
            this.quantum_luminance[42] = 55;
            this.quantum_luminance[43] = 64;
            this.quantum_luminance[44] = 81;
            this.quantum_luminance[45] = 104;
            this.quantum_luminance[46] = 113;
            this.quantum_luminance[47] = 92;
            this.quantum_luminance[48] = 49;
            this.quantum_luminance[49] = 64;
            this.quantum_luminance[50] = 78;
            this.quantum_luminance[51] = 87;
            this.quantum_luminance[52] = 103;
            this.quantum_luminance[53] = 121;
            this.quantum_luminance[54] = 120;
            this.quantum_luminance[55] = 101;
            this.quantum_luminance[56] = 72;
            this.quantum_luminance[57] = 92;
            this.quantum_luminance[58] = 95;
            this.quantum_luminance[59] = 98;
            this.quantum_luminance[60] = 112;
            this.quantum_luminance[61] = 100;
            this.quantum_luminance[62] = 103;
            this.quantum_luminance[63] = 99;
            for (j = 0; j < 64; ++j) {
                temp = (this.quantum_luminance[j] * Quality + 50) / 100;
                if (temp <= 0) {
                    temp = 1;
                }
                if (temp > 255) {
                    temp = 255;
                }
                this.quantum_luminance[j] = temp;
            }
            int index = 0;
            for (i = 0; i < 8; ++i) {
                for (j = 0; j < 8; ++j) {
                    this.DivisorsLuminance[index] = 1.0 / ((double)this.quantum_luminance[index] * AANscaleFactor[i] * AANscaleFactor[j] * 8.0);
                    ++index;
                }
            }
            this.quantum_chrominance[0] = 17;
            this.quantum_chrominance[1] = 18;
            this.quantum_chrominance[2] = 24;
            this.quantum_chrominance[3] = 47;
            this.quantum_chrominance[4] = 99;
            this.quantum_chrominance[5] = 99;
            this.quantum_chrominance[6] = 99;
            this.quantum_chrominance[7] = 99;
            this.quantum_chrominance[8] = 18;
            this.quantum_chrominance[9] = 21;
            this.quantum_chrominance[10] = 26;
            this.quantum_chrominance[11] = 66;
            this.quantum_chrominance[12] = 99;
            this.quantum_chrominance[13] = 99;
            this.quantum_chrominance[14] = 99;
            this.quantum_chrominance[15] = 99;
            this.quantum_chrominance[16] = 24;
            this.quantum_chrominance[17] = 26;
            this.quantum_chrominance[18] = 56;
            this.quantum_chrominance[19] = 99;
            this.quantum_chrominance[20] = 99;
            this.quantum_chrominance[21] = 99;
            this.quantum_chrominance[22] = 99;
            this.quantum_chrominance[23] = 99;
            this.quantum_chrominance[24] = 47;
            this.quantum_chrominance[25] = 66;
            this.quantum_chrominance[26] = 99;
            this.quantum_chrominance[27] = 99;
            this.quantum_chrominance[28] = 99;
            this.quantum_chrominance[29] = 99;
            this.quantum_chrominance[30] = 99;
            this.quantum_chrominance[31] = 99;
            this.quantum_chrominance[32] = 99;
            this.quantum_chrominance[33] = 99;
            this.quantum_chrominance[34] = 99;
            this.quantum_chrominance[35] = 99;
            this.quantum_chrominance[36] = 99;
            this.quantum_chrominance[37] = 99;
            this.quantum_chrominance[38] = 99;
            this.quantum_chrominance[39] = 99;
            this.quantum_chrominance[40] = 99;
            this.quantum_chrominance[41] = 99;
            this.quantum_chrominance[42] = 99;
            this.quantum_chrominance[43] = 99;
            this.quantum_chrominance[44] = 99;
            this.quantum_chrominance[45] = 99;
            this.quantum_chrominance[46] = 99;
            this.quantum_chrominance[47] = 99;
            this.quantum_chrominance[48] = 99;
            this.quantum_chrominance[49] = 99;
            this.quantum_chrominance[50] = 99;
            this.quantum_chrominance[51] = 99;
            this.quantum_chrominance[52] = 99;
            this.quantum_chrominance[53] = 99;
            this.quantum_chrominance[54] = 99;
            this.quantum_chrominance[55] = 99;
            this.quantum_chrominance[56] = 99;
            this.quantum_chrominance[57] = 99;
            this.quantum_chrominance[58] = 99;
            this.quantum_chrominance[59] = 99;
            this.quantum_chrominance[60] = 99;
            this.quantum_chrominance[61] = 99;
            this.quantum_chrominance[62] = 99;
            this.quantum_chrominance[63] = 99;
            for (j = 0; j < 64; ++j) {
                temp = (this.quantum_chrominance[j] * Quality + 50) / 100;
                if (temp <= 0) {
                    temp = 1;
                }
                if (temp >= 255) {
                    temp = 255;
                }
                this.quantum_chrominance[j] = temp;
            }
            index = 0;
            for (i = 0; i < 8; ++i) {
                for (j = 0; j < 8; ++j) {
                    this.DivisorsChrominance[index] = 1.0 / ((double)this.quantum_chrominance[index] * AANscaleFactor[i] * AANscaleFactor[j] * 8.0);
                    ++index;
                }
            }
            this.quantum[0] = this.quantum_luminance;
            this.Divisors[0] = this.DivisorsLuminance;
            this.quantum[1] = this.quantum_chrominance;
            this.Divisors[1] = this.DivisorsChrominance;
        }

        public double[][] forwardDCTExtreme(float[][] input) {
            double[][] output = new double[this.N][this.N];
            for (int v = 0; v < 8; ++v) {
                for (int u = 0; u < 8; ++u) {
                    for (int x = 0; x < 8; ++x) {
                        for (int y = 0; y < 8; ++y) {
                            double[] dArray = output[v];
                            int n = u;
                            dArray[n] = dArray[n] + (double)input[x][y] * Math.cos((double)(2 * x + 1) * (double)u * Math.PI / 16.0) * Math.cos((double)(2 * y + 1) * (double)v * Math.PI / 16.0);
                        }
                    }
                    double[] dArray = output[v];
                    int n = u;
                    dArray[n] = dArray[n] * (0.25 * (u == 0 ? 1.0 / Math.sqrt(2.0) : 1.0) * (v == 0 ? 1.0 / Math.sqrt(2.0) : 1.0));
                }
            }
            return output;
        }

        public double[][] forwardDCT(float[][] input) {
            double z13;
            double z11;
            double z3;
            double z4;
            double z2;
            double z5;
            double z1;
            double tmp12;
            double tmp11;
            double tmp13;
            double tmp10;
            double tmp4;
            double tmp3;
            double tmp5;
            double tmp2;
            double tmp6;
            double tmp1;
            double tmp7;
            double tmp0;
            int i;
            double[][] output = new double[this.N][this.N];
            for (i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    output[i][j] = (double)input[i][j] - 128.0;
                }
            }
            for (i = 0; i < 8; ++i) {
                tmp0 = output[i][0] + output[i][7];
                tmp7 = output[i][0] - output[i][7];
                tmp1 = output[i][1] + output[i][6];
                tmp6 = output[i][1] - output[i][6];
                tmp2 = output[i][2] + output[i][5];
                tmp5 = output[i][2] - output[i][5];
                tmp3 = output[i][3] + output[i][4];
                tmp4 = output[i][3] - output[i][4];
                tmp10 = tmp0 + tmp3;
                tmp13 = tmp0 - tmp3;
                tmp11 = tmp1 + tmp2;
                tmp12 = tmp1 - tmp2;
                output[i][0] = tmp10 + tmp11;
                output[i][4] = tmp10 - tmp11;
                z1 = (tmp12 + tmp13) * 0.707106781;
                output[i][2] = tmp13 + z1;
                output[i][6] = tmp13 - z1;
                tmp10 = tmp4 + tmp5;
                tmp11 = tmp5 + tmp6;
                tmp12 = tmp6 + tmp7;
                z5 = (tmp10 - tmp12) * 0.382683433;
                z2 = 0.5411961 * tmp10 + z5;
                z4 = 1.306562965 * tmp12 + z5;
                z3 = tmp11 * 0.707106781;
                z11 = tmp7 + z3;
                z13 = tmp7 - z3;
                output[i][5] = z13 + z2;
                output[i][3] = z13 - z2;
                output[i][1] = z11 + z4;
                output[i][7] = z11 - z4;
            }
            for (i = 0; i < 8; ++i) {
                tmp0 = output[0][i] + output[7][i];
                tmp7 = output[0][i] - output[7][i];
                tmp1 = output[1][i] + output[6][i];
                tmp6 = output[1][i] - output[6][i];
                tmp2 = output[2][i] + output[5][i];
                tmp5 = output[2][i] - output[5][i];
                tmp3 = output[3][i] + output[4][i];
                tmp4 = output[3][i] - output[4][i];
                tmp10 = tmp0 + tmp3;
                tmp13 = tmp0 - tmp3;
                tmp11 = tmp1 + tmp2;
                tmp12 = tmp1 - tmp2;
                output[0][i] = tmp10 + tmp11;
                output[4][i] = tmp10 - tmp11;
                z1 = (tmp12 + tmp13) * 0.707106781;
                output[2][i] = tmp13 + z1;
                output[6][i] = tmp13 - z1;
                tmp10 = tmp4 + tmp5;
                tmp11 = tmp5 + tmp6;
                tmp12 = tmp6 + tmp7;
                z5 = (tmp10 - tmp12) * 0.382683433;
                z2 = 0.5411961 * tmp10 + z5;
                z4 = 1.306562965 * tmp12 + z5;
                z3 = tmp11 * 0.707106781;
                z11 = tmp7 + z3;
                z13 = tmp7 - z3;
                output[5][i] = z13 + z2;
                output[3][i] = z13 - z2;
                output[1][i] = z11 + z4;
                output[7][i] = z11 - z4;
            }
            return output;
        }

        public int[] quantizeBlock(double[][] inputData, int code) {
            int[] outputData = new int[this.N * this.N];
            int index = 0;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    outputData[index] = (int)(inputData[i][j] * ((double[])this.Divisors[code])[index]);
                    ++index;
                }
            }
            return outputData;
        }

        public int[] quantizeBlockExtreme(double[][] inputData, int code) {
            int[] outputData = new int[this.N * this.N];
            int index = 0;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    outputData[index] = (int)Math.floor(inputData[i][j] / (double)((int[])this.quantum[code])[index]);
                    ++index;
                }
            }
            return outputData;
        }
    }
}

