/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.composer;

import dinesh.mobile.composer.ComposerMIDlet;
import dinesh.mobile.composer.EditPatternScreen;
import dinesh.mobile.composer.ErrorScreen;
import dinesh.mobile.composer.FrequencyScreen;
import dinesh.mobile.composer.InputTitleScreen;
import dinesh.mobile.composer.KeyThread;
import dinesh.mobile.composer.PatternFormatScreen;
import dinesh.mobile.composer.RingtoneMessageScreen;
import dinesh.mobile.composer.SaveAsScreen;
import dinesh.mobile.composer.TestCanvas;
import dinesh.mobile.composer.TonePlayer;
import dinesh.mobile.sms.ringtone.RingtoneProgrammingLanguage;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

class EditCanvas
extends Canvas
implements CommandListener {
    public static final Font SHARP_FONT = Font.getFont((int)0, (int)2, (int)8);
    public static final Font DOT_FONT = Font.getFont((int)0, (int)1, (int)8);
    public static final Font NOTE_VALUE_FONT = Font.getFont((int)0, (int)3, (int)16);
    public static final int SHARP_WIDTH = SHARP_FONT.stringWidth("#");
    public static final int DOT_WIDTH;
    public static final int DOT_HEIGHT;
    public static final int SCALE_WIDTH;
    public static final int NOTE_VALUE_WIDTH;
    public static final int DURATION_LEVEL_WIDTH;
    public static final int SHARP_COLOR;
    public static final int DOT_COLOR;
    public static final int SCALE_COLOR;
    public static final int NOTE_VALUE_COLOR;
    public static final int DURATION_LEVEL_COLOR;
    public static final int NOTE_WIDTH;
    public static final int NOTE_HEIGHT;
    private final ComposerMIDlet parent;
    private String name;
    private String title;
    private String pattern;
    private Vector notes;
    private int tempo;
    private int volume;
    private int scale;
    private int duration;
    private TonePlayer tonePlayer;
    private TestCanvas testCanvas;
    private KeyThread keyThread;
    private boolean playing;
    private int pos;
    private int printedPos;
    private int pressedKey;
    private long pressedTime;
    private boolean pounded;
    private int canvasWidth;
    private int canvasHeight;
    private int notesPerLine;
    private int noteLines;
    private int notesPerCanvas;
    private int offsetX;
    private int offsetY;
    private Command clearCommand;
    private Command modeCommand;
    private boolean graphicalMode;

    EditCanvas(ComposerMIDlet composerMIDlet) {
        this(composerMIDlet, null, "", "");
    }

    EditCanvas(ComposerMIDlet composerMIDlet, String string, String string2, String string3) {
        this.addCommand(new Command("Ph\u00e1t", 4, 0));
        this.addCommand(new Command("L\u01b0u", 1, 0));
        this.addCommand(new Command("L\u01b0u nh\u01b0", 1, 0));
        this.addCommand(new Command("Xoa\u0301", 1, 0));
        this.modeCommand = new Command("Ch\u00ea\u0301 \u0111\u00f4\u0323 xem kha\u0301c", 1, 0);
        this.addCommand(this.modeCommand);
        this.addCommand(new Command("Nghe nh\u1ea1c", 1, 0));
        this.addCommand(new Command("X\u00f3a h\u1ebft", 1, 0));
        this.addCommand(new Command("S\u01b0\u0309a ti\u00eau \u0111\u00ea\u0300", 1, 0));
        this.addCommand(new Command("C\u00e0i \u0111\u1eb7t", 1, 0));
        this.addCommand(new Command("S\u01b0\u0309a ki\u00ea\u0309u m\u00e2\u0303u", 1, 0));
        this.addCommand(new Command("G\u01b0\u0309i", 1, 0));
        this.addCommand(new Command("Danh sa\u0301ch", 2, 1));
        this.clearCommand = new Command("X\u00f3a", 2, 0);
        this.setCommandListener(this);
        this.parent = composerMIDlet;
        this.name = string;
        this.title = string2;
        this.pattern = string3;
        this.duration = 4;
        if (string3.length() == 0) {
            this.tempo = 63;
            this.volume = 7;
            this.scale = 1;
            this.notes = new Vector();
            string3 = this.patternString(this.notes);
        } else {
            this.notes = this.notesVector(string3);
            this.pos = this.notes.size();
            this.addCommand(this.clearCommand);
        }
        this.tonePlayer = EditCanvas.makeTonePlayer();
        this.testCanvas = new TestCanvas(this, this.tonePlayer);
        this.testCanvas.setSoundEnabled(true);
        this.pos = 0;
        this.printedPos = 0;
        this.pressedKey = -1;
        this.pounded = false;
        this.canvasWidth = this.getWidth();
        this.canvasHeight = this.getHeight();
        this.notesPerLine = this.canvasWidth / NOTE_WIDTH;
        this.noteLines = this.canvasHeight / NOTE_HEIGHT;
        this.notesPerCanvas = this.noteLines * this.notesPerLine;
        this.offsetX = (this.canvasWidth - NOTE_WIDTH * this.notesPerLine) / 2;
        this.offsetY = (this.canvasHeight - NOTE_HEIGHT * this.noteLines) / 2;
        this.graphicalMode = false;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        int n3 = this.notes.size();
        for (n2 = n = this.pos - this.pos % this.notesPerCanvas; n2 < n3 && n2 - n < this.notesPerCanvas; ++n2) {
            int n4 = (n2 - n) % this.notesPerLine;
            int n5 = (n2 - n) / this.notesPerLine;
            String string = ((String[])this.notes.elementAt(n2))[0];
            String string2 = ((String[])this.notes.elementAt(n2))[1];
            this.drawNote(graphics, string, string2, (n4 *= NOTE_WIDTH) + this.offsetX, (n5 *= NOTE_HEIGHT) + this.offsetY);
        }
        n2 = this.pos % this.notesPerCanvas % this.notesPerLine;
        int n6 = this.pos % this.notesPerCanvas / this.notesPerLine;
        graphics.setColor(0);
        graphics.drawLine(this.offsetX + (n2 *= NOTE_WIDTH) + 1, this.offsetY + (n6 *= NOTE_HEIGHT), this.offsetX + n2 + 1, this.offsetY + n6 + NOTE_HEIGHT);
    }

    private void drawNote(Graphics graphics, String string, String string2, int n, int n2) {
        int n3;
        int n4;
        n += 2;
        int n5 = string.length();
        graphics.setColor(SCALE_COLOR);
        int n6 = Integer.parseInt(string2.substring(1));
        if (this.graphicalMode && string.charAt(0) != 'P') {
            n4 = NOTE_HEIGHT - 2;
            graphics.drawLine(n + SHARP_WIDTH + DOT_WIDTH + NOTE_VALUE_WIDTH + DURATION_LEVEL_WIDTH + SCALE_WIDTH / 2, n2 + 1, n + SHARP_WIDTH + DOT_WIDTH + NOTE_VALUE_WIDTH + DURATION_LEVEL_WIDTH + SCALE_WIDTH / 2, n2 + n4 - 1);
            n3 = n2 + (4 * n4 - n4 * (n6 + 1)) / 4;
            graphics.fillRect(n + SHARP_WIDTH + DOT_WIDTH + NOTE_VALUE_WIDTH + DURATION_LEVEL_WIDTH, n3 + 1, SCALE_WIDTH, n4 / 8);
            n4 += 2;
        } else if (string.charAt(0) != 'P') {
            graphics.setFont(SHARP_FONT);
            graphics.drawString(String.valueOf(n6), n + SHARP_WIDTH + DOT_WIDTH + NOTE_VALUE_WIDTH + DURATION_LEVEL_WIDTH + 1, n2 + NOTE_HEIGHT - SHARP_FONT.getHeight() - 1, 0x10 | 4);
        }
        graphics.setFont(NOTE_VALUE_FONT);
        graphics.setColor(NOTE_VALUE_COLOR);
        if (!this.graphicalMode && string.charAt(0) == 'P') {
            graphics.drawString("-", n + SHARP_WIDTH + DOT_WIDTH + DURATION_LEVEL_WIDTH, n2, 0x10 | 4);
        } else if (string.charAt(0) == 'H') {
            graphics.drawString(String.valueOf('B'), n + SHARP_WIDTH + DOT_WIDTH + DURATION_LEVEL_WIDTH, n2, 0x10 | 4);
        } else {
            graphics.drawString(String.valueOf(string.charAt(0)), n + SHARP_WIDTH + DOT_WIDTH + DURATION_LEVEL_WIDTH, n2, 0x10 | 4);
        }
        n4 = 1;
        n3 = 1;
        if (n5 > 1) {
            if (string.charAt(n4) == '#') {
                if (string.charAt(0) == 'C' || string.charAt(0) == 'D' || string.charAt(0) == 'F' || string.charAt(0) == 'G' || string.charAt(0) == 'A') {
                    graphics.setFont(SHARP_FONT);
                    graphics.setColor(SHARP_COLOR);
                    graphics.drawString("#", n + DOT_WIDTH, n2, 0x10 | 4);
                }
                ++n4;
            }
            if (n5 > n4 && string.charAt(n4) == '.') {
                graphics.setFont(DOT_FONT);
                graphics.setColor(DOT_COLOR);
                if (string.charAt(0) != 'P') {
                    graphics.drawString(".", n + SHARP_WIDTH, n2 + 2 * DOT_HEIGHT, 0x10 | 4);
                }
                if (n5 > ++n4 && string.charAt(n4) == '.') {
                    if (string.charAt(0) != 'P') {
                        graphics.drawString(".", n + SHARP_WIDTH, n2 + 1 * DOT_HEIGHT, 0x10 | 4);
                    }
                    if (n5 > ++n4 && string.charAt(n4) == '.') {
                        if (string.charAt(0) != 'P') {
                            graphics.drawString(".", n + SHARP_WIDTH, n2 + 0 * DOT_HEIGHT, 0x10 | 4);
                        }
                        ++n4;
                    }
                }
            }
            if (n5 > n4 + 1 && string.charAt(n4) == '/') {
                n3 = Integer.parseInt(string.substring(n4 + 1));
                n4 = NOTE_HEIGHT / n3 + 1;
            }
        }
        if (n3 == 1 || n4 > NOTE_HEIGHT) {
            n4 = NOTE_HEIGHT - 2;
        }
        graphics.setColor(DURATION_LEVEL_COLOR);
        if (this.graphicalMode) {
            graphics.fillRect(n + SHARP_WIDTH + DOT_WIDTH, n2 + NOTE_HEIGHT - n4 - 1, DURATION_LEVEL_WIDTH, n4);
        } else {
            graphics.setFont(SHARP_FONT);
            if (n3 > 1) {
                graphics.drawString(String.valueOf(n3), n + SHARP_WIDTH + DOT_WIDTH + 1, n2 + NOTE_HEIGHT - SHARP_FONT.getHeight() - 1, 0x10 | 4);
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        String string = "$";
        for (int i = 0; i < this.notes.size() && i < this.notesPerLine; ++i) {
            String string2 = ((String[])this.notes.elementAt(i))[0];
            string = string + String.valueOf(string2.charAt(string2.lastIndexOf(59) + 1));
        }
        string = string + "$.nrt";
        if (command.getLabel().equals("X\u00f3a")) {
            if (this.pos == 0) {
                return;
            }
            this.notes.removeElementAt(this.pos - 1);
            --this.pos;
            if (this.notes.size() == 0) {
                this.removeCommand(this.clearCommand);
            }
            this.pattern = this.patternString(this.notes);
            this.pressedKey = -1;
            this.repaint();
        } else if (command.getLabel().equals("Ph\u00e1t")) {
            TestCanvas testCanvas = new TestCanvas(this, this.tonePlayer);
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)testCanvas);
            testCanvas.setSoundEnabled(false);
            this.playing = true;
            this.keyThread = new KeyThread(this.parent, testCanvas, this.pattern);
            this.keyThread.start();
            this.tonePlayer.play(this.parent.convertTone(string, this.pattern));
        } else if (command.getLabel().equals("L\u01b0u")) {
            if (this.name == null) {
                if (this.title.length() > 0) {
                    string = this.title;
                }
                Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)new InputTitleScreen(this, string, true));
            } else {
                this.parent.saveTone(this.name, this.title, this.pattern);
                Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
            }
        } else if (command.getLabel().equals("L\u01b0u nh\u01b0")) {
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)new InputTitleScreen(this, string, true));
        } else if (command.getLabel().equals("Xoa\u0301")) {
            if (this.name == null) {
                ErrorScreen.showError("Nh\u1ea1c kh\u00f4ng th\u1ec3 l\u01b0u");
            } else {
                this.parent.deleteTone(this.name);
            }
        } else if (command.getLabel().equals("X\u00f3a h\u1ebft")) {
            this.notes = new Vector();
            this.pattern = this.patternString(this.notes);
            this.pos = 0;
            this.removeCommand(this.clearCommand);
            this.repaint();
        } else if (command.getLabel().equals("C\u00e0i \u0111\u1eb7t")) {
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)new FrequencyScreen(this, this.tempo, this.volume, this.scale, this.duration));
        } else if (command.getLabel().equals("Ch\u00ea\u0301 \u0111\u00f4\u0323 xem kha\u0301c")) {
            this.graphicalMode = !this.graphicalMode;
            this.repaint();
        } else if (command.getLabel().equals("Ma\u0300n hi\u0300nh chu\u00e2\u0309n")) {
            this.removeCommand(this.modeCommand);
            this.modeCommand = new Command("Ma\u0300n hi\u0300nh ve\u0303", 1, 0);
            this.addCommand(this.modeCommand);
            this.graphicalMode = false;
        } else if (command.getLabel().equals("Ma\u0300n hi\u0300nh ve\u0303")) {
            this.removeCommand(this.modeCommand);
            this.modeCommand = new Command("Ma\u0300n hi\u0300nh chu\u00e2\u0309n", 1, 0);
            this.addCommand(this.modeCommand);
            this.graphicalMode = true;
        } else if (command.getLabel().equals("Nghe nh\u1ea1c")) {
            TestCanvas testCanvas = new TestCanvas(this, this.tonePlayer);
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)testCanvas);
            testCanvas.setSoundEnabled(true);
        } else if (command.getLabel().equals("S\u01b0\u0309a ki\u00ea\u0309u m\u00e2\u0303u")) {
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)new PatternFormatScreen(this));
        } else if (command.getLabel().equals("S\u01b0\u0309a ti\u00eau \u0111\u00ea\u0300")) {
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)new InputTitleScreen(this, this.title, false));
        } else if (command.getLabel().equals("G\u01b0\u0309i")) {
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)new RingtoneMessageScreen(this));
        } else if (command.getLabel().equals("Tr\u1edf v\u1ec1") || command.getLabel().equals("Danh sa\u0301ch")) {
            this.parent.editCanvasBack(this.name);
        }
    }

    public void keyRepeated(int n) {
        block0 : switch (n) {
            case 35: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                break;
            }
            case 42: 
            case 56: 
            case 57: {
                this.keyPressed(n);
                break;
            }
            default: {
                switch (this.getGameAction(n)) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: {
                        this.keyPressed(n);
                        break block0;
                    }
                }
            }
        }
    }

    public void keyPressed(int n) {
        if (this.pressedKey != -1) {
            this.keyReleased(this.pressedKey);
        }
        this.pressedKey = n;
        block0 : switch (n) {
            case 35: {
                this.testCanvas.keyPressed(n);
                if (this.pos <= 0) break;
                this.addHash();
                this.repaint();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.testCanvas.keyPressed(n);
                this.pressedTime = System.currentTimeMillis();
                break;
            }
            case 56: {
                if (this.pos <= 0) break;
                String[] stringArray = (String[])this.notes.elementAt(this.pos - 1);
                int n2 = stringArray[0].indexOf(47);
                if (n2 == -1) {
                    stringArray[0] = stringArray[0] + "/2";
                } else {
                    int n3 = Integer.parseInt(stringArray[0].substring(n2 + 1)) * 2;
                    stringArray[0] = stringArray[0].substring(0, n2);
                    if (n3 <= 32) {
                        stringArray[0] = stringArray[0] + "/" + n3;
                    }
                }
                this.pattern = this.patternString(this.notes);
                this.repaint();
                break;
            }
            case 57: {
                if (!this.graphicalMode && this.pos > 0) {
                    String[] stringArray = (String[])this.notes.elementAt(this.pos - 1);
                    int n4 = stringArray[0].indexOf(47);
                    if (n4 == -1) {
                        stringArray[0] = stringArray[0] + "/32";
                    } else {
                        int n5 = Integer.parseInt(stringArray[0].substring(n4 + 1)) / 2;
                        stringArray[0] = stringArray[0].substring(0, n4);
                        if (n5 > 1) {
                            stringArray[0] = stringArray[0] + "/" + n5;
                        }
                    }
                    this.pattern = this.patternString(this.notes);
                    this.repaint();
                    break;
                }
                if (this.pos <= 0) break;
                this.addDot();
                this.repaint();
                break;
            }
            case 42: {
                String[] stringArray;
                if (this.pos <= 0 || (stringArray = (String[])this.notes.elementAt(this.pos - 1))[0].charAt(0) == 'P') break;
                int n6 = Integer.parseInt(stringArray[1].substring(1)) + 1;
                if (this.graphicalMode) {
                    if (n6 > 3) {
                        n6 = 0;
                    }
                } else if (n6 > 3) {
                    n6 = 1;
                }
                stringArray[1] = "S" + n6;
                this.pattern = this.patternString(this.notes);
                this.repaint();
                break;
            }
            default: {
                switch (this.getGameAction(n)) {
                    case 1: {
                        this.pos = this.pos < this.notesPerLine ? this.notes.size() : (this.pos -= this.notesPerLine);
                        if (this.pos > this.notes.size()) {
                            this.pos = this.notes.size();
                        }
                        this.repaint();
                        break block0;
                    }
                    case 2: {
                        --this.pos;
                        if (this.pos == -1) {
                            this.pos = this.notes.size();
                        }
                        this.repaint();
                        break block0;
                    }
                    case 6: {
                        if (this.pos == this.notes.size()) {
                            this.pos = 0;
                        } else {
                            this.pos += this.notesPerLine;
                            if (this.pos > this.notes.size()) {
                                this.pos = this.notes.size();
                            }
                        }
                        this.repaint();
                        break block0;
                    }
                    case 5: {
                        ++this.pos;
                        if (this.pos == this.notes.size() + 1) {
                            this.pos = 0;
                        }
                        this.repaint();
                        break block0;
                    }
                }
            }
        }
    }

    void addHash() {
        String[] stringArray = (String[])this.notes.elementAt(this.pos - 1);
        if (stringArray[0].charAt(1) == '#') {
            stringArray[0] = String.valueOf(stringArray[0].charAt(0)) + stringArray[0].substring(2);
            this.pattern = this.patternString(this.notes);
        } else if (stringArray[0].charAt(0) == 'C' || stringArray[0].charAt(0) == 'D' || stringArray[0].charAt(0) == 'F' || stringArray[0].charAt(0) == 'G' || stringArray[0].charAt(0) == 'A') {
            stringArray[0] = String.valueOf(stringArray[0].charAt(0)) + "#" + stringArray[0].substring(1);
            this.pattern = this.patternString(this.notes);
        }
    }

    void addDot() {
        String string;
        int n;
        String[] stringArray = (String[])this.notes.elementAt(this.pos - 1);
        if (stringArray[0].charAt(0) == 'P') {
            return;
        }
        int n2 = stringArray[0].indexOf(47);
        if (n2 == -1) {
            n2 = stringArray[0].length();
        }
        int n3 = 1;
        if (stringArray[0].length() > n3 && stringArray[0].charAt(n3) == '#') {
            ++n3;
        }
        if ((n = (string = stringArray[0].substring(n3, n2)).length() + 1) > 3) {
            n = 0;
        }
        string = "";
        for (int i = 0; i < n; ++i) {
            string = string + ".";
        }
        stringArray[0] = stringArray[0].substring(0, n3) + string + stringArray[0].substring(n2, stringArray[0].length());
        this.pattern = this.patternString(this.notes);
    }

    int p2(int n) {
        if (n <= 1) {
            return 1;
        }
        if (n <= 2) {
            return 2;
        }
        if (n <= 4) {
            return 4;
        }
        if (n <= 8) {
            return 8;
        }
        if (n <= 16) {
            return 16;
        }
        return 32;
    }

    private void addNoteElement(String string, int n) {
        int n2;
        String[] stringArray = null;
        long l = 240000 / this.tempo;
        int n3 = (int)l;
        if (n == -1) {
            n2 = this.pos;
            while (stringArray == null && n2 != 0) {
                stringArray = (String[])this.notes.elementAt(n2 - 1);
                if (stringArray[0].charAt(0) != 'P') continue;
                stringArray = null;
                --n2;
            }
            if (stringArray != null) {
                int n4 = stringArray[0].indexOf(47);
                int n5 = n4 == -1 && n4 > stringArray[0].length() - 2 ? 1 : Integer.parseInt(stringArray[0].substring(n4 + 1));
                n = n3 / n5;
            } else {
                n = n3 / this.duration;
            }
        }
        stringArray = new String[2];
        stringArray[1] = this.pos > 0 ? ((String[])this.notes.elementAt(this.pos - 1))[1] : "S" + this.scale;
        for (n2 = 0; n2 < n / n3; ++n2) {
            stringArray[0] = string;
            this.notes.insertElementAt(stringArray, this.pos);
            ++this.pos;
        }
        if ((n %= n3) > 0) {
            stringArray[0] = string + "/" + this.p2(n3 / n);
            this.notes.insertElementAt(stringArray, this.pos);
            ++this.pos;
        }
        this.addCommand(this.clearCommand);
    }

    public void keyReleased(int n) {
        int n2 = 0;
        boolean bl = true;
        int n3 = (int)(System.currentTimeMillis() - this.pressedTime);
        if (!this.graphicalMode) {
            n2 = n3;
            n3 = -1;
        }
        this.testCanvas.keyReleased(n);
        switch (n) {
            case 48: {
                this.addNoteElement("P", n3);
                break;
            }
            case 49: {
                this.addNoteElement("C", n3);
                break;
            }
            case 50: {
                this.addNoteElement("D", n3);
                break;
            }
            case 51: {
                this.addNoteElement("E", n3);
                break;
            }
            case 52: {
                this.addNoteElement("F", n3);
                break;
            }
            case 53: {
                this.addNoteElement("G", n3);
                break;
            }
            case 54: {
                this.addNoteElement("A", n3);
                break;
            }
            case 55: {
                this.addNoteElement("H", n3);
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            this.pattern = this.patternString(this.notes);
            if (!this.graphicalMode && n > 48 && n < 56 && n2 > 800) {
                this.addDot();
            }
            this.repaint();
        }
        this.pressedKey = -1;
    }

    String patternString(Vector vector) {
        String string = "T" + this.tempo + ";" + "V" + this.volume + ";" + "S" + this.scale + ";";
        String string2 = "S" + this.scale;
        String[] stringArray = new String[2];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray = (String[])vector.elementAt(i);
            if (!string2.equals(stringArray[1])) {
                string2 = stringArray[1];
                string = string + string2 + ";";
            }
            string = string + stringArray[0] + ";";
        }
        return string;
    }

    Vector notesVector(String string) {
        Vector<String[]> vector = new Vector<String[]>();
        String string2 = "";
        String string3 = "S1";
        String[] stringArray = new String[2];
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ';') {
                if (bl) {
                    if (string2.charAt(0) == 'T') {
                        this.tempo = Integer.parseInt(string2.substring(1));
                        string2 = "";
                        continue;
                    }
                    if (string2.charAt(0) == 'V') {
                        this.volume = Integer.parseInt(string2.substring(1));
                        string2 = "";
                        continue;
                    }
                    if (string2.charAt(0) == 'S') {
                        this.scale = Integer.parseInt(string2.substring(1));
                        string3 = "S" + this.scale;
                        string2 = "";
                        continue;
                    }
                }
                bl = false;
                if (string2.charAt(0) == 'S') {
                    string3 = string2;
                } else {
                    stringArray = new String[]{string2, string3};
                    vector.addElement(stringArray);
                }
                string2 = "";
                continue;
            }
            string2 = string2 + String.valueOf(string.charAt(i));
        }
        return vector;
    }

    void frequencyScreenBack() {
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
    }

    void frequencyScreenDone(int n, int n2, int n3, int n4) {
        this.tempo = n;
        this.volume = n2;
        this.scale = n3;
        this.duration = n4;
        this.pattern = this.pattern.substring(this.pattern.indexOf(59) + 1);
        this.pattern = this.pattern.substring(this.pattern.indexOf(59) + 1);
        this.pattern = this.pattern.substring(this.pattern.indexOf(59) + 1);
        this.pattern = "T" + n + ";" + "V" + n2 + ";" + "S" + n3 + ";" + this.pattern;
        this.notes = this.notesVector(this.pattern);
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
    }

    void testCanvasBack() {
        this.playing = false;
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
    }

    void inputTitleScreenCancel(boolean bl) {
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
    }

    void inputTitleScreenDone(String string, boolean bl) {
        this.title = string;
        if (bl) {
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)new SaveAsScreen(this));
        } else {
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
        }
    }

    void saveAsScreenBack() {
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)new InputTitleScreen(this, this.title, true));
    }

    void saveAsScreenCancel() {
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
    }

    void saveAsScreenDone(String string) {
        this.name = string;
        this.parent.saveTone(string, this.title, this.pattern);
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
    }

    void patternFormatScreenDone(String string) {
        this.pattern = this.patternString(this.notes);
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)new EditPatternScreen(this, RingtoneProgrammingLanguage.changeFormat(this.pattern, string)));
    }

    void patternFormatScreenCancel() {
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
    }

    void editPatternScreenCancel() {
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
    }

    void editPatternScreenDone(String string) {
        this.pattern = RingtoneProgrammingLanguage.localFormat(string);
        this.notes = this.notesVector(this.pattern);
        this.pattern = this.patternString(this.notes);
        this.pos = 0;
        if (this.notes.size() == 0) {
            this.removeCommand(this.clearCommand);
        } else {
            this.addCommand(this.clearCommand);
        }
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
    }

    void ringtoneMessageScreenCancel() {
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
    }

    void ringtoneMessageScreenDone(String string) {
        this.parent.sendTone(this.title, this.pattern, string);
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this);
    }

    private static TonePlayer makeTonePlayer() {
        TonePlayer tonePlayer;
        try {
            Class.forName("com.nokia.mid.sound.Sound");
            Class<?> clazz = Class.forName("dinesh.mobile.composer.NokiaTonePlayer");
            tonePlayer = (TonePlayer)clazz.newInstance();
        }
        catch (Exception exception) {
            tonePlayer = new TonePlayer();
        }
        return tonePlayer;
    }

    static {
        DOT_HEIGHT = DOT_WIDTH = DOT_FONT.stringWidth(".");
        NOTE_VALUE_WIDTH = NOTE_VALUE_FONT.stringWidth("G");
        DURATION_LEVEL_WIDTH = SHARP_FONT.stringWidth("32");
        SCALE_WIDTH = SHARP_FONT.stringWidth("8");
        SHARP_COLOR = 255;
        NOTE_VALUE_COLOR = 0xFF0000;
        DOT_COLOR = 0xFF0000;
        DURATION_LEVEL_COLOR = 65280;
        SCALE_COLOR = 0xFF00FF;
        NOTE_WIDTH = 3 + SHARP_WIDTH + DOT_WIDTH + DURATION_LEVEL_WIDTH + NOTE_VALUE_WIDTH + SCALE_WIDTH;
        NOTE_HEIGHT = NOTE_VALUE_FONT.getHeight();
    }
}

