/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.composer;

import dinesh.mobile.composer.EditCanvas;
import dinesh.mobile.composer.TonePlayer;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class TestCanvas
extends Canvas
implements CommandListener {
    private static final int SILENT = -1;
    private static int[][] frequencies = new int[][]{{0, 0}, {523, 554}, {587, 622}, {659, 659}, {698, 740}, {784, 831}, {880, 932}, {988, 988}};
    private static final int NATURAL = 0;
    private static final int SHARP = 1;
    private static final int CLEF_G_LINE_Y = 30;
    private static final int NOTE_WIDTH = 7;
    private static final int NOTE_HEIGHT = 7;
    private static final int SHARP_WIDTH = 5;
    private static final int LINE_SPACING = 6;
    private static final int TOP_LINE_Y = 12;
    private static final int MIDDLE_C_Y = 42;
    private static final int LAYOUT_HEIGHT = 46;
    private static final int SHARP_OFFSET = 7;
    private static final int LEGER_LINE_WIDTH = 11;
    private final EditCanvas parent;
    private final Image trebleImg;
    private final Image noteImg;
    private final Image sharpImg;
    private final TonePlayer tonePlayer;
    private boolean soundEnabled;
    private int note = -1;
    private int currentKey;
    private boolean sharp = false;
    private boolean displayed = true;

    TestCanvas(EditCanvas editCanvas, TonePlayer tonePlayer) {
        this.parent = editCanvas;
        this.tonePlayer = tonePlayer;
        this.trebleImg = TestCanvas.createImage("/treble.png");
        this.noteImg = TestCanvas.createImage("/note.png");
        this.sharpImg = TestCanvas.createImage("/sharp.png");
        this.addCommand(new Command("Tr\u1edf v\u1ec1", 2, 1));
        this.setCommandListener(this);
    }

    public void showNotify() {
        this.displayed = true;
    }

    public void hideNotify() {
        this.displayed = false;
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, n, n2);
        int n3 = (this.getHeight() - 46) / 2;
        graphics.drawImage(this.trebleImg, 1, n3 - 10, 20);
        if (this.note != -1) {
            this.drawNote(graphics, n3, n);
        }
        this.drawLines(graphics, n3, n);
    }

    private void drawLines(Graphics graphics, int n, int n2) {
        graphics.setColor(0);
        for (int i = 0; i < 5; ++i) {
            int n3 = n + 12 + 6 * i;
            graphics.drawLine(0, n3, n2 - 1, n3);
        }
    }

    private void drawNote(Graphics graphics, int n, int n2) {
        int n3 = n + 42 - (this.note + 1) * 6 / 2;
        int n4 = n2 / 2;
        graphics.drawImage(this.noteImg, n4, n3, 3);
        if (this.note == 1) {
            graphics.setColor(0);
            graphics.drawLine(n4 - 5, n3, n4 + 5, n3);
        }
        if (this.sharp && frequencies[this.note][0] != frequencies[this.note][1]) {
            graphics.drawImage(this.sharpImg, n4 - 7, n3, 3);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getLabel().equals("Tr\u1edf v\u1ec1")) {
            this.stopNote();
            this.parent.testCanvasBack();
        }
    }

    public void keyPressed(int n) {
        if (n == 35) {
            this.sharp = !this.sharp;
        } else {
            switch (n) {
                case 49: {
                    this.note = 1;
                    break;
                }
                case 50: {
                    this.note = 2;
                    break;
                }
                case 51: {
                    this.note = 3;
                    break;
                }
                case 52: {
                    this.note = 4;
                    break;
                }
                case 53: {
                    this.note = 5;
                    break;
                }
                case 54: {
                    this.note = 6;
                    break;
                }
                case 55: {
                    this.note = 7;
                    break;
                }
                case 48: {
                    this.note = 0;
                    break;
                }
                default: {
                    this.note = -1;
                }
            }
            if (this.note != -1 && this.soundEnabled) {
                this.startNote();
            }
            this.currentKey = n;
        }
        if (this.displayed) {
            this.repaint();
        }
    }

    public void keyReleased(int n) {
        if (n == this.currentKey) {
            this.note = -1;
            if (this.soundEnabled) {
                this.stopNote();
            }
        }
        if (this.displayed) {
            this.repaint();
        }
    }

    private void startNote() {
        this.tonePlayer.play(frequencies[this.note][this.sharp ? 1 : 0]);
    }

    void stopNote() {
        this.tonePlayer.stop();
    }

    private static Image createImage(String string) {
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    void setSoundEnabled(boolean bl) {
        this.soundEnabled = bl;
    }

    public boolean getSoundEnabled() {
        return this.soundEnabled;
    }

    public boolean getSharp() {
        return this.sharp;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }
}

