/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.sms.ringtone;

import dinesh.io.BitInputStream;
import dinesh.io.BitOutputStream;
import dinesh.mobile.sms.ringtone.Constants;
import dinesh.mobile.sms.ringtone.PatternInstruction;
import java.io.IOException;

public class NoteInstruction
extends PatternInstruction
implements Constants {
    private int value;
    private int duration;
    private int durationSpecifier;

    public NoteInstruction(String string) {
        int n = string.length();
        switch (string.charAt(0)) {
            case 'P': {
                this.value = 0;
                break;
            }
            case 'C': {
                this.value = 1;
                break;
            }
            case 'D': {
                this.value = 3;
                break;
            }
            case 'E': {
                this.value = 5;
                break;
            }
            case 'F': {
                this.value = 6;
                break;
            }
            case 'G': {
                this.value = 8;
                break;
            }
            case 'A': {
                this.value = 10;
                break;
            }
            case 'H': {
                this.value = 12;
                break;
            }
        }
        int n2 = 1;
        if (n > n2) {
            if (string.charAt(n2) == '#') {
                if (string.charAt(0) == 'C' || string.charAt(0) == 'D' || string.charAt(0) == 'F' || string.charAt(0) == 'G' || string.charAt(0) == 'A') {
                    ++this.value;
                }
                ++n2;
            }
            this.durationSpecifier = 0;
            if (n > n2 && string.charAt(n2) == '.') {
                this.durationSpecifier = 1;
                if (n > ++n2 && string.charAt(n2) == '.') {
                    this.durationSpecifier = 2;
                    if (n > ++n2 && string.charAt(n2) == '.') {
                        this.durationSpecifier = 3;
                        ++n2;
                    }
                }
            }
            this.duration = 0;
            if (n > n2 + 1 && string.charAt(n2) == '/') {
                n2 = Integer.parseInt(string.substring(n2 + 1));
                switch (n2) {
                    case 2: {
                        this.duration = 1;
                        break;
                    }
                    case 4: {
                        this.duration = 2;
                        break;
                    }
                    case 8: {
                        this.duration = 3;
                        break;
                    }
                    case 16: {
                        this.duration = 4;
                        break;
                    }
                    case 32: {
                        this.duration = 5;
                        break;
                    }
                }
            }
        }
    }

    public NoteInstruction(BitInputStream bitInputStream) throws IOException {
        this.value = bitInputStream.read(4);
        this.duration = bitInputStream.read(3);
        this.durationSpecifier = bitInputStream.read(2);
    }

    public NoteInstruction(int n, int n2, int n3) {
        this.value = n;
        this.duration = n2;
        this.durationSpecifier = n3;
    }

    public NoteInstruction(int n, int n2) {
        this.value = n;
        this.duration = n2;
        this.durationSpecifier = 0;
    }

    public int length() {
        return 12;
    }

    public void writeToStream(BitOutputStream bitOutputStream) throws Exception {
        bitOutputStream.write(this.getTypeID(), 3);
        bitOutputStream.write(this.value, 4);
        bitOutputStream.write(this.duration, 3);
        bitOutputStream.write(this.durationSpecifier, 2);
    }

    public String print() {
        String string;
        switch (this.value) {
            case 0: {
                string = "P";
                break;
            }
            case 1: {
                string = "C";
                break;
            }
            case 2: {
                string = "C#";
                break;
            }
            case 3: {
                string = "D";
                break;
            }
            case 4: {
                string = "D#";
                break;
            }
            case 5: {
                string = "E";
                break;
            }
            case 6: {
                string = "F";
                break;
            }
            case 7: {
                string = "F#";
                break;
            }
            case 8: {
                string = "G";
                break;
            }
            case 9: {
                string = "G#";
                break;
            }
            case 10: {
                string = "A";
                break;
            }
            case 11: {
                string = "A#";
                break;
            }
            case 12: {
                string = "H";
                break;
            }
            default: {
                string = "";
            }
        }
        switch (this.durationSpecifier) {
            case 3: {
                string = string + ".";
            }
            case 2: {
                string = string + ".";
            }
            case 1: {
                string = string + ".";
            }
        }
        switch (this.duration) {
            case 0: {
                string = string + "/1";
                break;
            }
            case 1: {
                string = string + "/2";
                break;
            }
            case 2: {
                string = string + "/4";
                break;
            }
            case 3: {
                string = string + "/8";
                break;
            }
            case 4: {
                string = string + "/16";
                break;
            }
            case 5: {
                string = string + "/32";
                break;
            }
        }
        return string;
    }

    public int getTypeID() {
        return 1;
    }

    public int getValue() {
        return this.value;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getDurationSpecifier() {
        return this.durationSpecifier;
    }
}

