/*
 * Decompiled with CFR 0.152.
 */
package zip;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import zip.ZipEntry;
import zip.ZipOutputStream;

public final class ZipFile {
    private static final int TYPE_GZIP = 1;
    private boolean inStreamEnded;
    private byte status;
    private static final byte EXPECTING_HEADER = 0;
    private static final byte EXPECTING_DATA = 1;
    private static final byte EXPECTING_CHECK = 2;
    private static final byte FINISHED = 3;
    private boolean hash;
    private boolean validData;
    private int crc32;
    private int type;
    private boolean BFINAL;
    private int BTYPE;
    private byte[] window = new byte[32768];
    private int pProcessed;
    private long allPocessed;
    byte[] outBuff;
    private int buffsize;
    int outEnd;
    int lastEnd;
    int outStart;
    private int B0len;
    long[] smallCodeBuffer;
    static final byte BL = 8;
    short[] huffmanTree;
    short[] distHuffTree;
    private static final boolean debug = false;
    private static final boolean CRC = false;
    private static final boolean GZIP = false;
    byte[] tmpRef = new byte[8];
    private int offset;
    int datalen;
    public byte[] bytes;
    Vector entries;

    public ZipFile(String url) throws IOException {
        this(url.startsWith("/") ? ZipFile.loadJar(url) : ZipFile.loadFile(url), 0, false, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadFile(String url) {
        byte[] byArray;
        FileConnection fc = null;
        try {
            fc = (FileConnection)Connector.open((String)url, (int)1);
            if (!fc.exists()) return null;
            if (fc.isDirectory()) return null;
            if (!fc.canRead()) return null;
            byte[] data = new byte[(int)fc.fileSize()];
            DataInputStream in = fc.openDataInputStream();
            in.readFully(data);
            in.close();
            byArray = data;
            if (fc == null) return byArray;
        }
        catch (Throwable throwable) {
            try {
                return null;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (fc != null) {
                    try {
                        fc.close();
                    }
                    catch (Throwable throwable3) {}
                }
            }
        }
        try {
            fc.close();
            return byArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadJar(String url) {
        byte[] byArray;
        InputStream in = url.getClass().getResourceAsStream(url);
        if (in == null) return null;
        try {
            DataInputStream din = new DataInputStream(in);
            byte[] data = new byte[in.available()];
            din.readFully(data);
            din.close();
            byArray = data;
        }
        catch (Throwable throwable) {
            try {
                return null;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable throwable3) {}
            }
        }
        try {
            in.close();
            return byArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return byArray;
    }

    public ZipFile(byte[] inputStream, int compressionType, boolean hash, boolean zipFile) throws IOException {
        this(inputStream, 1024, compressionType, hash, zipFile);
    }

    public ZipFile(byte[] inputStream, int size, int compressionType, boolean hash, boolean zipFile) throws IOException {
        if (inputStream == null || zipFile && inputStream.length < 23) {
            throw new IOException();
        }
        this.ContDataInputStream(inputStream, inputStream.length);
        if (zipFile) {
            this.endsys();
        }
        this.inf_reset();
        this.hash = hash;
        this.type = compressionType;
        this.huffmanTree = new short[1152];
        this.distHuffTree = new short[128];
        this.buffsize = size;
        this.outBuff = new byte[size + 300];
    }

    private static void skipheader(ZipFile in) throws IOException {
        if (in.readbuf() != 31 || in.readbuf() != 139 || in.readbuf() != 8) {
            throw new IOException("0");
        }
        int flag = in.readbuf();
        in.skipbuf(6);
        if ((flag & 4) == 4) {
            in.skipbuf(in.readbuf() | in.readbuf() << 8);
        }
        if ((flag & 8) == 8) {
            while (in.readbuf() != 0) {
            }
        }
        if ((flag & 0x10) == 16) {
            while (in.readbuf() != 0) {
            }
        }
        if ((flag & 2) == 2) {
            in.skipbuf(2);
        }
    }

    final void inf_reset() {
        this.inStreamEnded = false;
        this.status = 0;
        this.smallCodeBuffer = new long[2];
        this.pProcessed = 0;
        this.allPocessed = 0L;
        this.outEnd = 0;
        this.lastEnd = 0;
        this.outStart = 0;
    }

    public void close() {
        this.bytes = null;
        this.entries = null;
        this.smallCodeBuffer = null;
        this.huffmanTree = null;
        this.distHuffTree = null;
    }

    private void copyFromWindow(int start, int len, byte[] dest, int destoff) {
        if (start + len < this.window.length) {
            System.arraycopy(this.window, start, dest, 0 + destoff, len);
        } else {
            System.arraycopy(this.window, start, dest, 0 + destoff, this.window.length - start);
            System.arraycopy(this.window, 0, dest, this.window.length - start + destoff, len - (this.window.length - start));
        }
    }

    private void copyIntoWindow(int start, int len, byte[] src, int srcOff) {
        if (len + start < this.window.length) {
            System.arraycopy(src, srcOff, this.window, start, len);
        } else {
            System.arraycopy(src, srcOff, this.window, start, this.window.length - start);
            System.arraycopy(src, srcOff + (this.window.length - start), this.window, 0, len - (this.window.length - start));
        }
    }

    private void inflate() throws IOException {
        int val = 0;
        byte[] myWindow = this.window;
        byte[] myOutBuff = this.outBuff;
        System.arraycopy(myOutBuff, this.outStart, myOutBuff, 0, this.outEnd - this.outStart);
        this.outEnd -= this.outStart;
        this.outStart = 0;
        this.lastEnd = this.outEnd;
        if (this.B0len == 0 && this.smallCodeBuffer[1] < 15L) {
            this.refillSmallCodeBuffer();
        }
        while (myOutBuff.length - this.outEnd > 300 && (this.smallCodeBuffer[1] > 0L || this.B0len > 0) && this.status != 3) {
            if (this.status == 0) {
                this.processHeader();
            }
            if (this.status == 1) {
                if (this.BTYPE == 0) {
                    if (this.B0len > 0) {
                        int copyBytes = myOutBuff.length - this.outEnd > this.B0len ? this.B0len : myOutBuff.length - this.outEnd;
                        copyBytes = this.readbuf(myOutBuff, this.outEnd, copyBytes);
                        this.copyIntoWindow(this.pProcessed, copyBytes, myOutBuff, this.outEnd);
                        this.outEnd += copyBytes;
                        this.pProcessed = this.pProcessed + copyBytes & Short.MAX_VALUE;
                        this.B0len -= copyBytes;
                    } else {
                        this.status = this.BFINAL ? (byte)2 : (byte)0;
                        if (this.smallCodeBuffer[1] < 15L) {
                            this.refillSmallCodeBuffer();
                        }
                    }
                } else {
                    if (this.smallCodeBuffer[1] < 15L) {
                        this.refillSmallCodeBuffer();
                    }
                    if ((val = ZipOutputStream.deHuffNext(this.smallCodeBuffer, this.huffmanTree)) < 256) {
                        myWindow[this.pProcessed] = (byte)val;
                        this.pProcessed = this.pProcessed + 1 & Short.MAX_VALUE;
                        myOutBuff[this.outEnd] = (byte)val;
                        ++this.outEnd;
                    } else if (val != 256) {
                        int aPos;
                        if (val > 285) {
                            throw new IOException("1");
                        }
                        int cLen = this.popSmallBuffer(ZipOutputStream.LENGTH_CODE[val - 257 << 1]);
                        cLen += ZipOutputStream.LENGTH_CODE[(val - 257 << 1) + 1];
                        if (this.smallCodeBuffer[1] < 15L) {
                            this.refillSmallCodeBuffer();
                        }
                        val = ZipOutputStream.deHuffNext(this.smallCodeBuffer, this.distHuffTree);
                        int cPos = this.popSmallBuffer(ZipOutputStream.DISTANCE_CODE[val << 1]);
                        aPos += (aPos = this.pProcessed - (cPos += ZipOutputStream.DISTANCE_CODE[(val << 1) + 1])) < 0 ? myWindow.length : 0;
                        int rep = cLen / cPos;
                        int rem = cLen - cPos * rep;
                        int j = 0;
                        while (j < rep) {
                            this.copyFromWindow(aPos, cPos, myOutBuff, this.outEnd);
                            this.copyIntoWindow(this.pProcessed, cPos, myOutBuff, this.outEnd);
                            this.outEnd += cPos;
                            this.pProcessed = this.pProcessed + cPos & Short.MAX_VALUE;
                            ++j;
                        }
                        this.copyFromWindow(aPos, rem, myOutBuff, this.outEnd);
                        this.copyIntoWindow(this.pProcessed, rem, myOutBuff, this.outEnd);
                        this.outEnd += rem;
                        this.pProcessed = this.pProcessed + rem & Short.MAX_VALUE;
                    } else {
                        this.status = this.BFINAL ? (byte)2 : (byte)0;
                    }
                    if (this.smallCodeBuffer[1] < 15L) {
                        this.refillSmallCodeBuffer();
                    }
                }
            }
            if (this.status != 2) continue;
            this.status = (byte)3;
            this.allPocessed = this.allPocessed + (long)this.outEnd - (long)this.lastEnd & 0xFFFFFFFFL;
            this.popSmallBuffer(this.smallCodeBuffer[1] & 7L);
            int cCrc = this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8 | this.popSmallBuffer(8L) << 16 | this.popSmallBuffer(8L) << 24;
            int iSize = this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8 | this.popSmallBuffer(8L) << 16 | this.popSmallBuffer(8L) << 24;
            boolean bl = this.validData = (long)iSize == this.allPocessed;
        }
        if (this.status != 3) {
            this.allPocessed = this.allPocessed + (long)this.outEnd - (long)this.lastEnd & 0xFFFFFFFFL;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processHeader() throws IOException {
        block23: {
            block24: {
                block22: {
                    distHuffCode = new int[30];
                    distHuffData = new int[30];
                    distHuffCodeLength = new byte[30];
                    huffmanCode = new int[286];
                    huffmanData = new int[286];
                    huffmanCodeLength = new byte[286];
                    this.BFINAL = this.popSmallBuffer(1L) == 1;
                    this.BTYPE = this.popSmallBuffer(2L);
                    if (this.BTYPE == 3) {
                        throw new IllegalArgumentException();
                    }
                    if (this.BTYPE != 1) break block22;
                    ZipOutputStream.genFixedTree(huffmanCode, huffmanCodeLength, distHuffCode, distHuffCodeLength);
                    i = 0;
                    while (i < 286) {
                        huffmanData[i] = i;
                        ++i;
                    }
                    i = 0;
                    while (i < 30) {
                        distHuffData[i] = i;
                        ++i;
                    }
                    ZipOutputStream.convertTable2Tree(huffmanCode, huffmanCodeLength, huffmanData, this.huffmanTree);
                    ZipOutputStream.convertTable2Tree(distHuffCode, distHuffCodeLength, distHuffData, this.distHuffTree);
                    break block23;
                }
                if (this.BTYPE != 2) break block24;
                HLIT = this.popSmallBuffer(5L);
                HDIST = this.popSmallBuffer(5L);
                HCLEN = this.popSmallBuffer(4L);
                v0 = new int[19];
                v0[0] = 16;
                v0[1] = 17;
                v0[2] = 18;
                v0[4] = 8;
                v0[5] = 7;
                v0[6] = 9;
                v0[7] = 6;
                v0[8] = 10;
                v0[9] = 5;
                v0[10] = 11;
                v0[11] = 4;
                v0[12] = 12;
                v0[13] = 3;
                v0[14] = 13;
                v0[15] = 2;
                v0[16] = 14;
                v0[17] = 1;
                v0[18] = 15;
                miniHuffData = v0;
                v1 = new int[19];
                v1[1] = 1;
                v1[2] = 2;
                v1[3] = 3;
                v1[4] = 4;
                v1[5] = 5;
                v1[6] = 6;
                v1[7] = 7;
                v1[8] = 8;
                v1[9] = 9;
                v1[10] = 10;
                v1[11] = 11;
                v1[12] = 12;
                v1[13] = 13;
                v1[14] = 14;
                v1[15] = 15;
                v1[16] = 16;
                v1[17] = 17;
                v1[18] = 18;
                seq = v1;
                miniHuffCodeLength = new byte[19];
                miniHuffCode = new int[19];
                i = 0;
                while (i < HCLEN + 4) {
                    miniHuffCodeLength[miniHuffData[i]] = (byte)this.popSmallBuffer(3L);
                    ++i;
                }
                ZipOutputStream.genHuffTree(miniHuffCode, miniHuffCodeLength);
                ZipOutputStream.revHuffTree(miniHuffCode, miniHuffCodeLength);
                miniTree = new short[76];
                ZipOutputStream.convertTable2Tree(miniHuffCode, miniHuffCodeLength, seq, miniTree);
                i = 0;
                while (i < huffmanCodeLength.length) {
                    huffmanCodeLength[i] = 0;
                    ++i;
                }
                i = 0;
                while (i < distHuffCodeLength.length) {
                    distHuffCodeLength[i] = 0;
                    ++i;
                }
                lastVal = 0;
                j = 0;
                while (j < HLIT + 257 + HDIST + 1) {
                    if (this.smallCodeBuffer[1] < 15L) {
                        this.refillSmallCodeBuffer();
                    }
                    if ((val = ZipOutputStream.deHuffNext(this.smallCodeBuffer, miniTree)) < 16) {
                        lastVal = (byte)val;
                        val = 1;
                    } else if (val == 16) {
                        val = this.popSmallBuffer(2L) + 3;
                    } else if (val == 17) {
                        lastVal = 0;
                        val = this.popSmallBuffer(3L) + 3;
                    } else if (val == 18) {
                        lastVal = 0;
                        val = this.popSmallBuffer(7L) + 11;
                    }
                    k = 0;
                    while (k < val) {
                        if (j < HLIT + 257) {
                            huffmanCodeLength[j] = lastVal;
                        } else {
                            distHuffCodeLength[j - (HLIT + 257)] = lastVal;
                        }
                        ++k;
                        ++j;
                    }
                }
                ZipOutputStream.genHuffTree(huffmanCode, huffmanCodeLength);
                i = 0;
                while (i < huffmanData.length) {
                    huffmanData[i] = i;
                    ++i;
                }
                ZipOutputStream.revHuffTree(huffmanCode, huffmanCodeLength);
                ZipOutputStream.convertTable2Tree(huffmanCode, huffmanCodeLength, huffmanData, this.huffmanTree);
                j = 0;
                while (j < distHuffCode.length) {
                    distHuffData[j] = j;
                    ++j;
                }
                ZipOutputStream.genHuffTree(distHuffCode, distHuffCodeLength);
                ZipOutputStream.revHuffTree(distHuffCode, distHuffCodeLength);
                ZipOutputStream.convertTable2Tree(distHuffCode, distHuffCodeLength, distHuffData, this.distHuffTree);
                break block23;
            }
            this.popSmallBuffer(this.smallCodeBuffer[1] & 7L);
            this.B0len = this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8;
            if (this.smallCodeBuffer[1] < 15L) {
                this.refillSmallCodeBuffer();
            }
            if (this.B0len + (this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8) == 65535) ** GOTO lbl152
            throw new IOException("3");
lbl-1000:
            // 1 sources

            {
                val = this.popSmallBuffer(8L);
                this.window[this.pProcessed] = (byte)val;
                this.pProcessed = this.pProcessed + 1 & 32767;
                this.outBuff[this.outEnd] = (byte)val;
                ++this.outEnd;
                --this.B0len;
lbl152:
                // 2 sources

                ** while (this.smallCodeBuffer[1] != 0L && this.B0len > 0)
            }
        }
        this.status = 1;
        distHuffCode = null;
        distHuffData = null;
        distHuffCodeLength = null;
        huffmanCodeLength = null;
        huffmanCode = null;
        huffmanData = null;
    }

    public int validData() throws IOException {
        this.inflate();
        if (this.status != 3) {
            return -1;
        }
        return 1;
    }

    private int popSmallBuffer(long len) throws IOException {
        if (len == 0L) {
            return 0;
        }
        if (this.smallCodeBuffer[1] < len) {
            this.refillSmallCodeBuffer();
        }
        int ret = (int)(this.smallCodeBuffer[0] & (long)((1 << (int)len) - 1));
        this.smallCodeBuffer[0] = this.smallCodeBuffer[0] >>> (int)len;
        this.smallCodeBuffer[1] = this.smallCodeBuffer[1] - len;
        return ret;
    }

    private void refillSmallCodeBuffer() throws IOException {
        if (!this.inStreamEnded) {
            int wanted = (int)(8L - this.smallCodeBuffer[1] / 8L - 1L);
            int count = this.readbuf(this.tmpRef, 0, wanted);
            if (count == -1) {
                this.inStreamEnded = true;
            }
            int i = 0;
            while (i < count) {
                this.smallCodeBuffer[0] = this.smallCodeBuffer[0] & (255L << (int)this.smallCodeBuffer[1] ^ 0xFFFFFFFFFFFFFFFFL);
                this.smallCodeBuffer[0] = this.tmpRef[i] < 0 ? this.smallCodeBuffer[0] | (long)(this.tmpRef[i] + 256) << (int)this.smallCodeBuffer[1] : this.smallCodeBuffer[0] | (long)this.tmpRef[i] << (int)this.smallCodeBuffer[1];
                this.smallCodeBuffer[1] = this.smallCodeBuffer[1] + 8L;
                ++i;
            }
        }
    }

    public int available() throws IOException {
        if (this.outEnd - this.outStart < this.outBuff.length - 300) {
            this.inflate();
        }
        return this.outEnd - this.outStart;
    }

    public long skip(long n) throws IOException {
        long skipped = 0L;
        byte[] b = new byte[this.buffsize];
        while (skipped < n && this.status != 3) {
            skipped += (long)this.read(b);
        }
        return skipped;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int av;
        if (this.outEnd - this.outStart < this.outBuff.length - 300) {
            this.inflate();
        }
        int copyBytes = len > (av = this.available()) ? av : len;
        System.arraycopy(this.outBuff, this.outStart, b, off, copyBytes);
        this.outStart += copyBytes;
        if (copyBytes != 0) {
            return copyBytes;
        }
        return -1;
    }

    void setOffset(int off) {
        this.offset = off;
    }

    private int checkFileEOF(int len) {
        int max = this.datalen - this.offset;
        return max == 0 ? -1 : (len > max ? max : len);
    }

    private void ContDataInputStream(byte[] b, int datalen) {
        this.offset = 0;
        this.bytes = b;
        this.datalen = datalen;
    }

    int getOffst() {
        return this.offset;
    }

    private void readFully(byte[] bufer, int off, int len) {
        if ((len = this.checkFileEOF(len)) > 0) {
            System.arraycopy(this.bytes, this.offset, bufer, off, len);
            this.offset += len;
        }
    }

    void skipbuf(int len) {
        this.offset += len;
    }

    private int readbuf(byte[] addr, int off, int len) {
        if ((len = this.checkFileEOF(len)) > 0) {
            System.arraycopy(this.bytes, this.offset, addr, off, len);
            this.offset += len;
        }
        return len;
    }

    private int readbuf() {
        return this.bytes[this.offset++] & 0xFF;
    }

    private int readInt() {
        return (this.bytes[this.offset++] & 0xFF) << 24 | (this.bytes[this.offset++] & 0xFF) << 16 | (this.bytes[this.offset++] & 0xFF) << 8 | this.bytes[this.offset++] & 0xFF;
    }

    int readLshort() {
        return this.bytes[this.offset++] & 0xFF | (this.bytes[this.offset++] & 0xFF) << 8;
    }

    private int readLint() {
        return this.bytes[this.offset++] & 0xFF | (this.bytes[this.offset++] & 0xFF) << 8 | (this.bytes[this.offset++] & 0xFF) << 16 | (this.bytes[this.offset++] & 0xFF) << 24;
    }

    private boolean endsys() {
        byte[] b = this.bytes;
        int i = this.datalen - 22;
        while (i > 0) {
            if (b[i] == 80 && b[i + 1] == 75 && b[i + 2] == 5 && b[i + 3] == 6) break;
            --i;
        }
        if (i < 20) {
            return false;
        }
        this.setOffset(i + 16);
        this.setOffset(this.readLint());
        Vector<Object> v = this.entries = new Vector<Object>();
        v.addElement(this);
        while (this.readInt() == 1347092738) {
            ZipEntry entry = new ZipEntry(null);
            this.skipbuf(4);
            entry.flag = this.readLshort();
            entry.setMethod(this.readLshort());
            entry.dostime = this.readLint();
            entry.crc = this.readLint();
            entry.compressedSize = this.readLint();
            entry.size = this.readLint();
            entry.namelen = this.readLshort();
            int extralen = this.readLshort();
            int commentlen = this.readLshort();
            this.skipbuf(8);
            entry.offset = this.readLint();
            entry.setname(this.bytes, this.getOffst(), entry.namelen);
            this.skipbuf(entry.namelen);
            if (!entry.isDirectory()) {
                if (entry.name.equals("META-INF/MANIFEST.MF")) {
                    v.setElementAt(entry, 0);
                } else {
                    v.addElement(entry);
                }
            }
            this.skipbuf(extralen + commentlen);
        }
        return true;
    }

    public Vector getEntrys() {
        return this.entries;
    }

    public byte[] getData(ZipEntry slen) {
        this.setOffset(slen.offset + 26);
        byte[] tb = null;
        try {
            int len = slen.size;
            tb = new byte[len];
            this.skipbuf(this.readLshort() + this.readLshort());
            if (slen.method == 8) {
                this.inf_reset();
                int off = 0;
                while (len - off > 0) {
                    off += this.read(tb, off, len - off);
                }
            } else {
                this.readFully(tb, 0, len);
            }
        }
        catch (Throwable e) {
            return null;
        }
        return tb;
    }
}

