/*
 * Decompiled with CFR 0.152.
 */
package MrAn;

import MrAn.BufDataOutputStream;
import MrAn.Deflater;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class DeflaterOutputStream
extends OutputStream {
    protected byte[] buf;
    private int size;
    protected Deflater def;
    protected BufDataOutputStream out;

    protected DeflaterOutputStream(Deflater defl) {
        this.def = defl;
    }

    protected DeflaterOutputStream(BufDataOutputStream out, Deflater defl) {
        this.out = out;
        this.def = defl;
    }

    protected DeflaterOutputStream(String sf, Deflater defl) {
        OutputStream os = null;
        try {
            FileConnection fcc = (FileConnection)Connector.open((String)sf, (int)3);
            if (fcc.exists()) {
                fcc.delete();
            }
            fcc.create();
            os = fcc.openOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.out = new BufDataOutputStream(os);
        this.def = defl;
    }

    protected void setBufsize(int bsz) {
        this.size = bsz;
        this.buf = new byte[this.size];
    }

    protected void deflate() throws IOException {
        int len;
        while (!this.def.needsInput() && (len = this.def.deflate(this.buf, 0, this.size)) > 0) {
            this.out.write(this.buf, 0, len);
        }
    }

    public void flush() throws IOException {
        this.def.flush();
        this.deflate();
    }

    public void finish() throws Exception {
        int len;
        this.def.finish();
        while (!this.def.finished() && (len = this.def.deflate(this.buf, 0, this.size)) > 0) {
            this.out.write(this.buf, 0, len);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void close() {
        try {
            this.finish();
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.def.setInput(buf, off, len);
        this.deflate();
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }
}

