/*
 * Decompiled with CFR 0.152.
 */
package MrAn;

class PendingBuffer {
    private byte[] buf;
    private int start;
    private int end;
    private int bits;
    private int bitCount;

    public PendingBuffer(int size) {
        this.buf = new byte[size];
    }

    public void reset() {
        this.bits = 0;
        this.bitCount = 0;
        this.end = 0;
        this.start = 0;
    }

    public void writeShortMSB(int s) {
        this.buf[this.end++] = (byte)(s >> 8);
        this.buf[this.end++] = (byte)s;
    }

    public boolean isFlushed() {
        return this.end == 0;
    }

    public void writeShort(int s) {
        this.buf[this.end++] = (byte)s;
        this.buf[this.end++] = (byte)(s >> 8);
    }

    public final void writeBlock(byte[] block, int offset, int len) {
        System.arraycopy(block, offset, this.buf, this.end, len);
        this.end += len;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public void alignToByte() {
        if (this.bitCount > 0) {
            this.buf[this.end++] = (byte)this.bits;
            if (this.bitCount > 8) {
                this.buf[this.end++] = (byte)(this.bits >> 8 & 0xFF);
            }
        }
        this.bits = 0;
        this.bitCount = 0;
    }

    public void writeBits(int b, int count) {
        this.bits |= b << this.bitCount;
        this.bitCount += count;
        if (this.bitCount >= 16) {
            this.buf[this.end++] = (byte)this.bits;
            this.buf[this.end++] = (byte)(this.bits >> 8);
            this.bits = this.bits >> 16 & 0xFFFF;
            this.bitCount -= 16;
        }
    }

    public int flush(byte[] output, int offset, int length) {
        if (this.bitCount >= 8) {
            this.buf[this.end++] = (byte)this.bits;
            this.bits = this.bits >> 8 & 0xFFFFFF;
            this.bitCount -= 8;
        }
        if (length > this.end - this.start) {
            length = this.end - this.start;
            System.arraycopy(this.buf, this.start, output, offset, length);
            this.end = 0;
            this.start = 0;
        } else {
            System.arraycopy(this.buf, this.start, output, offset, length);
            this.start += length;
        }
        return length;
    }
}

