/*
 * Decompiled with CFR 0.152.
 */
package MrAn;

import MrAn.BufDataOutputStream;
import MrAn.CRC32;
import MrAn.Deflater;
import MrAn.DeflaterOutputStream;
import MrAn.ZipEntry;
import MrAn.ZipInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ZipOutputStream
extends DeflaterOutputStream {
    private Vector entries = new Vector();
    private CRC32 crc;
    private ZipEntry curEntry = null;
    private int curMethod;
    private int size;

    public ZipOutputStream(BufDataOutputStream out) {
        super(out, new Deflater(0, true));
        super.setBufsize(10240);
        this.crc = new CRC32();
    }

    public ZipOutputStream(String sf) {
        super(sf, new Deflater(0, true));
        super.setBufsize(10240);
        this.crc = new CRC32();
    }

    public void setBufsize(int bsz) {
        super.setBufsize(bsz);
    }

    public void setMethod(int method) {
        this.curMethod = method;
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    public void preEntry() {
        this.curEntry = null;
    }

    public void putNextEntry(String name) throws Exception {
        ZipEntry entry = new ZipEntry(name);
        entry.flag = 8;
        entry.setMethod(this.curMethod);
        entry.setTime(System.currentTimeMillis());
        this.putNextEntry(entry);
    }

    public void putNextEntry(ZipEntry entry) throws Exception {
        if (this.curEntry != null) {
            this.closeEntry();
        }
        this.curEntry = entry;
        this.entries.addElement(entry);
        entry.offset = this.out.getoffse();
        this.out.writeLint(67324752);
        this.out.writeLshort(entry.getMethod() == 0 ? 10 : 20);
        entry.setname(entry.name.getBytes());
        this.writeEntry(entry);
        this.out.write(entry.getNamebytes());
        if (entry.extralen > 0) {
            this.out.write(entry.getExtra());
        }
        this.crc.reset();
        this.def.reset();
        this.size = 0;
    }

    public void putFooEntry(ZipEntry entry, ZipInputStream zin) throws Exception {
        this.putNextEntry(entry);
        byte[] b = zin.getNextFooData();
        this.out.write(b, 0, b.length);
        this.out.flush();
        this.curEntry = null;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        byte[] byArray = new byte[3];
        byArray[0] = (byte)b;
        byArray[2] = 1;
        this.write(byArray);
    }

    public void closeEntry() throws Exception {
        if (this.curEntry == null) {
            return;
        }
        if (this.curMethod == 8) {
            super.finish();
        }
        ZipEntry entry = this.curEntry;
        entry.size = this.size;
        entry.compressedSize = this.curMethod == 8 ? this.def.getTotalOut() : this.size;
        entry.crc = (int)this.crc.getValue();
        int now = this.out.getoffse();
        if (!this.out.resetTo(entry.offset + 6)) {
            this.out.writeLint(134695760);
            this.out.writeLint(entry.crc);
            this.out.writeLint(entry.compressedSize);
            this.out.writeLint(entry.size);
        } else {
            entry.flag = 0;
            this.writeEntry(entry);
            this.out.skipto(now);
        }
        this.out.flush();
        this.curEntry = null;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.curMethod == 0) {
            this.out.write(b, off, len);
        } else {
            super.write(b, off, len);
        }
        this.crc.update(b, off, len);
        this.size += len;
    }

    private void writeEntry(ZipEntry entry) throws IOException {
        this.out.writeLshort(entry.flag);
        this.out.writeLshort(entry.getMethod());
        this.out.writeLint(entry.dostime);
        this.out.writeLint(entry.crc);
        this.out.writeLint(entry.compressedSize);
        this.out.writeLint(entry.size);
        this.out.writeLshort(entry.namelen);
        this.out.writeLshort(entry.extralen);
    }

    public void finish() throws Exception {
        if (this.entries == null) {
            return;
        }
        if (this.curEntry != null) {
            this.closeEntry();
        }
        int offset = this.out.getoffse();
        int numEntries = 0;
        int sizeEntries = 0;
        Enumeration enu = this.entries.elements();
        while (enu.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)enu.nextElement();
            int method = entry.getMethod();
            this.out.writeLint(33639248);
            this.out.writeLshort(method == 0 ? 10 : 20);
            this.out.writeLshort(0);
            this.writeEntry(entry);
            this.out.writeLshort(entry.commentlen);
            this.out.writeLint(0);
            this.out.writeLint(0);
            this.out.writeLint(entry.offset);
            this.out.write(entry.getNamebytes());
            if (entry.extralen > 0) {
                this.out.write(entry.getExtra());
            }
            if (entry.commentlen > 0) {
                this.out.write(entry.comment);
            }
            ++numEntries;
            sizeEntries += 46 + entry.namelen + entry.extralen + entry.commentlen;
        }
        this.out.writeLint(101010256);
        this.out.writeLint(0);
        this.out.writeLshort(numEntries);
        this.out.writeLshort(numEntries);
        this.out.writeLint(sizeEntries);
        this.out.writeLint(offset);
        this.out.writeLshort(0);
        this.out.flush();
        this.entries = null;
    }
}

