/*
 * Decompiled with CFR 0.152.
 */
package MrAn;

import java.io.IOException;
import java.io.OutputStream;

public class BufDataOutputStream
extends OutputStream {
    OutputStream out;
    byte[] bytes;
    private int bufoff;
    private int offset;

    public BufDataOutputStream(OutputStream output) {
        this.out = output;
        this.bytes = new byte[65536];
        this.bufoff = 0;
        this.offset = 0;
    }

    public byte[] getBuf() {
        return this.bytes;
    }

    public boolean resetTo(int off) {
        int l = this.offset - off;
        if (l <= this.bufoff) {
            this.bufoff -= l;
            this.offset = off;
            return true;
        }
        return false;
    }

    public int getoffse() {
        return this.offset;
    }

    public void skipto(int off) {
        this.bufoff += off - this.offset;
        this.offset = off;
    }

    public void flush() throws IOException {
        if (this.bufoff > 0) {
            this.out.write(this.bytes, 0, this.bufoff);
            this.bufoff = 0;
        }
    }

    public void close() throws IOException {
        this.flush();
        this.bytes = null;
        this.out.close();
    }

    public void write(byte[] addr, int off, int len) throws IOException {
        if (len < this.bytes.length - this.bufoff) {
            System.arraycopy(addr, off, this.bytes, this.bufoff, len);
            this.bufoff += len;
        } else {
            this.flush();
            this.out.write(addr, off, len);
        }
        this.offset += len;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void writeInt(int l) throws IOException {
        if (this.bytes.length < this.bufoff + 4) {
            this.flush();
        }
        this.offset += 4;
        this.bytes[this.bufoff++] = (byte)(l >> 24);
        this.bytes[this.bufoff++] = (byte)((l & 0xFF0000) >> 16);
        this.bytes[this.bufoff++] = (byte)((l & 0xFF00) >> 8);
        this.bytes[this.bufoff++] = (byte)(l & 0xFF);
    }

    public void writeLshort(int l) throws IOException {
        if (this.bytes.length < this.bufoff + 2) {
            this.flush();
        }
        this.offset += 2;
        this.bytes[this.bufoff++] = (byte)(l & 0xFF);
        this.bytes[this.bufoff++] = (byte)((l & 0xFF00) >> 8);
    }

    public void writeLint(int l) throws IOException {
        if (this.bytes.length < this.bufoff + 4) {
            this.flush();
        }
        this.offset += 4;
        this.bytes[this.bufoff++] = (byte)(l & 0xFF);
        this.bytes[this.bufoff++] = (byte)((l & 0xFF00) >> 8);
        this.bytes[this.bufoff++] = (byte)((l & 0xFF0000) >> 16);
        this.bytes[this.bufoff++] = (byte)(l >> 24);
    }

    public void writeUnsignedByte(int l) throws IOException {
        if (this.bytes.length < this.bufoff + 1) {
            this.flush();
        }
        ++this.offset;
        this.bytes[this.bufoff++] = (byte)(l & 0xFF);
    }

    public void write(int b) throws IOException {
        if (this.bytes.length < this.bufoff + 1) {
            this.flush();
        }
        ++this.offset;
        this.bytes[this.bufoff++] = (byte)b;
    }
}

