/*
 * Decompiled with CFR 0.152.
 */
package MrAn;

import MrAn.Adler32;
import MrAn.DeflaterHuffman;
import MrAn.PendingBuffer;

class DeflaterEngine {
    static final int[] GOOD_LENGTH;
    static final int[] MAX_LAZY;
    static final int[] NICE_LENGTH;
    static final int[] MAX_CHAIN;
    static final int[] COMPR_FUNC;
    private byte[] window;
    private byte[] inputBuf;
    private short[] head;
    private short[] prev;
    private int ins_h;
    private int matchStart;
    private int matchLen;
    private boolean prevAvailable;
    private int blockStart;
    private int strstart;
    private int lookahead;
    private int strategy;
    private int max_chain;
    private int max_lazy;
    private int niceLength;
    private int goodLength;
    private int comprFunc;
    private int inputOff;
    private int inputEnd;
    private PendingBuffer pending;
    private DeflaterHuffman huffman;
    private Adler32 adler;

    static {
        int[] nArray = new int[10];
        nArray[1] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[6] = 8;
        nArray[7] = 8;
        nArray[8] = 32;
        nArray[9] = 32;
        GOOD_LENGTH = nArray;
        int[] nArray2 = new int[10];
        nArray2[1] = 4;
        nArray2[2] = 5;
        nArray2[3] = 6;
        nArray2[4] = 4;
        nArray2[5] = 16;
        nArray2[6] = 16;
        nArray2[7] = 32;
        nArray2[8] = 128;
        nArray2[9] = 258;
        MAX_LAZY = nArray2;
        int[] nArray3 = new int[10];
        nArray3[1] = 8;
        nArray3[2] = 16;
        nArray3[3] = 32;
        nArray3[4] = 16;
        nArray3[5] = 32;
        nArray3[6] = 128;
        nArray3[7] = 128;
        nArray3[8] = 258;
        nArray3[9] = 258;
        NICE_LENGTH = nArray3;
        int[] nArray4 = new int[10];
        nArray4[1] = 4;
        nArray4[2] = 8;
        nArray4[3] = 32;
        nArray4[4] = 16;
        nArray4[5] = 32;
        nArray4[6] = 128;
        nArray4[7] = 256;
        nArray4[8] = 1024;
        nArray4[9] = 4096;
        MAX_CHAIN = nArray4;
        int[] nArray5 = new int[10];
        nArray5[1] = 1;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArray5[5] = 2;
        nArray5[6] = 2;
        nArray5[7] = 2;
        nArray5[8] = 2;
        nArray5[9] = 2;
        COMPR_FUNC = nArray5;
    }

    DeflaterEngine(PendingBuffer pen) {
        this.pending = pen;
        this.huffman = new DeflaterHuffman(this.pending);
        this.adler = new Adler32();
        this.window = new byte[65536];
        this.head = new short[32768];
        this.prev = new short[32768];
        this.strstart = 1;
        this.blockStart = 1;
    }

    public void reset() {
        this.strstart = 1;
        this.blockStart = 1;
        this.lookahead = 0;
        this.prevAvailable = false;
        this.matchLen = 2;
        int i = Short.MAX_VALUE;
        while (i >= 0) {
            this.head[i] = 0;
            this.prev[i] = 0;
            --i;
        }
        this.huffman.reset();
        this.adler.reset();
    }

    public void resetAdler() {
        this.adler.reset();
    }

    public int getAdler() {
        return this.adler.checksum;
    }

    public void setStrategy(int strat) {
        this.strategy = strat;
    }

    public void setLevel(int lvl) {
        this.goodLength = GOOD_LENGTH[lvl];
        this.max_lazy = MAX_LAZY[lvl];
        this.niceLength = NICE_LENGTH[lvl];
        this.max_chain = MAX_CHAIN[lvl];
        if (COMPR_FUNC[lvl] != this.comprFunc) {
            switch (this.comprFunc) {
                case 0: {
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushStoredBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.updateHash();
                    break;
                }
                case 1: {
                    if (this.strstart <= this.blockStart) break;
                    this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                    this.blockStart = this.strstart;
                    break;
                }
                case 2: {
                    if (this.prevAvailable) {
                        this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                    }
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.prevAvailable = false;
                    this.matchLen = 2;
                }
            }
            this.comprFunc = COMPR_FUNC[lvl];
        }
    }

    private void updateHash() {
        this.ins_h = this.window[this.strstart] << 5 ^ this.window[this.strstart + 1];
    }

    private int insertString() {
        short match;
        int hash = (this.ins_h << 5 ^ this.window[this.strstart + 2]) & Short.MAX_VALUE;
        this.prev[this.strstart & Short.MAX_VALUE] = match = this.head[hash];
        this.head[hash] = (short)this.strstart;
        this.ins_h = hash;
        return match & 0xFFFF;
    }

    private void slideWindow() {
        System.arraycopy(this.window, 32768, this.window, 0, 32768);
        this.matchStart -= 32768;
        this.strstart -= 32768;
        this.blockStart -= 32768;
        int i = 0;
        while (i < 32768) {
            int m = this.head[i] & 0xFFFF;
            this.head[i] = m >= 32768 ? (short)(m - 32768) : (short)0;
            m = this.prev[i] & 0xFFFF;
            this.prev[i] = m >= 32768 ? (short)(m - 32768) : (short)0;
            ++i;
        }
    }

    private void fillWindow() {
        if (this.strstart >= 65274) {
            this.slideWindow();
        }
        while (this.lookahead < 262 && this.inputOff < this.inputEnd) {
            int more = Math.min(65536 - this.lookahead - this.strstart, this.inputEnd - this.inputOff);
            System.arraycopy(this.inputBuf, this.inputOff, this.window, this.strstart + this.lookahead, more);
            this.adler.update(this.inputBuf, this.inputOff, more);
            this.inputOff += more;
            this.lookahead += more;
        }
        if (this.lookahead > 2) {
            this.updateHash();
        }
    }

    private boolean findLongestMatch(int curMatch) {
        int chainLength = this.max_chain;
        int nicelen = this.niceLength;
        short[] preve = this.prev;
        int scan = this.strstart;
        int best_end = this.strstart + this.matchLen;
        int best_len = Math.max(this.matchLen, 2);
        int limit = Math.max(this.strstart - 32506, 0);
        int strend = scan + 257;
        byte scan_end1 = this.window[best_end - 1];
        byte scan_end = this.window[best_end];
        if (best_len >= this.goodLength) {
            chainLength >>= 2;
        }
        if (nicelen > this.lookahead) {
            nicelen = this.lookahead;
        }
        do {
            if (this.window[curMatch + best_len] != scan_end || this.window[curMatch + best_len - 1] != scan_end1 || this.window[curMatch] != this.window[scan] || this.window[curMatch + 1] != this.window[scan + 1]) continue;
            int match = curMatch + 2;
            scan += 2;
            while (this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && scan < strend) {
            }
            if (scan > best_end) {
                this.matchStart = curMatch;
                best_end = scan;
                best_len = scan - this.strstart;
                if (best_len >= nicelen) break;
                scan_end1 = this.window[best_end - 1];
                scan_end = this.window[best_end];
            }
            scan = this.strstart;
        } while ((curMatch = preve[curMatch & Short.MAX_VALUE] & 0xFFFF) > limit && --chainLength != 0);
        this.matchLen = Math.min(best_len, this.lookahead);
        return this.matchLen >= 3;
    }

    private boolean deflateStored(boolean flush, boolean finish) {
        if (!flush && this.lookahead == 0) {
            return false;
        }
        this.strstart += this.lookahead;
        this.lookahead = 0;
        int storedLen = this.strstart - this.blockStart;
        if (storedLen >= 65531 || this.blockStart < 32768 && storedLen >= 32506 || flush) {
            boolean lastBlock = finish;
            if (storedLen > 65531) {
                storedLen = 65531;
                lastBlock = false;
            }
            this.huffman.flushStoredBlock(this.window, this.blockStart, storedLen, lastBlock);
            this.blockStart += storedLen;
            return !lastBlock;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean deflateFast(boolean flush, boolean finish) {
        if (this.lookahead >= 262 || flush) ** GOTO lbl35
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.lookahead == 0) {
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, finish);
                this.blockStart = this.strstart;
                return false;
            }
            if (this.strstart > 65274) {
                this.slideWindow();
            }
            if (this.lookahead >= 3 && (hashHead = this.insertString()) != 0 && this.strategy != 2 && this.strstart - hashHead <= 32506 && this.findLongestMatch(hashHead)) {
                this.huffman.tallyDist(this.strstart - this.matchStart, this.matchLen);
                this.lookahead -= this.matchLen;
                if (this.matchLen <= this.max_lazy && this.lookahead >= 3) {
                    while (--this.matchLen > 0) {
                        ++this.strstart;
                        this.insertString();
                    }
                    ++this.strstart;
                } else {
                    this.strstart += this.matchLen;
                    if (this.lookahead >= 2) {
                        this.updateHash();
                    }
                }
                this.matchLen = 2;
                continue;
            }
            this.huffman.tallyLit(this.window[this.strstart] & 255);
            ++this.strstart;
            --this.lookahead;
            if (!this.huffman.isFull()) continue;
            lastBlock = finish != false && this.lookahead == 0;
            this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, lastBlock);
            this.blockStart = this.strstart;
            return lastBlock == false;
lbl35:
            // 3 sources

            ** while (this.lookahead >= 262 || flush)
        }
lbl36:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean deflateSlow(boolean flush, boolean finish) {
        if (this.lookahead >= 262 || flush) ** GOTO lbl49
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.lookahead == 0) {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 255);
                }
                this.prevAvailable = false;
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, finish);
                this.blockStart = this.strstart;
                return false;
            }
            if (this.strstart >= 65274) {
                this.slideWindow();
            }
            prevMatch = this.matchStart;
            prevLen = this.matchLen;
            if (this.lookahead >= 3) {
                hashHead = this.insertString();
                if (this.strategy != 2 && hashHead != 0 && this.strstart - hashHead <= 32506 && this.findLongestMatch(hashHead) && this.matchLen <= 5 && (this.strategy == 1 || this.matchLen == 3 && this.strstart - this.matchStart > 4096)) {
                    this.matchLen = 2;
                }
            }
            if (prevLen >= 3 && this.matchLen <= prevLen) {
                this.huffman.tallyDist(this.strstart - 1 - prevMatch, prevLen);
                prevLen -= 2;
                do {
                    ++this.strstart;
                    --this.lookahead;
                    if (this.lookahead < 3) continue;
                    this.insertString();
                } while (--prevLen > 0);
                ++this.strstart;
                --this.lookahead;
                this.prevAvailable = false;
                this.matchLen = 2;
            } else {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 255);
                }
                this.prevAvailable = true;
                ++this.strstart;
                --this.lookahead;
            }
            if (!this.huffman.isFull()) continue;
            len = this.strstart - this.blockStart;
            if (this.prevAvailable) {
                --len;
            }
            lastBlock = finish != false && this.lookahead == 0 && this.prevAvailable == false;
            this.huffman.flushBlock(this.window, this.blockStart, len, lastBlock);
            this.blockStart += len;
            return lastBlock == false;
lbl49:
            // 2 sources

            ** while (this.lookahead >= 262 || flush)
        }
lbl50:
        // 1 sources

        return true;
    }

    void setInput(byte[] buf, int off, int len) {
        this.inputBuf = buf;
        this.inputOff = off;
        this.inputEnd = off + len;
    }

    boolean needsInput() {
        return this.inputEnd == this.inputOff;
    }

    boolean deflate(boolean flush, boolean finish) {
        boolean progress = false;
        do {
            this.fillWindow();
            boolean canFlush = flush && this.inputOff == this.inputEnd;
            switch (this.comprFunc) {
                case 0: {
                    progress = this.deflateStored(canFlush, finish);
                    break;
                }
                case 1: {
                    progress = this.deflateFast(canFlush, finish);
                    break;
                }
                case 2: {
                    progress = this.deflateSlow(canFlush, finish);
                }
            }
        } while (this.pending.isFlushed() && progress);
        return progress;
    }
}

