/*
 * Decompiled with CFR 0.152.
 */
package MrAn;

import MrAn.InflaterHuffmanTree;
import MrAn.StreamManipulator;

class InflaterDynHeader {
    private static final int[] BL_ORDER;
    private byte[] blLens;
    private byte[] litdistLens;
    private InflaterHuffmanTree blTree;
    private int mode;
    private int lnum;
    private int dnum;
    private int blnum;
    private int num;
    private int repSymbol;
    private int ptr;
    private byte lastLen;

    static {
        int[] nArray = new int[19];
        nArray[0] = 16;
        nArray[1] = 17;
        nArray[2] = 18;
        nArray[4] = 8;
        nArray[5] = 7;
        nArray[6] = 9;
        nArray[7] = 6;
        nArray[8] = 10;
        nArray[9] = 5;
        nArray[10] = 11;
        nArray[11] = 4;
        nArray[12] = 12;
        nArray[13] = 3;
        nArray[14] = 13;
        nArray[15] = 2;
        nArray[16] = 14;
        nArray[17] = 1;
        nArray[18] = 15;
        BL_ORDER = nArray;
    }

    InflaterDynHeader() {
    }

    public boolean decode(StreamManipulator input) {
        while (true) {
            switch (this.mode) {
                case 0: {
                    this.lnum = input.peekBits(5);
                    if (this.lnum < 0) {
                        return false;
                    }
                    this.lnum += 257;
                    input.dropBits(5);
                    this.mode = 1;
                }
                case 1: {
                    this.dnum = input.peekBits(5);
                    if (this.dnum < 0) {
                        return false;
                    }
                    ++this.dnum;
                    input.dropBits(5);
                    this.num = this.lnum + this.dnum;
                    this.litdistLens = new byte[this.num];
                    this.mode = 2;
                }
                case 2: {
                    this.blnum = input.peekBits(4);
                    if (this.blnum < 0) {
                        return false;
                    }
                    this.blnum += 4;
                    input.dropBits(4);
                    this.blLens = new byte[19];
                    this.ptr = 0;
                    this.mode = 3;
                }
                case 3: {
                    while (this.ptr < this.blnum) {
                        int len = input.peekBits(3);
                        if (len < 0) {
                            return false;
                        }
                        input.dropBits(3);
                        this.blLens[InflaterDynHeader.BL_ORDER[this.ptr]] = (byte)len;
                        ++this.ptr;
                    }
                    this.blTree = new InflaterHuffmanTree(this.blLens, 19);
                    this.blLens = null;
                    this.ptr = 0;
                    this.mode = 4;
                }
                case 4: {
                    int symbol;
                    while (((symbol = this.blTree.getSymbol(input)) & 0xFFFFFFF0) == 0) {
                        this.litdistLens[this.ptr++] = this.lastLen = (byte)symbol;
                        if (this.ptr != this.num) continue;
                        return true;
                    }
                    if (symbol < 0) {
                        return false;
                    }
                    if (symbol >= 17) {
                        this.lastLen = 0;
                    }
                    this.repSymbol = symbol - 16;
                    this.mode = 5;
                }
                case 5: {
                    int bits = this.repSymbol > 1 ? 7 : this.repSymbol + 2;
                    int count = input.peekBits(bits);
                    if (count < 0) {
                        return false;
                    }
                    input.dropBits(bits);
                    count += this.repSymbol > 1 ? 11 : 3;
                    while (count-- > 0) {
                        this.litdistLens[this.ptr++] = this.lastLen;
                    }
                    if (this.ptr == this.num) {
                        return true;
                    }
                    this.mode = 4;
                }
            }
        }
    }

    public InflaterHuffmanTree buildLitLenTree() {
        byte[] litlenLens = new byte[this.lnum];
        System.arraycopy(this.litdistLens, 0, litlenLens, 0, this.lnum);
        return new InflaterHuffmanTree(litlenLens, this.lnum);
    }

    public InflaterHuffmanTree buildDistTree() {
        byte[] distLens = new byte[this.dnum];
        System.arraycopy(this.litdistLens, this.lnum, distLens, 0, this.dnum);
        return new InflaterHuffmanTree(distLens, this.dnum);
    }
}

