/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class vnTelex
extends MIDlet
implements CommandListener {
    private Display display;
    private Command convCommand = new Command("ch\u00ef Vi\u00c7t", 8, 1);
    private Command exitCommand = new Command("Exit", 7, 2);
    private Command clearCommand = new Command("X\u00e3a tr\u00d1ng", 8, 3);
    private Command asciiCommand = new Command("?i\u00c1n m\u00a3 ASCII", 8, 4);
    private Command aboutCommand = new Command("About ...", 1, 5);
    private TextBox sInput;
    static final int sSize = 8192;
    private static final String titleInput = "Chu?i telex";
    private static final String titleHelp = "Gi\u00dbi thi\u00c7u ch?\u00a1ng tr?nh";
    private static final String shortHelp = "CharTelex V1.05 by lephuong123@gmail.com\n\n C\u00a1ch g\u00e5 TELEX: \n\n Aa=?, aa=?, Ee=?, ee=?, Oo=?, oo=\u00e4; \n\n Aw=?, aw=?; \n\n Dd=?, dd=?, Ow=?, ow=\u00a1, UW=W=?, uw=w=?; \n\n s=s?c, f=huy\u00c1n, r=h\u00cfi, x=ng\u00a3, j=n?ng. \n\n * G\u00e5 m\u00a3 ASCII: \\D ho?c \\xH,  D = h\u00c7 10, H = h\u00c7 16. Nh? \\9 -> TAB. \n\n * G\u00e5 \\ tr?\u00dbc k\u00ed c\u00a7n gi\u00ef,  nh? \\W -> W, \\\\ -> \\. \n\n";
    private String Source;
    static final String vnTag = "ADEOWSFRXJ";
    static final String[] vnBase = new String[]{"Aa", "Dd", "Ee", "Oo", "AaOoUu", "Aa????Ee??IiOo?\u00e4?\u00a1Uu??Yy"};
    static final String[] vnDau = new String[]{"??", "??", "??", "?\u00e4", "???\u00a1??", "?\u00a1??\u00a4\u00a5???\u00bf???\u00e3\u00d0\u00d1\u00da\u00db?\u00ea\u00e8\u00e9?\u00ed", "?????\u00a7??\u00c0\u00c1???\u00e2\u00d2\u00d3\u00dc\u00dd?\u00e9\u00ea\u00eb\u00f2\u00f3", "?\u00a3??????\u00c2\u00c3\u00c8\u00c9\u00ce\u00cf\u00d4\u00d5\u00de\u00df\u00e6\u00e7\u00ec\u00ed\u00f5?", "?\u00a3??????\u00c4\u00c5()?\u00e5\u00d6?\u00e0\u00e1hi\u00ee\u00ef\u00f8\u00f9", "?\u00a1??????\u00c6\u00c7\u00ca\u00cb\u00cc\u00cd\u00d8\u00d9\u00e2\u00e3\u00e4\u00e5\u00f0\u00f1\u00f4\u00f5"};

    public vnTelex() {
        this.display = Display.getDisplay((MIDlet)this);
        this.sInput = new TextBox(titleInput, "", 8192, 0);
        this.sInput.addCommand(this.convCommand);
        this.sInput.addCommand(this.exitCommand);
        this.sInput.addCommand(this.clearCommand);
        this.sInput.addCommand(this.asciiCommand);
        this.sInput.addCommand(this.aboutCommand);
        this.sInput.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.sInput);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.convCommand) {
            this.sInput.setString(this.Telex(this.sInput.getString().trim()));
            String string = this.sInput.getString();
            this.sInput.setTitle("Chu?i telex (" + string.length() + "/" + 8192 + ")");
        } else if (command == this.asciiCommand) {
            this.sInput.setString(this.ListAscii());
            String string = this.sInput.getString();
            this.sInput.setTitle("Chu?i telex (" + string.length() + "/" + 8192 + ")");
        } else if (command == this.clearCommand) {
            this.sInput.setString("");
            this.sInput.setTitle(titleInput);
        } else if (command == this.aboutCommand) {
            vnTelex.showAbout(this.display);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public static void showAbout(Display display) {
        Alert alert = new Alert(titleHelp, shortHelp, null, AlertType.INFO);
        alert.setTimeout(-2);
        display.setCurrent((Displayable)alert);
    }

    String ListAscii() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 32; i < 256; ++i) {
            String string = Integer.toHexString(i);
            if (string.length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append(", " + string.toUpperCase() + ":").append((char)i);
        }
        return stringBuffer.toString().substring(2);
    }

    boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    boolean isHexDigit(char c) {
        return this.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private char NextChar() {
        char c = '\u0000';
        if (this.Source.length() > 0) {
            c = this.Source.charAt(0);
            this.Source = this.Source.substring(1);
        }
        return c;
    }

    String Telex(String string) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        this.Source = string;
        stringBuffer.setLength(0);
        char c2 = '\u0000';
        while ((c = this.NextChar()) != '\u0000') {
            if (c == '\\') {
                c = this.NextChar();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        String string2 = "" + c;
                        while (this.Source.length() > 0 && this.isDigit(this.Source.charAt(0))) {
                            string2 = string2 + this.NextChar();
                        }
                        stringBuffer.append((char)Integer.parseInt(string2, 10));
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        String string2 = "";
                        while (this.Source.length() > 0 && this.isHexDigit(this.Source.charAt(0))) {
                            string2 = string2 + this.NextChar();
                        }
                        if (string2.length() > 0) {
                            stringBuffer.append((char)Integer.parseInt(string2, 16));
                            break;
                        }
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                c = '\u0000';
            } else {
                char c3 = Character.toUpperCase(c);
                int n = vnTag.indexOf(c3);
                if (c2 == '\u0000' || n < 0) {
                    c = this.CheckU(c);
                    stringBuffer.append(c);
                } else {
                    int n2 = stringBuffer.length() - 1;
                    int n3 = vnBase[n > 4 ? 5 : n].indexOf(c2);
                    if (n3 >= 0) {
                        c = vnDau[n].charAt(n3);
                        stringBuffer.setCharAt(n2, c);
                    } else {
                        c = this.CheckU(c);
                        stringBuffer.append(c);
                    }
                }
            }
            c2 = c;
        }
        return stringBuffer.toString();
    }

    private char CheckU(char c) {
        switch (c) {
            case 'W': {
                return '\u01af';
            }
            case 'w': {
                return '\u01b0';
            }
        }
        return c;
    }
}

