/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.jmp3tag;

import com.gowtham.jmp3tag.FileBrowserEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class FileBrowser
extends Form
implements CommandListener,
ItemStateListener {
    private List fileBrowser;
    private boolean sortEntries = false;
    private String currentRoot;
    private Hashtable extnTable;
    private boolean isDirectory;
    private Command selectCommand;
    private MIDlet m;
    private Displayable next;
    private Command cancelCommand;
    private Command backCommand;
    private boolean cancelled;
    private String selection;
    private FileBrowserEvent fbEvent;
    private Image musicImage;
    private Image folderImage;
    private Image upImage;

    public FileBrowser(String string, FileBrowserEvent fileBrowserEvent, String string2, String[] stringArray, boolean bl, MIDlet mIDlet) {
        super(string);
        this.fbEvent = fileBrowserEvent;
        this.currentRoot = string2;
        this.isDirectory = bl;
        this.m = mIDlet;
        if (stringArray != null) {
            this.extnTable = new Hashtable(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.extnTable.put(stringArray[i].toUpperCase(), "");
            }
        }
        this.cancelCommand = new Command("Cancel", 1, 0);
        this.backCommand = new Command("Cancel", 2, 1);
        if (!this.isDirectory) {
            this.fileBrowser = new List(string, 3);
        } else {
            this.fileBrowser = new List(string, 3);
            this.selectCommand = new Command("Select", 1, 0);
            this.fileBrowser.addCommand(this.selectCommand);
        }
        this.fileBrowser.addCommand(this.backCommand);
        this.fileBrowser.setCommandListener((CommandListener)this);
        new Thread(new Runnable(){

            public void run() {
                FileBrowser.this.getDirContents();
            }
        }).start();
    }

    public void setSort(boolean bl) {
        this.sortEntries = bl;
    }

    public boolean getSort() {
        return this.sortEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getDirContents() {
        FileConnection fileConnection = null;
        Enumeration enumeration = null;
        try {
            if (this.currentRoot.compareTo("/") == 0) {
                enumeration = FileSystemRegistry.listRoots();
            } else {
                fileConnection = (FileConnection)Connector.open((String)("file://" + this.currentRoot));
                if (fileConnection != null) {
                    enumeration = fileConnection.list("*", false);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (fileConnection != null) {
                try {
                    fileConnection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.updateListBox(enumeration);
        }
    }

    public void updateListBox(Enumeration enumeration) {
        int n;
        if (enumeration == null) {
            return;
        }
        this.fileBrowser.deleteAll();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        if (this.currentRoot.compareTo("/") != 0) {
            this.fileBrowser.append("..", this.upImage);
        }
        String string = null;
        while (enumeration.hasMoreElements()) {
            String string2;
            string = (String)enumeration.nextElement();
            if (string.endsWith("/")) {
                vector.addElement(string);
                continue;
            }
            System.out.println("File " + string);
            if (this.extnTable == null) {
                vector2.addElement(string);
                continue;
            }
            n = string.lastIndexOf(46);
            if (n == -1 || !this.extnTable.containsKey((string2 = string.substring(n + 1)).toUpperCase())) continue;
            vector2.addElement(string);
        }
        if (this.sortEntries) {
            this.sortVector(vector);
            this.sortVector(vector2);
        }
        for (n = 0; n < vector.size(); ++n) {
            this.fileBrowser.append((String)vector.elementAt(n), this.folderImage);
        }
        if (!this.isDirectory) {
            for (n = 0; n < vector2.size(); ++n) {
                this.fileBrowser.append((String)vector2.elementAt(n), this.musicImage);
            }
        }
        this.fileBrowser.setTitle("File Browser");
    }

    public void commandAction(Command command, Displayable displayable) {
        String string = this.fileBrowser.getString(this.fileBrowser.getSelectedIndex());
        if (command == List.SELECT_COMMAND) {
            if (this.isDirectory) {
                if (string.equalsIgnoreCase("..") || string.endsWith("/")) {
                    this.traverse(string);
                }
            } else if (string.equalsIgnoreCase("..") || string.endsWith("/")) {
                this.traverse(string);
            } else {
                this.cancelled = false;
                this.selection = "file://" + this.currentRoot + string;
                this.fbEvent.someThingSelected(this, this.selection);
                Display.getDisplay((MIDlet)this.m).setCurrent(this.next);
            }
        } else if (command == this.cancelCommand || command == this.backCommand) {
            this.cancelled = true;
            Display.getDisplay((MIDlet)this.m).setCurrent(this.next);
        } else if (command == this.selectCommand) {
            if (string.equalsIgnoreCase("..")) {
                return;
            }
            this.cancelled = false;
            this.selection = "file://" + this.currentRoot + string;
            Display.getDisplay((MIDlet)this.m).setCurrent(this.next);
            this.fbEvent.someThingSelected(this, this.selection);
        }
    }

    public void show(Displayable displayable) {
        this.cancelled = true;
        this.selection = "";
        this.next = displayable;
        Display.getDisplay((MIDlet)this.m).setCurrent((Displayable)this.fileBrowser);
    }

    public void traverse(String string) {
        int n;
        int n2;
        this.fileBrowser.setTitle("Loading...");
        this.currentRoot = string.equalsIgnoreCase("..") ? ((n2 = this.currentRoot.lastIndexOf(47, (n = this.currentRoot.length()) - 2)) == -1 ? "/" : this.currentRoot.substring(0, n2 + 1)) : this.currentRoot + string;
        new Thread(new Runnable(){

            public void run() {
                FileBrowser.this.getDirContents();
            }
        }).start();
    }

    public void itemStateChanged(Item item) {
        if (this.fileBrowser.getString(this.fileBrowser.getSelectedIndex()).equalsIgnoreCase("..")) {
            this.fileBrowser.removeCommand(this.selectCommand);
        } else {
            this.fileBrowser.addCommand(this.selectCommand);
        }
    }

    private void sortVector(Vector vector) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        do {
            bl = false;
            for (int i = 0; i < vector.size() - 1; ++i) {
                string = (String)vector.elementAt(i);
                string2 = (String)vector.elementAt(i + 1);
                string3 = string.toUpperCase();
                if (string3.compareTo(string4 = string2.toUpperCase()) <= 0) continue;
                vector.setElementAt(string, i + 1);
                vector.setElementAt(string2, i);
                bl = true;
            }
        } while (bl);
    }

    public Image getFileImage() {
        return this.musicImage;
    }

    public void setFileImage(Image image) {
        this.musicImage = image;
    }

    public Image getUpImage() {
        return this.upImage;
    }

    public void setUpImage(Image image) {
        this.upImage = image;
    }

    public Image getFolderImage() {
        return this.folderImage;
    }

    public void setFolderImage(Image image) {
        this.folderImage = image;
    }
}

