/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.sms.ringtone;

import dinesh.io.BitInputStream;
import dinesh.io.BitOutputStream;
import dinesh.mobile.sms.ringtone.Constants;
import dinesh.mobile.sms.ringtone.SongPattern;
import dinesh.mobile.sms.ringtone.SoundCommandSpecifier;
import java.io.IOException;

public class BasicSong
extends SoundCommandSpecifier
implements Constants {
    private String title;
    private SongPattern[] pattern;

    public BasicSong(BitInputStream bitInputStream) throws IOException {
        int n;
        int n2 = bitInputStream.read(4);
        char[] cArray = new char[n2];
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = (char)bitInputStream.read();
        }
        this.title = new String(cArray);
        n = bitInputStream.read();
        this.pattern = new SongPattern[n];
        for (int i = 0; i < this.pattern.length; ++i) {
            this.pattern[i] = new SongPattern(bitInputStream);
        }
    }

    public BasicSong(String string, SongPattern[] songPatternArray) {
        this.title = string;
        this.pattern = songPatternArray;
    }

    public BasicSong(String string, SongPattern songPattern) {
        this.title = string;
        this.pattern = new SongPattern[1];
        this.pattern[0] = songPattern;
    }

    public BasicSong(SongPattern songPattern) {
        this.pattern = new SongPattern[1];
        this.pattern[0] = songPattern;
    }

    public int length() {
        int n = 7 + this.title.length() * 8 + 8;
        for (int i = 0; i < this.pattern.length; ++i) {
            n += this.pattern[i].length();
        }
        return n;
    }

    public void writeToStream(BitOutputStream bitOutputStream) throws Exception {
        int n;
        bitOutputStream.write(this.getType(), 3);
        bitOutputStream.write(this.title.length(), 4);
        for (n = 0; n < this.title.length(); ++n) {
            bitOutputStream.write(this.title.charAt(n));
        }
        bitOutputStream.write(this.pattern.length);
        for (n = 0; n < this.pattern.length; ++n) {
            this.pattern[n].writeToStream(bitOutputStream);
        }
    }

    public int getType() {
        return 1;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getSongPatternLength() {
        return this.pattern.length;
    }

    public SongPattern getSongPattern(int n) {
        return this.pattern[n];
    }
}

