/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class vnTelex
extends MIDlet
implements CommandListener {
    private Display display;
    private Command convCommand = new Command("->ch\u1eef Vi\u1ec7t", 8, 1);
    private Command exitCommand = new Command("Exit", 7, 2);
    private Command clearCommand = new Command("X\u00f3a tr\u1ed1ng", 8, 3);
    private Command asciiCommand = new Command("\u0110i\u1ec1n m\u00e3 ASCII (32..255)", 8, 4);
    private Command aboutCommand = new Command("About ...", 1, 5);
    private TextBox sInput;
    static final int sSize = 8192;
    private static final String titleInput = "Chu\u1ed7i Telex";
    private static final String titleHelp = "Gi\u1edbi thi\u1ec7u ch\u01b0\u01a1ng tr\u00ecnh";
    private static final String shortHelp = "vnTelex V1.05 by quocsan@gmail.com\n\n C\u00e1ch g\u00f5 TELEX: \n\n Aa=\u00c2, aa=\u00e2, Ee=\u00ca, ee=\u00ea, Oo=\u00d4, oo=\u00f4; \n\n Aw=\u0102, aw=\u0103; \n\n Dd=\u0110, dd=\u0111, Ow=\u01a0, ow=\u01a1, UW=W=\u01af, uw=w=\u01b0; \n\n s=s\u1eafc, f=huy\u1ec1n, r=h\u1ecfi, x=ng\u00e3, j=n\u1eb7ng. \n\n * G\u00f5 m\u00e3 ASCII: \\D ho\u1eb7c \\xH,  D = h\u1ec7 10, H = h\u1ec7 16. Nh\u01b0 \\9 -> TAB. \n\n * G\u00f5 \\ tr\u01b0\u1edbc k\u00fd t\u1ef1 c\u1ea7n gi\u1eef,  nh\u01b0 \\W -> W, \\\\ -> \\. \n\n";
    private String Source;
    static final String vnTag = "ADEOWSFRXJ";
    static final String[] vnBase = new String[]{"Aa", "Dd", "Ee", "Oo", "AaOoUu", "Aa\u0102\u0103\u00c2\u00e2Ee\u00ca\u00eaIiOo\u00d4\u00f4\u01a0\u01a1Uu\u01af\u01b0Yy"};
    static final String[] vnDau = new String[]{"\u00c2\u00e2", "\u0110\u0111", "\u00ca\u00ea", "\u00d4\u00f4", "\u0102\u0103\u01a0\u01a1\u01af\u01b0", "\u00c1\u00e1\u1eae\u1eaf\u1ea4\u1ea5\u00c9\u00e9\u1ebe\u1ebf\u00cd\u00ed\u00d3\u00f3\u1ed0\u1ed1\u1eda\u1edb\u00da\u00fa\u1ee8\u1ee9\u00dd\u00fd", "\u00c0\u00e0\u1eb0\u1eb1\u1ea6\u1ea7\u00c8\u00e8\u1ec0\u1ec1\u00cc\u00ec\u00d2\u00f2\u1ed2\u1ed3\u1edc\u1edd\u00d9\u00f9\u1eea\u1eeb\u1ef2\u1ef3", "\u1ea2\u1ea3\u1eb2\u1eb3\u1ea8\u1ea9\u1eba\u1ebb\u1ec2\u1ec3\u1ec8\u1ec9\u1ece\u1ecf\u1ed4\u1ed5\u1ede\u1edf\u1ee6\u1ee7\u1eec\u1eed\u1ef6\u1ef7", "\u00c3\u00e3\u1eb4\u1eb5\u1eaa\u1eab\u1ebc\u1ebd\u1ec4\u1ec5\u0128\u0129\u00d5\u00f5\u1ed6\u1ed7\u1ee0\u1ee1\u0168\u0169\u1eee\u1eef\u1ef8\u1ef9", "\u1ea0\u1ea1\u1eb6\u1eb7\u1eac\u1ead\u1eb8\u1eb9\u1ec6\u1ec7\u1eca\u1ecb\u1ecc\u1ecd\u1ed8\u1ed9\u1ee2\u1ee3\u1ee4\u1ee5\u1ef0\u1ef1\u1ef4\u1ef5"};

    public vnTelex() {
        this.display = Display.getDisplay((MIDlet)this);
        this.sInput = new TextBox(titleInput, "", 8192, 0);
        this.sInput.addCommand(this.convCommand);
        this.sInput.addCommand(this.exitCommand);
        this.sInput.addCommand(this.clearCommand);
        this.sInput.addCommand(this.asciiCommand);
        this.sInput.addCommand(this.aboutCommand);
        this.sInput.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.sInput);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.convCommand) {
            this.sInput.setString(this.Telex(this.sInput.getString().trim()));
            String string = this.sInput.getString();
            this.sInput.setTitle("Chu\u1ed7i Telex (" + string.length() + "/" + 8192 + ")");
        } else if (command == this.asciiCommand) {
            this.sInput.setString(this.ListAscii());
            String string = this.sInput.getString();
            this.sInput.setTitle("Chu\u1ed7i Telex (" + string.length() + "/" + 8192 + ")");
        } else if (command == this.clearCommand) {
            this.sInput.setString("");
            this.sInput.setTitle(titleInput);
        } else if (command == this.aboutCommand) {
            vnTelex.showAbout(this.display);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public static void showAbout(Display display) {
        Alert alert = new Alert(titleHelp, shortHelp, null, AlertType.INFO);
        alert.setTimeout(-2);
        display.setCurrent((Displayable)alert);
    }

    String ListAscii() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 32; i < 256; ++i) {
            String string = Integer.toHexString(i);
            if (string.length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append(", " + string.toUpperCase() + ":").append((char)i);
        }
        return stringBuffer.toString().substring(2);
    }

    boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    boolean isHexDigit(char c) {
        return this.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private char NextChar() {
        char c = '\u0000';
        if (this.Source.length() > 0) {
            c = this.Source.charAt(0);
            this.Source = this.Source.substring(1);
        }
        return c;
    }

    String Telex(String string) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        this.Source = string;
        stringBuffer.setLength(0);
        char c2 = '\u0000';
        while ((c = this.NextChar()) != '\u0000') {
            if (c == '\\') {
                c = this.NextChar();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        String string2 = "" + c;
                        while (this.Source.length() > 0 && this.isDigit(this.Source.charAt(0))) {
                            string2 = string2 + this.NextChar();
                        }
                        stringBuffer.append((char)Integer.parseInt(string2, 10));
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        String string2 = "";
                        while (this.Source.length() > 0 && this.isHexDigit(this.Source.charAt(0))) {
                            string2 = string2 + this.NextChar();
                        }
                        if (string2.length() > 0) {
                            stringBuffer.append((char)Integer.parseInt(string2, 16));
                            break;
                        }
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                c = '\u0000';
            } else {
                char c3 = Character.toUpperCase(c);
                int n = vnTag.indexOf(c3);
                if (c2 == '\u0000' || n < 0) {
                    c = this.CheckU(c);
                    stringBuffer.append(c);
                } else {
                    int n2 = stringBuffer.length() - 1;
                    int n3 = vnBase[n > 4 ? 5 : n].indexOf(c2);
                    if (n3 >= 0) {
                        c = vnDau[n].charAt(n3);
                        stringBuffer.setCharAt(n2, c);
                    } else {
                        c = this.CheckU(c);
                        stringBuffer.append(c);
                    }
                }
            }
            c2 = c;
        }
        return stringBuffer.toString();
    }

    private char CheckU(char c) {
        switch (c) {
            case 'W': {
                return '\u01af';
            }
            case 'w': {
                return '\u01b0';
            }
        }
        return c;
    }
}

