/*
 * Decompiled with CFR 0.152.
 */
package dinesh.io;

import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends InputStream {
    protected InputStream is;
    private int currentByte;
    private int currentOffset;

    public BitInputStream(InputStream inputStream) {
        this.is = inputStream;
        this.currentByte = 0;
        this.currentOffset = 0;
    }

    protected BitInputStream() {
        this.currentByte = 0;
        this.currentOffset = 0;
    }

    public int read() throws IOException {
        return this.read(8);
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public long skip(long l) throws IOException {
        return this.is.skip(l);
    }

    public void close() throws IOException {
        this.is.close();
    }

    public long availableBits() throws IOException {
        long l = 8 * this.available() + 8 - this.currentOffset;
        if (this.currentOffset == 0) {
            l -= 8L;
        }
        return l;
    }

    public int read(int n) throws IOException {
        if (n < 0 || n > 32) {
            throw new IOException("Minimum of 0 and maximum of 32 bits are supported");
        }
        int n2 = 0;
        for (int i = 32 - n; i < 32; ++i) {
            n2 <<= 1;
            int n3 = this.readBit();
            if (n3 == -1) {
                n2 = -1;
                break;
            }
            n2 |= n3;
        }
        return n2;
    }

    public int skipCurrentByte() throws IOException {
        if (this.currentOffset > 0) {
            return this.skipBits(8 - this.currentOffset);
        }
        return 0;
    }

    public int skipBits(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.readBit();
        }
        return n;
    }

    public int readBit() throws IOException {
        if (this.currentOffset == 0) {
            this.currentByte = this.is.read();
        }
        if (this.currentByte == -1) {
            return -1;
        }
        int n = 128;
        n >>>= this.currentOffset;
        n &= this.currentByte;
        n >>>= 8 - this.currentOffset - 1;
        ++this.currentOffset;
        if (this.currentOffset == 8) {
            this.currentOffset = 0;
        }
        return n;
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }
}

