/*
 * Decompiled with CFR 0.152.
 */
package dinesh.io;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends OutputStream {
    protected OutputStream os;
    private int currentByte;
    private int currentOffset;

    public BitOutputStream(OutputStream outputStream) {
        this.os = outputStream;
        this.currentByte = 0;
        this.currentOffset = 0;
    }

    protected BitOutputStream() {
        this.currentByte = 0;
        this.currentOffset = 0;
    }

    public void write(int n) throws IOException {
        this.write(n, 8);
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void close() throws IOException {
        if (this.currentOffset > 0) {
            this.os.write(this.currentByte);
        }
        this.os.close();
    }

    public void write(int n, int n2) throws IOException {
        if (n2 < 0 || n2 > 31) {
            throw new IOException("Minimum of 0 and maximum of 31 bits are supported");
        }
        for (int i = 31 - n2; i < 31; ++i) {
            int n3 = 0x40000000;
            n3 >>= i;
            n3 &= n;
            this.writeBit(n3 >>= 31 - i - 1);
        }
    }

    public void flush(int n) throws IOException {
        int n2;
        int n3 = n2 = n == 0 ? 0 : 255;
        if (this.currentOffset > 0) {
            this.write(n2, 8 - this.currentOffset);
        }
        this.flush();
    }

    public void writeBit(int n) throws IOException {
        int n2 = 128;
        n2 >>>= this.currentOffset;
        this.currentByte = n == 0 ? (this.currentByte &= (n2 ^= 0xFFFFFFFF)) : (this.currentByte |= n2);
        ++this.currentOffset;
        if (this.currentOffset == 8) {
            this.os.write(this.currentByte);
            this.currentByte = 0;
            this.currentOffset = 0;
        }
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }
}

