/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.sms.ringtone;

import dinesh.io.BitInputStream;
import dinesh.mobile.sms.ringtone.CommandPart;
import dinesh.mobile.sms.ringtone.RingingToneProgramming;
import dinesh.mobile.sms.ringtone.Sound;
import java.io.IOException;

public class Command {
    private CommandPart[] part;

    public Command(BitInputStream bitInputStream) throws IOException {
        int n = bitInputStream.read();
        this.part = new CommandPart[n];
        for (int i = 0; i < n; ++i) {
            this.part[i] = CommandPart.build(bitInputStream);
        }
    }

    public Command(CommandPart[] commandPartArray) {
        this.part = commandPartArray;
    }

    public Command(CommandPart commandPart) {
        this.part = new CommandPart[1];
        this.part[0] = commandPart;
    }

    public Command(Sound sound) {
        this.part = new CommandPart[2];
        this.part[0] = new RingingToneProgramming();
        this.part[1] = sound;
    }

    public int getCommandPartLength() {
        return this.part.length;
    }

    public byte[] getBytes() {
        byte[][] byArrayArray = new byte[this.part.length][];
        int n = 1;
        for (int i = 0; i < this.part.length; ++i) {
            byArrayArray[i] = this.part[i].getBytes();
            n += byArrayArray[i].length;
        }
        byte[] byArray = new byte[n];
        byArray[0] = (byte)this.part.length;
        n = 1;
        for (int i = 0; i < this.part.length; ++i) {
            System.arraycopy(byArrayArray[i], 0, byArray, n, byArrayArray[i].length);
            n += byArrayArray[i].length;
        }
        return byArray;
    }

    public CommandPart getCommandPart(int n) {
        return this.part[n];
    }
}

