/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.composer;

import dinesh.mobile.composer.EditCanvas;
import dinesh.mobile.composer.EntryScreen;
import dinesh.mobile.composer.ErrorScreen;
import dinesh.mobile.composer.ToneListScreen;
import dinesh.mobile.composer.ToneStore;
import dinesh.mobile.sms.messaging.RingtoneMessage;
import dinesh.mobile.sms.ringtone.BasicSong;
import dinesh.mobile.sms.ringtone.Constants;
import dinesh.mobile.sms.ringtone.NoteInstruction;
import dinesh.mobile.sms.ringtone.PatternInstruction;
import dinesh.mobile.sms.ringtone.RingtoneProgrammingLanguage;
import dinesh.mobile.sms.ringtone.Sound;
import dinesh.mobile.sms.ringtone.TempoInstruction;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.wireless.messaging.BinaryMessage;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;

public class ComposerMIDlet
extends MIDlet
implements Constants {
    EntryScreen entry;
    ToneStore store;
    ToneListScreen nameList;
    EditCanvas editCanvas;

    public ComposerMIDlet() {
        ErrorScreen.init(null, Display.getDisplay((MIDlet)this));
        this.entry = new EntryScreen(this);
        this.store = ToneStore.getToneStore();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.entry);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        Display.getDisplay((MIDlet)this).setCurrent(null);
        this.store.updateRecordStore();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exitRequested() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    void entryScreenDone(String string) {
        if (string.equals("Thoa\u0301t")) {
            this.exitRequested();
        }
        if (string.equals("Ta\u0323o m\u01a1\u0301i")) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)new EditCanvas(this));
        } else if (string.equals("M\u01a1\u0309")) {
            this.nameList = new ToneListScreen(this, this.store.getNames());
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.nameList);
        } else {
            ErrorScreen.showError(string);
        }
    }

    void toneListScreenBack() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.entry);
    }

    void toneListScreenDone(String string) {
        RingtoneProgrammingLanguage ringtoneProgrammingLanguage = this.store.getTone(string);
        BasicSong basicSong = (BasicSong)((Sound)ringtoneProgrammingLanguage.getCommand(0).getCommandPart(1)).getSoundCommandSpecifier();
        String string2 = basicSong.getTitle();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < basicSong.getSongPattern(0).getPatternInstructionLength(); ++i) {
            stringBuffer.append(basicSong.getSongPattern(0).getPatternInstruction(i).print() + ";");
        }
        String string3 = stringBuffer.toString();
        this.editCanvas = new EditCanvas(this, string, string2, string3);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.editCanvas);
    }

    RingtoneProgrammingLanguage buildTone(String string, String string2) {
        return RingtoneProgrammingLanguage.build(string, string2);
    }

    byte[] convertTone(String string, String string2) {
        return this.buildTone(string, string2).getBytes();
    }

    int[][] getKeyStrokes(String string) {
        int n;
        Vector<PatternInstruction> vector = new Vector<PatternInstruction>();
        String string2 = "";
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == ';') {
                PatternInstruction patternInstruction = PatternInstruction.build(string2);
                vector.addElement(patternInstruction);
                string2 = "";
                continue;
            }
            string2 = string2 + String.valueOf(string.charAt(n));
        }
        n = 0;
        int n2 = 0;
        int n3 = 63;
        int[][] nArray = new int[2][2 * vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            PatternInstruction patternInstruction;
            Object e = vector.elementAt(i);
            if (e instanceof TempoInstruction) {
                patternInstruction = (TempoInstruction)e;
                n3 = Integer.parseInt(((TempoInstruction)patternInstruction).print().substring(1));
                continue;
            }
            if (!(e instanceof NoteInstruction)) continue;
            patternInstruction = (NoteInstruction)e;
            boolean bl = true;
            switch (((NoteInstruction)patternInstruction).getValue()) {
                case 0: {
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 12: {
                    if (n == 0) break;
                    n = 0;
                    nArray[0][n2] = 35;
                    nArray[1][n2] = 1;
                    ++n2;
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 9: 
                case 11: {
                    if (n != 0) break;
                    n = 1;
                    nArray[0][n2] = 35;
                    nArray[1][n2] = 1;
                    ++n2;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) continue;
            switch (((NoteInstruction)patternInstruction).getValue()) {
                case 1: 
                case 2: {
                    nArray[0][n2] = 49;
                    break;
                }
                case 3: 
                case 4: {
                    nArray[0][n2] = 50;
                    break;
                }
                case 5: {
                    nArray[0][n2] = 51;
                    break;
                }
                case 6: 
                case 7: {
                    nArray[0][n2] = 52;
                    break;
                }
                case 8: 
                case 9: {
                    nArray[0][n2] = 53;
                    break;
                }
                case 10: 
                case 11: {
                    nArray[0][n2] = 54;
                    break;
                }
                case 12: {
                    nArray[0][n2] = 55;
                    break;
                }
                case 0: {
                    nArray[0][n2] = 48;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            long l = 240000 / n3;
            int n4 = (int)l;
            switch (((NoteInstruction)patternInstruction).getDuration()) {
                case 0: {
                    nArray[1][n2] = n4 / 1;
                    break;
                }
                case 1: {
                    nArray[1][n2] = n4 / 2;
                    break;
                }
                case 2: {
                    nArray[1][n2] = n4 / 4;
                    break;
                }
                case 3: {
                    nArray[1][n2] = n4 / 8;
                    break;
                }
                case 4: {
                    nArray[1][n2] = n4 / 16;
                    break;
                }
                case 5: {
                    nArray[1][n2] = n4 / 32;
                    break;
                }
            }
            ++n2;
        }
        int[][] nArray2 = new int[2][n2];
        for (int i = 0; i < nArray2[0].length; ++i) {
            nArray2[0][i] = nArray[0][i];
            nArray2[1][i] = nArray[1][i];
        }
        return nArray2;
    }

    void editCanvasBack(String string) {
        this.nameList = new ToneListScreen(this, this.store.getNames(), string);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.nameList);
    }

    void saveTone(String string, String string2, String string3) {
        this.store.update(string, this.buildTone(string2, string3));
    }

    void deleteTone(String string) {
        String string2 = this.store.getNextName(string);
        this.store.removeEntry(string);
        this.nameList = new ToneListScreen(this, this.store.getNames());
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.nameList);
    }

    void sendTone(String string, String string2, String string3) {
        RingtoneMessage ringtoneMessage = new RingtoneMessage(this.buildTone(string, string2));
        try {
            MessageConnection messageConnection = (MessageConnection)Connector.open((String)"sms://:8888");
            BinaryMessage binaryMessage = (BinaryMessage)messageConnection.newMessage("binary");
            binaryMessage.setAddress("sms://" + string3 + ":" + ringtoneMessage.getPort());
            binaryMessage.setPayloadData(ringtoneMessage.getBytes());
            messageConnection.send((Message)binaryMessage);
            messageConnection.close();
        }
        catch (Exception exception) {
            ErrorScreen.showError("C\u00f3 th\u1ec3 g\u1eedi");
        }
    }
}

