/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.sms.ringtone;

import dinesh.io.BitInputStream;
import dinesh.mobile.sms.ringtone.BasicSong;
import dinesh.mobile.sms.ringtone.Command;
import dinesh.mobile.sms.ringtone.PatternInstruction;
import dinesh.mobile.sms.ringtone.SongPattern;
import dinesh.mobile.sms.ringtone.Sound;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;

public class RingtoneProgrammingLanguage {
    private Command[] command;
    public static final String RTTTL_TYPE = "rtttl";
    public static final String NOKIA_TYPE = "nokia";
    public static final String LOCAL_TYPE = "local";

    public static String spaceTrimmedString(String string) {
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == ' ' && bl) {
                stringBuffer.append(' ');
                bl = false;
                continue;
            }
            if (string.charAt(i) == ' ') continue;
            stringBuffer.append(string.charAt(i));
            bl = true;
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static String changeFormat(String string, String string2) {
        if (string == null) {
            return null;
        }
        string = string.replace(',', ' ');
        string = string.replace(';', ' ');
        string = string.replace(':', ' ');
        string = RingtoneProgrammingLanguage.spaceTrimmedString(string);
        string = string.toLowerCase();
        string = string + " ";
        String string3 = RTTTL_TYPE;
        String string4 = "";
        String string5 = "1";
        String string6 = "1";
        String string7 = "4";
        String string8 = "63";
        String string9 = "7";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        String string15 = "duration";
        int n = 32;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                if (!string15.equals("")) {
                    if (string15.equals("default duration")) {
                        string7 = string7 + c;
                    } else if (string15.equals("default scale")) {
                        string5 = string5 + c;
                    } else if (string15.equals("previous scale")) {
                        string6 = string6 + c;
                    } else if (string15.equals("tempo")) {
                        string8 = string8 + c;
                    } else if (string15.equals("volume")) {
                        string9 = string9 + c;
                    } else if (string15.equals("duration")) {
                        string12 = string12 + c;
                    } else if (string15.equals("scale")) {
                        string11 = string11 + c;
                    }
                }
            } else if (c == ' ') {
                try {
                    string5 = "" + Integer.parseInt(string5) % 4;
                    string6 = "" + Integer.parseInt(string6) % 4;
                    string11 = "" + Integer.parseInt(string11) % 4;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!string15.equals("")) {
                    if (string15.equals("default duration")) {
                        if (string7.trim().length() == 0) {
                            string7 = "1";
                        }
                    } else if (string15.equals("default scale")) {
                        string6 = "" + string5;
                    } else if (string15.equals("previous scale")) {
                        if (string2.equals(LOCAL_TYPE)) {
                            int n2 = Integer.parseInt(string6);
                            string4 = string4 + "S" + (n2 %= 4) + ";";
                        }
                    } else if (string15.equals("tempo")) {
                        if (string2.equals(LOCAL_TYPE)) {
                            string4 = string4 + "T" + string8 + ";";
                        }
                    } else if (string15.equals("volume")) {
                        if (string2.equals(LOCAL_TYPE)) {
                            string4 = string4 + "V" + string9 + ";";
                        }
                    } else {
                        if (string2.equals(NOKIA_TYPE)) {
                            string4 = string12.length() > 0 ? string4 + string12 : (string7.length() > 0 ? string4 + string7 : string4 + "4");
                            if (string10.equals("p") || string10.equals("-")) {
                                string4 = string4 + "-";
                            } else {
                                if (string10.equals("h")) {
                                    string10 = "b";
                                }
                                string4 = string4 + string14 + string13 + string10;
                                string4 = string11.length() > 0 ? string4 + Integer.parseInt(string11) % 4 : (string6.length() > 0 ? string4 + Integer.parseInt(string6) % 4 : (string5.length() > 0 ? string4 + Integer.parseInt(string5) % 4 : string4 + "1"));
                            }
                            string4 = string4 + ",";
                        } else if (string2.equals(RTTTL_TYPE)) {
                            if (string12.length() != 0 && !string12.equals(string7)) {
                                string4 = string12.length() > 0 ? string4 + string12 : (string7.length() > 0 ? string4 + string7 : string4 + "4");
                            }
                            if (string10.equals("p") || string10.equals("-")) {
                                string4 = string4 + "p";
                            } else {
                                if (string10.equals("h")) {
                                    string10 = "b";
                                }
                                string4 = string4 + string10 + string13 + string14;
                                if (string11.length() > 0 && !string11.equals(string5)) {
                                    string4 = string4 + (Integer.parseInt(string11) % 4 + 4);
                                } else if (string6.length() > 0 && !string6.equals(string5)) {
                                    string4 = string4 + (Integer.parseInt(string6) % 4 + 4);
                                }
                            }
                            string4 = string4 + ",";
                        } else if (string2.equals(LOCAL_TYPE)) {
                            if (string10.equals("p") || string10.equals("-")) {
                                string4 = string4 + "p";
                            } else {
                                if (string11.length() > 0) {
                                    if (!string11.equals(string6)) {
                                        string4 = string4 + "S" + Integer.parseInt(string11) % 4 + ";";
                                        string6 = "" + string11;
                                    }
                                } else if (!string3.equals(LOCAL_TYPE) && !string5.equals(string6)) {
                                    string4 = string4 + "S" + Integer.parseInt(string5) % 4 + ";";
                                    string6 = "" + string5;
                                }
                                if (string10.equals("b")) {
                                    string10 = "h";
                                }
                                string4 = string4 + string10 + string13 + string14;
                            }
                            string4 = string12.length() > 0 ? string4 + "/" + string12 : (string7.length() > 0 ? string4 + "/" + string7 : string4 + "/4");
                            string4 = string4 + ";";
                        }
                        string14 = "";
                        string13 = "";
                        string10 = "";
                        string11 = "";
                        string12 = "";
                    }
                }
                string15 = "duration";
            } else if (c == '#') {
                string13 = "#";
            } else if (c == '.') {
                string14 = string14 + ".";
            } else if (c == 'c' || c == 'd' || c == 'e' || c == 'f' || c == 'g' || c == 'h' || c == 'a' || c == 'b' || c == 'p' || c == '-') {
                string10 = string10 + c;
                string15 = "scale";
            } else if (c == '/') {
                string3 = LOCAL_TYPE;
                string15 = "duration";
                string12 = "";
            } else if (c == 't') {
                string15 = "tempo";
                string8 = "";
            } else if (c == 'v') {
                string15 = "volume";
                string9 = "";
            } else if (c == 's') {
                string3 = LOCAL_TYPE;
                string15 = "previous scale";
                string6 = "";
            } else if (c == '=') {
                string10 = "";
                if (n == 98) {
                    string15 = "tempo";
                    string8 = "";
                } else if (n == 111) {
                    string15 = "default scale";
                    string5 = "";
                } else if (n == 100) {
                    string15 = "default duration";
                    string7 = "";
                }
            }
            n = c;
        }
        if (string2.equals(LOCAL_TYPE)) {
            string4 = string4.toUpperCase();
        }
        if (string2.equals(RTTTL_TYPE)) {
            string4 = "d=" + string7 + ",o=" + (Integer.parseInt(string5) % 4 + 4) + ",b=" + string8 + ":" + string4;
        }
        return string4;
    }

    public static String localFormat(String string) {
        return RingtoneProgrammingLanguage.changeFormat(string, LOCAL_TYPE);
    }

    public static String nokiaFormat(String string) {
        return RingtoneProgrammingLanguage.changeFormat(string, NOKIA_TYPE);
    }

    public static String rtttlFormat(String string) {
        return RingtoneProgrammingLanguage.changeFormat(string, RTTTL_TYPE);
    }

    public static byte[] encode(String string, PatternInstruction[] patternInstructionArray) {
        RingtoneProgrammingLanguage ringtoneProgrammingLanguage = RingtoneProgrammingLanguage.build(string, patternInstructionArray);
        return ringtoneProgrammingLanguage.getBytes();
    }

    public static RingtoneProgrammingLanguage build(String string, PatternInstruction[] patternInstructionArray) {
        return new RingtoneProgrammingLanguage(new Command(new Sound(new BasicSong(string, new SongPattern(patternInstructionArray)))));
    }

    public static RingtoneProgrammingLanguage build(String string, String string2) {
        Vector<PatternInstruction> vector = new Vector<PatternInstruction>();
        String string3 = "";
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == ';') {
                vector.addElement(PatternInstruction.build(string3));
                string3 = "";
                continue;
            }
            string3 = string3 + String.valueOf(string2.charAt(i));
        }
        PatternInstruction[] patternInstructionArray = new PatternInstruction[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            patternInstructionArray[i] = (PatternInstruction)vector.elementAt(i);
        }
        return RingtoneProgrammingLanguage.build(string, patternInstructionArray);
    }

    public RingtoneProgrammingLanguage(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BitInputStream bitInputStream = new BitInputStream(byteArrayInputStream);
        Command[] commandArray = new Command[20];
        int n = 0;
        while (bitInputStream.availableBits() > 8L) {
            commandArray[n++] = new Command(bitInputStream);
        }
        this.command = new Command[n];
        for (int i = 0; i < this.command.length; ++i) {
            this.command[i] = commandArray[i];
        }
    }

    public RingtoneProgrammingLanguage(Command[] commandArray) {
        this.command = commandArray;
    }

    public RingtoneProgrammingLanguage(Command command) {
        this.command = new Command[1];
        this.command[0] = command;
    }

    public int getCommandLength() {
        return this.command.length;
    }

    public Command getCommand(int n) {
        return this.command[n];
    }

    public byte[] getBytes() {
        byte[][] byArrayArray = new byte[this.command.length][];
        int n = 1;
        for (int i = 0; i < this.command.length; ++i) {
            byArrayArray[i] = this.command[i].getBytes();
            n += byArrayArray[i].length;
        }
        byte[] byArray = new byte[n];
        n = 0;
        for (int i = 0; i < this.command.length; ++i) {
            System.arraycopy(byArrayArray[i], 0, byArray, n, byArrayArray[i].length);
            n += byArrayArray[i].length;
        }
        byArray[byArray.length - 1] = 0;
        return byArray;
    }
}

