/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.sms.ringtone;

import dinesh.io.BitInputStream;
import dinesh.io.BitOutputStream;
import dinesh.mobile.sms.ringtone.BasicSong;
import dinesh.mobile.sms.ringtone.CommandPart;
import dinesh.mobile.sms.ringtone.Constants;
import dinesh.mobile.sms.ringtone.SoundCommandSpecifier;
import dinesh.mobile.sms.ringtone.TemporarySong;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Sound
extends CommandPart
implements Constants {
    private SoundCommandSpecifier soundSpec;

    public Sound(BitInputStream bitInputStream) throws IOException {
        int n = bitInputStream.read(3);
        switch (n) {
            case 1: {
                this.soundSpec = new BasicSong(bitInputStream);
                break;
            }
            case 2: {
                this.soundSpec = new TemporarySong(bitInputStream);
                break;
            }
        }
        bitInputStream.skipCurrentByte();
    }

    public Sound(SoundCommandSpecifier soundCommandSpecifier) {
        this.soundSpec = soundCommandSpecifier;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BitOutputStream bitOutputStream = new BitOutputStream(byteArrayOutputStream);
        try {
            bitOutputStream.write(this.getType(), 7);
            this.soundSpec.writeToStream(bitOutputStream);
            bitOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public int getType() {
        return 29;
    }

    public SoundCommandSpecifier getSoundCommandSpecifier() {
        return this.soundSpec;
    }
}

