/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.sms.ringtone;

import dinesh.io.BitInputStream;
import dinesh.io.BitOutputStream;
import dinesh.mobile.sms.ringtone.Constants;
import dinesh.mobile.sms.ringtone.NoteInstruction;
import dinesh.mobile.sms.ringtone.ScaleInstruction;
import dinesh.mobile.sms.ringtone.StyleInstruction;
import dinesh.mobile.sms.ringtone.TempoInstruction;
import dinesh.mobile.sms.ringtone.VolumeInstruction;
import java.io.IOException;

public abstract class PatternInstruction
implements Constants {
    public abstract int getTypeID();

    public abstract int length();

    public abstract void writeToStream(BitOutputStream var1) throws Exception;

    public abstract String print();

    public static PatternInstruction build(BitInputStream bitInputStream) throws IOException {
        int n = bitInputStream.read(3);
        switch (n) {
            case 1: {
                return new NoteInstruction(bitInputStream);
            }
            case 2: {
                return new ScaleInstruction(bitInputStream);
            }
            case 3: {
                return new StyleInstruction(bitInputStream);
            }
            case 4: {
                return new TempoInstruction(bitInputStream);
            }
            case 5: {
                return new VolumeInstruction(bitInputStream);
            }
        }
        return null;
    }

    public static PatternInstruction build(String string) {
        switch (string.charAt(0)) {
            case 'S': {
                return new ScaleInstruction(string);
            }
            case 'T': {
                return new TempoInstruction(string);
            }
            case 'V': {
                return new VolumeInstruction(string);
            }
        }
        return new NoteInstruction(string);
    }
}

