/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D;

import emulator.graphics2D.c;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class a {
    private static final PaletteData a = new PaletteData(65280, 0xFF0000, -16777216);
    private static BufferedImage a;
    private static int[] a;

    public static BufferedImage a(ImageData imageData) {
        Object object;
        ColorModel colorModel = null;
        PaletteData paletteData = imageData.palette;
        if (paletteData.isDirect) {
            colorModel = new DirectColorModel(imageData.depth, paletteData.redMask, paletteData.greenMask, paletteData.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(imageData.width, imageData.height), false, null);
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[3];
            for (int i2 = 0; i2 < imageData.height; ++i2) {
                for (int i3 = 0; i3 < imageData.width; ++i3) {
                    int n2 = imageData.getPixel(i3, i2);
                    RGB rGB = paletteData.getRGB(n2);
                    nArray[0] = rGB.red;
                    nArray[1] = rGB.green;
                    nArray[2] = rGB.blue;
                    writableRaster.setPixels(i3, i2, 1, 1, nArray);
                }
            }
            return bufferedImage;
        }
        RGB[] rGBArray = paletteData.getRGBs();
        byte[] byArray = new byte[rGBArray.length];
        byte[] byArray2 = new byte[rGBArray.length];
        byte[] byArray3 = new byte[rGBArray.length];
        for (int i4 = 0; i4 < rGBArray.length; ++i4) {
            object = rGBArray[i4];
            byArray[i4] = (byte)((RGB)object).red;
            byArray2[i4] = (byte)((RGB)object).green;
            byArray3[i4] = (byte)((RGB)object).blue;
        }
        colorModel = imageData.transparentPixel != -1 ? new IndexColorModel(imageData.depth, rGBArray.length, byArray, byArray2, byArray3, imageData.transparentPixel) : new IndexColorModel(imageData.depth, rGBArray.length, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(imageData.width, imageData.height), false, null);
        object = bufferedImage.getRaster();
        int[] nArray = new int[1];
        for (int i5 = 0; i5 < imageData.height; ++i5) {
            for (int i6 = 0; i6 < imageData.width; ++i6) {
                int n3;
                nArray[0] = n3 = imageData.getPixel(i6, i5);
                ((WritableRaster)object).setPixel(i6, i5, nArray);
            }
        }
        return bufferedImage;
    }

    private static ImageData b(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData paletteData = new PaletteData(directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask());
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), directColorModel.getPixelSize(), paletteData);
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[4];
            for (int i2 = 0; i2 < imageData.height; ++i2) {
                for (int i3 = 0; i3 < imageData.width; ++i3) {
                    writableRaster.getPixel(i3, i2, nArray);
                    int n2 = paletteData.getPixel(new RGB(nArray[0], nArray[1], nArray[2]));
                    imageData.setPixel(i3, i2, n2);
                    if (!directColorModel.hasAlpha()) continue;
                    imageData.setAlpha(i3, i2, nArray[3]);
                }
            }
            return imageData;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            int n3 = indexColorModel.getMapSize();
            byte[] byArray = new byte[n3];
            byte[] byArray2 = new byte[n3];
            byte[] byArray3 = new byte[n3];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            RGB[] rGBArray = new RGB[n3];
            for (int i4 = 0; i4 < rGBArray.length; ++i4) {
                rGBArray[i4] = new RGB(byArray[i4] & 0xFF, byArray2[i4] & 0xFF, byArray3[i4] & 0xFF);
            }
            PaletteData paletteData = new PaletteData(rGBArray);
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), indexColorModel.getPixelSize(), paletteData);
            new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), indexColorModel.getPixelSize(), paletteData).transparentPixel = indexColorModel.getTransparentPixel();
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[1];
            for (int i5 = 0; i5 < imageData.height; ++i5) {
                for (int i6 = 0; i6 < imageData.width; ++i6) {
                    writableRaster.getPixel(i6, i5, nArray);
                    imageData.setPixel(i6, i5, nArray[0]);
                }
            }
            return imageData;
        }
        return null;
    }

    public static BufferedImage b(ImageData imageData) {
        BufferedImage bufferedImage = new BufferedImage(imageData.width, imageData.height, 2);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n2 = imageData.width * imageData.height;
        imageData.getPixels(0, 0, n2, nArray, 0);
        if (imageData.alphaData != null) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                RGB rGB = imageData.palette.getRGB(nArray[i2]);
                nArray[i2] = (imageData.alphaData[i2] << 24) + ((rGB.red & 0xFF) << 16) + ((rGB.green & 0xFF) << 8) + (rGB.blue & 0xFF);
            }
        } else if (imageData.transparentPixel != -1 && !imageData.palette.isDirect) {
            RGB[] rGBArray = imageData.palette.colors;
            for (int i3 = n2 - 1; i3 >= 0; --i3) {
                int n3;
                int n4;
                int[] nArray2;
                if (nArray[i3] == imageData.transparentPixel) {
                    nArray2 = nArray;
                    n4 = i3;
                    n3 = 0;
                } else {
                    RGB rGB = rGBArray[nArray[i3] % rGBArray.length];
                    nArray2 = nArray;
                    n4 = i3;
                    n3 = -16777216 + ((rGB.red & 0xFF) << 16) + ((rGB.green & 0xFF) << 8) + (rGB.blue & 0xFF);
                }
                nArray2[n4] = n3;
            }
        } else if (!imageData.palette.isDirect) {
            RGB[] rGBArray = imageData.palette.colors;
            for (int i4 = n2 - 1; i4 >= 0; --i4) {
                RGB rGB = imageData.palette.getRGB(nArray[i4] % rGBArray.length);
                nArray[i4] = -16777216 + ((rGB.red & 0xFF) << 16) + ((rGB.green & 0xFF) << 8) + (rGB.blue & 0xFF);
            }
        } else {
            for (int i5 = n2 - 1; i5 >= 0; --i5) {
                RGB rGB = imageData.palette.getRGB(nArray[i5]);
                nArray[i5] = -16777216 + ((rGB.red & 0xFF) << 16) + ((rGB.green & 0xFF) << 8) + (rGB.blue & 0xFF);
            }
        }
        return bufferedImage;
    }

    public static ImageData a(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 1) {
            return emulator.graphics2D.a.b(bufferedImage);
        }
        ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 32, a);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n2 = imageData.data.length - 1;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            imageData.data[n2--] = (byte)(nArray[i2] >> 24 & 0xFF);
            imageData.data[n2--] = (byte)(nArray[i2] >> 16 & 0xFF);
            imageData.data[n2--] = (byte)(nArray[i2] >> 8 & 0xFF);
            imageData.data[n2--] = (byte)(nArray[i2] & 0xFF);
        }
        return imageData;
    }

    public static BufferedImage a(ImageData imageData, boolean bl2) {
        if (a == null || a.getWidth() != imageData.width || a.getHeight() != imageData.height) {
            a = new BufferedImage(imageData.width, imageData.height, 1);
            a = ((DataBufferInt)a.getRaster().getDataBuffer()).getData();
        }
        int n2 = imageData.width * imageData.height;
        int n3 = n2 * 4 - 1;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            emulator.graphics2D.a.a[i2] = ((imageData.data[n3--] & 0xFF) << 24) + ((imageData.data[n3--] & 0xFF) << 16) + ((imageData.data[n3--] & 0xFF) << 8) + (imageData.data[n3--] & 0xFF);
        }
        if (bl2) {
            int[] nArray = new int[imageData.width];
            n3 = 0;
            int n4 = n2 - nArray.length;
            for (int i3 = imageData.height >> 1; i3 > 0; --i3) {
                System.arraycopy(a, n3, nArray, 0, nArray.length);
                System.arraycopy(a, n4 - n3, a, n3, nArray.length);
                System.arraycopy(nArray, 0, a, n4 - n3, nArray.length);
                n3 += nArray.length;
            }
        }
        return a;
    }

    public static void a(BufferedImage bufferedImage) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new c(bufferedImage), null);
    }
}

