/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gdip.BitmapData;
import org.eclipse.swt.internal.gdip.ColorPalette;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public int handle;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    ImageData data;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image() {
    }

    public Image(Device device, int n2, int n3) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, n2, n3);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Image image, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rectangle = image.getBounds();
        switch (n2) {
            case 0: {
                this.type = image.type;
                switch (this.type) {
                    case 0: {
                        int n3 = device.internal_new_GC(null);
                        int n4 = OS.CreateCompatibleDC(n3);
                        int n5 = OS.CreateCompatibleDC(n3);
                        int n6 = OS.SelectObject(n4, image.handle);
                        BITMAP bITMAP = new BITMAP();
                        OS.GetObject(image.handle, BITMAP.sizeof, bITMAP);
                        this.handle = OS.CreateCompatibleBitmap(n4, rectangle.width, bITMAP.bmBits != 0 ? -rectangle.height : rectangle.height);
                        if (this.handle == 0) {
                            SWT.error(2);
                        }
                        int n7 = OS.SelectObject(n5, this.handle);
                        OS.BitBlt(n5, 0, 0, rectangle.width, rectangle.height, n4, 0, 0, 0xCC0020);
                        OS.SelectObject(n4, n6);
                        OS.SelectObject(n5, n7);
                        OS.DeleteDC(n4);
                        OS.DeleteDC(n5);
                        device.internal_dispose_GC(n3, null);
                        this.transparentPixel = image.transparentPixel;
                        this.alpha = image.alpha;
                        if (image.alphaData == null) break;
                        this.alphaData = new byte[image.alphaData.length];
                        System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                        break;
                    }
                    case 1: {
                        if (OS.IsWinCE) {
                            this.init(device, image.data);
                            break;
                        }
                        this.handle = OS.CopyImage(image.handle, 1, rectangle.width, rectangle.height, 0);
                        if (this.handle != 0) break;
                        SWT.error(2);
                        break;
                    }
                    default: {
                        SWT.error(40);
                    }
                }
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
            case 1: {
                ImageData imageData = image.getImageData();
                PaletteData paletteData = imageData.palette;
                RGB[] rGBArray = new RGB[]{device.getSystemColor(2).getRGB(), device.getSystemColor(18).getRGB(), device.getSystemColor(22).getRGB()};
                ImageData imageData2 = new ImageData(rectangle.width, rectangle.height, 8, new PaletteData(rGBArray));
                imageData2.alpha = imageData.alpha;
                imageData2.alphaData = imageData.alphaData;
                imageData2.maskData = imageData.maskData;
                imageData2.maskPad = imageData.maskPad;
                if (imageData.transparentPixel != -1) {
                    imageData2.transparentPixel = 0;
                }
                int[] nArray = new int[rectangle.width];
                int[] nArray2 = null;
                ImageData imageData3 = null;
                if (imageData.maskData != null) {
                    imageData3 = imageData.getTransparencyMask();
                }
                if (imageData3 != null) {
                    nArray2 = new int[rectangle.width];
                }
                int n8 = paletteData.redMask;
                int n9 = paletteData.greenMask;
                int n10 = paletteData.blueMask;
                int n11 = paletteData.redShift;
                int n12 = paletteData.greenShift;
                int n13 = paletteData.blueShift;
                int n14 = 0;
                while (n14 < rectangle.height) {
                    int n15 = n14 * imageData2.bytesPerLine;
                    imageData.getPixels(0, n14, rectangle.width, nArray, 0);
                    if (imageData3 != null) {
                        imageData3.getPixels(0, n14, rectangle.width, nArray2, 0);
                    }
                    int n16 = 0;
                    while (n16 < rectangle.width) {
                        int n17 = nArray[n16];
                        if (!(imageData.transparentPixel != -1 && n17 == imageData.transparentPixel || imageData3 != null && nArray2[n16] == 0)) {
                            int n18;
                            int n19;
                            int n20;
                            if (paletteData.isDirect) {
                                n20 = n17 & n8;
                                n20 = n11 < 0 ? n20 >>> -n11 : n20 << n11;
                                n19 = n17 & n9;
                                n19 = n12 < 0 ? n19 >>> -n12 : n19 << n12;
                                n18 = n17 & n10;
                                n18 = n13 < 0 ? n18 >>> -n13 : n18 << n13;
                            } else {
                                n20 = paletteData.colors[n17].red;
                                n19 = paletteData.colors[n17].green;
                                n18 = paletteData.colors[n17].blue;
                            }
                            int n21 = n20 * n20 + n19 * n19 + n18 * n18;
                            imageData2.data[n15] = n21 < 98304 ? 1 : 2;
                        }
                        ++n15;
                        ++n16;
                    }
                    ++n14;
                }
                this.init(device, imageData2);
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
            case 2: {
                ImageData imageData = image.getImageData();
                PaletteData paletteData = imageData.palette;
                ImageData imageData4 = imageData;
                if (!paletteData.isDirect) {
                    RGB[] rGBArray = paletteData.getRGBs();
                    int n22 = 0;
                    while (n22 < rGBArray.length) {
                        if (imageData.transparentPixel != n22) {
                            int n23;
                            RGB rGB = rGBArray[n22];
                            int n24 = rGB.red;
                            int n25 = rGB.green;
                            int n26 = rGB.blue;
                            rGB.green = rGB.blue = (n23 = n24 + n24 + n25 + n25 + n25 + n25 + n25 + n26 >> 3);
                            rGB.red = rGB.blue;
                        }
                        ++n22;
                    }
                    imageData4.palette = new PaletteData(rGBArray);
                } else {
                    RGB[] rGBArray = new RGB[256];
                    int n27 = 0;
                    while (n27 < rGBArray.length) {
                        rGBArray[n27] = new RGB(n27, n27, n27);
                        ++n27;
                    }
                    imageData4 = new ImageData(rectangle.width, rectangle.height, 8, new PaletteData(rGBArray));
                    imageData4.alpha = imageData.alpha;
                    imageData4.alphaData = imageData.alphaData;
                    imageData4.maskData = imageData.maskData;
                    imageData4.maskPad = imageData.maskPad;
                    if (imageData.transparentPixel != -1) {
                        imageData4.transparentPixel = 254;
                    }
                    int[] nArray = new int[rectangle.width];
                    int n28 = paletteData.redMask;
                    int n29 = paletteData.greenMask;
                    int n30 = paletteData.blueMask;
                    int n31 = paletteData.redShift;
                    int n32 = paletteData.greenShift;
                    int n33 = paletteData.blueShift;
                    int n34 = 0;
                    while (n34 < rectangle.height) {
                        int n35 = n34 * imageData4.bytesPerLine;
                        imageData.getPixels(0, n34, rectangle.width, nArray, 0);
                        int n36 = 0;
                        while (n36 < rectangle.width) {
                            int n37 = nArray[n36];
                            if (n37 != imageData.transparentPixel) {
                                int n38 = n37 & n28;
                                n38 = n31 < 0 ? n38 >>> -n31 : n38 << n31;
                                int n39 = n37 & n29;
                                n39 = n32 < 0 ? n39 >>> -n32 : n39 << n32;
                                int n40 = n37 & n30;
                                n40 = n33 < 0 ? n40 >>> -n33 : n40 << n33;
                                int n41 = n38 + n38 + n39 + n39 + n39 + n39 + n39 + n40 >> 3;
                                if (imageData4.transparentPixel == n41) {
                                    n41 = 255;
                                }
                                imageData4.data[n35] = (byte)n41;
                            } else {
                                imageData4.data[n35] = -2;
                            }
                            ++n35;
                            ++n36;
                        }
                        ++n34;
                    }
                }
                this.init(device, imageData4);
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
        }
        SWT.error(5);
    }

    public Image(Device device, Rectangle rectangle) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(device, rectangle.width, rectangle.height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData imageData) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, imageData);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        Image.init(device, this, imageData, imageData2);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, InputStream inputStream) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(inputStream));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, String string) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.device = device;
        try {
            device.checkGDIP();
            int n2 = string.length();
            char[] cArray = new char[n2 + 1];
            string.getChars(0, n2, cArray, 0);
            int n3 = Gdip.Bitmap_new(cArray, false);
            if (n3 != 0) {
                int n4 = 2;
                int n5 = Gdip.Image_GetLastStatus(n3);
                if (n5 == 0) {
                    if (string.toLowerCase().endsWith(".ico")) {
                        this.type = 1;
                        int[] nArray = new int[1];
                        Gdip.Bitmap_GetHICON(n3, nArray);
                        this.handle = nArray[0];
                    } else {
                        this.type = 0;
                        int n6 = Gdip.Image_GetWidth(n3);
                        int n7 = Gdip.Image_GetHeight(n3);
                        int n8 = Gdip.Image_GetPixelFormat(n3);
                        switch (n8) {
                            case 135173: 
                            case 135174: {
                                this.handle = Image.createDIB(n6, n7, 16);
                                break;
                            }
                            case 137224: {
                                this.handle = Image.createDIB(n6, n7, 24);
                                break;
                            }
                            case 139273: 
                            case 925707: 
                            case 0x101004: 
                            case 1060876: 
                            case 1851406: 
                            case 3424269: {
                                this.handle = Image.createDIB(n6, n7, 32);
                            }
                        }
                        if (this.handle != 0) {
                            int n9 = device.internal_new_GC(null);
                            int n10 = OS.CreateCompatibleDC(n9);
                            int n11 = OS.SelectObject(n10, this.handle);
                            int n12 = Gdip.Graphics_new(n10);
                            if (n12 != 0) {
                                Rect rect = new Rect();
                                rect.Width = n6;
                                rect.Height = n7;
                                n5 = Gdip.Graphics_DrawImage(n12, n3, rect, 0, 0, n6, n7, 2, 0, 0, 0);
                                if (n5 != 0) {
                                    n4 = 40;
                                    OS.DeleteObject(this.handle);
                                    this.handle = 0;
                                }
                                Gdip.Graphics_delete(n12);
                            }
                            OS.SelectObject(n10, n11);
                            OS.DeleteDC(n10);
                            device.internal_dispose_GC(n9, null);
                        } else {
                            int n13 = Gdip.BitmapData_new();
                            if (n13 != 0) {
                                Gdip.Bitmap_LockBits(n3, 0, 0, n8, n13);
                                BitmapData bitmapData = new BitmapData();
                                Gdip.MoveMemory(bitmapData, n13);
                                int n14 = bitmapData.Stride;
                                int n15 = bitmapData.Scan0;
                                int n16 = 0;
                                int n17 = 4;
                                int n18 = -1;
                                switch (bitmapData.PixelFormat) {
                                    case 196865: {
                                        n16 = 1;
                                        break;
                                    }
                                    case 197634: {
                                        n16 = 4;
                                        break;
                                    }
                                    case 198659: {
                                        n16 = 8;
                                        break;
                                    }
                                    case 135173: 
                                    case 135174: 
                                    case 397319: {
                                        n16 = 16;
                                        break;
                                    }
                                    case 137224: {
                                        n16 = 24;
                                        break;
                                    }
                                    case 139273: 
                                    case 2498570: {
                                        n16 = 32;
                                    }
                                }
                                if (n16 != 0) {
                                    int n19;
                                    PaletteData paletteData = null;
                                    switch (bitmapData.PixelFormat) {
                                        case 196865: 
                                        case 197634: 
                                        case 198659: {
                                            int n20 = Gdip.Image_GetPaletteSize(n3);
                                            int n21 = OS.GetProcessHeap();
                                            n19 = OS.HeapAlloc(n21, 8, n20);
                                            if (n19 == 0) {
                                                SWT.error(2);
                                            }
                                            Gdip.Image_GetPalette(n3, n19, n20);
                                            ColorPalette colorPalette = new ColorPalette();
                                            Gdip.MoveMemory(colorPalette, n19, ColorPalette.sizeof);
                                            int[] nArray = new int[colorPalette.Count];
                                            OS.MoveMemory(nArray, n19 + 8, nArray.length * 4);
                                            OS.HeapFree(n21, 0, n19);
                                            RGB[] rGBArray = new RGB[colorPalette.Count];
                                            paletteData = new PaletteData(rGBArray);
                                            int n22 = 0;
                                            while (n22 < nArray.length) {
                                                if ((nArray[n22] >> 24 & 0xFF) == 0 && (colorPalette.Flags & 1) != 0) {
                                                    n18 = n22;
                                                }
                                                rGBArray[n22] = new RGB((nArray[n22] & 0xFF0000) >> 16, (nArray[n22] & 0xFF00) >> 8, (nArray[n22] & 0xFF) >> 0);
                                                ++n22;
                                            }
                                            break;
                                        }
                                        case 135173: 
                                        case 397319: {
                                            paletteData = new PaletteData(31744, 992, 31);
                                            break;
                                        }
                                        case 135174: {
                                            paletteData = new PaletteData(63488, 2016, 31);
                                            break;
                                        }
                                        case 137224: {
                                            paletteData = new PaletteData(255, 65280, 0xFF0000);
                                            break;
                                        }
                                        case 139273: 
                                        case 2498570: {
                                            paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                                        }
                                    }
                                    byte[] byArray = new byte[n14 * n7];
                                    byte[] byArray2 = null;
                                    OS.MoveMemory(byArray, n15, byArray.length);
                                    switch (bitmapData.PixelFormat) {
                                        case 397319: {
                                            byArray2 = new byte[n6 * n7];
                                            n19 = 1;
                                            int n23 = 0;
                                            while (n19 < byArray.length) {
                                                byArray2[n23] = (byte)((byArray[n19] & 0x80) != 0 ? 255 : 0);
                                                n19 += 2;
                                                ++n23;
                                            }
                                            break;
                                        }
                                        case 2498570: {
                                            byArray2 = new byte[n6 * n7];
                                            n19 = 3;
                                            int n24 = 0;
                                            while (n19 < byArray.length) {
                                                byArray2[n24] = byArray[n19];
                                                n19 += 4;
                                                ++n24;
                                            }
                                            break;
                                        }
                                    }
                                    Gdip.Bitmap_UnlockBits(n3, n13);
                                    Gdip.BitmapData_delete(n13);
                                    ImageData imageData = new ImageData(n6, n7, n16, paletteData, n17, byArray);
                                    imageData.transparentPixel = n18;
                                    imageData.alphaData = byArray2;
                                    this.init(device, imageData);
                                }
                            }
                        }
                    }
                }
                Gdip.Bitmap_delete(n3);
                if (n5 == 0) {
                    if (this.handle == 0) {
                        SWT.error(n4);
                    }
                    return;
                }
            }
        }
        catch (SWTException sWTException) {}
        this.init(device, new ImageData(string));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    int createDIBFromDDB(int n2, int n3, int n4, int n5) {
        int[] nArray;
        int n6;
        int n7;
        int n8;
        Object object;
        int n9;
        int n10;
        int n11 = OS.GetDeviceCaps(n2, 12);
        int n12 = n11 * (n10 = OS.GetDeviceCaps(n2, 14));
        boolean bl2 = n12 > 8;
        RGB[] rGBArray = null;
        if (!bl2) {
            n9 = 1 << n12;
            object = new byte[4 * n9];
            OS.GetPaletteEntries(this.device.hPalette, 0, n9, (byte[])object);
            rGBArray = new RGB[n9];
            int n13 = 0;
            while (n13 < n9) {
                rGBArray[n13] = new RGB((int)(object[n13] & 0xFF), (int)(object[n13 + 1] & 0xFF), (int)(object[n13 + 2] & 0xFF));
                ++n13;
            }
        }
        n9 = OS.IsWinCE && (n12 == 16 || n12 == 32) ? 1 : 0;
        object = new BITMAPINFOHEADER();
        ((BITMAPINFOHEADER)object).biSize = BITMAPINFOHEADER.sizeof;
        ((BITMAPINFOHEADER)object).biWidth = n4;
        ((BITMAPINFOHEADER)object).biHeight = -n5;
        ((BITMAPINFOHEADER)object).biPlanes = 1;
        ((BITMAPINFOHEADER)object).biBitCount = (short)n12;
        ((BITMAPINFOHEADER)object).biCompression = n9 != 0 ? 3 : 0;
        byte[] byArray = bl2 ? new byte[BITMAPINFOHEADER.sizeof + (n9 != 0 ? 12 : 0)] : new byte[BITMAPINFOHEADER.sizeof + rGBArray.length * 4];
        OS.MoveMemory(byArray, (BITMAPINFOHEADER)object, BITMAPINFOHEADER.sizeof);
        int n14 = BITMAPINFOHEADER.sizeof;
        if (bl2) {
            if (n9 != 0) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                switch (n12) {
                    case 16: {
                        n8 = 31744;
                        n7 = 992;
                        n6 = 31;
                        byArray[n14] = (byte)((n8 & 0xFF) >> 0);
                        byArray[n14 + 1] = (byte)((n8 & 0xFF00) >> 8);
                        byArray[n14 + 2] = (byte)((n8 & 0xFF0000) >> 16);
                        byArray[n14 + 3] = (byte)((n8 & 0xFF000000) >> 24);
                        byArray[n14 + 4] = (byte)((n7 & 0xFF) >> 0);
                        byArray[n14 + 5] = (byte)((n7 & 0xFF00) >> 8);
                        byArray[n14 + 6] = (byte)((n7 & 0xFF0000) >> 16);
                        byArray[n14 + 7] = (byte)((n7 & 0xFF000000) >> 24);
                        byArray[n14 + 8] = (byte)((n6 & 0xFF) >> 0);
                        byArray[n14 + 9] = (byte)((n6 & 0xFF00) >> 8);
                        byArray[n14 + 10] = (byte)((n6 & 0xFF0000) >> 16);
                        byArray[n14 + 11] = (byte)((n6 & 0xFF000000) >> 24);
                        break;
                    }
                    case 32: {
                        n8 = 65280;
                        n7 = 0xFF0000;
                        n6 = -16777216;
                        byArray[n14] = (byte)((n8 & 0xFF000000) >> 24);
                        byArray[n14 + 1] = (byte)((n8 & 0xFF0000) >> 16);
                        byArray[n14 + 2] = (byte)((n8 & 0xFF00) >> 8);
                        byArray[n14 + 3] = (byte)((n8 & 0xFF) >> 0);
                        byArray[n14 + 4] = (byte)((n7 & 0xFF000000) >> 24);
                        byArray[n14 + 5] = (byte)((n7 & 0xFF0000) >> 16);
                        byArray[n14 + 6] = (byte)((n7 & 0xFF00) >> 8);
                        byArray[n14 + 7] = (byte)((n7 & 0xFF) >> 0);
                        byArray[n14 + 8] = (byte)((n6 & 0xFF000000) >> 24);
                        byArray[n14 + 9] = (byte)((n6 & 0xFF0000) >> 16);
                        byArray[n14 + 10] = (byte)((n6 & 0xFF00) >> 8);
                        byArray[n14 + 11] = (byte)((n6 & 0xFF) >> 0);
                        break;
                    }
                    default: {
                        SWT.error(38);
                        break;
                    }
                }
            }
        } else {
            n8 = 0;
            while (n8 < rGBArray.length) {
                byArray[n14] = (byte)rGBArray[n8].blue;
                byArray[n14 + 1] = (byte)rGBArray[n8].green;
                byArray[n14 + 2] = (byte)rGBArray[n8].red;
                byArray[n14 + 3] = 0;
                n14 += 4;
                ++n8;
            }
        }
        if ((n7 = OS.CreateDIBSection(0, byArray, 0, nArray = new int[1], 0, 0)) == 0) {
            SWT.error(2);
        }
        n6 = OS.CreateCompatibleDC(n2);
        int n15 = OS.CreateCompatibleDC(n2);
        int n16 = OS.SelectObject(n6, n3);
        int n17 = OS.SelectObject(n15, n7);
        OS.BitBlt(n15, 0, 0, n4, n5, n6, 0, 0, 0xCC0020);
        OS.SelectObject(n6, n16);
        OS.SelectObject(n15, n17);
        OS.DeleteDC(n6);
        OS.DeleteDC(n15);
        return n7;
    }

    int[] createGdipImage() {
        switch (this.type) {
            case 0: {
                if (this.alpha != -1 || this.alphaData != null || this.transparentPixel != -1) {
                    int n2;
                    int n3;
                    int n4;
                    byte[] byArray;
                    BITMAP bITMAP = new BITMAP();
                    OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
                    int n5 = bITMAP.bmWidth;
                    int n6 = bITMAP.bmHeight;
                    int n7 = this.device.internal_new_GC(null);
                    int n8 = OS.CreateCompatibleDC(n7);
                    int n9 = OS.SelectObject(n8, this.handle);
                    int n10 = OS.CreateCompatibleDC(n7);
                    int n11 = Image.createDIB(n5, n6, 32);
                    if (n11 == 0) {
                        SWT.error(2);
                    }
                    int n12 = OS.SelectObject(n10, n11);
                    BITMAP bITMAP2 = new BITMAP();
                    OS.GetObject(n11, BITMAP.sizeof, bITMAP2);
                    int n13 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
                    OS.BitBlt(n10, 0, 0, n5, n6, n8, 0, 0, 0xCC0020);
                    byte by2 = 0;
                    byte by3 = 0;
                    byte by4 = 0;
                    if (this.transparentPixel != -1) {
                        if (bITMAP.bmBitsPixel <= 8) {
                            byArray = new byte[4];
                            OS.GetDIBColorTable(n8, this.transparentPixel, 1, byArray);
                            by4 = byArray[0];
                            by3 = byArray[1];
                            by2 = byArray[2];
                        } else {
                            switch (bITMAP.bmBitsPixel) {
                                case 16: {
                                    int n14 = 31;
                                    n4 = ImageData.getChannelShift(n14);
                                    byte[] byArray2 = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(n14, n4)];
                                    by4 = byArray2[(this.transparentPixel & n14) >> n4];
                                    n3 = 992;
                                    n2 = ImageData.getChannelShift(n3);
                                    byte[] byArray3 = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(n3, n2)];
                                    by3 = byArray3[(this.transparentPixel & n3) >> n2];
                                    int n15 = 31744;
                                    int n16 = ImageData.getChannelShift(n15);
                                    byte[] byArray4 = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(n15, n16)];
                                    by2 = byArray4[(this.transparentPixel & n15) >> n16];
                                    break;
                                }
                                case 24: {
                                    by4 = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    by3 = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                    by2 = (byte)(this.transparentPixel & 0xFF);
                                    break;
                                }
                                case 32: {
                                    by4 = (byte)((this.transparentPixel & 0xFF000000) >>> 24);
                                    by3 = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    by2 = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                }
                            }
                        }
                    }
                    OS.SelectObject(n8, n9);
                    OS.SelectObject(n10, n12);
                    OS.DeleteObject(n8);
                    OS.DeleteObject(n10);
                    byArray = new byte[n13];
                    OS.MoveMemory(byArray, bITMAP2.bmBits, n13);
                    OS.DeleteObject(n11);
                    this.device.internal_dispose_GC(n7, null);
                    if (this.alpha != -1) {
                        n4 = 0;
                        int n17 = 0;
                        while (n4 < n6) {
                            n3 = 0;
                            while (n3 < n5) {
                                byArray[n17 + 3] = (byte)this.alpha;
                                n17 += 4;
                                ++n3;
                            }
                            ++n4;
                        }
                    } else if (this.alphaData != null) {
                        n4 = 0;
                        int n18 = 0;
                        n3 = 0;
                        while (n4 < n6) {
                            n2 = 0;
                            while (n2 < n5) {
                                byArray[n18 + 3] = this.alphaData[n3++];
                                n18 += 4;
                                ++n2;
                            }
                            ++n4;
                        }
                    } else if (this.transparentPixel != -1) {
                        n4 = 0;
                        int n19 = 0;
                        while (n4 < n6) {
                            n3 = 0;
                            while (n3 < n5) {
                                byArray[n19 + 3] = byArray[n19] == by4 && byArray[n19 + 1] == by3 && byArray[n19 + 2] == by2 ? 0 : -1;
                                n19 += 4;
                                ++n3;
                            }
                            ++n4;
                        }
                    }
                    n4 = OS.GetProcessHeap();
                    int n20 = OS.HeapAlloc(n4, 8, byArray.length);
                    if (n20 == 0) {
                        SWT.error(2);
                    }
                    OS.MoveMemory(n20, byArray, n13);
                    return new int[]{Gdip.Bitmap_new(n5, n6, bITMAP2.bmWidthBytes, 2498570, n20), n20};
                }
                int[] nArray = new int[2];
                nArray[0] = Gdip.Bitmap_new(this.handle, 0);
                return nArray;
            }
            case 1: {
                ICONINFO iCONINFO = new ICONINFO();
                if (OS.IsWinCE) {
                    Image.GetIconInfo(this, iCONINFO);
                } else {
                    OS.GetIconInfo(this.handle, iCONINFO);
                }
                int n21 = iCONINFO.hbmColor;
                if (n21 == 0) {
                    n21 = iCONINFO.hbmMask;
                }
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(n21, BITMAP.sizeof, bITMAP);
                int n22 = bITMAP.bmWidth;
                int n23 = n21 == iCONINFO.hbmMask ? bITMAP.bmHeight / 2 : bITMAP.bmHeight;
                int n24 = 0;
                int n25 = 0;
                if (n22 > n23) {
                    int n26 = this.device.internal_new_GC(null);
                    int n27 = OS.CreateCompatibleDC(n26);
                    int n28 = OS.SelectObject(n27, n21);
                    int n29 = OS.CreateCompatibleDC(n26);
                    int n30 = Image.createDIB(n22, n23, 32);
                    if (n30 == 0) {
                        SWT.error(2);
                    }
                    int n31 = OS.SelectObject(n29, n30);
                    BITMAP bITMAP3 = new BITMAP();
                    OS.GetObject(n30, BITMAP.sizeof, bITMAP3);
                    OS.BitBlt(n29, 0, 0, n22, n23, n27, 0, n21 == iCONINFO.hbmMask ? n23 : 0, 0xCC0020);
                    OS.SelectObject(n29, n31);
                    OS.DeleteObject(n29);
                    byte[] byArray = new byte[bITMAP3.bmWidthBytes * bITMAP3.bmHeight];
                    OS.MoveMemory(byArray, bITMAP3.bmBits, byArray.length);
                    OS.DeleteObject(n30);
                    OS.SelectObject(n27, iCONINFO.hbmMask);
                    int n32 = 0;
                    int n33 = 0;
                    while (n32 < n23) {
                        int n34 = 0;
                        while (n34 < n22) {
                            byArray[n33 + 3] = OS.GetPixel(n27, n34, n32) != 0 ? 0 : -1;
                            n33 += 4;
                            ++n34;
                        }
                        ++n32;
                    }
                    OS.SelectObject(n27, n28);
                    OS.DeleteObject(n27);
                    this.device.internal_dispose_GC(n26, null);
                    n32 = OS.GetProcessHeap();
                    n25 = OS.HeapAlloc(n32, 8, byArray.length);
                    if (n25 == 0) {
                        SWT.error(2);
                    }
                    OS.MoveMemory(n25, byArray, byArray.length);
                    n24 = Gdip.Bitmap_new(n22, n23, bITMAP3.bmWidthBytes, 2498570, n25);
                } else {
                    n24 = Gdip.Bitmap_new(this.handle);
                }
                if (iCONINFO.hbmColor != 0) {
                    OS.DeleteObject(iCONINFO.hbmColor);
                }
                if (iCONINFO.hbmMask != 0) {
                    OS.DeleteObject(iCONINFO.hbmMask);
                }
                return new int[]{n24, n25};
            }
        }
        SWT.error(40);
        return null;
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.type == 1) {
            if (OS.IsWinCE) {
                this.data = null;
            }
            OS.DestroyIcon(this.handle);
        } else {
            OS.DeleteObject(this.handle);
        }
        this.handle = 0;
        this.memGC = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        int n2 = this.device.internal_new_GC(null);
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
        int n3 = OS.CreateCompatibleDC(n2);
        int n4 = OS.SelectObject(n3, this.handle);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (bITMAP.bmBitsPixel <= 8) {
            if (OS.IsWinCE) {
                byte[] byArray = new byte[1];
                OS.MoveMemory(byArray, bITMAP.bmBits, 1);
                byte by2 = byArray[0];
                int n8 = 255 << 8 - bITMAP.bmBitsPixel & 0xFF;
                byArray[0] = (byte)(this.transparentPixel << 8 - bITMAP.bmBitsPixel | byArray[0] & ~n8);
                OS.MoveMemory(bITMAP.bmBits, byArray, 1);
                int n9 = OS.GetPixel(n3, 0, 0);
                byArray[0] = by2;
                OS.MoveMemory(bITMAP.bmBits, byArray, 1);
                n7 = (n9 & 0xFF0000) >> 16;
                n6 = (n9 & 0xFF00) >> 8;
                n5 = n9 & 0xFF;
            } else {
                byte[] byArray = new byte[4];
                OS.GetDIBColorTable(n3, this.transparentPixel, 1, byArray);
                n7 = byArray[0] & 0xFF;
                n6 = byArray[1] & 0xFF;
                n5 = byArray[2] & 0xFF;
            }
        } else {
            switch (bITMAP.bmBitsPixel) {
                case 16: {
                    n7 = (this.transparentPixel & 0x1F) << 3;
                    n6 = (this.transparentPixel & 0x3E0) >> 2;
                    n5 = (this.transparentPixel & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    n7 = (this.transparentPixel & 0xFF0000) >> 16;
                    n6 = (this.transparentPixel & 0xFF00) >> 8;
                    n5 = this.transparentPixel & 0xFF;
                    break;
                }
                case 32: {
                    n7 = (this.transparentPixel & 0xFF000000) >>> 24;
                    n6 = (this.transparentPixel & 0xFF0000) >> 16;
                    n5 = (this.transparentPixel & 0xFF00) >> 8;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        OS.SelectObject(n3, n4);
        OS.DeleteDC(n3);
        this.device.internal_dispose_GC(n2, null);
        return Color.win32_new(this.device, n7 << 16 | n6 << 8 | n5);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        switch (this.type) {
            case 0: {
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
                this.width = bITMAP.bmWidth;
                this.height = bITMAP.bmHeight;
                return new Rectangle(0, 0, this.width, this.height);
            }
            case 1: {
                if (OS.IsWinCE) {
                    this.width = this.data.width;
                    this.height = this.data.height;
                    return new Rectangle(0, 0, this.width, this.height);
                }
                ICONINFO iCONINFO = new ICONINFO();
                OS.GetIconInfo(this.handle, iCONINFO);
                int n2 = iCONINFO.hbmColor;
                if (n2 == 0) {
                    n2 = iCONINFO.hbmMask;
                }
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(n2, BITMAP.sizeof, bITMAP);
                if (n2 == iCONINFO.hbmMask) {
                    bITMAP.bmHeight /= 2;
                }
                if (iCONINFO.hbmColor != 0) {
                    OS.DeleteObject(iCONINFO.hbmColor);
                }
                if (iCONINFO.hbmMask != 0) {
                    OS.DeleteObject(iCONINFO.hbmMask);
                }
                this.width = bITMAP.bmWidth;
                this.height = bITMAP.bmHeight;
                return new Rectangle(0, 0, this.width, this.height);
            }
        }
        SWT.error(40);
        return null;
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        switch (this.type) {
            case 1: {
                int n2;
                int n3;
                Object[] objectArray;
                int n4;
                if (OS.IsWinCE) {
                    return this.data;
                }
                ICONINFO iCONINFO = new ICONINFO();
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetIconInfo(this.handle, iCONINFO);
                int n5 = iCONINFO.hbmColor;
                if (n5 == 0) {
                    n5 = iCONINFO.hbmMask;
                }
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(n5, BITMAP.sizeof, bITMAP);
                int n6 = bITMAP.bmPlanes * bITMAP.bmBitsPixel;
                int n7 = bITMAP.bmWidth;
                if (n5 == iCONINFO.hbmMask) {
                    bITMAP.bmHeight /= 2;
                }
                int n8 = bITMAP.bmHeight;
                int n9 = 0;
                if (n6 <= 8) {
                    n9 = 1 << n6;
                }
                BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                bITMAPINFOHEADER.biWidth = n7;
                bITMAPINFOHEADER.biHeight = -n8;
                bITMAPINFOHEADER.biPlanes = 1;
                bITMAPINFOHEADER.biBitCount = (short)n6;
                bITMAPINFOHEADER.biCompression = 0;
                byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + n9 * 4];
                OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                int n10 = this.device.internal_new_GC(null);
                int n11 = OS.CreateCompatibleDC(n10);
                int n12 = OS.SelectObject(n11, n5);
                int n13 = 0;
                if (n6 <= 8 && (n4 = this.device.hPalette) != 0) {
                    n13 = OS.SelectPalette(n11, n4, false);
                    OS.RealizePalette(n11);
                }
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(n11, n5, 0, n8, 0, byArray, 0);
                OS.MoveMemory(bITMAPINFOHEADER, byArray, BITMAPINFOHEADER.sizeof);
                n4 = bITMAPINFOHEADER.biSizeImage;
                byte[] byArray2 = new byte[n4];
                int n14 = OS.GetProcessHeap();
                int n15 = OS.HeapAlloc(n14, 8, n4);
                if (n15 == 0) {
                    SWT.error(2);
                }
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(n11, n5, 0, n8, n15, byArray, 0);
                OS.MoveMemory(byArray2, n15, n4);
                PaletteData paletteData = null;
                if (n6 <= 8) {
                    objectArray = new RGB[n9];
                    n3 = 40;
                    n2 = 0;
                    while (n2 < n9) {
                        objectArray[n2] = new RGB(byArray[n3 + 2] & 0xFF, byArray[n3 + 1] & 0xFF, byArray[n3] & 0xFF);
                        n3 += 4;
                        ++n2;
                    }
                    paletteData = new PaletteData((RGB[])objectArray);
                } else if (n6 == 16) {
                    paletteData = new PaletteData(31744, 992, 31);
                } else if (n6 == 24) {
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                } else if (n6 == 32) {
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                objectArray = null;
                if (iCONINFO.hbmColor == 0) {
                    objectArray = new byte[n4];
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n11, n5, n8, n8, n15, byArray, 0);
                    OS.MoveMemory((byte[])objectArray, n15, n4);
                } else {
                    bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biWidth = n7;
                    bITMAPINFOHEADER.biHeight = -n8;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = 1;
                    bITMAPINFOHEADER.biCompression = 0;
                    byArray = new byte[BITMAPINFOHEADER.sizeof + 8];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                    n3 = BITMAPINFOHEADER.sizeof;
                    byArray[n3 + 6] = -1;
                    byArray[n3 + 5] = -1;
                    byArray[n3 + 4] = -1;
                    byArray[n3 + 7] = 0;
                    OS.SelectObject(n11, iCONINFO.hbmMask);
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n11, iCONINFO.hbmMask, 0, n8, 0, byArray, 0);
                    OS.MoveMemory(bITMAPINFOHEADER, byArray, BITMAPINFOHEADER.sizeof);
                    n4 = bITMAPINFOHEADER.biSizeImage;
                    objectArray = new byte[n4];
                    n2 = OS.HeapAlloc(n14, 8, n4);
                    if (n2 == 0) {
                        SWT.error(2);
                    }
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n11, iCONINFO.hbmMask, 0, n8, n2, byArray, 0);
                    OS.MoveMemory((byte[])objectArray, n2, n4);
                    OS.HeapFree(n14, 0, n2);
                    int n16 = 0;
                    while (n16 < objectArray.length) {
                        int n17 = n16++;
                        objectArray[n17] = (RGB)((byte)(~objectArray[n17]));
                    }
                    int n18 = n4 / n8;
                    n16 = 1;
                    while (n16 < 128) {
                        int n19 = ((n7 + 7) / 8 + (n16 - 1)) / n16 * n16;
                        if (n19 == n18) break;
                        ++n16;
                    }
                    objectArray = ImageData.convertPad((byte[])objectArray, n7, n8, 1, n16, 2);
                }
                OS.HeapFree(n14, 0, n15);
                OS.SelectObject(n11, n12);
                if (n13 != 0) {
                    OS.SelectPalette(n11, n13, false);
                    OS.RealizePalette(n11);
                }
                OS.DeleteDC(n11);
                this.device.internal_dispose_GC(n10, null);
                if (iCONINFO.hbmColor != 0) {
                    OS.DeleteObject(iCONINFO.hbmColor);
                }
                if (iCONINFO.hbmMask != 0) {
                    OS.DeleteObject(iCONINFO.hbmMask);
                }
                ImageData imageData = new ImageData(n7, n8, n6, paletteData, 4, byArray2);
                imageData.maskData = (byte[])objectArray;
                imageData.maskPad = 2;
                return imageData;
            }
            case 0: {
                int n20;
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
                int n21 = bITMAP.bmPlanes * bITMAP.bmBitsPixel;
                int n22 = bITMAP.bmWidth;
                int n23 = bITMAP.bmHeight;
                boolean bl2 = bITMAP.bmBits != 0;
                int n24 = this.device.internal_new_GC(null);
                int n25 = this.handle;
                if (OS.IsWinCE && !bl2) {
                    boolean bl3 = false;
                    if (this.memGC != null && !this.memGC.isDisposed()) {
                        this.memGC.flush();
                        bl3 = true;
                        GCData gCData = this.memGC.data;
                        if (gCData.hNullBitmap != 0) {
                            OS.SelectObject(this.memGC.handle, gCData.hNullBitmap);
                            gCData.hNullBitmap = 0;
                        }
                    }
                    n25 = this.createDIBFromDDB(n24, this.handle, n22, n23);
                    if (bl3) {
                        int n26;
                        this.memGC.data.hNullBitmap = n26 = OS.SelectObject(this.memGC.handle, this.handle);
                    }
                    bl2 = true;
                }
                DIBSECTION dIBSECTION = null;
                if (bl2) {
                    dIBSECTION = new DIBSECTION();
                    OS.GetObject(n25, DIBSECTION.sizeof, dIBSECTION);
                }
                int n27 = 0;
                if (n21 <= 8) {
                    n27 = bl2 ? dIBSECTION.biClrUsed : 1 << n21;
                }
                byte[] byArray = null;
                BITMAPINFOHEADER bITMAPINFOHEADER = null;
                if (!bl2) {
                    bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biWidth = n22;
                    bITMAPINFOHEADER.biHeight = -n23;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = (short)n21;
                    bITMAPINFOHEADER.biCompression = 0;
                    byArray = new byte[BITMAPINFOHEADER.sizeof + n27 * 4];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                }
                int n28 = OS.CreateCompatibleDC(n24);
                int n29 = OS.SelectObject(n28, n25);
                int n30 = 0;
                if (!bl2 && n21 <= 8 && (n20 = this.device.hPalette) != 0) {
                    n30 = OS.SelectPalette(n28, n20, false);
                    OS.RealizePalette(n28);
                }
                if (bl2) {
                    n20 = dIBSECTION.biSizeImage;
                } else {
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n28, n25, 0, n23, 0, byArray, 0);
                    OS.MoveMemory(bITMAPINFOHEADER, byArray, BITMAPINFOHEADER.sizeof);
                    n20 = bITMAPINFOHEADER.biSizeImage;
                }
                byte[] byArray3 = new byte[n20];
                if (bl2) {
                    if (OS.IsWinCE && this.handle != n25) {
                        OS.MoveMemory(byArray3, dIBSECTION.bmBits, n20);
                    } else {
                        OS.MoveMemory(byArray3, bITMAP.bmBits, n20);
                    }
                } else {
                    int n31 = OS.GetProcessHeap();
                    int n32 = OS.HeapAlloc(n31, 8, n20);
                    if (n32 == 0) {
                        SWT.error(2);
                    }
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n28, n25, 0, n23, n32, byArray, 0);
                    OS.MoveMemory(byArray3, n32, n20);
                    OS.HeapFree(n31, 0, n32);
                }
                PaletteData paletteData = null;
                if (n21 <= 8) {
                    RGB[] rGBArray = new RGB[n27];
                    if (bl2) {
                        if (OS.IsWinCE) {
                            int n33 = 0;
                            int n34 = 0;
                            int n35 = 0;
                            byte[] byArray4 = new byte[1];
                            OS.MoveMemory(byArray4, bITMAP.bmBits, 1);
                            byte by2 = byArray4[0];
                            int n36 = 255 << 8 - bITMAP.bmBitsPixel & 0xFF;
                            int n37 = 0;
                            while (n37 < n27) {
                                byArray4[0] = (byte)(n37 << 8 - bITMAP.bmBitsPixel | byArray4[0] & ~n36);
                                OS.MoveMemory(bITMAP.bmBits, byArray4, 1);
                                int n38 = OS.GetPixel(n28, 0, 0);
                                n35 = (n38 & 0xFF0000) >> 16;
                                n34 = (n38 & 0xFF00) >> 8;
                                n33 = n38 & 0xFF;
                                rGBArray[n37] = new RGB(n33, n34, n35);
                                ++n37;
                            }
                            byArray4[0] = by2;
                            OS.MoveMemory(bITMAP.bmBits, byArray4, 1);
                        } else {
                            byte[] byArray5 = new byte[n27 * 4];
                            OS.GetDIBColorTable(n28, 0, n27, byArray5);
                            int n39 = 0;
                            int n40 = 0;
                            while (n40 < rGBArray.length) {
                                rGBArray[n40] = new RGB(byArray5[n39 + 2] & 0xFF, byArray5[n39 + 1] & 0xFF, byArray5[n39] & 0xFF);
                                n39 += 4;
                                ++n40;
                            }
                        }
                    } else {
                        int n41 = BITMAPINFOHEADER.sizeof;
                        int n42 = 0;
                        while (n42 < n27) {
                            rGBArray[n42] = new RGB(byArray[n41 + 2] & 0xFF, byArray[n41 + 1] & 0xFF, byArray[n41] & 0xFF);
                            n41 += 4;
                            ++n42;
                        }
                    }
                    paletteData = new PaletteData(rGBArray);
                } else if (n21 == 16) {
                    paletteData = new PaletteData(31744, 992, 31);
                } else if (n21 == 24) {
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                } else if (n21 == 32) {
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                OS.SelectObject(n28, n29);
                if (n30 != 0) {
                    OS.SelectPalette(n28, n30, false);
                    OS.RealizePalette(n28);
                }
                if (OS.IsWinCE && n25 != this.handle) {
                    OS.DeleteObject(n25);
                }
                OS.DeleteDC(n28);
                this.device.internal_dispose_GC(n24, null);
                ImageData imageData = new ImageData(n22, n23, n21, paletteData, 4, byArray3);
                imageData.transparentPixel = this.transparentPixel;
                imageData.alpha = this.alpha;
                if (this.alpha == -1 && this.alphaData != null) {
                    imageData.alphaData = new byte[this.alphaData.length];
                    System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
                }
                return imageData;
            }
        }
        SWT.error(40);
        return null;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, int n2, int n3) {
        int n4;
        int n5;
        if (n2 <= 0 || n3 <= 0) {
            SWT.error(5);
        }
        this.device = device;
        this.type = 0;
        int n6 = device.internal_new_GC(null);
        this.handle = OS.CreateCompatibleBitmap(n6, n2, n3);
        if (this.handle == 0) {
            n5 = OS.GetDeviceCaps(n6, 12);
            int n7 = n5 * (n4 = OS.GetDeviceCaps(n6, 14));
            if (n7 < 16) {
                n7 = 16;
            }
            this.handle = Image.createDIB(n2, n3, n7);
        }
        if (this.handle != 0) {
            n5 = OS.CreateCompatibleDC(n6);
            n4 = OS.SelectObject(n5, this.handle);
            OS.PatBlt(n5, 0, 0, n2, n3, 15728673);
            OS.SelectObject(n5, n4);
            OS.DeleteDC(n5);
        }
        device.internal_dispose_GC(n6, null);
        if (this.handle == 0) {
            SWT.error(2, null, device.getLastError());
        }
    }

    static int createDIB(int n2, int n3, int n4) {
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n2;
        bITMAPINFOHEADER.biHeight = -n3;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)n4;
        bITMAPINFOHEADER.biCompression = OS.IsWinCE ? 3 : 0;
        byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + (OS.IsWinCE ? 12 : 0)];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        if (OS.IsWinCE) {
            int n5 = 65280;
            int n6 = 0xFF0000;
            int n7 = -16777216;
            int n8 = BITMAPINFOHEADER.sizeof;
            byArray[n8] = (byte)((n5 & 0xFF000000) >> 24);
            byArray[n8 + 1] = (byte)((n5 & 0xFF0000) >> 16);
            byArray[n8 + 2] = (byte)((n5 & 0xFF00) >> 8);
            byArray[n8 + 3] = (byte)((n5 & 0xFF) >> 0);
            byArray[n8 + 4] = (byte)((n6 & 0xFF000000) >> 24);
            byArray[n8 + 5] = (byte)((n6 & 0xFF0000) >> 16);
            byArray[n8 + 6] = (byte)((n6 & 0xFF00) >> 8);
            byArray[n8 + 7] = (byte)((n6 & 0xFF) >> 0);
            byArray[n8 + 8] = (byte)((n7 & 0xFF000000) >> 24);
            byArray[n8 + 9] = (byte)((n7 & 0xFF0000) >> 16);
            byArray[n8 + 10] = (byte)((n7 & 0xFF00) >> 8);
            byArray[n8 + 11] = (byte)((n7 & 0xFF) >> 0);
        }
        int[] nArray = new int[1];
        return OS.CreateDIBSection(0, byArray, 0, nArray, 0, 0);
    }

    static void GetIconInfo(Image image, ICONINFO iCONINFO) {
        int[] nArray = Image.init(image.device, null, image.data);
        iCONINFO.hbmColor = nArray[0];
        iCONINFO.hbmMask = nArray[1];
    }

    static int[] init(Device device, Image image, ImageData object) {
        int[] nArray;
        int n2;
        Object object2;
        int n3;
        int n4;
        int n5;
        Object object3;
        if (image != null) {
            image.device = device;
        }
        if (OS.IsWin95 && ((ImageData)object).depth == 1 && ((ImageData)object).getTransparencyType() != 2 || ((ImageData)object).depth == 2) {
            object3 = new ImageData(((ImageData)object).width, ((ImageData)object).height, 4, ((ImageData)object).palette);
            ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, null, null, null, 255, null, 0, 0, 0, ((ImageData)object3).data, ((ImageData)object3).depth, ((ImageData)object3).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object3).width, ((ImageData)object3).height, null, null, null, false, false);
            ((ImageData)object3).transparentPixel = ((ImageData)object).transparentPixel;
            ((ImageData)object3).maskPad = ((ImageData)object).maskPad;
            ((ImageData)object3).maskData = ((ImageData)object).maskData;
            ((ImageData)object3).alpha = ((ImageData)object).alpha;
            ((ImageData)object3).alphaData = ((ImageData)object).alphaData;
            object = object3;
        }
        if (((ImageData)object).palette.isDirect) {
            object3 = ((ImageData)object).palette;
            n5 = ((PaletteData)object3).redMask;
            int n6 = ((PaletteData)object3).greenMask;
            int n7 = ((PaletteData)object3).blueMask;
            n4 = ((ImageData)object).depth;
            n3 = 1;
            PaletteData paletteData = null;
            switch (((ImageData)object).depth) {
                case 8: {
                    n4 = 16;
                    n3 = 0;
                    paletteData = new PaletteData(31744, 992, 31);
                    break;
                }
                case 16: {
                    n3 = 0;
                    if (n5 == 31744 && n6 == 992 && n7 == 31) break;
                    paletteData = new PaletteData(31744, 992, 31);
                    break;
                }
                case 24: {
                    if (n5 == 255 && n6 == 65280 && n7 == 0xFF0000) break;
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                    break;
                }
                case 32: {
                    if (n5 == 65280 && n6 == 0xFF0000 && n7 == -16777216) break;
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                    break;
                }
                default: {
                    SWT.error(38);
                }
            }
            if (paletteData != null) {
                object2 = new ImageData(((ImageData)object).width, ((ImageData)object).height, n4, paletteData);
                ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, n5, n6, n7, 255, null, 0, 0, 0, ((ImageData)object2).data, ((ImageData)object2).depth, ((ImageData)object2).bytesPerLine, n3, 0, 0, ((ImageData)object2).width, ((ImageData)object2).height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, false, false);
                if (((ImageData)object).transparentPixel != -1) {
                    ((ImageData)object2).transparentPixel = paletteData.getPixel(((PaletteData)object3).getRGB(((ImageData)object).transparentPixel));
                }
                ((ImageData)object2).maskPad = ((ImageData)object).maskPad;
                ((ImageData)object2).maskData = ((ImageData)object).maskData;
                ((ImageData)object2).alpha = ((ImageData)object).alpha;
                ((ImageData)object2).alphaData = ((ImageData)object).alphaData;
                object = object2;
            }
        }
        object3 = ((ImageData)object).palette.getRGBs();
        n5 = OS.IsWinCE && (((ImageData)object).depth == 16 || ((ImageData)object).depth == 32) ? 1 : 0;
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = ((ImageData)object).width;
        bITMAPINFOHEADER.biHeight = -((ImageData)object).height;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)((ImageData)object).depth;
        bITMAPINFOHEADER.biCompression = n5 != 0 ? 3 : 0;
        int n8 = bITMAPINFOHEADER.biClrUsed = object3 == null ? 0 : ((RGB[])object3).length;
        byte[] byArray = ((ImageData)object).palette.isDirect ? new byte[BITMAPINFOHEADER.sizeof + (n5 != 0 ? 12 : 0)] : new byte[BITMAPINFOHEADER.sizeof + ((RGB[])object3).length * 4];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        n4 = BITMAPINFOHEADER.sizeof;
        if (((ImageData)object).palette.isDirect) {
            if (n5 != 0) {
                PaletteData paletteData = ((ImageData)object).palette;
                int n9 = paletteData.redMask;
                int n10 = paletteData.greenMask;
                int n11 = paletteData.blueMask;
                if (((ImageData)object).getByteOrder() == 0) {
                    byArray[n4] = (byte)((n9 & 0xFF) >> 0);
                    byArray[n4 + 1] = (byte)((n9 & 0xFF00) >> 8);
                    byArray[n4 + 2] = (byte)((n9 & 0xFF0000) >> 16);
                    byArray[n4 + 3] = (byte)((n9 & 0xFF000000) >> 24);
                    byArray[n4 + 4] = (byte)((n10 & 0xFF) >> 0);
                    byArray[n4 + 5] = (byte)((n10 & 0xFF00) >> 8);
                    byArray[n4 + 6] = (byte)((n10 & 0xFF0000) >> 16);
                    byArray[n4 + 7] = (byte)((n10 & 0xFF000000) >> 24);
                    byArray[n4 + 8] = (byte)((n11 & 0xFF) >> 0);
                    byArray[n4 + 9] = (byte)((n11 & 0xFF00) >> 8);
                    byArray[n4 + 10] = (byte)((n11 & 0xFF0000) >> 16);
                    byArray[n4 + 11] = (byte)((n11 & 0xFF000000) >> 24);
                } else {
                    byArray[n4] = (byte)((n9 & 0xFF000000) >> 24);
                    byArray[n4 + 1] = (byte)((n9 & 0xFF0000) >> 16);
                    byArray[n4 + 2] = (byte)((n9 & 0xFF00) >> 8);
                    byArray[n4 + 3] = (byte)((n9 & 0xFF) >> 0);
                    byArray[n4 + 4] = (byte)((n10 & 0xFF000000) >> 24);
                    byArray[n4 + 5] = (byte)((n10 & 0xFF0000) >> 16);
                    byArray[n4 + 6] = (byte)((n10 & 0xFF00) >> 8);
                    byArray[n4 + 7] = (byte)((n10 & 0xFF) >> 0);
                    byArray[n4 + 8] = (byte)((n11 & 0xFF000000) >> 24);
                    byArray[n4 + 9] = (byte)((n11 & 0xFF0000) >> 16);
                    byArray[n4 + 10] = (byte)((n11 & 0xFF00) >> 8);
                    byArray[n4 + 11] = (byte)((n11 & 0xFF) >> 0);
                }
            }
        } else {
            n3 = 0;
            while (n3 < ((RGB[])object3).length) {
                byArray[n4] = (byte)object3[n3].blue;
                byArray[n4 + 1] = (byte)((RGB)object3[n3]).green;
                byArray[n4 + 2] = (byte)((RGB)object3[n3]).red;
                byArray[n4 + 3] = 0;
                n4 += 4;
                ++n3;
            }
        }
        if ((n2 = OS.CreateDIBSection(0, byArray, 0, nArray = new int[1], 0, 0)) == 0) {
            SWT.error(2);
        }
        object2 = ((ImageData)object).data;
        if (((ImageData)object).scanlinePad != 4 && ((ImageData)object).bytesPerLine % 4 != 0) {
            object2 = ImageData.convertPad((byte[])object2, ((ImageData)object).width, ((ImageData)object).height, ((ImageData)object).depth, ((ImageData)object).scanlinePad, 4);
        }
        OS.MoveMemory(nArray[0], (byte[])object2, ((Object)object2).length);
        int[] nArray2 = null;
        if (((ImageData)object).getTransparencyType() == 2) {
            int n12 = device.internal_new_GC(null);
            int n13 = OS.CreateCompatibleDC(n12);
            OS.SelectObject(n13, n2);
            int n14 = OS.CreateCompatibleBitmap(n12, ((ImageData)object).width, ((ImageData)object).height);
            if (n14 == 0) {
                SWT.error(2);
            }
            int n15 = OS.CreateCompatibleDC(n12);
            OS.SelectObject(n15, n14);
            OS.BitBlt(n15, 0, 0, ((ImageData)object).width, ((ImageData)object).height, n13, 0, 0, 0xCC0020);
            device.internal_dispose_GC(n12, null);
            byte[] byArray2 = ImageData.convertPad(((ImageData)object).maskData, ((ImageData)object).width, ((ImageData)object).height, 1, ((ImageData)object).maskPad, 2);
            int n16 = OS.CreateBitmap(((ImageData)object).width, ((ImageData)object).height, 1, 1, byArray2);
            if (n16 == 0) {
                SWT.error(2);
            }
            OS.SelectObject(n13, n16);
            OS.PatBlt(n13, 0, 0, ((ImageData)object).width, ((ImageData)object).height, 0x550009);
            OS.DeleteDC(n13);
            OS.DeleteDC(n15);
            OS.DeleteObject(n2);
            if (image == null) {
                nArray2 = new int[]{n14, n16};
            } else {
                ICONINFO iCONINFO = new ICONINFO();
                iCONINFO.fIcon = true;
                iCONINFO.hbmColor = n14;
                iCONINFO.hbmMask = n16;
                int n17 = OS.CreateIconIndirect(iCONINFO);
                if (n17 == 0) {
                    SWT.error(2);
                }
                OS.DeleteObject(n14);
                OS.DeleteObject(n16);
                image.handle = n17;
                image.type = 1;
                if (OS.IsWinCE) {
                    image.data = object;
                }
            }
        } else if (image == null) {
            nArray2 = new int[]{n2};
        } else {
            image.handle = n2;
            image.type = 0;
            image.transparentPixel = ((ImageData)object).transparentPixel;
            if (image.transparentPixel == -1) {
                image.alpha = ((ImageData)object).alpha;
                if (((ImageData)object).alpha == -1 && ((ImageData)object).alphaData != null) {
                    int n18 = ((ImageData)object).alphaData.length;
                    image.alphaData = new byte[n18];
                    System.arraycopy(((ImageData)object).alphaData, 0, image.alphaData, 0, n18);
                }
            }
        }
        return nArray2;
    }

    /*
     * Unable to fully structure code
     */
    static int[] init(Device var0, Image var1_1, ImageData var2_2, ImageData var3_3) {
        block13: {
            block12: {
                var5_4 = 0;
                if (!var2_2.palette.isDirect) break block12;
                var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, var2_2.palette);
                break block13;
            }
            var6_6 = new RGB(0, 0, 0);
            var7_7 = var2_2.getRGBs();
            if (var2_2.transparentPixel == -1) ** GOTO lbl27
            var8_8 = new RGB[var7_7.length];
            System.arraycopy(var7_7, 0, var8_8, 0, var7_7.length);
            if (var2_2.transparentPixel >= var8_8.length) {
                var7_7 = new RGB[var2_2.transparentPixel + 1];
                System.arraycopy(var8_8, 0, var7_7, 0, var8_8.length);
                var9_10 = var8_8.length;
                while (var9_10 <= var2_2.transparentPixel) {
                    var7_7[var9_10] = new RGB(0, 0, 0);
                    ++var9_10;
                }
            } else {
                var8_8[var2_2.transparentPixel] = var6_6;
                var7_7 = var8_8;
            }
            var5_4 = var2_2.transparentPixel;
            var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, new PaletteData(var7_7));
            break block13;
            while (!var7_7[var5_4].equals(var6_6)) {
                ++var5_4;
lbl27:
                // 2 sources

                if (var5_4 < var7_7.length) continue;
            }
            if (var5_4 == var7_7.length) {
                if (1 << var2_2.depth > var7_7.length) {
                    var8_8 = new RGB[var7_7.length + 1];
                    System.arraycopy(var7_7, 0, var8_8, 0, var7_7.length);
                    var8_8[var7_7.length] = var6_6;
                    var7_7 = var8_8;
                } else {
                    var5_4 = -1;
                }
            }
            var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, new PaletteData(var7_7));
        }
        if (var5_4 == -1) {
            System.arraycopy(var2_2.data, 0, var4_5.data, 0, var4_5.data.length);
        } else {
            var6_6 = new int[var4_5.width];
            var7_7 = (RGB[])new int[var3_3.width];
            var8_9 = 0;
            while (var8_9 < var4_5.height) {
                var2_2.getPixels(0, var8_9, var4_5.width, (int[])var6_6, 0);
                var3_3.getPixels(0, var8_9, var3_3.width, (int[])var7_7, 0);
                var9_10 = 0;
                while (var9_10 < ((Object)var6_6).length) {
                    if (var7_7[var9_10] == false) {
                        var6_6[var9_10] = var5_4;
                    }
                    ++var9_10;
                }
                var4_5.setPixels(0, var8_9, var2_2.width, (int[])var6_6, 0);
                ++var8_9;
            }
        }
        var4_5.maskPad = var3_3.scanlinePad;
        var4_5.maskData = var3_3.data;
        return Image.init(var0, var1_1, var4_5);
    }

    void init(Device device, ImageData imageData) {
        if (imageData == null) {
            SWT.error(4);
        }
        Image.init(device, this, imageData);
    }

    public int internal_new_GC(GCData gCData) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        int n2 = this.device.internal_new_GC(null);
        int n3 = OS.CreateCompatibleDC(n2);
        this.device.internal_dispose_GC(n2, null);
        if (n3 == 0) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n4 = 0x6000000;
            if ((gCData.style & n4) != 0) {
                gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this.device;
            gCData.image = this;
            gCData.hFont = this.device.systemFont;
        }
        return n3;
    }

    public void internal_dispose_GC(int n2, GCData gCData) {
        OS.DeleteDC(n2);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (OS.IsWinCE) {
            return;
        }
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        int n2 = this.device.internal_new_GC(null);
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
        int n3 = OS.CreateCompatibleDC(n2);
        OS.SelectObject(n3, this.handle);
        int n4 = 1 << bITMAP.bmBitsPixel;
        byte[] byArray = new byte[n4 * 4];
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        int n5 = OS.GetDIBColorTable(n3, 0, n4, byArray);
        int n6 = this.transparentPixel * 4;
        byArray[n6] = (byte)color.getBlue();
        byArray[n6 + 1] = (byte)color.getGreen();
        byArray[n6 + 2] = (byte)color.getRed();
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        OS.SetDIBColorTable(n3, 0, n5, byArray);
        OS.DeleteDC(n3);
        this.device.internal_dispose_GC(n2, null);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }

    public static Image win32_new(Device device, int n2, int n3) {
        if (device == null) {
            device = Device.getDevice();
        }
        Image image = new Image();
        image.type = n2;
        image.handle = n3;
        image.device = device;
        return image;
    }
}

