/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.CREATESTRUCT;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.HELPINFO;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public int handle;
    Composite parent;
    Cursor cursor;
    Menu menu;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    Image backgroundImage;
    int drawCount;
    int foreground;
    int background;

    Control() {
    }

    public Control(Composite composite, int n2) {
        super(composite, n2);
        this.parent = composite;
        this.createWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(dragDetectListener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseTrackListener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseWheelListener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    int borderHandle() {
        return this.handle;
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFBFF;
        Composite composite = this.parent;
        while (true) {
            int n2;
            if ((n2 = composite.backgroundMode) != 0) {
                if (n2 == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x100) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x400;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBorder() {
        if (this.getBorderWidth() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void checkBuffered() {
        this.style &= 0xDFFFFFFF;
    }

    boolean checkHandle(int n2) {
        return n2 == this.handle;
    }

    void checkMirrored() {
        int n2;
        if ((this.style & 0x4000000) != 0 && ((n2 = OS.GetWindowLong(this.handle, -20)) & 0x400000) != 0) {
            this.style |= 0x8000000;
        }
    }

    public Point computeSize(int n2, int n3) {
        return this.computeSize(n2, n3, true);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 64;
        int n5 = 64;
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        int n6 = this.getBorderWidth();
        return new Point(n4 += n6 * 2, n5 += n6 * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n2 = 0;
            while (n2 < controlArray.length) {
                if (controlArray[n2] == this) break;
                ++n2;
            }
            if (n2 == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    void createHandle() {
        int n2;
        int n3 = this.widgetParent();
        this.handle = OS.CreateWindowEx(this.widgetExtStyle(), this.windowClass(), null, this.widgetStyle(), Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, n3, 0, OS.GetModuleHandle(null), this.widgetCreateStruct());
        if (this.handle == 0) {
            this.error(2);
        }
        if (((n2 = OS.GetWindowLong(this.handle, -16)) & 0x40000000) != 0) {
            OS.SetWindowLong(this.handle, -12, this.handle);
        }
        if (OS.IsDBLocale && n3 != 0) {
            int n4 = OS.ImmGetContext(n3);
            OS.ImmAssociateContext(this.handle, n4);
            OS.ImmReleaseContext(n3, n4);
        }
    }

    void createWidget() {
        this.state |= 0x8000;
        this.background = -1;
        this.foreground = -1;
        this.checkOrientation(this.parent);
        this.createHandle();
        this.checkBackground();
        this.checkBuffered();
        this.register();
        this.subclass();
        this.setDefaultFont();
        this.checkMirrored();
        this.checkBorder();
        if ((this.state & 0x400) != 0) {
            this.setBackground();
        }
    }

    int defaultBackground() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return OS.GetSysColor(OS.COLOR_BTNFACE);
    }

    int defaultFont() {
        return this.display.getSystemFont().handle;
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_WINDOWTEXT);
    }

    void deregister() {
        this.display.removeControl(this.handle);
    }

    void destroyWidget() {
        int n2 = this.topHandle();
        this.releaseHandle();
        if (n2 != 0) {
            OS.DestroyWindow(n2);
        }
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent mouseEvent) {
        this.checkWidget();
        if (mouseEvent == null) {
            this.error(4);
        }
        return this.dragDetect(mouseEvent.button, mouseEvent.count, mouseEvent.stateMask, mouseEvent.x, mouseEvent.y);
    }

    boolean dragDetect(int n2, int n3, int n4, int n5, int n6) {
        if (n2 != 1 || n3 != 1) {
            return false;
        }
        boolean bl2 = this.dragDetect(this.handle, n5, n6, false, null, null);
        if (OS.GetKeyState(1) < 0 && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if (!bl2) {
            if (n2 == 1 && OS.GetKeyState(27) >= 0) {
                int n7 = 0;
                if ((n4 & 0x40000) != 0) {
                    n7 |= 8;
                }
                if ((n4 & 0x20000) != 0) {
                    n7 |= 4;
                }
                if ((n4 & 0x10000) != 0) {
                    n7 |= 0x20;
                }
                if ((n4 & 0x80000) != 0) {
                    n7 |= 1;
                }
                if ((n4 & 0x100000) != 0) {
                    n7 |= 0x10;
                }
                if ((n4 & 0x200000) != 0) {
                    n7 |= 2;
                }
                if ((n4 & 0x800000) != 0) {
                    n7 |= 0x20;
                }
                if ((n4 & 0x2000000) != 0) {
                    n7 |= 0x40;
                }
                int n8 = n5 & 0xFFFF | n6 << 16 & 0xFFFF0000;
                OS.SendMessage(this.handle, 514, n7, n8);
            }
            return false;
        }
        return this.sendDragEvent(n2, n4, n5, n6);
    }

    void drawBackground(int n2) {
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        this.drawBackground(n2, rECT);
    }

    void drawBackground(int n2, RECT rECT) {
        this.drawBackground(n2, rECT, -1);
    }

    void drawBackground(int n2, RECT rECT, int n3) {
        Control control = this.findBackgroundControl();
        if (control != null) {
            if (control.backgroundImage != null) {
                this.fillImageBackground(n2, control, rECT);
                return;
            }
            n3 = control.getBackgroundPixel();
        }
        if (n3 == -1 && (this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (control = this.findThemeControl()) != null) {
            this.fillThemeBackground(n2, control, rECT);
            return;
        }
        if (n3 == -1) {
            n3 = this.getBackgroundPixel();
        }
        this.fillBackground(n2, n3, rECT);
    }

    void drawImageBackground(int n2, int n3, int n4, RECT rECT) {
        RECT rECT2 = new RECT();
        OS.GetClientRect(n3, rECT2);
        OS.MapWindowPoints(n3, this.handle, rECT2, 2);
        int n5 = this.findBrush(n4, 3);
        POINT pOINT = new POINT();
        OS.GetWindowOrgEx(n2, pOINT);
        OS.SetBrushOrgEx(n2, -rECT2.left - pOINT.x, -rECT2.top - pOINT.y, pOINT);
        int n6 = OS.SelectObject(n2, n5);
        OS.PatBlt(n2, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
        OS.SetBrushOrgEx(n2, pOINT.x, pOINT.y, null);
        OS.SelectObject(n2, n6);
    }

    void drawThemeBackground(int n2, int n3, RECT rECT) {
    }

    void enableDrag(boolean bl2) {
    }

    void enableWidget(boolean bl2) {
        OS.EnableWindow(this.handle, bl2);
    }

    void fillBackground(int n2, int n3, RECT rECT) {
        if (rECT.left > rECT.right || rECT.top > rECT.bottom) {
            return;
        }
        int n4 = this.display.hPalette;
        if (n4 != 0) {
            OS.SelectPalette(n2, n4, false);
            OS.RealizePalette(n2);
        }
        OS.FillRect(n2, rECT, this.findBrush(n3, 0));
    }

    void fillImageBackground(int n2, Control control, RECT rECT) {
        Image image;
        if (rECT.left > rECT.right || rECT.top > rECT.bottom) {
            return;
        }
        if (control != null && (image = control.backgroundImage) != null) {
            control.drawImageBackground(n2, this.handle, image.handle, rECT);
        }
    }

    void fillThemeBackground(int n2, Control control, RECT rECT) {
        if (rECT.left > rECT.right || rECT.top > rECT.bottom) {
            return;
        }
        if (control != null) {
            control.drawThemeBackground(n2, this.handle, rECT);
        }
    }

    Control findBackgroundControl() {
        if (this.background != -1 || this.backgroundImage != null) {
            return this;
        }
        return (this.state & 0x400) != 0 ? this.parent.findBackgroundControl() : null;
    }

    int findBrush(int n2, int n3) {
        return this.parent.findBrush(n2, n3);
    }

    Cursor findCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent.findCursor();
    }

    Control findImageControl() {
        Control control = this.findBackgroundControl();
        return control != null && control.backgroundImage != null ? control : null;
    }

    Control findThemeControl() {
        return this.background == -1 && this.backgroundImage == null ? this.parent.findThemeControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    char findMnemonic(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return '\u0000';
            }
            if (string.charAt(n2) != '&') {
                return string.charAt(n2);
            }
            if (++n2 >= n3) break;
        }
        return '\u0000';
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        shell2.fixShell(shell, this);
        decorations2.fixDecorations(decorations, this, menuArray);
    }

    void fixFocus(Control control) {
        Shell shell = this.getShell();
        Control control2 = this;
        while (control2 != shell && (control2 = control2.parent) != null) {
            if (!control2.setFixedFocus()) continue;
            return;
        }
        shell.setSavedFocus(control);
        OS.SetFocus(0);
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations decorations = this.menuShell();
        decorations.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        decorations.setSavedFocus(null);
        OS.SetFocus(this.handle);
        if (this.isDisposed()) {
            return false;
        }
        decorations.setSavedFocus(this);
        return this.isFocusControl();
    }

    void forceResize() {
        if (this.parent == null) {
            return;
        }
        WINDOWPOS[] wINDOWPOSArray = this.parent.lpwp;
        if (wINDOWPOSArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < wINDOWPOSArray.length) {
            WINDOWPOS wINDOWPOS = wINDOWPOSArray[n2];
            if (wINDOWPOS != null && wINDOWPOS.hwnd == this.handle) {
                this.SetWindowPos(wINDOWPOS.hwnd, 0, wINDOWPOS.x, wINDOWPOS.y, wINDOWPOS.cx, wINDOWPOS.cy, wINDOWPOS.flags);
                wINDOWPOSArray[n2] = null;
                return;
            }
            ++n2;
        }
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.win32_new(this.display, control.getBackgroundPixel());
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    int getBackgroundPixel() {
        return this.background != -1 ? this.background : this.defaultBackground();
    }

    public int getBorderWidth() {
        this.checkWidget();
        int n2 = this.borderHandle();
        int n3 = OS.GetWindowLong(n2, -20);
        if ((n3 & 0x200) != 0) {
            return OS.GetSystemMetrics(45);
        }
        if ((n3 & 0x20000) != 0) {
            return OS.GetSystemMetrics(5);
        }
        int n4 = OS.GetWindowLong(n2, -16);
        if ((n4 & 0x800000) != 0) {
            return OS.GetSystemMetrics(5);
        }
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.topHandle(), rECT);
        int n2 = this.parent == null ? 0 : this.parent.handle;
        OS.MapWindowPoints(0, n2, rECT, 2);
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n3, n4);
    }

    int getCodePage() {
        if (OS.IsUnicode) {
            return 0;
        }
        int n2 = OS.SendMessage(this.handle, 49, 0, 0);
        LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        OS.GetObject(n2, LOGFONT.sizeof, lOGFONT);
        int n3 = lOGFONT.lfCharSet & 0xFF;
        int[] nArray = new int[8];
        if (OS.TranslateCharsetInfo(n3, nArray, 1)) {
            return nArray[1];
        }
        return OS.GetACP();
    }

    String getClipboardText() {
        String string = "";
        if (OS.OpenClipboard(0)) {
            int n2 = OS.GetClipboardData(OS.IsUnicode ? 13 : 1);
            if (n2 != 0) {
                int n3 = OS.GlobalSize(n2) / TCHAR.sizeof * TCHAR.sizeof;
                int n4 = OS.GlobalLock(n2);
                if (n4 != 0) {
                    TCHAR tCHAR = new TCHAR(0, n3 / TCHAR.sizeof);
                    OS.MoveMemory(tCHAR, n4, n3);
                    string = tCHAR.toString(0, tCHAR.strlen());
                    OS.GlobalUnlock(n2);
                }
            }
            OS.CloseClipboard();
        }
        return string;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x8000) != 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.IsWindowEnabled(this.handle);
    }

    public Font getFont() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n2 == 0) {
            n2 = this.defaultFont();
        }
        return Font.win32_new(this.display, n2);
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.getForegroundPixel());
    }

    int getForegroundPixel() {
        return this.foreground != -1 ? this.foreground : this.defaultForeground();
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.topHandle(), rECT);
        int n2 = this.parent == null ? 0 : this.parent.handle;
        OS.MapWindowPoints(0, n2, rECT, 2);
        return new Point(rECT.left, rECT.top);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return this.display.getPrimaryMonitor();
        }
        int n2 = OS.MonitorFromWindow(this.handle, 2);
        MONITORINFO mONITORINFO = new MONITORINFO();
        mONITORINFO.cbSize = MONITORINFO.sizeof;
        OS.GetMonitorInfo(n2, mONITORINFO);
        Monitor monitor = new Monitor();
        monitor.handle = n2;
        monitor.x = mONITORINFO.rcMonitor_left;
        monitor.y = mONITORINFO.rcMonitor_top;
        monitor.width = mONITORINFO.rcMonitor_right - mONITORINFO.rcMonitor_left;
        monitor.height = mONITORINFO.rcMonitor_bottom - mONITORINFO.rcMonitor_top;
        monitor.clientX = mONITORINFO.rcWork_left;
        monitor.clientY = mONITORINFO.rcWork_top;
        monitor.clientWidth = mONITORINFO.rcWork_right - mONITORINFO.rcWork_left;
        monitor.clientHeight = mONITORINFO.rcWork_bottom - mONITORINFO.rcWork_top;
        return monitor;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int n2 = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++n2;
            control = control.parent;
        }
        control = this;
        Control[] controlArray = new Control[n2];
        while (control != shell) {
            controlArray[--n2] = control;
            control = control.parent;
        }
        return controlArray;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.topHandle(), rECT);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Point(n2, n3);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        if (this.drawCount != 0) {
            return (this.state & 0x10) == 0;
        }
        int n2 = OS.GetWindowLong(this.handle, -16);
        return (n2 & 0x10000000) != 0;
    }

    boolean hasCursor() {
        RECT rECT = new RECT();
        if (!OS.GetClientRect(this.handle, rECT)) {
            return false;
        }
        OS.MapWindowPoints(this.handle, 0, rECT, 2);
        POINT pOINT = new POINT();
        return OS.GetCursorPos(pOINT) && OS.PtInRect(rECT, pOINT);
    }

    boolean hasFocus() {
        int n2 = OS.GetFocus();
        while (n2 != 0) {
            if (n2 == this.handle) {
                return true;
            }
            if (this.display.getControl(n2) != null) {
                return false;
            }
            n2 = OS.GetParent(n2);
        }
        return false;
    }

    public int internal_new_GC(GCData gCData) {
        this.checkWidget();
        int n2 = this.handle;
        if (gCData != null && gCData.hwnd != 0) {
            n2 = gCData.hwnd;
        }
        if (gCData != null) {
            gCData.hwnd = n2;
        }
        int n3 = 0;
        n3 = gCData == null || gCData.ps == null ? OS.GetDC(n2) : OS.BeginPaint(n2, gCData.ps);
        if (n3 == 0) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n4;
            Control control;
            int n5;
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
                n5 = 0x6000000;
                if ((gCData.style & n5) != 0) {
                    gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
                } else {
                    int n6 = OS.GetLayout(n3);
                    gCData.style = (n6 & 1) != 0 ? (gCData.style |= 0xC000000) : (gCData.style |= 0x2000000);
                }
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this.display;
            n5 = this.getForegroundPixel();
            if (n5 != OS.GetTextColor(n3)) {
                gCData.foreground = n5;
            }
            if ((control = this.findBackgroundControl()) == null) {
                control = this;
            }
            if ((n4 = control.getBackgroundPixel()) != OS.GetBkColor(n3)) {
                gCData.background = n4;
            }
            gCData.hFont = OS.SendMessage(n2, 49, 0, 0);
            gCData.uiState = OS.SendMessage(n2, 297, 0, 0);
        }
        return n3;
    }

    public void internal_dispose_GC(int n2, GCData gCData) {
        this.checkWidget();
        int n3 = this.handle;
        if (gCData != null && gCData.hwnd != 0) {
            n3 = gCData.hwnd;
        }
        if (gCData == null || gCData.ps == null) {
            OS.ReleaseDC(n3, n2);
        } else {
            OS.EndPaint(n3, gCData.ps);
        }
    }

    boolean isActive() {
        Shell shell = this.display.getModalDialogShell();
        if (shell != null && shell != this.getShell()) {
            return false;
        }
        Shell shell2 = null;
        Shell[] shellArray = this.display.modalShells;
        if (shellArray != null) {
            int n2 = 196608;
            int n3 = shellArray.length;
            while (--n3 >= 0) {
                Shell shell3 = shellArray[n3];
                if (shell3 == null) continue;
                if ((shell3.style & n2) != 0) {
                    Control control = this;
                    while (control != null) {
                        if (control == shell3) break;
                        control = control.parent;
                    }
                    if (control == shell3) break;
                    return false;
                }
                if ((shell3.style & 0x8000) == 0) continue;
                if (shell2 == null) {
                    shell2 = this.getShell();
                }
                if (shell3.parent != shell2) continue;
                return false;
            }
        }
        if (shell2 == null) {
            shell2 = this.getShell();
        }
        return shell2.getEnabled();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control control = this.display.focusControl;
        if (control != null && !control.isDisposed()) {
            return this == control;
        }
        return this.hasFocus();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point point = control.getSize();
            if (point.x == 0 || point.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int n2;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n2 = 0;
            while (n2 < controlArray.length) {
                if (controlArray[n2] == this) {
                    return true;
                }
                ++n2;
            }
        }
        return ((n2 = OS.GetWindowLong(this.handle, -16)) & 0x10000) != 0;
    }

    boolean isTabItem() {
        int n2;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n2 = 0;
            while (n2 < controlArray.length) {
                if (controlArray[n2] == this) {
                    return false;
                }
                ++n2;
            }
        }
        if (((n2 = OS.GetWindowLong(this.handle, -16)) & 0x10000) != 0) {
            return false;
        }
        int n3 = OS.SendMessage(this.handle, 135, 0, 0);
        if ((n3 & 0x100) != 0) {
            return false;
        }
        if ((n3 & 4) != 0) {
            return false;
        }
        if ((n3 & 1) != 0) {
            return false;
        }
        return (n3 & 2) == 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        if (OS.IsWindowVisible(this.handle)) {
            return true;
        }
        return this.getVisible() && this.parent.isVisible();
    }

    void mapEvent(int n2, Event event) {
        if (n2 != this.handle) {
            POINT pOINT = new POINT();
            pOINT.x = event.x;
            pOINT.y = event.y;
            OS.MapWindowPoints(n2, this.handle, pOINT, 1);
            event.x = pOINT.x;
            event.y = pOINT.y;
        }
    }

    void markLayout(boolean bl2, boolean bl3) {
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char c2) {
        return false;
    }

    boolean mnemonicMatch(char c2) {
        return false;
    }

    public void moveAbove(Control control) {
        int n2;
        this.checkWidget();
        int n3 = this.topHandle();
        int n4 = 0;
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            n2 = control.topHandle();
            if (n2 == 0 || n2 == n3) {
                return;
            }
            n4 = OS.GetWindow(n2, 3);
            if (n4 == 0 || n4 == n2) {
                n4 = 0;
            }
        }
        n2 = 19;
        this.SetWindowPos(n3, n4, 0, 0, 0, 0, n2);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        int n2 = this.topHandle();
        int n3 = 1;
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            n3 = control.topHandle();
        } else {
            Shell shell = this.getShell();
            if (this == shell && this.parent != null) {
                int n4;
                int n5 = n4 = this.parent.handle;
                n3 = OS.GetWindow(n5, 3);
                while (n3 != 0 && n3 != n5) {
                    if (OS.GetWindow(n3, 4) == n4) break;
                    n5 = n3;
                    n3 = OS.GetWindow(n5, 3);
                }
                if (n3 == n5) {
                    return;
                }
            }
        }
        if (n3 == 0 || n3 == n2) {
            return;
        }
        int n6 = 19;
        this.SetWindowPos(n2, n3, 0, 0, 0, 0, n6);
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    GC new_GC(GCData gCData) {
        return GC.win32_new(this, gCData);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean bl2) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, bl2));
    }

    public void redraw() {
        this.checkWidget();
        this.redraw(false);
    }

    void redraw(boolean bl2) {
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n2 = 1029;
            if (bl2) {
                n2 |= 0x80;
            }
            OS.RedrawWindow(this.handle, null, 0, n2);
        }
    }

    public void redraw(int n2, int n3, int n4, int n5, boolean bl2) {
        this.checkWidget();
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, rECT, true);
        } else {
            int n6 = 1029;
            if (bl2) {
                n6 |= 0x80;
            }
            OS.RedrawWindow(this.handle, rECT, 0, n6);
        }
    }

    boolean redrawChildren() {
        if (!OS.IsWindowVisible(this.handle)) {
            return false;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                OS.InvalidateRect(this.handle, null, true);
                return true;
            }
        } else if (control.backgroundImage != null) {
            OS.InvalidateRect(this.handle, null, true);
            return true;
        }
        return false;
    }

    void register() {
        this.display.addControl(this.handle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
        this.parent = null;
    }

    void releaseParent() {
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (OS.IsDBLocale) {
            OS.ImmAssociateContext(this.handle, 0);
        }
        if (this.toolTipText != null) {
            this.setToolTipText(this.getShell(), null);
        }
        this.toolTipText = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.backgroundImage = null;
        this.menu = null;
        this.cursor = null;
        this.unsubclass();
        this.deregister();
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, dragDetectListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, mouseTrackListener);
        this.eventTable.unhook(7, mouseTrackListener);
        this.eventTable.unhook(32, mouseTrackListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, mouseWheelListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    void showWidget(boolean bl2) {
        int n2 = this.topHandle();
        OS.ShowWindow(n2, bl2 ? 5 : 0);
        if (this.handle != n2) {
            OS.ShowWindow(this.handle, bl2 ? 5 : 0);
        }
    }

    boolean sendFocusEvent(int n2) {
        Shell shell = this.getShell();
        Display display = this.display;
        display.focusEvent = n2;
        display.focusControl = this;
        this.sendEvent(n2);
        display.focusEvent = 0;
        display.focusControl = null;
        if (!shell.isDisposed()) {
            switch (n2) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.getActiveShell()) break;
                    shell.setActiveControl(null);
                }
            }
        }
        return true;
    }

    void setBackground() {
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            Shell shell = this.getShell();
            shell.releaseBrushes();
            this.setBackgroundImage(control.backgroundImage.handle);
        } else {
            this.setBackgroundPixel(control.background == -1 ? control.defaultBackground() : control.background);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        int n2 = -1;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            n2 = color.handle;
        }
        if (n2 == this.background) {
            return;
        }
        this.background = n2;
        this.updateBackgroundColor();
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (image.type != 0) {
                this.error(5);
            }
        }
        if (this.backgroundImage == image) {
            return;
        }
        this.backgroundImage = image;
        Shell shell = this.getShell();
        shell.releaseBrushes();
        this.updateBackgroundImage();
    }

    void setBackgroundImage(int n2) {
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n3 = 1029;
            OS.RedrawWindow(this.handle, null, 0, n3);
        }
    }

    void setBackgroundPixel(int n2) {
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n3 = 1029;
            OS.RedrawWindow(this.handle, null, 0, n3);
        }
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        int n6 = 52;
        this.setBounds(n2, n3, Math.max(0, n4), Math.max(0, n5), n6);
    }

    void setBounds(int n2, int n3, int n4, int n5, int n6) {
        this.setBounds(n2, n3, n4, n5, n6, true);
    }

    void setBounds(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        int n7 = this.topHandle();
        if (bl2 && this.parent != null) {
            WINDOWPOS[] wINDOWPOSArray;
            this.forceResize();
            if (OS.GetWindow(this.handle, 5) == 0) {
                if (this.findImageControl() != null) {
                    n6 |= 0x100;
                } else if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.findThemeControl() != null) {
                    n6 |= 0x100;
                }
            }
            if ((wINDOWPOSArray = this.parent.lpwp) == null) {
                this.SetWindowPos(n7, 0, n2, n3, n4, n5, n6);
            } else {
                WINDOWPOS[] wINDOWPOSArray2;
                int n8 = 0;
                while (n8 < wINDOWPOSArray.length) {
                    if (wINDOWPOSArray[n8] == null) break;
                    ++n8;
                }
                if (n8 == wINDOWPOSArray.length) {
                    wINDOWPOSArray2 = new WINDOWPOS[wINDOWPOSArray.length + 4];
                    System.arraycopy(wINDOWPOSArray, 0, wINDOWPOSArray2, 0, wINDOWPOSArray.length);
                    wINDOWPOSArray = wINDOWPOSArray2;
                    this.parent.lpwp = wINDOWPOSArray2;
                }
                wINDOWPOSArray2 = new WINDOWPOS();
                wINDOWPOSArray2.hwnd = n7;
                wINDOWPOSArray2.x = n2;
                wINDOWPOSArray2.y = n3;
                wINDOWPOSArray2.cx = n4;
                wINDOWPOSArray2.cy = n5;
                wINDOWPOSArray2.flags = n6;
                wINDOWPOSArray[n8] = wINDOWPOSArray2;
            }
        } else {
            this.SetWindowPos(n7, 0, n2, n3, n4, n5, n6);
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setCapture(boolean bl2) {
        this.checkWidget();
        if (bl2) {
            OS.SetCapture(this.handle);
        } else if (OS.GetCapture() == this.handle) {
            OS.ReleaseCapture();
        }
    }

    void setCursor() {
        int n2 = 0x2000001;
        OS.SendMessage(this.handle, 32, this.handle, n2);
    }

    public void setCursor(Cursor cursor) {
        Object object;
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            SWT.error(5);
        }
        this.cursor = cursor;
        if (OS.IsWinCE) {
            int n2 = cursor != null ? cursor.handle : 0;
            OS.SetCursor(n2);
            return;
        }
        int n3 = OS.GetCapture();
        if (n3 == 0) {
            object = new POINT();
            if (!OS.GetCursorPos((POINT)object)) {
                return;
            }
            int n4 = n3 = OS.WindowFromPoint((POINT)object);
            while (n4 != 0 && n4 != this.handle) {
                n4 = OS.GetParent(n4);
            }
            if (n4 == 0) {
                return;
            }
        }
        if ((object = this.display.getControl(n3)) == null) {
            object = this;
        }
        ((Control)object).setCursor();
    }

    void setDefaultFont() {
        int n2 = this.display.getSystemFont().handle;
        OS.SendMessage(this.handle, 48, n2, 0);
    }

    public void setDragDetect(boolean bl2) {
        this.checkWidget();
        this.state = bl2 ? (this.state |= 0x8000) : (this.state &= 0xFFFF7FFF);
        this.enableDrag(bl2);
    }

    public void setEnabled(boolean bl2) {
        this.checkWidget();
        Control control = null;
        boolean bl3 = false;
        if (!bl2 && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl3 = this.isFocusAncestor(control);
        }
        this.enableWidget(bl2);
        if (bl3) {
            this.fixFocus(control);
        }
    }

    boolean setFixedFocus() {
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        int n2 = 0;
        if (font != null) {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            n2 = font.handle;
        }
        if (n2 == 0) {
            n2 = this.defaultFont();
        }
        OS.SendMessage(this.handle, 48, n2, 1);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        int n2 = -1;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            n2 = color.handle;
        }
        if (n2 == this.foreground) {
            return;
        }
        this.foreground = n2;
        this.setForegroundPixel(n2);
    }

    void setForegroundPixel(int n2) {
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public void setLocation(int n2, int n3) {
        this.checkWidget();
        int n4 = 21;
        if (!OS.IsWinCE) {
            n4 |= 0x20;
        }
        this.setBounds(n2, n3, 0, 0, n4);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    boolean setRadioFocus() {
        return false;
    }

    boolean setRadioSelection(boolean bl2) {
        return false;
    }

    public void setRedraw(boolean bl2) {
        int n2;
        this.checkWidget();
        if (this.drawCount == 0 && ((n2 = OS.GetWindowLong(this.handle, -16)) & 0x10000000) == 0) {
            this.state |= 0x10;
        }
        if (bl2) {
            if (--this.drawCount == 0) {
                n2 = this.topHandle();
                OS.SendMessage(n2, 11, 1, 0);
                if (this.handle != n2) {
                    OS.SendMessage(this.handle, 11, 1, 0);
                }
                if ((this.state & 0x10) != 0) {
                    this.state &= 0xFFFFFFEF;
                    OS.ShowWindow(n2, 0);
                    if (this.handle != n2) {
                        OS.ShowWindow(this.handle, 0);
                    }
                } else if (OS.IsWinCE) {
                    OS.InvalidateRect(n2, null, true);
                    if (this.handle != n2) {
                        OS.InvalidateRect(this.handle, null, true);
                    }
                } else {
                    int n3 = 1157;
                    OS.RedrawWindow(n2, null, 0, n3);
                }
            }
        } else if (this.drawCount++ == 0) {
            n2 = this.topHandle();
            OS.SendMessage(n2, 11, 0, 0);
            if (this.handle != n2) {
                OS.SendMessage(this.handle, 11, 0, 0);
            }
        }
    }

    boolean setSavedFocus() {
        return this.forceFocus();
    }

    public void setSize(int n2, int n3) {
        this.checkWidget();
        int n4 = 54;
        this.setBounds(0, 0, Math.max(0, n2), Math.max(0, n3), n4);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.setToolTipText(this.getShell(), string);
    }

    void setToolTipText(Shell shell, String string) {
        shell.setToolTipText(this.handle, string);
    }

    public void setVisible(boolean bl2) {
        int n2;
        this.checkWidget();
        if (this.drawCount != 0 ? (this.state & 0x10) == 0 == bl2 : ((n2 = OS.GetWindowLong(this.handle, -16)) & 0x10000000) != 0 == bl2) {
            return;
        }
        if (bl2) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean bl3 = false;
        if (!bl2 && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl3 = this.isFocusAncestor(control);
        }
        if (this.drawCount != 0) {
            this.state = bl2 ? this.state & 0xFFFFFFEF : this.state | 0x10;
        } else {
            this.showWidget(bl2);
            if (this.isDisposed()) {
                return;
            }
        }
        if (!bl2) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (bl3) {
            this.fixFocus(control);
        }
    }

    void sort(int[] nArray) {
        int n2 = nArray.length;
        int n3 = n2 / 2;
        while (n3 > 0) {
            int n4 = n3;
            while (n4 < n2) {
                int n5 = n4 - n3;
                while (n5 >= 0) {
                    if (nArray[n5] <= nArray[n5 + n3]) {
                        int n6 = nArray[n5];
                        nArray[n5] = nArray[n5 + n3];
                        nArray[n5 + n3] = n6;
                    }
                    n5 -= n3;
                }
                ++n4;
            }
            n3 /= 2;
        }
    }

    void subclass() {
        int n2;
        int n3 = this.windowProc();
        if (n3 == (n2 = this.display.windowProc)) {
            return;
        }
        OS.SetWindowLong(this.handle, -4, n2);
    }

    public Point toControl(int n2, int n3) {
        this.checkWidget();
        POINT pOINT = new POINT();
        pOINT.x = n2;
        pOINT.y = n3;
        OS.ScreenToClient(this.handle, pOINT);
        return new Point(pOINT.x, pOINT.y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int n2, int n3) {
        this.checkWidget();
        POINT pOINT = new POINT();
        pOINT.x = n2;
        pOINT.y = n3;
        OS.ClientToScreen(this.handle, pOINT);
        return new Point(pOINT.x, pOINT.y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    int topHandle() {
        return this.handle;
    }

    boolean translateAccelerator(MSG mSG) {
        return this.menuShell().translateAccelerator(mSG);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(MSG mSG) {
        Decorations decorations;
        if (mSG.wParam < 32) {
            return false;
        }
        int n2 = mSG.hwnd;
        if (OS.GetKeyState(18) >= 0) {
            int n3 = OS.SendMessage(n2, 135, 0, 0);
            if ((n3 & 4) != 0) {
                return false;
            }
            if ((n3 & 0x2000) == 0) {
                return false;
            }
        }
        if ((decorations = this.menuShell()).isVisible() && decorations.isEnabled()) {
            this.display.lastAscii = mSG.wParam;
            this.display.lastDead = false;
            this.display.lastNull = false;
            Event event = new Event();
            event.detail = 128;
            if (this.setKeyState(event, 31, mSG.wParam, mSG.lParam)) {
                return this.translateMnemonic(event, null) || decorations.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(MSG mSG) {
        int n2 = mSG.hwnd;
        int n3 = mSG.wParam;
        if (n3 == 18) {
            OS.SendMessage(n2, 295, 3, 0);
            return false;
        }
        int n4 = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        int n5 = n3;
        int n6 = 0;
        switch (n3) {
            case 27: {
                bl3 = true;
                n6 = 27;
                int n7 = OS.SendMessage(n2, 135, 0, 0);
                if ((n7 & 4) != 0 && (n7 & 8) == 0) {
                    bl2 = false;
                }
                n4 = 2;
                break;
            }
            case 13: {
                bl3 = true;
                n6 = 13;
                int n7 = OS.SendMessage(n2, 135, 0, 0);
                if ((n7 & 4) != 0) {
                    bl2 = false;
                }
                n4 = 4;
                break;
            }
            case 9: {
                n6 = 9;
                int n7 = OS.GetKeyState(16) >= 0 ? 1 : 0;
                int n8 = OS.SendMessage(n2, 135, 0, 0);
                if ((n8 & 6) != 0) {
                    if ((n8 & 8) != 0) {
                        if (n7 != 0 && OS.GetKeyState(17) >= 0) {
                            bl2 = false;
                        }
                    } else {
                        bl2 = false;
                    }
                }
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (n3 == 37 || n3 == 39)) {
                    n7 = n7 != 0 ? 0 : 1;
                }
                n4 = n7 != 0 ? 16 : 8;
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (OS.IsSP && (n3 == 37 || n3 == 39)) {
                    return false;
                }
                bl4 = true;
                int n7 = OS.SendMessage(n2, 135, 0, 0);
                if ((n7 & 1) != 0) {
                    bl2 = false;
                }
                int n8 = n3 != 40 && n3 != 39 ? 0 : 1;
                n4 = n8 != 0 ? 64 : 32;
                break;
            }
            case 33: 
            case 34: {
                bl3 = true;
                bl4 = true;
                if (OS.GetKeyState(17) >= 0) {
                    return false;
                }
                int n7 = OS.SendMessage(n2, 135, 0, 0);
                if ((n7 & 4) != 0 && (n7 & 8) == 0) {
                    bl2 = false;
                }
                n4 = n3 == 33 ? 256 : 512;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = bl2;
        event.detail = n4;
        this.display.lastKey = n5;
        this.display.lastAscii = n6;
        this.display.lastVirtual = bl4;
        this.display.lastDead = false;
        this.display.lastNull = false;
        if (!this.setKeyState(event, 31, mSG.wParam, mSG.lParam)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                OS.SendMessage(n2, 295, 3, 0);
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl3 && control != null);
        return false;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int n2) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n2;
        return this.traverse(event);
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl2) {
        Control control = this.computeTabRoot();
        Control control2 = this.computeTabGroup();
        Control[] controlArray = control.computeTabList();
        int n2 = controlArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (controlArray[n3] == control2) break;
            ++n3;
        }
        if (n3 == n2) {
            return false;
        }
        int n4 = n3;
        int n5 = bl2 ? 1 : -1;
        while ((n3 = (n3 + n5 + n2) % n2) != n4) {
            Control control3 = controlArray[n3];
            if (control3.isDisposed() || !control3.setTabGroupFocus()) continue;
            return true;
        }
        if (control2.isDisposed()) {
            return false;
        }
        return control2.setTabGroupFocus();
    }

    boolean traverseItem(boolean bl2) {
        Control[] controlArray = this.parent._getChildren();
        int n2 = controlArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (controlArray[n3] == this) break;
            ++n3;
        }
        if (n3 == n2) {
            return false;
        }
        int n4 = n3;
        int n5 = bl2 ? 1 : -1;
        while ((n3 = (n3 + n5 + n2) % n2) != n4) {
            Control control = controlArray[n3];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseMnemonic(char c2) {
        if (this.mnemonicHit(c2)) {
            OS.SendMessage(this.handle, 295, 3, 0);
            return true;
        }
        return false;
    }

    boolean traversePage(boolean bl2) {
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    void unsubclass() {
        int n2 = this.display.windowProc;
        int n3 = this.windowProc();
        if (n2 == n3) {
            return;
        }
        OS.SetWindowLong(this.handle, -4, n3);
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean bl2) {
        if (OS.IsWinCE) {
            OS.UpdateWindow(this.handle);
        } else {
            int n2 = 256;
            if (bl2) {
                n2 |= 0x80;
            }
            OS.RedrawWindow(this.handle, null, 0, n2);
        }
    }

    void updateBackgroundColor() {
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        this.setBackgroundPixel(control.background);
    }

    void updateBackgroundImage() {
        Control control = this.findBackgroundControl();
        Image image = control != null ? control.backgroundImage : this.backgroundImage;
        this.setBackgroundImage(image != null ? image.handle : 0);
    }

    void updateBackgroundMode() {
        int n2 = this.state & 0x400;
        this.checkBackground();
        if (n2 != (this.state & 0x400)) {
            this.setBackground();
        }
    }

    void updateFont(Font font, Font font2) {
        if (this.getFont().equals(font)) {
            this.setFont(font2);
        }
    }

    void updateImages() {
    }

    void updateLayout(boolean bl2, boolean bl3) {
    }

    CREATESTRUCT widgetCreateStruct() {
        return null;
    }

    int widgetExtStyle() {
        int n2 = 0;
        if (!OS.IsPPC && (this.style & 0x800) != 0) {
            n2 |= 0x200;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return n2;
        }
        n2 |= 0x100000;
        if ((this.style & 0x4000000) != 0) {
            n2 |= 0x400000;
        }
        return n2;
    }

    int widgetParent() {
        return this.parent.handle;
    }

    int widgetStyle() {
        int n2 = 0x54000000;
        if (OS.IsPPC && (this.style & 0x800) != 0) {
            n2 |= 0x800000;
        }
        return n2;
    }

    public boolean setParent(Composite composite) {
        int n2;
        this.checkWidget();
        if (composite == null) {
            this.error(4);
        }
        if (composite.isDisposed()) {
            SWT.error(5);
        }
        if (this.parent == composite) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        this.releaseParent();
        Shell shell = composite.getShell();
        Shell shell2 = this.getShell();
        Decorations decorations = composite.menuShell();
        Decorations decorations2 = this.menuShell();
        if (shell2 != shell || decorations2 != decorations) {
            Menu[] menuArray = shell2.findMenus(this);
            this.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        }
        if (OS.SetParent(n2 = this.topHandle(), composite.handle) == 0) {
            return false;
        }
        this.parent = composite;
        int n3 = 19;
        this.SetWindowPos(n2, 1, 0, 0, 0, 0, n3);
        return true;
    }

    abstract TCHAR windowClass();

    abstract int windowProc();

    int windowProc(int n2, int n3, int n4, int n5) {
        LRESULT lRESULT = null;
        switch (n3) {
            case 6: {
                lRESULT = this.WM_ACTIVATE(n4, n5);
                break;
            }
            case 533: {
                lRESULT = this.WM_CAPTURECHANGED(n4, n5);
                break;
            }
            case 258: {
                lRESULT = this.WM_CHAR(n4, n5);
                break;
            }
            case 771: {
                lRESULT = this.WM_CLEAR(n4, n5);
                break;
            }
            case 16: {
                lRESULT = this.WM_CLOSE(n4, n5);
                break;
            }
            case 273: {
                lRESULT = this.WM_COMMAND(n4, n5);
                break;
            }
            case 123: {
                lRESULT = this.WM_CONTEXTMENU(n4, n5);
                break;
            }
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: {
                lRESULT = this.WM_CTLCOLOR(n4, n5);
                break;
            }
            case 768: {
                lRESULT = this.WM_CUT(n4, n5);
                break;
            }
            case 2: {
                lRESULT = this.WM_DESTROY(n4, n5);
                break;
            }
            case 43: {
                lRESULT = this.WM_DRAWITEM(n4, n5);
                break;
            }
            case 22: {
                lRESULT = this.WM_ENDSESSION(n4, n5);
                break;
            }
            case 289: {
                lRESULT = this.WM_ENTERIDLE(n4, n5);
                break;
            }
            case 20: {
                lRESULT = this.WM_ERASEBKGND(n4, n5);
                break;
            }
            case 135: {
                lRESULT = this.WM_GETDLGCODE(n4, n5);
                break;
            }
            case 49: {
                lRESULT = this.WM_GETFONT(n4, n5);
                break;
            }
            case 61: {
                lRESULT = this.WM_GETOBJECT(n4, n5);
                break;
            }
            case 36: {
                lRESULT = this.WM_GETMINMAXINFO(n4, n5);
                break;
            }
            case 83: {
                lRESULT = this.WM_HELP(n4, n5);
                break;
            }
            case 276: {
                lRESULT = this.WM_HSCROLL(n4, n5);
                break;
            }
            case 646: {
                lRESULT = this.WM_IME_CHAR(n4, n5);
                break;
            }
            case 271: {
                lRESULT = this.WM_IME_COMPOSITION(n4, n5);
                break;
            }
            case 279: {
                lRESULT = this.WM_INITMENUPOPUP(n4, n5);
                break;
            }
            case 81: {
                lRESULT = this.WM_INPUTLANGCHANGE(n4, n5);
                break;
            }
            case 786: {
                lRESULT = this.WM_HOTKEY(n4, n5);
                break;
            }
            case 256: {
                lRESULT = this.WM_KEYDOWN(n4, n5);
                break;
            }
            case 257: {
                lRESULT = this.WM_KEYUP(n4, n5);
                break;
            }
            case 8: {
                lRESULT = this.WM_KILLFOCUS(n4, n5);
                break;
            }
            case 515: {
                lRESULT = this.WM_LBUTTONDBLCLK(n4, n5);
                break;
            }
            case 513: {
                lRESULT = this.WM_LBUTTONDOWN(n4, n5);
                break;
            }
            case 514: {
                lRESULT = this.WM_LBUTTONUP(n4, n5);
                break;
            }
            case 521: {
                lRESULT = this.WM_MBUTTONDBLCLK(n4, n5);
                break;
            }
            case 519: {
                lRESULT = this.WM_MBUTTONDOWN(n4, n5);
                break;
            }
            case 520: {
                lRESULT = this.WM_MBUTTONUP(n4, n5);
                break;
            }
            case 44: {
                lRESULT = this.WM_MEASUREITEM(n4, n5);
                break;
            }
            case 288: {
                lRESULT = this.WM_MENUCHAR(n4, n5);
                break;
            }
            case 287: {
                lRESULT = this.WM_MENUSELECT(n4, n5);
                break;
            }
            case 33: {
                lRESULT = this.WM_MOUSEACTIVATE(n4, n5);
                break;
            }
            case 673: {
                lRESULT = this.WM_MOUSEHOVER(n4, n5);
                break;
            }
            case 675: {
                lRESULT = this.WM_MOUSELEAVE(n4, n5);
                break;
            }
            case 512: {
                lRESULT = this.WM_MOUSEMOVE(n4, n5);
                break;
            }
            case 522: {
                lRESULT = this.WM_MOUSEWHEEL(n4, n5);
                break;
            }
            case 3: {
                lRESULT = this.WM_MOVE(n4, n5);
                break;
            }
            case 134: {
                lRESULT = this.WM_NCACTIVATE(n4, n5);
                break;
            }
            case 131: {
                lRESULT = this.WM_NCCALCSIZE(n4, n5);
                break;
            }
            case 132: {
                lRESULT = this.WM_NCHITTEST(n4, n5);
                break;
            }
            case 161: {
                lRESULT = this.WM_NCLBUTTONDOWN(n4, n5);
                break;
            }
            case 133: {
                lRESULT = this.WM_NCPAINT(n4, n5);
                break;
            }
            case 78: {
                lRESULT = this.WM_NOTIFY(n4, n5);
                break;
            }
            case 15: {
                lRESULT = this.WM_PAINT(n4, n5);
                break;
            }
            case 785: {
                lRESULT = this.WM_PALETTECHANGED(n4, n5);
                break;
            }
            case 528: {
                lRESULT = this.WM_PARENTNOTIFY(n4, n5);
                break;
            }
            case 770: {
                lRESULT = this.WM_PASTE(n4, n5);
                break;
            }
            case 791: {
                lRESULT = this.WM_PRINT(n4, n5);
                break;
            }
            case 792: {
                lRESULT = this.WM_PRINTCLIENT(n4, n5);
                break;
            }
            case 17: {
                lRESULT = this.WM_QUERYENDSESSION(n4, n5);
                break;
            }
            case 783: {
                lRESULT = this.WM_QUERYNEWPALETTE(n4, n5);
                break;
            }
            case 19: {
                lRESULT = this.WM_QUERYOPEN(n4, n5);
                break;
            }
            case 518: {
                lRESULT = this.WM_RBUTTONDBLCLK(n4, n5);
                break;
            }
            case 516: {
                lRESULT = this.WM_RBUTTONDOWN(n4, n5);
                break;
            }
            case 517: {
                lRESULT = this.WM_RBUTTONUP(n4, n5);
                break;
            }
            case 32: {
                lRESULT = this.WM_SETCURSOR(n4, n5);
                break;
            }
            case 7: {
                lRESULT = this.WM_SETFOCUS(n4, n5);
                break;
            }
            case 48: {
                lRESULT = this.WM_SETFONT(n4, n5);
                break;
            }
            case 26: {
                lRESULT = this.WM_SETTINGCHANGE(n4, n5);
                break;
            }
            case 11: {
                lRESULT = this.WM_SETREDRAW(n4, n5);
                break;
            }
            case 24: {
                lRESULT = this.WM_SHOWWINDOW(n4, n5);
                break;
            }
            case 5: {
                lRESULT = this.WM_SIZE(n4, n5);
                break;
            }
            case 262: {
                lRESULT = this.WM_SYSCHAR(n4, n5);
                break;
            }
            case 21: {
                lRESULT = this.WM_SYSCOLORCHANGE(n4, n5);
                break;
            }
            case 274: {
                lRESULT = this.WM_SYSCOMMAND(n4, n5);
                break;
            }
            case 260: {
                lRESULT = this.WM_SYSKEYDOWN(n4, n5);
                break;
            }
            case 261: {
                lRESULT = this.WM_SYSKEYUP(n4, n5);
                break;
            }
            case 275: {
                lRESULT = this.WM_TIMER(n4, n5);
                break;
            }
            case 772: {
                lRESULT = this.WM_UNDO(n4, n5);
                break;
            }
            case 296: {
                lRESULT = this.WM_UPDATEUISTATE(n4, n5);
                break;
            }
            case 277: {
                lRESULT = this.WM_VSCROLL(n4, n5);
                break;
            }
            case 71: {
                lRESULT = this.WM_WINDOWPOSCHANGED(n4, n5);
                break;
            }
            case 70: {
                lRESULT = this.WM_WINDOWPOSCHANGING(n4, n5);
                break;
            }
            case 525: {
                lRESULT = this.WM_XBUTTONDBLCLK(n4, n5);
                break;
            }
            case 523: {
                lRESULT = this.WM_XBUTTONDOWN(n4, n5);
                break;
            }
            case 524: {
                lRESULT = this.WM_XBUTTONUP(n4, n5);
            }
        }
        if (lRESULT != null) {
            return lRESULT.value;
        }
        return this.callWindowProc(n2, n3, n4, n5);
    }

    LRESULT WM_ACTIVATE(int n2, int n3) {
        return null;
    }

    LRESULT WM_CAPTURECHANGED(int n2, int n3) {
        return this.wmCaptureChanged(this.handle, n2, n3);
    }

    LRESULT WM_CHAR(int n2, int n3) {
        return this.wmChar(this.handle, n2, n3);
    }

    LRESULT WM_CLEAR(int n2, int n3) {
        return null;
    }

    LRESULT WM_CLOSE(int n2, int n3) {
        return null;
    }

    LRESULT WM_COMMAND(int n2, int n3) {
        if (n3 == 0) {
            int n4;
            MenuItem menuItem;
            Decorations decorations = this.menuShell();
            if (decorations.isEnabled() && (menuItem = this.display.getMenuItem(n4 = n2 & 0xFFFF)) != null && menuItem.isEnabled()) {
                return menuItem.wmCommandChild(n2, n3);
            }
            return null;
        }
        Control control = this.display.getControl(n3);
        if (control == null) {
            return null;
        }
        return control.wmCommandChild(n2, n3);
    }

    LRESULT WM_CONTEXTMENU(int n2, int n3) {
        return this.wmContextMenu(this.handle, n2, n3);
    }

    LRESULT WM_CTLCOLOR(int n2, int n3) {
        Control control;
        int n4 = this.display.hPalette;
        if (n4 != 0) {
            OS.SelectPalette(n2, n4, false);
            OS.RealizePalette(n2);
        }
        if ((control = this.display.getControl(n3)) == null) {
            return null;
        }
        return control.wmColorChild(n2, n3);
    }

    LRESULT WM_CUT(int n2, int n3) {
        return null;
    }

    LRESULT WM_DESTROY(int n2, int n3) {
        return null;
    }

    LRESULT WM_DRAWITEM(int n2, int n3) {
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n3, DRAWITEMSTRUCT.sizeof);
        if (dRAWITEMSTRUCT.CtlType == 1) {
            MenuItem menuItem = this.display.getMenuItem(dRAWITEMSTRUCT.itemID);
            if (menuItem == null) {
                return null;
            }
            return menuItem.wmDrawChild(n2, n3);
        }
        Control control = this.display.getControl(dRAWITEMSTRUCT.hwndItem);
        if (control == null) {
            return null;
        }
        return control.wmDrawChild(n2, n3);
    }

    LRESULT WM_ENDSESSION(int n2, int n3) {
        return null;
    }

    LRESULT WM_ENTERIDLE(int n2, int n3) {
        return null;
    }

    LRESULT WM_ERASEBKGND(int n2, int n3) {
        if ((this.state & 0x200) != 0 && this.findImageControl() != null) {
            return LRESULT.ONE;
        }
        if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.findThemeControl() != null) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT WM_GETDLGCODE(int n2, int n3) {
        return null;
    }

    LRESULT WM_GETFONT(int n2, int n3) {
        return null;
    }

    LRESULT WM_GETOBJECT(int n2, int n3) {
        int n4;
        if (this.accessible != null && (n4 = this.accessible.internal_WM_GETOBJECT(n2, n3)) != 0) {
            return new LRESULT(n4);
        }
        return null;
    }

    LRESULT WM_GETMINMAXINFO(int n2, int n3) {
        return null;
    }

    LRESULT WM_HOTKEY(int n2, int n3) {
        return null;
    }

    LRESULT WM_HELP(int n2, int n3) {
        if (OS.IsWinCE) {
            return null;
        }
        HELPINFO hELPINFO = new HELPINFO();
        OS.MoveMemory(hELPINFO, n3, HELPINFO.sizeof);
        Decorations decorations = this.menuShell();
        if (!decorations.isEnabled()) {
            return null;
        }
        if (hELPINFO.iContextType == 2) {
            MenuItem menuItem = this.display.getMenuItem(hELPINFO.iCtrlId);
            if (menuItem != null && menuItem.isEnabled()) {
                Widget widget = null;
                if (menuItem.hooks(28)) {
                    widget = menuItem;
                } else {
                    Menu menu = menuItem.parent;
                    if (menu.hooks(28)) {
                        widget = menu;
                    }
                }
                if (widget != null) {
                    int n4 = decorations.handle;
                    OS.SendMessage(n4, 31, 0, 0);
                    widget.postEvent(28);
                    return LRESULT.ONE;
                }
            }
            return null;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT WM_HSCROLL(int n2, int n3) {
        Control control = this.display.getControl(n3);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(n2, n3);
    }

    LRESULT WM_IME_CHAR(int n2, int n3) {
        return this.wmIMEChar(this.handle, n2, n3);
    }

    LRESULT WM_IME_COMPOSITION(int n2, int n3) {
        return null;
    }

    LRESULT WM_INITMENUPOPUP(int n2, int n3) {
        if (this.display.accelKeyHit) {
            return null;
        }
        Shell shell = this.getShell();
        Menu menu = shell.activeMenu;
        Menu menu2 = null;
        if (n3 >> 16 == 0 && (menu2 = this.menuShell().findMenu(n2)) != null) {
            menu2.update();
        }
        Menu menu3 = menu2;
        while (menu3 != null && menu3 != menu) {
            menu3 = menu3.getParentMenu();
        }
        if (menu3 == null) {
            menu3 = shell.activeMenu;
            while (menu3 != null) {
                menu3.sendEvent(23);
                if (menu3.isDisposed()) break;
                menu3 = menu3.getParentMenu();
                Menu menu4 = menu2;
                while (menu4 != null && menu4 != menu3) {
                    menu4 = menu4.getParentMenu();
                }
                if (menu4 != null) break;
            }
        }
        if (menu2 != null && menu2.isDisposed()) {
            menu2 = null;
        }
        shell.activeMenu = menu2;
        if (menu2 != null && menu2 != menu) {
            menu2.sendEvent(22);
        }
        return null;
    }

    LRESULT WM_INPUTLANGCHANGE(int n2, int n3) {
        return null;
    }

    LRESULT WM_KEYDOWN(int n2, int n3) {
        return this.wmKeyDown(this.handle, n2, n3);
    }

    LRESULT WM_KEYUP(int n2, int n3) {
        return this.wmKeyUp(this.handle, n2, n3);
    }

    LRESULT WM_KILLFOCUS(int n2, int n3) {
        return this.wmKillFocus(this.handle, n2, n3);
    }

    LRESULT WM_LBUTTONDBLCLK(int n2, int n3) {
        return this.wmLButtonDblClk(this.handle, n2, n3);
    }

    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        return this.wmLButtonDown(this.handle, n2, n3);
    }

    LRESULT WM_LBUTTONUP(int n2, int n3) {
        return this.wmLButtonUp(this.handle, n2, n3);
    }

    LRESULT WM_MBUTTONDBLCLK(int n2, int n3) {
        return this.wmMButtonDblClk(this.handle, n2, n3);
    }

    LRESULT WM_MBUTTONDOWN(int n2, int n3) {
        return this.wmMButtonDown(this.handle, n2, n3);
    }

    LRESULT WM_MBUTTONUP(int n2, int n3) {
        return this.wmMButtonUp(this.handle, n2, n3);
    }

    LRESULT WM_MEASUREITEM(int n2, int n3) {
        MEASUREITEMSTRUCT mEASUREITEMSTRUCT = new MEASUREITEMSTRUCT();
        OS.MoveMemory(mEASUREITEMSTRUCT, n3, MEASUREITEMSTRUCT.sizeof);
        if (mEASUREITEMSTRUCT.CtlType == 1) {
            MenuItem menuItem = this.display.getMenuItem(mEASUREITEMSTRUCT.itemID);
            if (menuItem == null) {
                return null;
            }
            return menuItem.wmMeasureChild(n2, n3);
        }
        int n4 = OS.GetDlgItem(this.handle, mEASUREITEMSTRUCT.CtlID);
        Control control = this.display.getControl(n4);
        if (control == null) {
            return null;
        }
        return control.wmMeasureChild(n2, n3);
    }

    LRESULT WM_MENUCHAR(int n2, int n3) {
        int n4 = n2 >> 16;
        if (n4 == 0 || n4 == 8192) {
            this.display.mnemonicKeyHit = false;
            return new LRESULT(65536);
        }
        return null;
    }

    LRESULT WM_MENUSELECT(int n2, int n3) {
        int n4 = n2 >> 16;
        Shell shell = this.getShell();
        if (n4 == -1 && n3 == 0) {
            Menu menu = shell.activeMenu;
            while (menu != null) {
                this.display.mnemonicKeyHit = true;
                menu.sendEvent(23);
                if (menu.isDisposed()) break;
                menu = menu.getParentMenu();
            }
            shell.activeMenu = null;
            return null;
        }
        if ((n4 & 0x2000) != 0) {
            return null;
        }
        if ((n4 & 0x80) != 0) {
            MenuItem menuItem = null;
            Decorations decorations = this.menuShell();
            if ((n4 & 0x10) != 0) {
                Menu menu;
                int n5 = n2 & 0xFFFF;
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 4;
                if (OS.GetMenuItemInfo(n3, n5, true, mENUITEMINFO) && (menu = decorations.findMenu(mENUITEMINFO.hSubMenu)) != null) {
                    menuItem = menu.cascade;
                }
            } else {
                Menu menu;
                Menu menu2 = decorations.findMenu(n3);
                if (menu2 != null) {
                    int n6 = n2 & 0xFFFF;
                    menuItem = this.display.getMenuItem(n6);
                }
                if ((menu = shell.activeMenu) != null) {
                    Menu menu3 = menu;
                    while (menu3 != null && menu3 != menu2) {
                        menu3 = menu3.getParentMenu();
                    }
                    if (menu3 == menu2) {
                        menu3 = menu;
                        while (menu3 != menu2) {
                            menu3.sendEvent(23);
                            if (menu3.isDisposed()) break;
                            menu3 = menu3.getParentMenu();
                        }
                        if (!shell.isDisposed()) {
                            if (menu2 != null && menu2.isDisposed()) {
                                menu2 = null;
                            }
                            shell.activeMenu = menu2;
                        }
                        if (menuItem != null && menuItem.isDisposed()) {
                            menuItem = null;
                        }
                    }
                }
            }
            if (menuItem != null) {
                menuItem.sendEvent(30);
            }
        }
        return null;
    }

    LRESULT WM_MOUSEACTIVATE(int n2, int n3) {
        return null;
    }

    LRESULT WM_MOUSEHOVER(int n2, int n3) {
        return this.wmMouseHover(this.handle, n2, n3);
    }

    LRESULT WM_MOUSELEAVE(int n2, int n3) {
        if (OS.COMCTL32_MAJOR >= 6) {
            this.getShell().fixToolTip();
        }
        return this.wmMouseLeave(this.handle, n2, n3);
    }

    LRESULT WM_MOUSEMOVE(int n2, int n3) {
        return this.wmMouseMove(this.handle, n2, n3);
    }

    LRESULT WM_MOUSEWHEEL(int n2, int n3) {
        return this.wmMouseWheel(this.handle, n2, n3);
    }

    LRESULT WM_MOVE(int n2, int n3) {
        if (this.findImageControl() != null) {
            if (this != this.getShell()) {
                this.redrawChildren();
            }
        } else if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && OS.IsWindowVisible(this.handle) && this.findThemeControl() != null) {
            this.redrawChildren();
        }
        this.sendEvent(10);
        return null;
    }

    LRESULT WM_NCACTIVATE(int n2, int n3) {
        return null;
    }

    LRESULT WM_NCCALCSIZE(int n2, int n3) {
        return null;
    }

    LRESULT WM_NCHITTEST(int n2, int n3) {
        if (!OS.IsWindowEnabled(this.handle)) {
            return null;
        }
        if (!this.isActive()) {
            return new LRESULT(-1);
        }
        return null;
    }

    LRESULT WM_NCLBUTTONDOWN(int n2, int n3) {
        return null;
    }

    LRESULT WM_NCPAINT(int n2, int n3) {
        return null;
    }

    LRESULT WM_NOTIFY(int n2, int n3) {
        NMHDR nMHDR = new NMHDR();
        OS.MoveMemory(nMHDR, n3, NMHDR.sizeof);
        return this.wmNotify(nMHDR, n2, n3);
    }

    LRESULT WM_PAINT(int n2, int n3) {
        return super.wmPaint(this.handle, n2, n3);
    }

    LRESULT WM_PALETTECHANGED(int n2, int n3) {
        return null;
    }

    LRESULT WM_PARENTNOTIFY(int n2, int n3) {
        return null;
    }

    LRESULT WM_PASTE(int n2, int n3) {
        return null;
    }

    LRESULT WM_PRINT(int n2, int n3) {
        return this.wmPrint(this.handle, n2, n3);
    }

    LRESULT WM_PRINTCLIENT(int n2, int n3) {
        return null;
    }

    LRESULT WM_QUERYENDSESSION(int n2, int n3) {
        return null;
    }

    LRESULT WM_QUERYNEWPALETTE(int n2, int n3) {
        return null;
    }

    LRESULT WM_QUERYOPEN(int n2, int n3) {
        return null;
    }

    LRESULT WM_RBUTTONDBLCLK(int n2, int n3) {
        return this.wmRButtonDblClk(this.handle, n2, n3);
    }

    LRESULT WM_RBUTTONDOWN(int n2, int n3) {
        return this.wmRButtonDown(this.handle, n2, n3);
    }

    LRESULT WM_RBUTTONUP(int n2, int n3) {
        return this.wmRButtonUp(this.handle, n2, n3);
    }

    LRESULT WM_SETCURSOR(int n2, int n3) {
        short s2 = (short)(n3 & 0xFFFF);
        if (s2 == 1) {
            Control control = this.display.getControl(n2);
            if (control == null) {
                return null;
            }
            Cursor cursor = control.findCursor();
            if (cursor != null) {
                OS.SetCursor(cursor.handle);
                return LRESULT.ONE;
            }
        }
        return null;
    }

    LRESULT WM_SETFOCUS(int n2, int n3) {
        return this.wmSetFocus(this.handle, n2, n3);
    }

    LRESULT WM_SETTINGCHANGE(int n2, int n3) {
        return null;
    }

    LRESULT WM_SETFONT(int n2, int n3) {
        return null;
    }

    LRESULT WM_SETREDRAW(int n2, int n3) {
        return null;
    }

    LRESULT WM_SHOWWINDOW(int n2, int n3) {
        return null;
    }

    LRESULT WM_SIZE(int n2, int n3) {
        this.sendEvent(11);
        return null;
    }

    LRESULT WM_SYSCHAR(int n2, int n3) {
        return this.wmSysChar(this.handle, n2, n3);
    }

    LRESULT WM_SYSCOLORCHANGE(int n2, int n3) {
        return null;
    }

    /*
     * Handled duff style switch with additional control
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    LRESULT WM_SYSCOMMAND(int n2, int n3) {
        Decorations decorations;
        if ((n2 & 0xF000) == 0) {
            MenuItem menuItem;
            Decorations decorations2 = this.menuShell();
            if (!decorations2.isEnabled() || (menuItem = this.display.getMenuItem(n2 & 0xFFFF)) == null) return LRESULT.ZERO;
            menuItem.wmCommandChild(n2, n3);
            return LRESULT.ZERO;
        }
        int n4 = n2 & 0xFFF0;
        int n5 = 0;
        block6: do {
            int n6;
            MenuItem[] menuItemArray;
            switch (n5 == 0 ? n4 : n5) {
                case 61536: {
                    int n7 = this.menuShell().handle;
                    int n8 = OS.GetWindowLong(n7, -16);
                    if ((n8 & 0x80000) != 0) return null;
                    return LRESULT.ZERO;
                }
                case 61696: {
                    char c2;
                    if (n3 == 0) {
                        n5 = 61552;
                        decorations = this.menuShell();
                        Menu menu = decorations.getMenuBar();
                        if (menu != null) continue block6;
                        n5 = 61552;
                        Control control = this.display._getFocusControl();
                        if (control == null) continue block6;
                        if (!control.hooks(1)) {
                            n5 = 61552;
                            if (!control.hooks(2)) continue block6;
                        }
                        this.display.mnemonicKeyHit = false;
                        return LRESULT.ZERO;
                    }
                    if (!this.hooks(1)) {
                        n5 = 61552;
                        if (!this.hooks(2)) continue block6;
                    }
                    n5 = 61552;
                    if (n3 == 32) continue block6;
                    decorations = this.menuShell();
                    Menu menu = decorations.getMenuBar();
                    if (menu != null) {
                        n5 = 61552;
                        c2 = Display.mbcsToWcs(n3);
                        if (c2 == '\u0000') continue block6;
                        c2 = Character.toUpperCase(c2);
                        menuItemArray = menu.getItems();
                        n6 = 0;
                        if (true) {
                            n5 = 61552;
                            if (n6 >= menuItemArray.length) continue block6;
                        }
                    } else {
                        this.display.mnemonicKeyHit = false;
                        n5 = 61552;
                        continue block6;
                    }
                }
                case 61472: {
                    this.menuShell().saveFocus();
                    return null;
                }
                default: {
                    return null;
                }
                do {
                    char c3;
                    char c2;
                    MenuItem menuItem = menuItemArray[n6];
                    String string = menuItem.getText();
                    char c4 = this.findMnemonic(string);
                    if (string.length() > 0 && c4 == '\u0000' && Character.toUpperCase(c3 = string.charAt(0)) == c2) {
                        this.display.mnemonicKeyHit = false;
                        return LRESULT.ZERO;
                    }
                    ++n6;
                    n5 = 61552;
                } while (n6 < menuItemArray.length);
                case 61552: 
                case 61568: 
            }
            break;
        } while (true);
        if ((decorations = this.menuShell()).isEnabled() && decorations.isActive()) return null;
        return LRESULT.ZERO;
    }

    LRESULT WM_SYSKEYDOWN(int n2, int n3) {
        return this.wmSysKeyDown(this.handle, n2, n3);
    }

    LRESULT WM_SYSKEYUP(int n2, int n3) {
        return this.wmSysKeyUp(this.handle, n2, n3);
    }

    LRESULT WM_TIMER(int n2, int n3) {
        return null;
    }

    LRESULT WM_UNDO(int n2, int n3) {
        return null;
    }

    LRESULT WM_UPDATEUISTATE(int n2, int n3) {
        return null;
    }

    LRESULT WM_VSCROLL(int n2, int n3) {
        Control control = this.display.getControl(n3);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(n2, n3);
    }

    LRESULT WM_WINDOWPOSCHANGED(int n2, int n3) {
        return null;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n2, int n3) {
        Shell shell;
        if (this.drawCount != 0 && (shell = this.getShell()) != this) {
            WINDOWPOS wINDOWPOS = new WINDOWPOS();
            OS.MoveMemory(wINDOWPOS, n3, WINDOWPOS.sizeof);
            if ((wINDOWPOS.flags & 2) == 0 || (wINDOWPOS.flags & 1) == 0) {
                RECT rECT = new RECT();
                OS.GetWindowRect(this.topHandle(), rECT);
                int n4 = this.parent == null ? 0 : this.parent.handle;
                OS.MapWindowPoints(0, n4, rECT, 2);
                OS.InvalidateRect(n4, rECT, true);
            }
        }
        return null;
    }

    LRESULT WM_XBUTTONDBLCLK(int n2, int n3) {
        return this.wmXButtonDblClk(this.handle, n2, n3);
    }

    LRESULT WM_XBUTTONDOWN(int n2, int n3) {
        return this.wmXButtonDown(this.handle, n2, n3);
    }

    LRESULT WM_XBUTTONUP(int n2, int n3) {
        return this.wmXButtonUp(this.handle, n2, n3);
    }

    LRESULT wmColorChild(int n2, int n3) {
        Control control = this.findBackgroundControl();
        if (control == null) {
            if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (control = this.findThemeControl()) != null) {
                RECT rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                OS.SetTextColor(n2, this.getForegroundPixel());
                OS.SetBkColor(n2, this.getBackgroundPixel());
                this.fillThemeBackground(n2, control, rECT);
                OS.SetBkMode(n2, 1);
                return new LRESULT(OS.GetStockObject(5));
            }
            if (this.foreground == -1) {
                return null;
            }
        }
        if (control == null) {
            control = this;
        }
        int n4 = this.getForegroundPixel();
        int n5 = control.getBackgroundPixel();
        OS.SetTextColor(n2, n4);
        OS.SetBkColor(n2, n5);
        if (control.backgroundImage != null) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            int n6 = control.handle;
            int n7 = control.backgroundImage.handle;
            OS.MapWindowPoints(this.handle, n6, rECT, 2);
            POINT pOINT = new POINT();
            OS.GetWindowOrgEx(n2, pOINT);
            OS.SetBrushOrgEx(n2, -rECT.left - pOINT.x, -rECT.top - pOINT.y, pOINT);
            int n8 = this.findBrush(n7, 3);
            if ((this.state & 0x200) != 0) {
                int n9 = OS.SelectObject(n2, n8);
                OS.MapWindowPoints(n6, this.handle, rECT, 2);
                OS.PatBlt(n2, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
                OS.SelectObject(n2, n9);
            }
            OS.SetBkMode(n2, 1);
            return new LRESULT(n8);
        }
        int n10 = this.findBrush(n5, 0);
        if ((this.state & 0x200) != 0) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            int n11 = OS.SelectObject(n2, n10);
            OS.PatBlt(n2, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
            OS.SelectObject(n2, n11);
        }
        return new LRESULT(n10);
    }

    LRESULT wmCommandChild(int n2, int n3) {
        return null;
    }

    LRESULT wmDrawChild(int n2, int n3) {
        return null;
    }

    LRESULT wmMeasureChild(int n2, int n3) {
        return null;
    }

    LRESULT wmNotify(NMHDR nMHDR, int n2, int n3) {
        Control control = this.display.getControl(nMHDR.hwndFrom);
        if (control == null) {
            return null;
        }
        return control.wmNotifyChild(nMHDR, n2, n3);
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        return null;
    }

    LRESULT wmScrollChild(int n2, int n3) {
        return null;
    }
}

