/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    int imageIndent;
    int background = -1;
    int foreground = -1;
    int font = -1;
    int[] cellBackground;
    int[] cellForeground;
    int[] cellFont;

    public TableItem(Table table, int n2) {
        this(table, n2, TableItem.checkNull(table).getItemCount(), true);
    }

    public TableItem(Table table, int n2, int n3) {
        this(table, n2, n3, true);
    }

    TableItem(Table table, int n2, int n3, boolean bl2) {
        super(table, n2);
        this.parent = table;
        if (bl2) {
            table.createItem(this, n3);
        }
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.imageIndent = 0;
        this.grayed = false;
        this.checked = false;
        this.font = -1;
        this.foreground = -1;
        this.background = -1;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.background == -1) {
            return this.parent.getBackground();
        }
        return Color.win32_new(this.display, this.background);
    }

    public Color getBackground(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return this.getBackground();
        }
        int n4 = this.cellBackground != null ? this.cellBackground[n2] : -1;
        return n4 == -1 ? this.getBackground() : Color.win32_new(this.display, n4);
    }

    public Rectangle getBounds() {
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n2 = this.parent.indexOf(this)) == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT = this.getBounds(n2, 0, true, false, false);
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n3, n4);
    }

    public Rectangle getBounds(int n2) {
        int n3;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n3 = this.parent.indexOf(this)) == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT = this.getBounds(n3, n2, true, true, true);
        int n4 = rECT.right - rECT.left;
        int n5 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n4, n5);
    }

    RECT getBounds(int n2, int n3, boolean bl2, boolean bl3, boolean bl4) {
        return this.getBounds(n2, n3, bl2, bl3, bl4, false, 0);
    }

    RECT getBounds(int n2, int n3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n4) {
        int n5;
        if (!bl2 && !bl3) {
            return new RECT();
        }
        int n6 = this.parent.getColumnCount();
        if (n3 < 0 || n3 >= Math.max(1, n6)) {
            return new RECT();
        }
        if (this.parent.fixScrollWidth) {
            this.parent.setScrollWidth(null, true);
        }
        RECT rECT = new RECT();
        int n7 = this.parent.handle;
        int n8 = OS.SendMessage(n7, 4151, 0, 0);
        if (n3 == 0 && (n8 & 0x20) == 0) {
            int n9;
            if (this.parent.explorerTheme) {
                rECT.left = 1;
                this.parent.ignoreCustomDraw = true;
                n9 = OS.SendMessage(n7, 4110, n2, rECT);
                this.parent.ignoreCustomDraw = false;
                if (n9 == 0) {
                    return new RECT();
                }
                if (bl2) {
                    int n10;
                    int n11 = 0;
                    int n12 = n10 = this.cellFont != null ? this.cellFont[n3] : -1;
                    if (n10 == -1) {
                        n10 = this.font;
                    }
                    if (n10 == -1 && n4 == 0) {
                        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, true);
                        n11 = OS.SendMessage(n7, OS.LVM_GETSTRINGWIDTH, 0, tCHAR);
                    } else {
                        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, false);
                        int n13 = n4 != 0 ? n4 : OS.GetDC(n7);
                        int n14 = -1;
                        if (n4 == 0) {
                            if (n10 == -1) {
                                n10 = OS.SendMessage(n7, 49, 0, 0);
                            }
                            n14 = OS.SelectObject(n13, n10);
                        }
                        RECT rECT2 = new RECT();
                        int n15 = 3104;
                        OS.DrawText(n13, tCHAR, tCHAR.length(), rECT2, n15);
                        n11 = rECT2.right - rECT2.left;
                        if (n4 == 0) {
                            if (n14 != -1) {
                                OS.SelectObject(n13, n14);
                            }
                            OS.ReleaseDC(n7, n13);
                        }
                    }
                    if (!bl3) {
                        rECT.left = rECT.right;
                    }
                    rECT.right += n11 + 8;
                }
            } else if (bl2) {
                rECT.left = 3;
                this.parent.ignoreCustomDraw = true;
                n9 = OS.SendMessage(n7, 4110, n2, rECT);
                this.parent.ignoreCustomDraw = false;
                if (n9 == 0) {
                    return new RECT();
                }
                if (!bl3) {
                    RECT rECT3 = new RECT();
                    rECT3.left = 1;
                    this.parent.ignoreCustomDraw = true;
                    n9 = OS.SendMessage(n7, 4110, n2, rECT3);
                    this.parent.ignoreCustomDraw = false;
                    if (n9 != 0) {
                        rECT.left = rECT3.right;
                    }
                }
            } else {
                rECT.left = 1;
                this.parent.ignoreCustomDraw = true;
                n9 = OS.SendMessage(n7, 4110, n2, rECT);
                this.parent.ignoreCustomDraw = false;
                if (n9 == 0) {
                    return new RECT();
                }
            }
            if (bl4 || bl5) {
                RECT rECT4 = new RECT();
                int n16 = OS.SendMessage(n7, 4127, 0, 0);
                OS.SendMessage(n16, 4615, 0, rECT4);
                OS.MapWindowPoints(n16, n7, rECT4, 2);
                if (bl2 && bl4) {
                    rECT.right = rECT4.right;
                }
                if (bl3 && bl5) {
                    rECT.left = rECT4.left;
                }
            }
        } else {
            boolean bl6 = n3 == 0 && this.image != null || this.images != null && this.images[n3] != null;
            rECT.top = n3;
            if (bl4 || bl5 || n4 == 0) {
                RECT rECT5;
                rECT.left = bl2 ? 2 : 1;
                this.parent.ignoreCustomDraw = true;
                int n17 = OS.SendMessage(n7, 4152, n2, rECT);
                this.parent.ignoreCustomDraw = false;
                if (n17 == 0) {
                    return new RECT();
                }
                if (n3 == 0 && bl2 && bl3) {
                    rECT5 = new RECT();
                    rECT5.left = 1;
                    this.parent.ignoreCustomDraw = true;
                    n17 = OS.SendMessage(n7, 4152, n2, rECT5);
                    this.parent.ignoreCustomDraw = false;
                    if (n17 != 0) {
                        rECT.left = rECT5.left;
                    }
                }
                if (bl6) {
                    if (n3 != 0 && bl2 && !bl3) {
                        rECT5 = new RECT();
                        rECT5.top = n3;
                        rECT5.left = 1;
                        if (OS.SendMessage(n7, 4152, n2, rECT5) != 0) {
                            rECT.left = rECT5.right + 2;
                        }
                    }
                } else if (bl3 && !bl2) {
                    rECT.right = rECT.left;
                }
                if (n3 == 0 && bl5) {
                    rECT5 = new RECT();
                    int n18 = OS.SendMessage(n7, 4127, 0, 0);
                    OS.SendMessage(n18, 4615, 0, rECT5);
                    OS.MapWindowPoints(n18, n7, rECT5, 2);
                    rECT.left = rECT5.left;
                }
            } else {
                rECT.left = 1;
                this.parent.ignoreCustomDraw = true;
                int n19 = OS.SendMessage(n7, 4152, n2, rECT);
                this.parent.ignoreCustomDraw = false;
                if (n19 == 0) {
                    return new RECT();
                }
                if (!bl6) {
                    rECT.right = rECT.left;
                }
                if (bl2) {
                    String string;
                    String string2 = n3 == 0 ? this.text : (string = this.strings != null ? this.strings[n3] : null);
                    if (string != null) {
                        RECT rECT6 = new RECT();
                        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), string, false);
                        int n20 = 3104;
                        OS.DrawText(n4, tCHAR, tCHAR.length(), rECT6, n20);
                        rECT.right += rECT6.right - rECT6.left + 12 + 1;
                    }
                }
            }
        }
        int n21 = n5 = this.parent.getLinesVisible() ? 1 : 0;
        if (OS.COMCTL32_VERSION >= OS.VERSION(5, 80)) {
            rECT.top -= n5;
        }
        if (n3 != 0) {
            rECT.left += n5;
        }
        rECT.right = Math.max(rECT.right, rECT.left);
        rECT.top += n5;
        rECT.bottom = Math.max(rECT.bottom - n5, rECT.top);
        return rECT;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font == -1 ? this.parent.getFont() : Font.win32_new(this.display, this.font);
    }

    public Font getFont(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return this.getFont();
        }
        int n4 = this.cellFont != null ? this.cellFont[n2] : this.font;
        return n4 == -1 ? this.getFont() : Font.win32_new(this.display, n4);
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.foreground == -1) {
            return this.parent.getForeground();
        }
        return Color.win32_new(this.display, this.foreground);
    }

    public Color getForeground(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return this.getForeground();
        }
        int n4 = this.cellForeground != null ? this.cellForeground[n2] : -1;
        return n4 == -1 ? this.getForeground() : Color.win32_new(this.display, n4);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n2 == 0) {
            return this.getImage();
        }
        if (this.images != null && n2 >= 0 && n2 < this.images.length) {
            return this.images[n2];
        }
        return null;
    }

    public Rectangle getImageBounds(int n2) {
        int n3;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n3 = this.parent.indexOf(this)) == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT = this.getBounds(n3, n2, false, true, false);
        int n4 = rECT.right - rECT.left;
        int n5 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n4, n5);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.imageIndent;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n2 == 0) {
            return this.getText();
        }
        if (this.strings != null && n2 >= 0 && n2 < this.strings.length) {
            String string = this.strings[n2];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int n2) {
        int n3;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n3 = this.parent.indexOf(this)) == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT = this.getBounds(n3, n2, true, false, true);
        rECT.left += 2;
        if (n2 != 0) {
            rECT.left += 4;
        }
        rECT.left = Math.min(rECT.left, rECT.right);
        rECT.right -= 4;
        int n4 = Math.max(0, rECT.right - rECT.left);
        int n5 = Math.max(0, rECT.bottom - rECT.top);
        return new Rectangle(rECT.left, rECT.top, n4, n5);
    }

    void redraw() {
        if (this.parent.currentItem == this || this.parent.drawCount != 0) {
            return;
        }
        int n2 = this.parent.handle;
        if (!OS.IsWindowVisible(n2)) {
            return;
        }
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return;
        }
        OS.SendMessage(n2, 4117, n3, n3);
    }

    void redraw(int n2, boolean bl2, boolean bl3) {
        if (this.parent.currentItem == this || this.parent.drawCount != 0) {
            return;
        }
        int n3 = this.parent.handle;
        if (!OS.IsWindowVisible(n3)) {
            return;
        }
        int n4 = this.parent.indexOf(this);
        if (n4 == -1) {
            return;
        }
        RECT rECT = this.getBounds(n4, n2, bl2, bl3, true);
        OS.InvalidateRect(n3, rECT, true);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = -1;
        if (color != null) {
            this.parent.setCustomDraw(true);
            n2 = color.handle;
        }
        if (this.background == n2) {
            return;
        }
        this.background = n2;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setBackground(int n2, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return;
        }
        int n4 = -1;
        if (color != null) {
            this.parent.setCustomDraw(true);
            n4 = color.handle;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new int[n3];
            int n5 = 0;
            while (n5 < n3) {
                this.cellBackground[n5] = -1;
                ++n5;
            }
        }
        if (this.cellBackground[n2] == n4) {
            return;
        }
        this.cellBackground[n2] = n4;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(n2, true, true);
    }

    public void setChecked(boolean bl2) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == bl2) {
            return;
        }
        this.setChecked(bl2, false);
    }

    void setChecked(boolean bl2, boolean bl3) {
        this.checked = bl2;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (bl3) {
            Event event = new Event();
            event.item = this;
            event.detail = 32;
            this.parent.postEvent(13, event);
        }
        this.redraw();
    }

    public void setFont(Font font) {
        int n2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n3 = -1;
        if (font != null) {
            this.parent.setCustomDraw(true);
            n3 = font.handle;
        }
        if (this.font == n3) {
            return;
        }
        this.font = n3;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if ((this.parent.style & 0x10000000) == 0 && this.cached && (n2 = this.parent.indexOf(this)) != -1) {
            int n4 = this.parent.handle;
            LVITEM lVITEM = new LVITEM();
            lVITEM.mask = 1;
            lVITEM.iItem = n2;
            lVITEM.pszText = -1;
            OS.SendMessage(n4, OS.LVM_SETITEM, 0, lVITEM);
            this.cached = false;
        }
        this.parent.setScrollWidth(this, false);
        this.redraw();
    }

    public void setFont(int n2, Font font) {
        int n3;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n4 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n4 - 1) {
            return;
        }
        int n5 = -1;
        if (font != null) {
            this.parent.setCustomDraw(true);
            n5 = font.handle;
        }
        if (this.cellFont == null) {
            this.cellFont = new int[n4];
            n3 = 0;
            while (n3 < n4) {
                this.cellFont[n3] = -1;
                ++n3;
            }
        }
        if (this.cellFont[n2] == n5) {
            return;
        }
        this.cellFont[n2] = n5;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (n2 == 0) {
            if ((this.parent.style & 0x10000000) == 0 && this.cached && (n3 = this.parent.indexOf(this)) != -1) {
                int n6 = this.parent.handle;
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 1;
                lVITEM.iItem = n3;
                lVITEM.pszText = -1;
                OS.SendMessage(n6, OS.LVM_SETITEM, 0, lVITEM);
                this.cached = false;
            }
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(n2, true, false);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = -1;
        if (color != null) {
            this.parent.setCustomDraw(true);
            n2 = color.handle;
        }
        if (this.foreground == n2) {
            return;
        }
        this.foreground = n2;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setForeground(int n2, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return;
        }
        int n4 = -1;
        if (color != null) {
            this.parent.setCustomDraw(true);
            n4 = color.handle;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new int[n3];
            int n5 = 0;
            while (n5 < n3) {
                this.cellForeground[n5] = -1;
                ++n5;
            }
        }
        if (this.cellForeground[n2] == n4) {
            return;
        }
        this.cellForeground[n2] = n4;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(n2, true, false);
    }

    public void setGrayed(boolean bl2) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl2) {
            return;
        }
        this.grayed = bl2;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n2 = 0;
        while (n2 < imageArray.length) {
            this.setImage(n2, imageArray[n2]);
            ++n2;
        }
    }

    public void setImage(int n2, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        Image image2 = null;
        if (n2 == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            image2 = this.image;
            super.setImage(image);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return;
        }
        if (this.images == null && n2 != 0) {
            this.images = new Image[n3];
            this.images[0] = image;
        }
        if (this.images != null) {
            if (image != null && image.type == 1 && image.equals(this.images[n2])) {
                return;
            }
            image2 = this.images[n2];
            this.images[n2] = image;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.parent.imageIndex(image, n2);
        if (n2 == 0) {
            this.parent.setScrollWidth(this, false);
        }
        boolean bl2 = image == null && image2 != null || image != null && image2 == null;
        this.redraw(n2, bl2, true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (this.imageIndent == n2) {
            return;
        }
        this.imageIndent = n2;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        } else {
            int n3 = this.parent.indexOf(this);
            if (n3 != -1) {
                int n4 = this.parent.handle;
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 16;
                lVITEM.iItem = n3;
                lVITEM.iIndent = n2;
                OS.SendMessage(n4, OS.LVM_SETITEM, 0, lVITEM);
            }
        }
        this.parent.setScrollWidth(this, false);
        this.redraw();
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            if (string != null) {
                this.setText(n2, string);
            }
            ++n2;
        }
    }

    public void setText(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n2 == 0) {
            if (string.equals(this.text)) {
                return;
            }
            super.setText(string);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return;
        }
        if (this.strings == null && n2 != 0) {
            this.strings = new String[n3];
            this.strings[0] = this.text;
        }
        if (this.strings != null) {
            if (string.equals(this.strings[n2])) {
                return;
            }
            this.strings[n2] = string;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (n2 == 0) {
            int n4;
            if ((this.parent.style & 0x10000000) == 0 && this.cached && (n4 = this.parent.indexOf(this)) != -1) {
                int n5 = this.parent.handle;
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 1;
                lVITEM.iItem = n4;
                lVITEM.pszText = -1;
                OS.SendMessage(n5, OS.LVM_SETITEM, 0, lVITEM);
                this.cached = false;
            }
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(n2, true, false);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

