/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.NondirectBufferWrapper;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class NVVertexArrayRange {
    public static final int GL_VERTEX_ARRAY_RANGE_NV = 34077;
    public static final int GL_VERTEX_ARRAY_RANGE_LENGTH_NV = 34078;
    public static final int GL_VERTEX_ARRAY_RANGE_VALID_NV = 34079;
    public static final int GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = 34080;
    public static final int GL_VERTEX_ARRAY_RANGE_POINTER_NV = 34081;

    private NVVertexArrayRange() {
    }

    public static void glVertexArrayRangeNV(ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_vertex_array_range_glVertexArrayRangeNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        byteBuffer = NondirectBufferWrapper.wrapDirect(byteBuffer);
        NVVertexArrayRange.nglVertexArrayRangeNV(byteBuffer.remaining(), byteBuffer, byteBuffer.position(), l2);
    }

    public static void glVertexArrayRangeNV(DoubleBuffer doubleBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_vertex_array_range_glVertexArrayRangeNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        doubleBuffer = NondirectBufferWrapper.wrapDirect(doubleBuffer);
        NVVertexArrayRange.nglVertexArrayRangeNV(doubleBuffer.remaining() << 3, doubleBuffer, doubleBuffer.position() << 3, l2);
    }

    public static void glVertexArrayRangeNV(FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_vertex_array_range_glVertexArrayRangeNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        floatBuffer = NondirectBufferWrapper.wrapDirect(floatBuffer);
        NVVertexArrayRange.nglVertexArrayRangeNV(floatBuffer.remaining() << 2, floatBuffer, floatBuffer.position() << 2, l2);
    }

    public static void glVertexArrayRangeNV(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_vertex_array_range_glVertexArrayRangeNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        intBuffer = NondirectBufferWrapper.wrapDirect(intBuffer);
        NVVertexArrayRange.nglVertexArrayRangeNV(intBuffer.remaining() << 2, intBuffer, intBuffer.position() << 2, l2);
    }

    public static void glVertexArrayRangeNV(ShortBuffer shortBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_vertex_array_range_glVertexArrayRangeNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        shortBuffer = NondirectBufferWrapper.wrapDirect(shortBuffer);
        NVVertexArrayRange.nglVertexArrayRangeNV(shortBuffer.remaining() << 1, shortBuffer, shortBuffer.position() << 1, l2);
    }

    private static native void nglVertexArrayRangeNV(int var0, Buffer var1, int var2, long var3);

    public static void glFlushVertexArrayRangeNV() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_vertex_array_range_glFlushVertexArrayRangeNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        NVVertexArrayRange.nglFlushVertexArrayRangeNV(l2);
    }

    private static native void nglFlushVertexArrayRangeNV(long var0);

    public static ByteBuffer glAllocateMemoryNV(int n2, float f2, float f3, float f4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_vertex_array_range_glAllocateMemoryNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ByteBuffer byteBuffer = NVVertexArrayRange.nglAllocateMemoryNV(n2, f2, f3, f4, n2, l2);
        return byteBuffer;
    }

    private static native ByteBuffer nglAllocateMemoryNV(int var0, float var1, float var2, float var3, long var4, long var6);

    public static void glFreeMemoryNV(ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_vertex_array_range_glFreeMemoryNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        byteBuffer = NondirectBufferWrapper.wrapDirect(byteBuffer);
        NVVertexArrayRange.nglFreeMemoryNV(byteBuffer, byteBuffer.position(), l2);
    }

    private static native void nglFreeMemoryNV(Buffer var0, int var1, long var2);
}

