/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.a;
import org.objectweb.asm.b;
import org.objectweb.asm.c;
import org.objectweb.asm.f;

public class ClassWriter
implements ClassVisitor {
    public static final int COMPUTE_MAXS = 1;
    public static final int COMPUTE_FRAMES = 2;
    static final int NOARG_INSN = 0;
    static final int SBYTE_INSN = 1;
    static final int SHORT_INSN = 2;
    static final int VAR_INSN = 3;
    static final int IMPLVAR_INSN = 4;
    static final int TYPE_INSN = 5;
    static final int FIELDORMETH_INSN = 6;
    static final int ITFMETH_INSN = 7;
    static final int LABEL_INSN = 8;
    static final int LABELW_INSN = 9;
    static final int LDC_INSN = 10;
    static final int LDCW_INSN = 11;
    static final int IINC_INSN = 12;
    static final int TABL_INSN = 13;
    static final int LOOK_INSN = 14;
    static final int MANA_INSN = 15;
    static final int WIDE_INSN = 16;
    static byte[] TYPE;
    static final int CLASS = 7;
    static final int FIELD = 9;
    static final int METH = 10;
    static final int IMETH = 11;
    static final int STR = 8;
    static final int INT = 3;
    static final int FLOAT = 4;
    static final int LONG = 5;
    static final int DOUBLE = 6;
    static final int NAME_TYPE = 12;
    static final int UTF8 = 1;
    static final int TYPE_NORMAL = 13;
    static final int TYPE_UNINIT = 14;
    static final int TYPE_MERGED = 15;
    ClassReader cr;
    int version;
    int index = 1;
    ByteVector pool = new ByteVector();
    b[] items = new b[256];
    int threshold = (int)(0.75 * (double)this.items.length);
    b key = new b();
    b key2 = new b();
    b key3 = new b();
    b[] typeTable;
    private short typeCount;
    private int access;
    private int name;
    String thisName;
    private int signature;
    private int superName;
    private int interfaceCount;
    private int[] interfaces;
    private int sourceFile;
    private ByteVector sourceDebug;
    private int enclosingMethodOwner;
    private int enclosingMethod;
    private c anns;
    private c ianns;
    private Attribute attrs;
    private int innerClassesCount;
    private ByteVector innerClasses;
    a firstField;
    a lastField;
    f firstMethod;
    f lastMethod;
    private boolean computeMaxs;
    private boolean computeFrames;
    boolean invalidFrames;

    public ClassWriter(int n2) {
        this.computeMaxs = (n2 & 1) != 0;
        this.computeFrames = (n2 & 2) != 0;
    }

    public ClassWriter(ClassReader classReader, int n2) {
        this(n2);
        classReader.copyPool(this);
        this.cr = classReader;
    }

    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        this.version = n2;
        this.access = n3;
        this.name = this.newClass(string);
        this.thisName = string;
        if (string2 != null) {
            this.signature = this.newUTF8(string2);
        }
        int n4 = this.superName = string3 == null ? 0 : this.newClass(string3);
        if (stringArray != null && stringArray.length > 0) {
            this.interfaceCount = stringArray.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i2 = 0; i2 < this.interfaceCount; ++i2) {
                this.interfaces[i2] = this.newClass(stringArray[i2]);
            }
        }
    }

    public void visitSource(String string, String string2) {
        if (string != null) {
            this.sourceFile = this.newUTF8(string);
        }
        if (string2 != null) {
            this.sourceDebug = new ByteVector().putUTF8(string2);
        }
    }

    public void visitOuterClass(String string, String string2, String string3) {
        this.enclosingMethodOwner = this.newClass(string);
        if (string2 != null && string3 != null) {
            this.enclosingMethod = this.newNameType(string2, string3);
        }
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(this.newUTF8(string)).putShort(0);
        c c2 = new c(this, true, byteVector, byteVector, 2);
        if (bl2) {
            c2.a = this.anns;
            this.anns = c2;
        } else {
            c2.a = this.ianns;
            this.ianns = c2;
        }
        return c2;
    }

    public void visitAttribute(Attribute attribute) {
        attribute.next = this.attrs;
        this.attrs = attribute;
    }

    public void visitInnerClass(String string, String string2, String string3, int n2) {
        if (this.innerClasses == null) {
            this.innerClasses = new ByteVector();
        }
        ++this.innerClassesCount;
        this.innerClasses.putShort(string == null ? 0 : this.newClass(string));
        this.innerClasses.putShort(string2 == null ? 0 : this.newClass(string2));
        this.innerClasses.putShort(string3 == null ? 0 : this.newUTF8(string3));
        this.innerClasses.putShort(n2);
    }

    public FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
        return new a(this, n2, string, string2, string3, object);
    }

    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        return new f(this, n2, string, string2, string3, stringArray, this.computeMaxs, this.computeFrames);
    }

    public void visitEnd() {
    }

    public byte[] toByteArray() {
        int n2;
        f f2;
        a a2;
        int n3 = 24 + 2 * this.interfaceCount;
        int n4 = 0;
        a a3 = a2 = this.firstField;
        while (a3 != null) {
            ++n4;
            n3 += a2.a();
            a3 = a2.a;
        }
        int n5 = 0;
        f f3 = f2 = this.firstMethod;
        while (f3 != null) {
            ++n5;
            n3 += f2.a();
            f3 = f2.a;
        }
        int n6 = 0;
        if (this.signature != 0) {
            ++n6;
            n3 += 8;
            this.newUTF8("Signature");
        }
        if (this.sourceFile != 0) {
            ++n6;
            n3 += 8;
            this.newUTF8("SourceFile");
        }
        if (this.sourceDebug != null) {
            ++n6;
            n3 += this.sourceDebug.length + 4;
            this.newUTF8("SourceDebugExtension");
        }
        if (this.enclosingMethodOwner != 0) {
            ++n6;
            n3 += 10;
            this.newUTF8("EnclosingMethod");
        }
        if ((this.access & 0x20000) != 0) {
            ++n6;
            n3 += 6;
            this.newUTF8("Deprecated");
        }
        if ((this.access & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            ++n6;
            n3 += 6;
            this.newUTF8("Synthetic");
        }
        if (this.innerClasses != null) {
            ++n6;
            n3 += 8 + this.innerClasses.length;
            this.newUTF8("InnerClasses");
        }
        if (this.anns != null) {
            ++n6;
            n3 += 8 + this.anns.a();
            this.newUTF8("RuntimeVisibleAnnotations");
        }
        if (this.ianns != null) {
            ++n6;
            n3 += 8 + this.ianns.a();
            this.newUTF8("RuntimeInvisibleAnnotations");
        }
        if (this.attrs != null) {
            n6 += this.attrs.getCount();
            n3 += this.attrs.getSize(this, null, 0, -1, -1);
        }
        ByteVector byteVector = new ByteVector(n3 += this.pool.length);
        byteVector.putInt(-889275714).putInt(this.version);
        byteVector.putShort(this.index).putByteArray(this.pool.data, 0, this.pool.length);
        byteVector.putShort(this.access).putShort(this.name).putShort(this.superName);
        byteVector.putShort(this.interfaceCount);
        for (n2 = 0; n2 < this.interfaceCount; ++n2) {
            byteVector.putShort(this.interfaces[n2]);
        }
        byteVector.putShort(n4);
        a a4 = a2 = this.firstField;
        while (a4 != null) {
            a2.a(byteVector);
            a4 = a2.a;
        }
        byteVector.putShort(n5);
        f f4 = f2 = this.firstMethod;
        while (f4 != null) {
            f2.a(byteVector);
            f4 = f2.a;
        }
        byteVector.putShort(n6);
        if (this.signature != 0) {
            byteVector.putShort(this.newUTF8("Signature")).putInt(2).putShort(this.signature);
        }
        if (this.sourceFile != 0) {
            byteVector.putShort(this.newUTF8("SourceFile")).putInt(2).putShort(this.sourceFile);
        }
        if (this.sourceDebug != null) {
            n2 = this.sourceDebug.length - 2;
            byteVector.putShort(this.newUTF8("SourceDebugExtension")).putInt(n2);
            byteVector.putByteArray(this.sourceDebug.data, 2, n2);
        }
        if (this.enclosingMethodOwner != 0) {
            byteVector.putShort(this.newUTF8("EnclosingMethod")).putInt(4);
            byteVector.putShort(this.enclosingMethodOwner).putShort(this.enclosingMethod);
        }
        if ((this.access & 0x20000) != 0) {
            byteVector.putShort(this.newUTF8("Deprecated")).putInt(0);
        }
        if ((this.access & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            byteVector.putShort(this.newUTF8("Synthetic")).putInt(0);
        }
        if (this.innerClasses != null) {
            byteVector.putShort(this.newUTF8("InnerClasses"));
            byteVector.putInt(this.innerClasses.length + 2).putShort(this.innerClassesCount);
            byteVector.putByteArray(this.innerClasses.data, 0, this.innerClasses.length);
        }
        if (this.anns != null) {
            byteVector.putShort(this.newUTF8("RuntimeVisibleAnnotations"));
            this.anns.a(byteVector);
        }
        if (this.ianns != null) {
            byteVector.putShort(this.newUTF8("RuntimeInvisibleAnnotations"));
            this.ianns.a(byteVector);
        }
        if (this.attrs != null) {
            this.attrs.put(this, null, 0, -1, -1, byteVector);
        }
        if (this.invalidFrames) {
            ClassWriter classWriter = new ClassWriter(2);
            new ClassReader(byteVector.data).accept(classWriter, 4);
            return classWriter.toByteArray();
        }
        return byteVector.data;
    }

    b newConstItem(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return this.newInteger(n2);
        }
        if (object instanceof Byte) {
            int n3 = ((Byte)object).intValue();
            return this.newInteger(n3);
        }
        if (object instanceof Character) {
            char c2 = ((Character)object).charValue();
            return this.newInteger(c2);
        }
        if (object instanceof Short) {
            int n4 = ((Short)object).intValue();
            return this.newInteger(n4);
        }
        if (object instanceof Boolean) {
            int n5 = (Boolean)object != false ? 1 : 0;
            return this.newInteger(n5);
        }
        if (object instanceof Float) {
            float f2 = ((Float)object).floatValue();
            return this.newFloat(f2);
        }
        if (object instanceof Long) {
            long l2 = (Long)object;
            return this.newLong(l2);
        }
        if (object instanceof Double) {
            double d2 = (Double)object;
            return this.newDouble(d2);
        }
        if (object instanceof String) {
            return this.newString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            return this.newClassItem(type.getSort() == 10 ? type.getInternalName() : type.getDescriptor());
        }
        throw new IllegalArgumentException("value " + object);
    }

    public int newConst(Object object) {
        return this.newConstItem((Object)object).a;
    }

    public int newUTF8(String string) {
        this.key.a(1, string, null, null);
        b b2 = this.get(this.key);
        if (b2 == null) {
            this.pool.putByte(1).putUTF8(string);
            b2 = new b(this.index++, this.key);
            this.put(b2);
        }
        return b2.a;
    }

    b newClassItem(String string) {
        this.key2.a(7, string, null, null);
        b b2 = this.get(this.key2);
        if (b2 == null) {
            this.pool.put12(7, this.newUTF8(string));
            b2 = new b(this.index++, this.key2);
            this.put(b2);
        }
        return b2;
    }

    public int newClass(String string) {
        return this.newClassItem((String)string).a;
    }

    b newFieldItem(String string, String string2, String string3) {
        this.key3.a(9, string, string2, string3);
        b b2 = this.get(this.key3);
        if (b2 == null) {
            this.put122(9, this.newClass(string), this.newNameType(string2, string3));
            b2 = new b(this.index++, this.key3);
            this.put(b2);
        }
        return b2;
    }

    public int newField(String string, String string2, String string3) {
        return this.newFieldItem((String)string, (String)string2, (String)string3).a;
    }

    b newMethodItem(String string, String string2, String string3, boolean bl2) {
        int n2 = bl2 ? 11 : 10;
        this.key3.a(n2, string, string2, string3);
        b b2 = this.get(this.key3);
        if (b2 == null) {
            this.put122(n2, this.newClass(string), this.newNameType(string2, string3));
            b2 = new b(this.index++, this.key3);
            this.put(b2);
        }
        return b2;
    }

    public int newMethod(String string, String string2, String string3, boolean bl2) {
        return this.newMethodItem((String)string, (String)string2, (String)string3, (boolean)bl2).a;
    }

    b newInteger(int n2) {
        this.key.a(n2);
        b b2 = this.get(this.key);
        if (b2 == null) {
            this.pool.putByte(3).putInt(n2);
            b2 = new b(this.index++, this.key);
            this.put(b2);
        }
        return b2;
    }

    b newFloat(float f2) {
        this.key.a(f2);
        b b2 = this.get(this.key);
        if (b2 == null) {
            this.pool.putByte(4).putInt(this.key.c);
            b2 = new b(this.index++, this.key);
            this.put(b2);
        }
        return b2;
    }

    b newLong(long l2) {
        this.key.a(l2);
        b b2 = this.get(this.key);
        if (b2 == null) {
            this.pool.putByte(5).putLong(l2);
            b2 = new b(this.index, this.key);
            this.put(b2);
            this.index += 2;
        }
        return b2;
    }

    b newDouble(double d2) {
        this.key.a(d2);
        b b2 = this.get(this.key);
        if (b2 == null) {
            this.pool.putByte(6).putLong(this.key.a);
            b2 = new b(this.index, this.key);
            this.put(b2);
            this.index += 2;
        }
        return b2;
    }

    private b newString(String string) {
        this.key2.a(8, string, null, null);
        b b2 = this.get(this.key2);
        if (b2 == null) {
            this.pool.put12(8, this.newUTF8(string));
            b2 = new b(this.index++, this.key2);
            this.put(b2);
        }
        return b2;
    }

    public int newNameType(String string, String string2) {
        this.key2.a(12, string, string2, null);
        b b2 = this.get(this.key2);
        if (b2 == null) {
            this.put122(12, this.newUTF8(string), this.newUTF8(string2));
            b2 = new b(this.index++, this.key2);
            this.put(b2);
        }
        return b2.a;
    }

    int addType(String string) {
        this.key.a(13, string, null, null);
        b b2 = this.get(this.key);
        if (b2 == null) {
            b2 = this.addType(this.key);
        }
        return b2.a;
    }

    int addUninitializedType(String string, int n2) {
        this.key.b = 14;
        this.key.c = n2;
        this.key.a = string;
        this.key.d = Integer.MAX_VALUE & 14 + string.hashCode() + n2;
        b b2 = this.get(this.key);
        if (b2 == null) {
            b2 = this.addType(this.key);
        }
        return b2.a;
    }

    private b addType(b b2) {
        this.typeCount = (short)(this.typeCount + 1);
        b b3 = new b(this.typeCount, this.key);
        this.put(b3);
        if (this.typeTable == null) {
            this.typeTable = new b[16];
        }
        if (this.typeCount == this.typeTable.length) {
            b[] bArray = new b[2 * this.typeTable.length];
            System.arraycopy(this.typeTable, 0, bArray, 0, this.typeTable.length);
            this.typeTable = bArray;
        }
        this.typeTable[this.typeCount] = b3;
        return b3;
    }

    int getMergedType(int n2, int n3) {
        this.key2.b = 15;
        this.key2.a = (long)n2 | (long)n3 << 32;
        this.key2.d = Integer.MAX_VALUE & 15 + n2 + n3;
        b b2 = this.get(this.key2);
        if (b2 == null) {
            String string = this.typeTable[n2].a;
            String string2 = this.typeTable[n3].a;
            this.key2.c = this.addType(this.getCommonSuperClass(string, string2));
            b2 = new b(0, this.key2);
            this.put(b2);
        }
        return b2.c;
    }

    protected String getCommonSuperClass(String string, String string2) {
        Class<?> clazz;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName(string.replace('/', '.'));
            clazz = Class.forName(string2.replace('/', '.'));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return string;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return string2;
        }
        if (clazz2.isInterface() || clazz.isInterface()) {
            return "java/lang/Object";
        }
        while (!(clazz2 = clazz2.getSuperclass()).isAssignableFrom(clazz)) {
        }
        return clazz2.getName().replace('.', '/');
    }

    private b get(b b2) {
        b b3;
        b b4 = b3 = this.items[b2.d % this.items.length];
        while (b4 != null && !b2.a(b3)) {
            b4 = b3.a;
        }
        return b3;
    }

    private void put(b b2) {
        int n2;
        if (this.index > this.threshold) {
            n2 = this.items.length;
            int n3 = n2 * 2 + 1;
            b[] bArray = new b[n3];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                b b3;
                b b4 = b3 = this.items[i2];
                while (b4 != null) {
                    int n4 = b3.d % bArray.length;
                    b b5 = b3.a;
                    b3.a = bArray[n4];
                    bArray[n4] = b3;
                    b4 = b5;
                }
            }
            this.items = bArray;
            this.threshold = (int)((double)n3 * 0.75);
        }
        n2 = b2.d % this.items.length;
        b2.a = this.items[n2];
        this.items[n2] = b2;
    }

    private void put122(int n2, int n3, int n4) {
        this.pool.put12(n2, n3).putShort(n4);
    }

    static {
        byte[] byArray = new byte[220];
        String string = "AAAAAAAAAAAAAAAABCKLLDDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAADDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAIIIIIIIIIIIIIIIIDNOAAAAAAGGGGGGGHAFBFAAFFAAQPIIJJIIIIIIIIIIIIIIIIII";
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)(string.charAt(i2) - 65);
        }
        TYPE = byArray;
    }
}

