/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;

class LazyActionMap
extends ActionMapUIResource {
    private transient Object _loader;
    private transient JComponent _component;
    static final /* synthetic */ boolean $assertionsDisabled;

    public int size() {
        this.loadIfNecessary();
        return super.size();
    }

    static {
        $assertionsDisabled = !LazyActionMap.class.desiredAssertionStatus();
    }

    public void clear() {
        this.loadIfNecessary();
        super.clear();
    }

    private void loadIfNecessary() {
        if (this._loader != null) {
            block11: {
                Object object = this._loader;
                this._loader = null;
                if (object instanceof Loader) {
                    ((Loader)object).loadActionMap(this._component, this);
                } else {
                    Class clazz = (Class)object;
                    try {
                        Method method = clazz.getDeclaredMethod("loadActionMap", new Class[]{ActionMap.class});
                        method.invoke(clazz, new Object[]{this});
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("LazyActionMap unable to load actions " + clazz));
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("LazyActionMap unable to load actions " + illegalAccessException));
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("LazyActionMap unable to load actions " + invocationTargetException));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError((Object)("LazyActionMap unable to load actions " + illegalArgumentException));
                    }
                }
            }
            this._component = null;
        }
    }

    private LazyActionMap(Class clazz) {
        this._loader = clazz;
    }

    public Object[] allKeys() {
        this.loadIfNecessary();
        return super.allKeys();
    }

    public Object[] keys() {
        this.loadIfNecessary();
        return super.keys();
    }

    public void remove(Object object) {
        this.loadIfNecessary();
        super.remove(object);
    }

    static void installLazyActionMap(JComponent jComponent, Loader loader) {
        SwingUtilities.replaceUIActionMap(jComponent, new LazyActionMap(loader, jComponent));
    }

    public Action get(Object object) {
        this.loadIfNecessary();
        return super.get(object);
    }

    public void put(Object object, Action action) {
        this.loadIfNecessary();
        super.put(object, action);
    }

    private LazyActionMap(Loader loader, JComponent jComponent) {
        this._loader = loader;
        this._component = jComponent;
    }

    static void installLazyActionMap(JComponent jComponent, Class clazz, String string) {
        ActionMap actionMap = (ActionMap)UIManager.get(string);
        if (actionMap == null) {
            actionMap = new LazyActionMap(clazz);
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        SwingUtilities.replaceUIActionMap(jComponent, actionMap);
    }

    static ActionMap getActionMap(Class clazz, String string) {
        ActionMap actionMap = (ActionMap)UIManager.get(string);
        if (actionMap == null) {
            actionMap = new LazyActionMap(clazz);
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        return actionMap;
    }

    public static interface Loader {
        public void loadActionMap(JComponent var1, ActionMap var2);
    }
}

