/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

class GeneralPathIterator
implements PathIterator {
    int typeIdx = 0;
    int pointIdx = 0;
    GeneralPath path;
    AffineTransform affine;
    private static final int[] curvesize = new int[]{2, 2, 4, 6, 0};

    public int getWindingRule() {
        return this.path.getWindingRule();
    }

    public void next() {
        byte by = this.path.pointTypes[this.typeIdx++];
        this.pointIdx += curvesize[by];
    }

    public boolean isDone() {
        return this.typeIdx >= this.path.numTypes;
    }

    public int currentSegment(double[] dArray) {
        byte by = this.path.pointTypes[this.typeIdx];
        int n2 = curvesize[by];
        if (n2 > 0 && this.affine != null) {
            this.affine.transform(this.path.pointCoords, this.pointIdx, dArray, 0, n2 / 2);
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                dArray[i2] = this.path.pointCoords[this.pointIdx + i2];
            }
        }
        return by;
    }

    public int currentSegment(float[] fArray) {
        byte by = this.path.pointTypes[this.typeIdx];
        int n2 = curvesize[by];
        if (n2 > 0 && this.affine != null) {
            this.affine.transform(this.path.pointCoords, this.pointIdx, fArray, 0, n2 / 2);
        } else {
            System.arraycopy(this.path.pointCoords, this.pointIdx, fArray, 0, n2);
        }
        return by;
    }

    GeneralPathIterator(GeneralPath generalPath) {
        this(generalPath, null);
    }

    GeneralPathIterator(GeneralPath generalPath, AffineTransform affineTransform) {
        this.path = generalPath;
        this.affine = affineTransform;
    }
}

