/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;

public class Kernel
implements Cloneable {
    private int width;
    private int height;
    private int xOrigin;
    private int yOrigin;
    private float[] data;

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getXOrigin() {
        return this.xOrigin;
    }

    public final int getYOrigin() {
        return this.yOrigin;
    }

    static {
        ColorModel.loadLibraries();
        Kernel.initIDs();
    }

    private static native void initIDs();

    public Kernel(int n2, int n3, float[] fArray) {
        this.width = n2;
        this.height = n3;
        this.xOrigin = n2 - 1 >> 1;
        this.yOrigin = n3 - 1 >> 1;
        int n4 = n2 * n3;
        if (fArray.length < n4) {
            throw new IllegalArgumentException("Data array too small (is " + fArray.length + " and should be " + n4);
        }
        this.data = new float[n4];
        System.arraycopy(fArray, 0, this.data, 0, n4);
    }

    public final float[] getKernelData(float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.data.length];
        } else if (fArray.length < this.data.length) {
            throw new IllegalArgumentException("Data array too small (should be " + this.data.length + " but is " + fArray.length + " )");
        }
        System.arraycopy(this.data, 0, fArray, 0, this.data.length);
        return fArray;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

