/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

public abstract class AbstractSelectableChannel
extends SelectableChannel {
    private final SelectorProvider provider;
    private SelectionKey[] keys = null;
    private int keyCount = 0;
    private final Object keyLock = new Object();
    private final Object regLock = new Object();
    boolean blocking = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !AbstractSelectableChannel.class.desiredAssertionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void implCloseChannel() throws IOException {
        this.implCloseSelectableChannel();
        Object object = this.keyLock;
        synchronized (object) {
            int n2 = this.keys == null ? 0 : this.keys.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                SelectionKey selectionKey = this.keys[i2];
                if (selectionKey == null) continue;
                selectionKey.cancel();
            }
        }
    }

    protected abstract void implCloseSelectableChannel() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haveValidKeys() {
        Object object = this.keyLock;
        synchronized (object) {
            if (this.keyCount == 0) {
                return false;
            }
            for (int i2 = 0; i2 < this.keys.length; ++i2) {
                if (this.keys[i2] == null || !this.keys[i2].isValid()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isBlocking() {
        Object object = this.regLock;
        synchronized (object) {
            return this.blocking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRegistered() {
        Object object = this.keyLock;
        synchronized (object) {
            return this.keyCount != 0;
        }
    }

    protected abstract void implConfigureBlocking(boolean var1) throws IOException;

    public final Object blockingLock() {
        return this.regLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SelectableChannel configureBlocking(boolean bl2) throws IOException {
        Object object = this.regLock;
        synchronized (object) {
            if (this.blocking == bl2) {
                return this;
            }
            if (bl2 && this.haveValidKeys()) {
                throw new IllegalBlockingModeException();
            }
            this.implConfigureBlocking(bl2);
            this.blocking = bl2;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKey(SelectionKey selectionKey) {
        Object object = this.keyLock;
        synchronized (object) {
            int n2 = 0;
            if (this.keys != null && this.keyCount < this.keys.length) {
                for (n2 = 0; n2 < this.keys.length && this.keys[n2] != null; ++n2) {
                }
            } else if (this.keys == null) {
                this.keys = new SelectionKey[3];
            } else {
                int n3 = this.keys.length * 2;
                SelectionKey[] selectionKeyArray = new SelectionKey[n3];
                for (n2 = 0; n2 < this.keys.length; ++n2) {
                    selectionKeyArray[n2] = this.keys[n2];
                }
                this.keys = selectionKeyArray;
                n2 = this.keyCount;
            }
            this.keys[n2] = selectionKey;
            ++this.keyCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeKey(SelectionKey selectionKey) {
        Object object = this.keyLock;
        synchronized (object) {
            int n2;
            for (n2 = 0; n2 < this.keys.length; ++n2) {
                if (this.keys[n2] != selectionKey) continue;
                this.keys[n2] = null;
                --this.keyCount;
            }
            if (!$assertionsDisabled && n2 > this.keyCount) {
                throw new AssertionError();
            }
        }
    }

    public final SelectorProvider provider() {
        return this.provider;
    }

    protected AbstractSelectableChannel(SelectorProvider selectorProvider) {
        this.provider = selectorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelectionKey findKey(Selector selector) {
        Object object = this.keyLock;
        synchronized (object) {
            if (this.keys == null) {
                return null;
            }
            for (int i2 = 0; i2 < this.keys.length; ++i2) {
                if (this.keys[i2] == null || this.keys[i2].selector() != selector) continue;
                return this.keys[i2];
            }
            return null;
        }
    }

    public final SelectionKey keyFor(Selector selector) {
        return this.findKey(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SelectionKey register(Selector selector, int n2, Object object) throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((n2 & ~this.validOps()) != 0) {
            throw new IllegalArgumentException();
        }
        Object object2 = this.regLock;
        synchronized (object2) {
            if (this.blocking) {
                throw new IllegalBlockingModeException();
            }
            SelectionKey selectionKey = this.findKey(selector);
            if (selectionKey != null) {
                selectionKey.interestOps(n2);
                selectionKey.attach(object);
            }
            if (selectionKey == null) {
                selectionKey = ((AbstractSelector)selector).register(this, n2, object);
                this.addKey(selectionKey);
            }
            return selectionKey;
        }
    }
}

