/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Utilities;

public class DefaultFormatter
extends JFormattedTextField.AbstractFormatter
implements Cloneable,
Serializable {
    private boolean allowsInvalid = true;
    private boolean overwriteMode = true;
    private boolean commitOnEdit;
    private Class valueClass;
    private NavigationFilter navigationFilter;
    private DocumentFilter documentFilter;
    transient ReplaceHolder replaceHolder;

    int getInitialVisualPosition() {
        return this.getNextNavigatableChar(0, 1);
    }

    void commitEdit() throws ParseException {
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        if (jFormattedTextField != null) {
            jFormattedTextField.commitEdit();
        }
    }

    void positionCursorAtInitialLocation() {
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        if (jFormattedTextField != null) {
            jFormattedTextField.setCaretPosition(this.getInitialVisualPosition());
        }
    }

    void updateValue() {
        this.updateValue(null);
    }

    public boolean getAllowsInvalid() {
        return this.allowsInvalid;
    }

    public boolean getCommitsOnValidEdit() {
        return this.commitOnEdit;
    }

    public boolean getOverwriteMode() {
        return this.overwriteMode;
    }

    boolean isNavigatable(int n2) {
        return true;
    }

    int getNextCursorPosition(int n2, int n3) {
        int n4 = this.getNextNavigatableChar(n2, n3);
        int n5 = this.getFormattedTextField().getDocument().getLength();
        if (!this.getAllowsInvalid()) {
            if (n3 == -1 && n2 == n4) {
                if ((n4 = this.getNextNavigatableChar(n4, 1)) >= n5) {
                    n4 = n2;
                }
            } else if (n3 == 1 && n4 >= n5 && (n4 = this.getNextNavigatableChar(n5 - 1, -1)) < n5) {
                ++n4;
            }
        }
        return n4;
    }

    private int getNextNavigatableChar(int n2, int n3) {
        int n4 = this.getFormattedTextField().getDocument().getLength();
        while (n2 >= 0 && n2 < n4) {
            if (this.isNavigatable(n2)) {
                return n2;
            }
            n2 += n3;
        }
        return n2;
    }

    void repositionCursor(int n2, int n3) {
        this.getFormattedTextField().getCaret().setDot(this.getNextCursorPosition(n2, n3));
    }

    public void setAllowsInvalid(boolean bl2) {
        this.allowsInvalid = bl2;
    }

    public void setCommitsOnValidEdit(boolean bl2) {
        this.commitOnEdit = bl2;
    }

    public void setOverwriteMode(boolean bl2) {
        this.overwriteMode = bl2;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class clazz) {
        this.valueClass = clazz;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultFormatter defaultFormatter = (DefaultFormatter)super.clone();
        defaultFormatter.navigationFilter = null;
        defaultFormatter.documentFilter = null;
        defaultFormatter.replaceHolder = null;
        return defaultFormatter;
    }

    void updateValue(Object object) {
        try {
            if (object == null) {
                String string = this.getFormattedTextField().getText();
                object = this.stringToValue(string);
            }
            if (this.getCommitsOnValidEdit()) {
                this.commitEdit();
            }
            this.setEditValid(true);
        }
        catch (ParseException parseException) {
            this.setEditValid(false);
        }
    }

    boolean isLegalInsertText(String string) {
        return true;
    }

    public void install(JFormattedTextField jFormattedTextField) {
        super.install(jFormattedTextField);
        this.positionCursorAtInitialLocation();
    }

    boolean canReplace(ReplaceHolder replaceHolder) {
        return this.isValidEdit(replaceHolder);
    }

    boolean isValidEdit(ReplaceHolder replaceHolder) {
        if (!this.getAllowsInvalid()) {
            String string = this.getReplaceString(replaceHolder.offset, replaceHolder.length, replaceHolder.text);
            try {
                replaceHolder.value = this.stringToValue(string);
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }

    boolean replace(ReplaceHolder replaceHolder) throws BadLocationException {
        boolean bl2 = true;
        int n2 = 1;
        if (!(replaceHolder.length <= 0 || replaceHolder.text != null && replaceHolder.text.length() != 0 || this.getFormattedTextField().getSelectionStart() == replaceHolder.offset && replaceHolder.length <= 1)) {
            n2 = -1;
        }
        if (this.getOverwriteMode() && replaceHolder.text != null) {
            replaceHolder.length = Math.min(Math.max(replaceHolder.length, replaceHolder.text.length()), replaceHolder.fb.getDocument().getLength() - replaceHolder.offset);
        }
        if (replaceHolder.text != null && !this.isLegalInsertText(replaceHolder.text) || !this.canReplace(replaceHolder) || replaceHolder.length == 0 && (replaceHolder.text == null || replaceHolder.text.length() == 0)) {
            bl2 = false;
        }
        if (bl2) {
            int n3 = replaceHolder.cursorPosition;
            replaceHolder.fb.replace(replaceHolder.offset, replaceHolder.length, replaceHolder.text, replaceHolder.attrs);
            if (n3 == -1) {
                n3 = replaceHolder.offset;
                if (n2 == 1 && replaceHolder.text != null) {
                    n3 = replaceHolder.offset + replaceHolder.text.length();
                }
            }
            this.updateValue(replaceHolder.value);
            this.repositionCursor(n3, n2);
            return true;
        }
        this.invalidEdit();
        return false;
    }

    protected DocumentFilter getDocumentFilter() {
        if (this.documentFilter == null) {
            this.documentFilter = new DefaultDocumentFilter();
        }
        return this.documentFilter;
    }

    protected NavigationFilter getNavigationFilter() {
        if (this.navigationFilter == null) {
            this.navigationFilter = new DefaultNavigationFilter();
        }
        return this.navigationFilter;
    }

    public Object stringToValue(String string) throws ParseException {
        Object object;
        Class clazz = this.getValueClass();
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        if (clazz == null && jFormattedTextField != null && (object = jFormattedTextField.getValue()) != null) {
            clazz = object.getClass();
        }
        if (clazz != null) {
            try {
                object = clazz.getConstructor(new Class[]{String.class});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object = null;
            }
            if (object != null) {
                try {
                    return ((Constructor)object).newInstance(new Object[]{string});
                }
                catch (Throwable throwable) {
                    throw new ParseException("Error creating instance", 0);
                }
            }
        }
        return string;
    }

    public String valueToString(Object object) throws ParseException {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    String getReplaceString(int n2, int n3, String string) {
        String string2 = this.getFormattedTextField().getText();
        String string3 = string2.substring(0, n2);
        if (string != null) {
            string3 = string3 + string;
        }
        if (n2 + n3 < string2.length()) {
            string3 = string3 + string2.substring(n2 + n3);
        }
        return string3;
    }

    void moveDot(NavigationFilter.FilterBypass filterBypass, int n2, Position.Bias bias) {
        filterBypass.moveDot(n2, bias);
    }

    void setDot(NavigationFilter.FilterBypass filterBypass, int n2, Position.Bias bias) {
        filterBypass.setDot(n2, bias);
    }

    void replace(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
        ReplaceHolder replaceHolder = this.getReplaceHolder(filterBypass, n2, n3, string, attributeSet);
        this.replace(replaceHolder);
    }

    int getNextVisualPositionFrom(JTextComponent jTextComponent, int n2, Position.Bias bias, int n3, Position.Bias[] biasArray) throws BadLocationException {
        int n4 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n2, bias, n3, biasArray);
        if (n4 == -1) {
            return -1;
        }
        if (!(this.getAllowsInvalid() || n3 != 3 && n3 != 7)) {
            int n5 = -1;
            while (!this.isNavigatable(n4) && n4 != n5) {
                n5 = n4;
                n4 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n4, bias, n3, biasArray);
            }
            int n6 = this.getFormattedTextField().getDocument().getLength();
            if (n5 == n4 || n4 == n6) {
                if (n4 == 0) {
                    biasArray[0] = Position.Bias.Forward;
                    n4 = this.getInitialVisualPosition();
                }
                if (n4 >= n6 && n6 > 0) {
                    biasArray[0] = Position.Bias.Forward;
                    n4 = this.getNextNavigatableChar(n6 - 1, -1) + 1;
                }
            }
        }
        return n4;
    }

    ReplaceHolder getReplaceHolder(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) {
        if (this.replaceHolder == null) {
            this.replaceHolder = new ReplaceHolder();
        }
        this.replaceHolder.reset(filterBypass, n2, n3, string, attributeSet);
        return this.replaceHolder;
    }

    private class DefaultDocumentFilter
    extends DocumentFilter
    implements Serializable {
        private DefaultDocumentFilter() {
        }

        public void remove(DocumentFilter.FilterBypass filterBypass, int n2, int n3) throws BadLocationException {
            JFormattedTextField jFormattedTextField = DefaultFormatter.this.getFormattedTextField();
            if (jFormattedTextField.composedTextExists()) {
                filterBypass.remove(n2, n3);
            } else {
                DefaultFormatter.this.replace(filterBypass, n2, n3, null, null);
            }
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
            JFormattedTextField jFormattedTextField = DefaultFormatter.this.getFormattedTextField();
            if (jFormattedTextField.composedTextExists() || Utilities.isComposedTextAttributeDefined(attributeSet)) {
                filterBypass.replace(n2, n3, string, attributeSet);
            } else {
                DefaultFormatter.this.replace(filterBypass, n2, n3, string, attributeSet);
            }
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            JFormattedTextField jFormattedTextField = DefaultFormatter.this.getFormattedTextField();
            if (jFormattedTextField.composedTextExists() || Utilities.isComposedTextAttributeDefined(attributeSet)) {
                filterBypass.insertString(n2, string, attributeSet);
            } else {
                DefaultFormatter.this.replace(filterBypass, n2, 0, string, attributeSet);
            }
        }
    }

    private class DefaultNavigationFilter
    extends NavigationFilter
    implements Serializable {
        private DefaultNavigationFilter() {
        }

        public void moveDot(NavigationFilter.FilterBypass filterBypass, int n2, Position.Bias bias) {
            JFormattedTextField jFormattedTextField = DefaultFormatter.this.getFormattedTextField();
            if (jFormattedTextField.composedTextExists()) {
                filterBypass.moveDot(n2, bias);
            } else {
                DefaultFormatter.this.moveDot(filterBypass, n2, bias);
            }
        }

        public void setDot(NavigationFilter.FilterBypass filterBypass, int n2, Position.Bias bias) {
            JFormattedTextField jFormattedTextField = DefaultFormatter.this.getFormattedTextField();
            if (jFormattedTextField.composedTextExists()) {
                filterBypass.setDot(n2, bias);
            } else {
                DefaultFormatter.this.setDot(filterBypass, n2, bias);
            }
        }

        public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n2, Position.Bias bias, int n3, Position.Bias[] biasArray) throws BadLocationException {
            if (jTextComponent.composedTextExists()) {
                return jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n2, bias, n3, biasArray);
            }
            return DefaultFormatter.this.getNextVisualPositionFrom(jTextComponent, n2, bias, n3, biasArray);
        }
    }

    static class ReplaceHolder {
        DocumentFilter.FilterBypass fb;
        int offset;
        int length;
        String text;
        AttributeSet attrs;
        Object value;
        int cursorPosition;

        ReplaceHolder() {
        }

        void reset(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) {
            this.fb = filterBypass;
            this.offset = n2;
            this.length = n3;
            this.text = string;
            this.attrs = attributeSet;
            this.value = null;
            this.cursorPosition = -1;
        }
    }
}

