/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.peer.CheckboxPeer;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;

public class WCheckboxPeer
extends WComponentPeer
implements CheckboxPeer {
    private static native int getCheckMarkSize();

    void initialize() {
        Checkbox checkbox = (Checkbox)this.target;
        this.setState(checkbox.getState());
        this.setCheckboxGroup(checkbox.getCheckboxGroup());
        Color color = ((Component)this.target).getBackground();
        if (color != null) {
            this.setBackground(color);
        }
        super.initialize();
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    void handleAction(final boolean bl2) {
        final Checkbox checkbox = (Checkbox)this.target;
        WToolkit.executeOnEventHandlerThread(checkbox, new Runnable(){

            public void run() {
                checkbox.setState(bl2);
                WCheckboxPeer.this.postEvent(new ItemEvent(checkbox, 701, checkbox.getLabel(), bl2 ? 1 : 2));
            }
        });
    }

    public native void setState(boolean var1);

    WCheckboxPeer(Checkbox checkbox) {
        super(checkbox);
    }

    public native void setCheckboxGroup(CheckboxGroup var1);

    public Dimension getMinimumSize() {
        String string = ((Checkbox)this.target).getLabel();
        int n2 = WCheckboxPeer.getCheckMarkSize();
        if (string == null) {
            string = "";
        }
        FontMetrics fontMetrics = this.getFontMetrics(((Checkbox)this.target).getFont());
        return new Dimension(fontMetrics.stringWidth(string) + n2 / 2 + n2, Math.max(fontMetrics.getHeight() + 8, n2));
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public native void setLabel(String var1);

    native void create(WComponentPeer var1);
}

